// File DLLstuff.c contains C support routines needed by the Fortran
// DLL.

#include <stdio.h>
#ifdef NULL
#undef NULL
#endif

#include <windows.h>

// typedef and declaration for the message handler callback
typedef BOOL (FAR PASCAL *LPHANDLER) (LPSTR);
LPHANDLER lpDoIt;

// typdefs and declarations for address-setting callbacks
typedef BOOL (FAR PASCAL *LPSETI) (LPSTR, long *);
LPSETI lpSetI;
typedef BOOL (FAR PASCAL *LPSETR) (LPSTR, float *);
LPSETR lpSetR;

// saved ID for the window the app has told us to use for updates

HWND hWndScreen;

BOOL FAR PASCAL init_handler (LPHANDLER);
BOOL FAR PASCAL init_lpsetI (LPSETI);
BOOL FAR PASCAL init_lpsetR (LPSETR);
BOOL FAR PASCAL init_window (HWND);

void _fortran setIntAddr (LPSTR, long *);
void _fortran setRealAddr (LPSTR, float *);
void _fortran c_msg_hndlr (LPSTR, LPSTR);
void _fortran c_update_window (LPSTR);
void _fortran bombOut (LPSTR);
void _fortran WinYield (void);
void _fortran doMsg (LPSTR, LPSTR);

void FAR PASCAL FatalAppExit (WORD, LPSTR);

// DLL initialisation routines

// Save the pointer to the message-handling function
BOOL FAR PASCAL init_handler (LPHANDLER lpHnd)
{
   
   lpDoIt = lpHnd;
   return(TRUE);
}

// Save the pointer to the address-setting function for ints
BOOL FAR PASCAL init_lpsetI (LPSETI lpHnd)
{
   
   lpSetI = lpHnd;
   return(TRUE);
}

// Save the pointer to the address-setting function for reals
BOOL FAR PASCAL init_lpsetR (LPSETR lpHnd)
{
   
   lpSetR = lpHnd;
   return(TRUE);
}

// Save a window ID
BOOL FAR PASCAL init_window(HWND hWnd)
{
   
   hWndScreen = hWnd;
   return(TRUE);
}

// This uses SDK calls to present a message box from within the DLL
void _fortran doMsg (LPSTR title, LPSTR msg)
{
   MessageBox (NULL, msg, title, MB_OK );
   return;
}

// Whereas this calls the message handler in the main app to print for us
void _fortran c_msg_hndlr( LPSTR title, LPSTR msg )
{
   (lpDoIt)(msg);
   return;
}

// update a window in the main app. This version changes the text of a 
// static text control, but you could call InvalidateRect and
// UpdateWindow to send a WM_PAINT message.
void _fortran c_update_window (LPSTR msg)
{
   SetWindowText(hWndScreen, msg);
   return;
}

// return the address of a long int to the caller
void _fortran setIntAddr (LPSTR var, long *Num1)
{
   (lpSetI)(var, Num1);
   return;
}

// return the address of a float to the caller
void _fortran setRealAddr (LPSTR var, float *Num1)
{
   (lpSetR)(var, Num1);
   return;
}

// cause a Fatal exit
void _fortran bombOut (LPSTR txt)
{
   FatalAppExit(0, txt);
   return;
}

// Process any outstanding events waiting. These may be characters
// typed at the keyboard, WM_PAINT messages, etc.
void _fortran WinYield()
{
   MSG msg;
   while (PeekMessage(&msg, NULL, NULL, NULL, PM_REMOVE)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }
}
