program LZTest;
 
{ Demonstrate use of routines in LZEXPAND.DLL. }
 
{ By Brett Glass }
 
{ This program demonstrates the use of LZEXPAND.DLL. It
  was based entirely on the behavior of existing Windows
  programs, yet works reliably. }
 
{$X+} { Turn on Turbo Pascal's idiosyncratic null-terminated string
        extensions.}
 
uses LZExpand, { This unit interfaces with LZEXPAND.DLL }
     WinCRT,   { Display program in scrolling character window.   
                 No need for fancy Windows tricks in this demo! }    
     WinTypes, { Windows types, defined for Turbo Pascal }
     WinProcs; { Windows APIs, defined for Turbo Pascal }
 
type
  { Make a type for big null-terminated strings }
  BigString = array [0..255] of Char;
 
var
  src, dest, exp : BigString; { Source and destination file names}
  srcHandle, destHandle : Integer; { Source and destination file handles }
  ofStructSrc, ofStructDest : TOFStruct; { OpenFile structures }
  lzResult : Integer; { This integer holds the results of some functions }
  copyResult : Longint; { This integer holds the byte count from the copy }  

procedure FinishWinCRT;
 { Bring a program written with TPW's WinCRT unit to a neat finish }
 begin
 Writeln('Press <Enter> to close window');
 Readln;
 DoneWinCrt;
 end;
 
begin
Writeln('LZEXPAND test program');
Write('Enter the name of a (possibly compressed) file to copy: ');
Readln(src);
Write('Now enter a filename for the copy: ');
Readln(dest);
 
{ Demonstrate GETEXPANDEDNAME. Note that LZSTART doesn't need to be 
  called before using this function. }
lzResult := GETEXPANDEDNAME(src, exp);
if lzResult < 0 then
  begin
  Writeln('Could not find source file');
  FinishWinCRT
  end
else
  Writeln('Expanded name of source file: ', exp);
 
{ Now demonstrate file expansion. }
lzResult := LZSTART; { Must do this before a compressed file is
opened } if lzResult <> 1 then
  begin
  Writeln('LZSTART failed. Error code: ',lzResult);
  FinishWinCRT
  end;
{ Open the source file. The string "src" can specify either the expanded
  or the unexpanded name. }
srcHandle := LZOPENFILE(src,ofStructSrc,of_Read);
if srcHandle < 0 then
  begin
  Writeln('Could not open source file.');
  FinishWinCRT
  end;
{ Open an ordinary file for output }
destHandle := OpenFile(dest,ofStructDest,of_Create);
if destHandle < 0 then
  begin
  Writeln('Could not open destination file.');
  FinishWinCRT
  end;
copyResult := LZCOPY(srcHandle, destHandle); { Copy the file } if
copyResult > 0 then
 Writeln(copyResult, ' bytes in destination')
else
 Writeln('Copy failed; error code ', lzResult);
LZCLOSE(srcHandle);
_lclose(destHandle);
LZDONE;
FinishWinCRT;
end.
