// sample function

void PaintGraphDlgCtrl(HWND hCtrl, short dataOffset)
  {
  HDC    hDC;    /* to create child window's DC */
  RECT   rect;   /* to get child window's
                                     client rect */
  WORD   ctrlID; /* child window's ID in RC file */
  TEXTMETRIC tm;
  HFONT hFontHeading;
  static int xmax,ymax,xoffset,yoffset,i,z;
  static int y=0;
  char buf[20] = "xxx";
  int q,r;

/* Find control dimensions */
  ctrlID = GetWindowWord(hCtrl, GWW_ID);
  GetClientRect(hCtrl, &rect);
  InvalidateRect(hCtrl, &rect, TRUE);
  UpdateWindow(hCtrl);
  hDC = GetDC(hCtrl);

  xmax = (rect.right - rect.left)*8/10;
  ymax = (rect.bottom - rect.top)*9/10;
  xoffset = rect.left +(rect.right - rect.left)*1/10;
  yoffset = rect.top + (rect.bottom - rect.top)*1/20;

/* Draw the coordinates */

  MoveTo (hDC,xoffset,yoffset);
  LineTo (hDC,xoffset, yoffset+ymax);
  LineTo (hDC,xoffset+xmax, yoffset+ymax);

  yoffset = yoffset + ymax;
  for (i=1;i<5;i++)
    {
    MoveTo(hDC,xoffset+(i*xmax/4),yoffset);
    LineTo(hDC,xoffset+(i*xmax/4),yoffset+3);
    }
  SetBkMode(hDC,TRANSPARENT);

/* Put in the coordinate values */

  GetTextMetrics(hDC,&tm);

/* If the width of the area between the left border
   and the left edge of the control is very small
   change the font to fit into the area.           */

  if((tm.tmAveCharWidth*3) >(rect.right - rect.left)
                                                 /10)
    {
    r = ((rect.right - rect.left)/30)+2;
    hFontHeading = CreateFont(8, r,0,0, 300,FALSE,
       FALSE,FALSE,OEM_CHARSET,OUT_CHARACTER_PRECIS,
       OUT_DEFAULT_PRECIS,PROOF_QUALITY,
       VARIABLE_PITCH|FF_ROMAN,"Times");
    SelectObject(hDC,hFontHeading);
    SetBkMode(hDC, TRANSPARENT);

    for (i=1;i<5;i++)
      {
      MoveTo(hDC,xoffset-3,yoffset-(i*ymax/5));
      LineTo(hDC,xoffset,yoffset-(i*ymax/5));
      wsprintf((LPSTR)buf,"%1d",20*i);
      TextOut(hDC,rect.left,yoffset-(ymax*i/5),
                                    (LPSTR)buf,2);
      }
    TextOut(hDC,rect.left,yoffset-ymax,(LPSTR)"100",
                                                  3);
    DeleteObject(hFontHeading);
    }
  else
    {
    for (i=1;i<5;i++)
      {
      SelectObject(hDC,hFontTimes);
      MoveTo(hDC,xoffset-3,yoffset-(i*ymax/5));
      LineTo(hDC,xoffset,yoffset-(i*ymax/5));
      wsprintf((LPSTR)buf,"%1d",20*i);
        TextOut(hDC,xoffset-20,yoffset-(ymax*i/5),
                                      (LPSTR)buf,2);
      }
    TextOut(hDC,xoffset-20,yoffset-ymax,
                                    (LPSTR)"100",3);
    }

/* Draw the graph */

  MoveTo(hDC,xoffset,yoffset);
  for (i=0;i<5;i++)
    {
    y =  statdata[i+dataOffset].itemave * ymax / 100;
    z = (int)y;
    LineTo(hDC,xoffset+(i*xmax/4),yoffset-z);
    Rectangle(hDC,(xoffset+(i*xmax/4))-2,
                (yoffset-z)-2,(xoffset+
                (i*xmax/4))+2,(yoffset-z)+2);
    }
  ReleaseDC(hCtrl, hDC);
  }

