constructor TChart.Load(var S:TStream);
{ Load a chart from a stream. Must be read in same order written. }
begin
  Name := S.StrRead;
  Items := PDict(S.Get);
end;

procedure TChart.Store(var S:TStream);
{ Store a chart onto a stream. Not all object fields are stored.
  For example, scale, area, lead, space are set properly when
  you rescale. Must be read in the exact same order. }
begin
  S.StrWrite(Name);
  S.Put(Items);
end;

{ Stream Registration records for each chart type }

const
  RChart: TStreamRec = (
    ObjType: 1002;
    VmtLink: Ofs(TypeOf(TChart)^);
    Load: @TChart.load;
    Store: @TChart.store);

  RHBarChart: TStreamRec = (
    ObjType: 1003;
    VmtLink: Ofs(TypeOf(THBarChart)^);
    Load: @THBarChart.load;
    Store: @THBarChart.store);

  RVBarChart: TStreamRec = (
    ObjType: 1004;
    VmtLink: Ofs(TypeOf(TVBarChart)^);
    Load: @TVBarChart.load;
    Store: @TVBarChart.store);

  RV3DBarChart: TStreamRec = (
    ObjType: 1005;
    VmtLink: Ofs(TypeOf(TV3DBarChart)^);
    Load: @TV3DBarChart.load;
    Store: @TV3DBarChart.store);

  RPieChart: TStreamRec = (
    ObjType: 1006;
    VmtLink: Ofs(TypeOf(TPieChart)^);
    Load: @TPieChart.load;
    Store: @TPieChart.store);

{ Initialization }
begin
  RegisterType(RChart);
  RegisterType(RHBarChart);
  RegisterType(RVBarChart);
  RegisterType(RV3DBarChart);
  RegisterType(RPieChart);
end.
