' Utility module to support Drag 'n Drop Client Functionality in VB

DefInt A-Z

'Shell functions
Declare Sub DragAcceptFiles Lib "Shell" (ByVal Wnd, ByVal Accept)
Declare Sub DragFinish Lib "Shell" (ByVal Wnd)
Declare Function DragQueryPoint Lib "Shell" (ByVal hDrop, lpPNT)
Declare Function DragQueryFile Lib "Shell" (ByVal hDrop, ByVal iFile, ByVal lpName$, ByVal BuffSize)

'User Functions
Declare Sub SetWindowPos Lib "User" (ByVal Wnd, ByVal hParent, ByVal X#, ByVal wFlags)
Declare Function PeekMessage Lib "User" (lpMSG, ByVal Wnd, ByVal wMsgFilterMin, ByVal wMsgFilterMax, ByVal wRemoveMsg)


Const TRUE = -1
Const False = Not TRUE

'SetWindowPos Constants
Const HWND_TOPMOST = -1
Const SWP_NOSIZE = 1
Const SWP_NOMOVE = 2
Const SWP_STATIC = SWP_NOSIZE Or SWP_NOMOVE

'PeekMessage Constants
Const HC_NOREMOVE = 3
Const WM_DROPFILES = 563

'MSG Replacement
Dim MSG(8)
Const HWND = 0
Const WPARAM = 2

'POINT replacement
Dim PNT(1)
Const X = 0
Const Y = 1

Dim MyWnd
Dim NameOfFile As String * 128

Sub Main ()
    ClientForm.Show
    MyWnd = ClientForm.HWND
    If ClientForm.WindowState = 1 Then
        SetWindowPos MyWnd, HWND_TOPMOST, 0, SWP_STATIC
    End If
    DragAcceptFiles MyWnd, TRUE
    Do While DoEvents()
        Res = PeekMessage(MSG(0), MyWnd, WM_DROPFILES, WM_DROPFILES, HC_NOREMOVE)
        If Res <> 0 Then
            Client = DragQueryPoint(MSG(WPARAM), PNT(0))
            nFiles = DragQueryFile(MSG(WPARAM), -1, NameOfFile, 128)
            ReDim FileArr$(nFiles - 1)
            For FileNum = 0 To nFiles - 1
                TChars = DragQueryFile(MSG(WPARAM), FileNum, NameOfFile, 128)
                FileArr$(FileNum) = Left$(NameOfFile, TChars)
            Next FileNum
            DragFinish MSG(WPARAM)
            Form_FileDrop FileArr$(), nFiles, PNT(X), PNT(Y), Client * -1
        End If
    Loop
End Sub
