// WinSem.H - Windows Semaphores master header file
// Copyright (C) 1993 Howard Kapustein, All Rights Reserved

#ifndef __WINSEM_H                      // Prevent repeat #includes
#define __WINSEM_H

//*********************************************************************
//  Header Files
//********************************************************************/

// Enable STRICT Windows
#ifndef STRICT
#   define STRICT
#endif

// Include Windows Headers
#include <windows.h>


//*********************************************************************
//  Windows Extensions
//*********************************************************************

// Base data types
typedef char                    CHAR;       // Character, signed
typedef unsigned char           UCHAR;      // Character, unsigned
typedef short                   SHORT;      // 16-bit, signed
typedef unsigned short          USHORT;     // 16-bit, unsigned
// WINDOWS.H defines LONG
typedef unsigned long           ULONG;      // 32-bit, unsigned
// WINDOWS.H defines VOID
// WINDOWS.H defines BOOL

// Boolean Values
// WINDOWS.H defines TRUE
// WINDOWS.H defines FALSE


//*********************************************************************
//  Constants
//*********************************************************************

// WinSem Calling Convention
#define WINSEMAPI WINAPI

// Semaphore Name constants
#define WINSEM_NAME_MAX     255
#define WINSEM_NAME_PREFIX  "\\SEM32\\"

// Semaphore Flags
#define WINSEM_PRIVATE      0x0000
#define WINSEM_SHARED       0x0001
#define WINSEM_RESERVED     0xFFFE

// WinSem Timeouts
#define WINSEM_IMMEDIATE_RETURN     (0)
#define WINSEM_INDEFINITE_WAIT      (-1L)

// Internal Limits
#define WINSEM_MAX_EVENT_SEMAPHORES     4
#define WINSEM_MAX_MUTEX_SEMAPHORES     4


//*********************************************************************
//  Data types
//*********************************************************************

// WinSem Error Type
typedef USHORT  WINSEMRET;

// Semaphore Data Types
typedef USHORT          HWSEM;
typedef HWSEM           HWSEVT;
typedef HWSEVT FAR *    PHWSEVT;
typedef HWSEM           HWSMTX;
typedef HWSMTX FAR *    PHWSMTX;


//*********************************************************************
//  Global Variables
//*********************************************************************


//*********************************************************************
//  Error Codes
//*********************************************************************

// WinSem Error Codes
#define WINSEM_NO_ERROR                      0
#define WINSEM_ERROR_INVALID_PARAMETER       1
#define WINSEM_ERROR_INVALID_NAME            2
#define WINSEM_ERROR_DUPLICATE_NAME          3
#define WINSEM_ERROR_TOO_MANY_HANDLES        4
#define WINSEM_ERROR_INVALID_HANDLE          5
#define WINSEM_ERROR_NOT_FOUND               6
#define WINSEM_ERROR_TOO_MANY_OPENS          7
#define WINSEM_ERROR_TOO_MANY_POSTS          8
#define WINSEM_ERROR_NOT_OWNER               9
#define WINSEM_ERROR_ALREADY_RESET          10
#define WINSEM_ERROR_TIMEOUT                11
#define WINSEM_ERROR_INTERRUPT              12
#define WINSEM_ERROR_SEM_OWNER_DIED         13
#define WINSEM_ERROR_TOO_MANY_SEM_REQUESTS  14
#define WINSEM_ERROR_ALREADY_RELEASED       15


//*********************************************************************
//  Function Prototypes
//*********************************************************************

// WinSem API is a C API
#ifdef __cplusplus
extern "C" {
#endif

// Event Semaphores
WINSEMRET WINSEMAPI WSCreateEventSem(LPSTR lpszName,
                                     PHWSEVT phEvtSem,
                                     USHORT fsFlags,
                                     BOOL fState);
WINSEMRET WINSEMAPI WSOpenEventSem(LPSTR lpszName,
                                   PHWSEVT phEvtSem);
WINSEMRET WINSEMAPI WSCloseEventSem(HWSEVT hEvtSem);
WINSEMRET WINSEMAPI WSPostEventSem(HWSEVT hEvtSem);
WINSEMRET WINSEMAPI WSResetEventSem(HWSEVT hEvtSem,
                                    LPLONG plPostCount);
WINSEMRET WINSEMAPI WSQueryEventSem(HWSEVT hEvtSem,
                                    LPLONG plPostCount);
WINSEMRET WINSEMAPI WSWaitEventSem(HWSEVT hEvtSem,
                                   LONG lTimeout);

// Mutex Semaphores
WINSEMRET WINSEMAPI WSCreateMutexSem(LPSTR lpszName,
                                     PHWSMTX phMtxSem,
                                     USHORT fsFlags,
                                     BOOL fState);
WINSEMRET WINSEMAPI WSOpenMutexSem(LPSTR lpszName,
                                   PHWSMTX phMtxSem);
WINSEMRET WINSEMAPI WSCloseMutexSem(HWSMTX hMtxSem);
WINSEMRET WINSEMAPI WSRequestMutexSem(HWSMTX hMtxSem,
                                      LONG lTimeout);
WINSEMRET WINSEMAPI WSReleaseMutexSem(HWSMTX hMtxSem);
WINSEMRET WINSEMAPI WSQueryMutexSem(HWSMTX hMtxSem,
                                    HTASK FAR * pOwner,
                                    LPLONG plRequestCount);

// MuxWait Semaphores
// Not Implemented (yet)

// Miscellaneous Semaphore functions
LPSTR WINSEMAPI WSErrorText(WINSEMRET wsErrorCode);
LPSTR WINSEMAPI WSQueryVersionText(VOID);

// WinSem API is a C API
#ifdef __cplusplus
}
#endif


//*********************************************************************
//  Miscellaneous
//*********************************************************************

#endif                                  // __WINSEM_H


