
/*
;
;  File: TESTMON.C
;
;   This bare-bones Windows app demonstrates the use of
;   WinMon as a development tool.
;
;  Copyright 1993, David Burki
;  All rights reserved.
;
;  Author: D. Burki
;  Created: June 24, 1993
;
;   NOTE:
;     All pointer parameters passed to WINMON_iMsg() (except the format string)
;     which are pointers must be cast as FAR pointers.  The compiler can handle
;     casting the format string, but has no idea that it should cast any of
;     the variable argument list parameters so you have to do it.
;
*/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <testmon.h>

/*
; include file for WinMon function prototypes
*/
#include <winmon.h>

static char szTestMsg[] = "This is a test message";


int PASCAL WinMain( HINSTANCE hInstance,
                    HINSTANCE hPrevInstance,
                    LPSTR     lpszCmdLine,
                    int       nCmdShow )
{
  static char szAppName[] = "TestMon";
  HWND hwnd;
  MSG msg;
  WNDCLASS wndclass;

  if ( !hPrevInstance )
  {
    wndclass.style = CS_HREDRAW | CS_VREDRAW;
    wndclass.lpfnWndProc = (WNDPROC)WndProc;
    wndclass.cbClsExtra = 0;
    wndclass.cbWndExtra = 0;
    wndclass.hInstance = hInstance;
    wndclass.hIcon = LoadIcon( NULL, IDI_APPLICATION );
    wndclass.hCursor = LoadCursor( NULL, IDC_ARROW );
    wndclass.hbrBackground = (HBRUSH)(COLOR_WINDOW + 1);
    wndclass.lpszMenuName = "Testmon";
    wndclass.lpszClassName = szAppName;

    RegisterClass( &wndclass );
  }

  /*
  ; try out a call to WinMon
  */
  WINMON_iMsg("Calling CreateWindow() for main window in %s", (LPSTR)szAppName );

  hwnd = CreateWindow( szAppName, "TestMon - WinMon test app",
                      WS_OVERLAPPEDWINDOW,
                      CW_USEDEFAULT, CW_USEDEFAULT,
                      CW_USEDEFAULT, CW_USEDEFAULT,
                      NULL, NULL, hInstance, NULL );

  ShowWindow( hwnd, nCmdShow );
  UpdateWindow( hwnd );

  while ( GetMessage( &msg, NULL, 0, 0 ) )
  {
    TranslateMessage( &msg );
    DispatchMessage( &msg );
  }

  return msg.wParam;
}

// long FAR PASCAL _export WndProc( HWND hwnd, UINT message, UINT wParam,

/*
;
;	USAGE: LRESULT CALLBACK _export WndProc( HWND, UINT, UINT, LONG );
;
;	Description:	
;
;
;	Returns:	
;
*/
LRESULT CALLBACK _export WndProc( HWND hwnd,
                                  UINT message,
                                  UINT wParam,
                                  LONG lParam )
{
  int           n;
  static HMENU  hMenu;
  static BOOL   bIsPaused  = FALSE;
  static BOOL   bIsStamped = FALSE;

  switch ( message )
  {
    case WM_CREATE:
      /*
      ; try out a couple of calls to WinMon
      */
      WINMON_iMsg( "Processing WM_CREATE message" );
      n = WINMON_iMsg( "hwnd = %d", hwnd );
      WINMON_iMsg( "Last message was %d characters long.", n );
      hMenu = GetMenu( hwnd );

      return 0;

    case WM_COMMAND:
      /*
      ; demonstrate the APIs of WinMon
      ; this switch handles clearing the list,
      ; toggling pause and timestamp on & off,
      ; sending a simple string of test, and
      ; appending & overwriting a file with the 
      ; contents of the list. 
      ; !!! file names are hard coded !!!
      */
      switch ( wParam )
      {
        case IDM_APPEND:
          WINMON_bFileSave( "append.txt", TRUE );
          break;

        case IDM_CLEAR:
          WINMON_vClear();
          break;

        case IDM_OVERWRITE:
          WINMON_bFileSave( "owrite.txt", FALSE );
          break;

        case IDM_PAUSE:
          bIsPaused = ~bIsPaused;
          WINMON_bPause( bIsPaused == FALSE ? FALSE : TRUE );
          CheckMenuItem( hMenu, IDM_PAUSE,
                             bIsPaused != FALSE ? MF_CHECKED : MF_UNCHECKED );
          break;

        case IDM_TIME:
          bIsStamped = ~bIsStamped;
          WINMON_bTimeStamp( bIsStamped == FALSE ? FALSE : TRUE );
          CheckMenuItem( hMenu, IDM_TIME,
                             bIsStamped != FALSE ? MF_CHECKED : MF_UNCHECKED );
          break;

        case IDM_SEND_MSG:
          WINMON_iMsg( "%s", (LPSTR)szTestMsg );
          break;

        default:
          break;

      }
      return 0;

    case WM_DESTROY:
      PostQuitMessage( 0 );
      return 0;
  }
  return DefWindowProc( hwnd, message, wParam, lParam );
}
