Class:ConFlds
  Index:PagePos
  Index:Prompt
  Index:Field
  Page
  Row
  Col
  Len
  Wid
  PrWid
  Type
  NumFormat
  Radiovalue
  Before
  After
  Action

ConFlds:Start
  New (ConFlds:ConFlds,ConPage:Page)
  Jorf:File("CONFLDS.DAT",Here)
  Event:Add()
  Mem:Ptr->ConIndex='PagePos'
  ConFlds=ConFlds:Next(ConFlds,'Next')

  Win:Add ("Contact Field Management")
    Menu:"&File"
      Menu:"&Generate"               Action:"ConFlds:Generate()"
      Menu:"&Rebuild"                Action:"ConFlds:Rebuild()"
      Menu:""
      Menu:"E&xit       Alt-X"       Action:"Return(Null)"
    Menu:"&Edit"
      Menu:"&Add"       Action:"ConFlds:Edit(ConFlds,'Add')"
      Menu:"&Change"    Action:"ConFlds:Edit(ConFlds,'Change')"
      Menu:"&Delete"    Action:"ConFlds:Edit(ConFlds,'Delete')"
    Menu:"&Search",
      Menu:"&Page       ",  Action:"ConFlds:KeySearch (ConFlds,'Page' ,'PagePos')
      Menu:"P&rompt     ",  Action:"ConFlds:KeySearch (ConFlds,'Prompt', 'Prompt')
      Menu:"&Field      ",  Action:"ConFlds:KeySearch (ConFlds,'Field' , 'Field')
    Group:"&ConFldss", Row:1, Col:1, Len:16, Wid:42
    String:"Prompt        Page Col Row  Field Name"
    List:"" Row:3, Col:2, Len:14, Wid:42
      Field:"ConFlds"
      Next:"ConFlds:Next(ConFlds,'Next')"
      Prev:"ConFlds:Next(ConFlds,'Prev')"
      Show:"ConFlds:Show(ConFlds)'
    Button:"&Ok"      Row:19 Col:5  Wid:14 Action:"Return(Null)"
    Button:"&Cancel"  Row:19 Col:25 Wid:14 Action:"Return('Esc_Key')"
  Return (Ok)

Class:ConPage
  Index:PageNo
  Text

ConFlds:BeforeLen()
  If (Str:In('HLine,Group,Text',ConFlds->Type)==0)
    ConFlds->Len=Null
    Return (Null)
  Return (Ok)

ConFlds:BeforeWid()
  If (Str:In('Radio,ChBox,Prompt',ConFlds->Type))
    ConFlds->Wid=Null
    Return (Null)
  Return (Ok)

ConFlds:CheckCol(Col)
  If (Col < 1 OR Col > 76)
    Msg:Add
      You must enter a column &
      between 1 and 76.
    Return (Null)
  Return (Ok)

ConFlds:CheckField(Field)
  New (i,c)
  If (Str:In(Field," ")
    Msg:Add
      You cannot have embedded spaces
      in your field name.  If you want,
      you can use an _underscore.
    Return (Null)
  If (To:Num(Str:At(Field,1,1)))
    Msg:Add
      You cannot begin a field name
      with a number.
    Return (Null)
  For (i = 1 thru str:len(field))
    c=To:Ucs(Str:At(Field,i,1))
    If ((C < "A" Or C > "Z") And C!='_')
      Msg:Add
        Illegal character "{C}".  You must
        use only alphabetic characters in
        a field name.
      Return (Null)
  Return (Ok)

ConFlds:CheckPage(Page)
  If (Page < 1 OR Page > 99)
    Msg:Add
      You must enter a page number &
      between 1 and 99.
    Return (Null)
  Return (Ok)

ConFlds:CheckRow(Row)
  If (Row < 1 OR Row > 15)
    Msg:Add
      You must enter a row &
      between 1 and 15.
    Return (Null)
  Return (Ok)

ConFlds:CheckWid(Wid)
  If (Wid < 1 OR Wid > 76)
    Msg:Add
      You must enter a width &
      between 1 and 76.
    Return (Null)
  Return (Ok)

ConFlds:Edit(*ConFlds,Action)
  | Add/Edit/Delete ConFldss
  New (ConFlds:NewConFlds, ConPage:Page,Result)

  Switch (Action)
    Case "Add"
      Jorf:Write(NewConFlds)
      ConFlds=NewConFlds
      Jorf:Lock(NewConFlds)

    Case "Change"
      If (Jorf:Lock(ConFlds)==Null)
        Win:Msg("Record is locked.  Cannot change right now.")
        Return (Ok)
      Page=Struct:Find('ConPage','PageNo',ConFlds->Page)
      If (Page->Text)
        Page->Text=Null
        Jorf:Write(Page)
    Case "Notes"
      If (Jorf:Lock(ConFlds)==Null)
        Win:Msg("Record is locked.  Cannot change right now.")
        Return (Ok)
      ConFlds:Page('Notes')
      Kbd:Put("End_Key")
      Kbd:Get()
      Jorf:Write(ConFlds)
      Return (Ok)
    Case "Delete"
      Result=Msg:Add('ConFlds Delete','No')
        Delete this Field?

        Page:   {ConFlds->Page}  Row: {ConFlds->Row}  Col: {ConFlds->Col}
        Prompt: {ConFlds->Prompt}
        Field:  {ConFlds->Field}
      If (Result)
        Jorf:Del(ConFlds)
        Page=Struct:Find('ConPage','PageNo',ConFlds->Page)
        If (Page->Text)
          Page->Text=Null
          Jorf:Write(Page)
        Win:Dsp
      Kbd:Put("Home_Key")
      Return(Ok)

  Win:Add ("{Action} Field")
    Group:"" Row:1 Col:1 Len:2 Wid:46
    Input:"&Prompt" Row:2 Col:2 Wid:39 Field:"ConFlds->Prompt"
    Input:"N&ame  " Row:3 Col:2 Wid:14 Field:"ConFlds->Field"
      After:"ConFlds:CheckField(ConFlds->Field)"
    Input:"Page" Row:3 Col:25 Wid:2  Field:"ConFlds->Page" Type:"Number"
      After:"ConFlds:CheckPage(ConFlds->Page)"
    Input:"Prompt Width" Row:3 Col:33 Wid:2  Field:"ConFlds->PrWid" Type:"Number"
      After:"ConFlds:CheckPage(ConFlds->Page)"
    Group:"Type" Row:5 Col:1 Len:6 Wid:46
    Radio:"Normal &Input " Row:6 Col:2
      Check:"ConFlds->Type=='Normal'"
      Action:"ConFlds->Type='Normal'"
      UnAction:"ConFlds->Type=Null"
    Radio:"&Date input   " Row:7 Col:2
      Check:"ConFlds->Type=='Date'"
      Action:"ConFlds->Type='Date'"
      UnAction:"ConFlds->Type=Null"
    Radio:"&Numeric input" Row:8 Col:2
      Check:"ConFlds->Type=='Number'"
      Action:"ConFlds->Type='Number'"
      UnAction:"ConFlds->Type=Null"
    Input:"Format"        Row:9 Col:5  Wid:16  Field:"ConFlds->NumFormat"
    Radio:"&Text input   " Row:10 Col:2
      Check:"ConFlds->Type=='Text'"
      Action:"ConFlds->Type='Text'"
      UnAction:"ConFlds->Type=Null"
    Radio:"Chec&k Box"     Row:6 Col:28
      Check:"ConFlds->Type=='ChBox'"
      Action:"ConFlds->Type='ChBox'"
      UnAction:"ConFlds->Type=Null"
    Radio:"&Radio Button"  Row:7 Col:28
      Check:"ConFlds->Type=='Radio'"
      Action:"ConFlds->Type='Radio'"
      UnAction:"ConFlds->Type=Null"
    Input:"Value"         Row:8 Col:31 Wid:10  Field:"ConFlds->RadioValue"
    Radio:"&Prompt only  " Row:9 Col:28
      Check:"ConFlds->Type=='Prompt'"
      Action:"ConFlds->Type='Prompt'"
      UnAction:"ConFlds->Type=Null"
    Radio:"Hori&zontal line"          Row:10 Col:28
      Check:"ConFlds->Type=='HLine'"
      Action:"ConFlds->Type='HLine'"
      UnAction:"ConFlds->Type=Null"
    Radio:"&Group box"           Row:11 Col:28
      Check:"ConFlds->Type=='Group'"
      Action:"ConFlds->Type='Group'"
      UnAction:"ConFlds->Type=Null"
    Group:"Position" Row:1 Col:50 Len:4 Wid:9
    Input:"Ro&w   " Row:2 Col:51 Wid:2  Field:"ConFlds->Row"  Type:"Number"
      After:"ConFlds:CheckRow(ConFlds->Row)"
    Input:"Co&lumn" Row:3 Col:51 Wid:2  Field:"ConFlds->Col" Type:"Number"
      After:"ConFlds:CheckCol(ConFlds->Col)"
    Input:"L&ength" Row:4 Col:51 Wid:2  Field:"ConFlds->Len" Type:"Number"
      Before:"ConFlds:BeforeLen()"
      After:"ConFlds:CheckWid(ConFlds->Wid)"
    Input:"Widt&h " Row:5 Col:51 Wid:2  Field:"ConFlds->Wid" Type:"Number"
      Before:"ConFlds:BeforeWid()"
      After:"ConFlds:CheckWid(ConFlds->Wid)"
    Group:"Extra Processing" Row:13 Col:1 Len:3 Wid:58
    Input:"&Before " Row:14 Col:2 Wid:50  Len:1 Field:"ConFlds->Before"
    Input:"A&fter  " Row:15 Col:2 Wid:50  Len:1 Field:"ConFlds->After"
    Input:"Action " Row:16 Col:2 Wid:50   Len:1 Field:"ConFlds->Action"
    Button:"&Ok"       Row:7  Col:50 Wid:10 Action:"Return(Null)"
    Button:"&Cancel"   Row:10  Col:50 Wid:10 Action:"Return('Esc_Key')"

  ConFlds->PagePos=Num:Str(ConFlds->Page,"###",10,3)+" "+Num:Str(ConFlds->Col,"##",10,2)+" "+Num:Str(ConFlds->Row,"##",10,2)
  Jorf:Write(ConFlds)
  Page=Struct:Find('ConPage','PageNo',ConFlds->Page)
  If (Page->Text)
    Page->Text=Null
    Jorf:Write(Page)
  Win:Dsp
  Return(Ok)

ConFlds:Generate(PageNo)
  New (Line,Text,ConFlds:ConFlds)
  If (PageNo==0)
    Win:Add("Generate")
      Input:"Page number to generate?", Field:"PageNo" Wid:2
    If (Kbd:Got=="Esc_Key" Or PageNo==0)
      Return (Null)

  Win:Add
    Generating page {PageNo}
  Jorf:File("CONFLDS.DAT",Here)
  ConFlds=Struct:Find('ConFlds','PagePos',Num:Str(PageNo,"###",10,3))
  While (ConFlds)
    If (ConFlds->PrWid)
      If (Str:In(ConFlds->Prompt,"&"))
        ConFlds->Prompt=Str:Pad(ConFlds->Prompt,ConFlds->PrWid+1)
      Else
        ConFlds->Prompt=Str:Pad(ConFlds->Prompt,ConFlds->PrWid)
    Switch (ConFlds->Type)
      Case "Date"
        Line='Input:"'+ConFlds->Prompt+'" Field:"Contact->'+ConFlds->Field+'" Type:"Date"'
      Case "Numeric"
        Line='Input:"'+ConFlds->Prompt+'" Field:"Contact->'+ConFlds->Field+'" Type:"Numeric" Format:"'+format+'"'
      Case "Text"
        Line='Text:"'+ConFlds->Prompt+'" Field:"Contact->'+ConFlds->Field+'" Len:'+ConFlds->Len
      Case "ChBox"
        Line='ChBox:"'+ConFlds->Prompt+'" Field:"Contact->'+ConFlds->Field+'"'
      Case "Radio"
        Line='Radio:"'+ConFlds->Prompt+'"'
        Text=Text:Add(Line,Text)
        Line='  Check:"Contact->'+ConFlds->Field+'=='+"'"+ConFlds->RadioValue+"'"+'"'
        Text=Text:Add(Line,Text)
        Line='  Action:"Contact->'+ConFlds->Field+'='+"'"+ConFlds->RadioValue+"'"+'"'
        Text=Text:Add(Line,Text)
        Line='  UnAction:"Contact->'+ConFlds->Field+'= Null"'
      Case "HLine"
        Line='HLine:"'+ConFlds->Prompt+'"'
      Case "Group"
        Line='Group:"'+ConFlds->Prompt+'"'
      Case "Prompt"
        Line='String:"'+ConFlds->Prompt+'"'
      Else | "Normal"
        Line='Input:"'+ConFlds->Prompt+'" Field:"Contact->'+ConFlds->Field+'"'
    Text = Text:Add(Line,Text)
    Line = Null

    If (ConFlds->Row)
      Line = Line + '  Row:'+(ConFlds->Row+8)
    If (ConFlds->Col)
      Line = Line + '  Col:'+ConFlds->Col
    If (ConFlds->Len)
      Line = Line + '  Len:'+ConFlds->Len
    If (ConFlds->Wid)
      Line = Line + '  Wid:'+ConFlds->Wid
    Text = Text:Add(Line,Text)

    If (ConFlds->Before)
      Line = '  Before:'+ConFlds->Before
      Text = Text:Add(Line,Text)

    If (ConFlds->After)
      Line = '  After:'+ConFlds->After
      Text = Text:Add(Line,Text)

    If (ConFlds->Action)
      Line = '  Action:'+ConFlds->Action
      Text = Text:Add(Line,Text)

    ConFlds=Struct:Next('ConFlds','PagePos',ConFlds)
    If (ConFlds->Page!=PageNo)
      Break
  Text=Text:Top(Text)
  File:Save('Page'+PageNo+'.Lst',Text)
  Return (Text)

ConFlds:GetPage(PageNo)
  New (ConPage:NewPage,ThePage)
  Jorf:File("CONFLDS.DAT",Here)
  ThePage=Struct:Find('ConPage','PageNo',PageNo)
  If (ThePage->Text==Null)
    NewPage->PageNo=PageNo
    NewPage->Text=ConFlds:Generate(PageNo)
    If (NewPage->Text)
      Jorf:Write(NewPage)
      ThePage=NewPage
  Return (ThePage->Text)

ConFlds:IsPage(PageNo)
  New (ConFlds:ConFlds)
  Jorf:File("CONFLDS.DAT",Here)
  ConFlds=Struct:Find('ConFlds','PagePos',Num:Str(PageNo,"###",10,3))
  If (ConFlds)
    Return (Ok)
  Return (Null)

ConFlds:KeySearch (*ConFlds,Prompt,Field)
  New (Value)
  Event:Add
  Win:Add ("Key Search", 10, 25, 0, 0, Here)
    Input:"Search for {Prompt}", Wid:30, Field:"Value"
  If (Kbd:Got <> "Esc_Key")
    Mem:Ptr->ConIndex=Field
    ConFlds=Struct:Find('ConFlds',Mem:Ptr->ConIndex,Value)
    Win:Dsp
  Return (ConFlds)

ConFlds:LastPage
  New (ConFlds:ConFlds)
  Jorf:File("CONFLDS.DAT",Here)
  ConFlds=Struct:Prev('ConFlds','PagePos',Null)
  If (ConFlds)
    Return (ConFlds->Page)
  Return (Null)

ConFlds:Next(*ConFlds,Flag)
  If (Flag=='Prev')
    ConFlds=Struct:Prev('ConFlds',Mem:Ptr->ConIndex,ConFlds)
  Else
    ConFlds=Struct:Next('ConFlds',Mem:Ptr->ConIndex,ConFlds)
  Return(ConFlds)

ConFlds:Rebuild
  New (Page)
  While (Ok)
    Page=Struct:Find('ConPage','PageNo',Null)
    If (Page)
      Jorf:Del(Page)
    Else
      Break
  Jorf:Rebuild
  Return (Ok)

ConFlds:Show(ConFlds)
  New (ShowStr)
  ShowStr=          Str:Pad(ConFlds->Prompt,14) + " "
  ShowStr=ShowStr + Str:Pad(ConFlds->PagePos,10) + " "
  ShowStr=ShowStr + Str:Pad(ConFlds->Field,14)
  Return (ShowStr)

