Tutorial:Start
  Event:Add("Tutorial")
  Jorf:File("TutText.J")

  Win:Add ("Josephine's Recipe Filer Tutorial", 0, 0, 22, 78, Here.)
    Menu:"&File"
      Menu:"E&xit         Alt-X" Action:"Jorf:Exit"
    This tutorial is {prompt:"&Hypertext", Action:"Tutorial:Box('Intro:Hyper')"}. &
    Press {Bold:"Lo"}Enter{Bold:"No"} to see the highlighted subjects. &
    Use your arrow keys to highlight different subjects.  You can &
    zoom to highlighted letters by holding the Alt key down &
    while pressing that letter.

    {Prompt:"&Josephine", Action:"Tutorial:Box('Intro:Jo')"}'s Recipe Filer, &
    JORF(R), is a new computer &
    language.  JORF was created by a &
    {Prompt:"&Grunt-Programmer" Action:"Tutorial:Box('Intro:Grunt')"} &
    frustrated by low level math based computer languages &
    that are inapproprate for business data processing.  With the JORF &
    language you can easily create data entry screens,  &
    and write sophisticated routines using an Object Oriented &
    data base manager.

    Press "Enter" now, to read more about the Hypertext system. &
    Then, highlight the various topics and explore &
    this Tutorial.   Thank you for your support.

    {Group:"Hypertext Topics" Row:13 Col:4 Len:5 Wid:70}
    {Prompt:" &About the JORF Language   " Row:14 Col:08 Wid:30 Action:"Tutorial:Box('Tut:About')"}
    {Prompt:" JORF &Programming Basics   " Row:15 Col:08 Wid:30 Action:"Tutorial:Box('Tut:Basic')"}
    {Prompt:" JORF Ad&vanced Programming " Row:16 Col:08 Wid:30 Action:"Tutorial:Box('Tut:AdvStart')"}
    {Prompt:" &OOP Programming Concepts  " Row:17 Col:08 Wid:30 Action:"Tutorial:Box('Tut:Oop')"}
    {Prompt:" JORF &Window Manager       " Row:18 Col:08 Wid:30 Action:"Tutorial:Box('Tut:DataEntry')"}
    {Prompt:" G&etting Started with JORF " Row:14 Col:42 Wid:30 Action:"Tutorial:Box('Write:Start')"}
    {Prompt:" &Quick Demonstration       " Row:15 Col:42 Wid:30 Action:"Tutorial:Box('Quick:Start')"}
    {Prompt:" &Registering JORF          " Row:16 Col:42 Wid:30 Action:"Tutorial:Regist"}
    {Prompt:" JORF Company Produc&ts     " Row:17 Col:42 Wid:30 Action:"Tutorial:Box('Tut:Prod')"}
    {Prompt:" &Contacting JORF Company   " Row:18 Col:42 Wid:30 Action:"Tutorial:Box('Tut:JorfCo')"}

    {Button:"&Sample Programs" Row:20 Col:2  Wid:22 Action:"Tutorial:Samples"}
    {Button:"See &Debugger"    Row:20 Col:28 Wid:22 Action:"Tutorial:Debugger"}
    {Button:"E&xit"            Row:20 Col:56 Wid:22 Action:"Jorf:Exit"}
  Jorf:Exit

JORFNote:Say (Letter)
  Msg:Add ("My Letter", "Ok")
    {Date:Str(Date:Get,"m d, y")}

    Dear Wayland,

    I just had to write to you, because I am &
    so {Letter->Feeling} by JORF. In Fact, &
    {Letter->Thought}

    Yours Truly,

    {Letter->Name}
    {Letter->Street}
    {Letter->CityStZip}
  Return(Ok)

JORFNote:Start
  New (JORFNote:Letter)
  Win:Add ("Letter To The JORF Company" 0,0,5,20)
    Input:"Your Name   ", Field:"Letter->Name"
    Input:"Your Street ", FIeld:"Letter->Street"
    Input:"City/St/Zip ", Field:"Letter->CityStZip"

    String:"How does JORF make you feel?  (Excited, Bored, Confused...)"
    Input:"Your Feeling ", Wid:20, Field:"Letter->Feeling"

    String:"What do you think of JORF? (Really Neat, Too Complicated...)"
    Input:"", Wid:60 Len:6, Field:"Letter->Thought"
    String:"           (Press Escape to Finish Text Entry)"
  JORFNote:Say (Letter)
  Return(Ok)

Tutorial:Alt_F10_Key
  Win:Add("Time")
    Flrco:"Center"
    {Date:Str(Date:Get,"s d, y")}
    {Time:Str(Time:Get,"h:mm")}
  Return Ok

Tutorial:Alt_F5_Key
  Jorf:Flush
  Return Ok

Tutorial:Alt_X_Key
  Jorf:Exit
  Return Ok

Tutorial:Box(Name)
  New (Box,Text,ShowText,ShowLine,NextLine)
  New (Label,NextName,Button)
  Text = Method:Find(Name)
  Text = Text:Next(Text)
  If (Text)
    Label = Class:At(Text,1)
    While (Label)
      Switch (Label)
	Case 'Title'
	  Box->Title = Word:At(Text,1)
	Case 'Wid'
	  Box->Wid   = Word:At(Text,1)
	Case 'Len'
	  Box->Len   = Word:At(Text,1)
	Case 'Script'
	  Jorf:Do("Script:"+Word:At(Text,1))
	  If (Kbd:Got=='Esc_Key')
	    Return (Null)
	  Jorf:Do (Word:At(Text, 2))
        Case 'Run'
          Jorf:Do (Word:At(Text,1))
      Text = Text:Next(Text)
      Label = Class:At(Text,1)

    ShowText = Text:Add()
    While (Text)
      ShowLine = Str:At(Text,3)
      NextLine = Text:Next(Text)
      Switch
        Case (ShowLine==Null)
        Case (Str:At(ShowLine,1,1)==' ')
        Case (Str:At(ShowLine,1,1)=='{')
        Case (Str:At(NextLine,3,1)=='{')
        Case (Str:Len(NextLine)==0)
          ShowText = Text:Add(ShowLine,ShowText)
        Else
          ShowText = Text:Add(ShowLine+" &",ShowText)
      Text = NextLine

    ShowText = Text:Top(ShowText)
    If (Box->Wid==0)
      Box->Wid=Text:Wid(ShowText,99,TRUE)
    If (Box->Len==0)
      Box->Len=Text:Len(ShowText,0,Box->Wid-1)

    Button =  "Wid:20 Row:"+(Box->Len)+" Col:"+((Box->Wid-20)/2)
    NextName = Tutorial:Next(Name)
    If (Method:Find(NextName)!=Null)
      Text:Chg("Button:'&More . . .' Action:'Tutorial:Box("+'"'+NextName+'"'+")'" + Button, ShowText)
    Else
      Text:Chg("Button:'&Done' Action:'Return(Null)' " + Button, ShowText)
    Box->Text = ShowText
    Kbd:Put("Down_Arrow_Key")  | Moves to top item in box . . .
    Win:Add(Box)
    If (Kbd:Got != 'Esc_Key')
      Kbd:Bye()
      Kbd:Put("Down_Arrow_Key")  | Moves to next item in box
      Return (Null)
  Return (Ok)

Tutorial:F1_Key
  If File:Exist("Help.Jrf" 0)
    Jorf:File ("Help.Jrf" Here)
    Help:Start
  Else
    Msg:Add
      The HELP.JRF file is not &
      on the current directory
  Return Ok

Tutorial:Next(Name)
  New (Char)
  Char = Str:At(Name,Str:Len(Name),1)
  if (Char >= "0" And Char <= "9")
    Name = Str:At(Name,1,-1) + (Char+1)
  Else
    Name = Name + "1"
  Return(Name)

Tutorial:Regist
  Win:Add("Registration")
    This program is Shareware.  Feel free to try it out without &
    charge, and to copy it to give it to friends.  If you decide &
    to use the JORF interpreter to create new programs, you must &
    purchase a registered copy from The JORF Company.

    We do not charge for any shipping within the U.S. or Canada. &
    We normally ship all versions on 3 1/2 inch disks so be sure to &
    note if you need 5 1/4 inch disks.

    If you have a printer hooked up, I have written a nice little &
    sample program to take the info and print a registration letter. &
    Just press the R button.

    {Button:"&Register Now" Row:13 Col:5 Wid:20 Action:"Tutorial:Run('REGISTER')"}
    {Button:"&Done" Row:13 Col:40 Wid:20 Action:"Return(Null)"}
  Return (Ok)

Tutorial:Ret
  If (Kbd:Got != 'Esc_Key')
    Return (Null)
  Return (Ok)

Tutorial:Run(FileName)
  If File:Exist(FileName+".J",0)
    Jorf:File (FileName,Here)
    Jorf:Do (FileName+":Start")
  Else
    Msg:Add
      The {FileName}.J file is not &
      on the current directory
  Kbd:Bye
  Return (Ok)

Tutorial:Samples
  Win:Add("Sample Programs",0,0,0,60,Here)
    Button:"&Done" Row:19 Col:20 Wid:20 Action:"Null"
    From the Debugger, select {Bold:"Lo"}F{Bold:"No"}ile, &
    {Bold:"Lo"}O{Bold:"No"}pen and run any of the following &
    programs.
    {Bold:"Lo"}
	ASCII.J      Basic Consol Operations
	ATTACK.J     Fun Typewriter attack game
	BINARY.J     Number formatting example
	COLORS.J     Demonstration of all colors
	CONTACT.J    Big Contact Manager (See Maillist)
	FILEPRNT.J   Print any file on directory
	FRENKEY.J    French Accents - Easy
	HAIKU.J      Poetry Generator
	MANTRA.J     Send your computer to heaven
	MAILLIST.J   Basic Contact Manager
	REGISTER.J   Register JORF - Input/Print example
	TEXTEDIT.J   Little text editor
	WHATKEY.J    Keyboard return values
    {Bold:"No"}
  Return (Ok)

Tutorial:Shift_F5_Key
  Jorf:Status
  Jorf:StatusClear
  Return Ok

Tutorial:Debugger
  Msg:Add
    To go back to Running the Tutorial, &
    Press {Bold:"Lo"}Alt-G{Bold:"No"}.  Pressing &
    Escape will exit the Debugger and the Tutorial.

  Kbd:Put("Ctrl_Break_Key")
  Return (Ok)

Class:Address Name Street CityStZip

Class:JORFNote Parent:Address Feeling Thought

Demo:Screen
  New (Rad, Chk, Inp1, Inp2)
  Win:Add ("A Real Screen", 4, 8, 14, 50, Here)
    Menu:"&Help"
      Menu:"&Indented Menu Items"
        Menu:"&Create Sub Menus"
          Menu:"&And Even Deeper"
          Menu:"&Sub Menus"
        Menu:""
        Menu:"(Escape to Exit)"
      Menu:"&Jorf Help           F1" Action:"Tutorial:F1_Key"
      Menu:"&Time and Date  Alt-F10" Action:"Tutorial:Alt_F10_Key"
    String:"  Use your Arrow Keys to go up and down.  On"
    String:"  Check Boxes and Radio Buttons, the Enter Key"
    String:"  checks and Space Bar skips.  Be sure to Press"
    String:"  Alt-H to check out the Menus and Submenus!"
    Radio:" Radio &1" Row:6 Col:8
      Check:"Rad==True", Action:"Rad=True"
    Radio:" Radio &2"
      Check:"Rad==False", Action:"Rad=False"
    ChBox:" Check Box &A" Row:6, Col:26
      Check:"Chk==True", Action:"Chk=True"
    ChBox:" Check Box &B"
      Check:"Chk==False", Action:"Chk=False"
    Input:"&Input 1  " Row:9, Col:8 Field:"Inp1"
    Input:"I&nput 2  "              Field:"Inp2"
    Button:"  &Done  "   Row:12, Col:24, Action:"Return 'Esc_Key'"
  Return

Demo:Start
  Msg:Add ("Quick Demonstration", "Ok")
    Sure you can say "Hello World" in one line of
    C code.  But how many punctuation characters
    are required to display a dialog box like this?

Script:Add(Name)
  Win:Add("The JORF Editor and Debugger", 0, 0, 24, 78, Here)
    Magic:"P"
    Menu:"&File"
    Menu:"&Edit"
    Menu:"&Debugger
    Menu:"&Show
    Menu:"&Help"
    Menu:"&About"
  Win:Msg("Press the space bar to speed up typing")
  Event:Add ('Script')
  Jorf:File ("Tutorial.Jrf", Here)
  Jorf:Do (Name)
  If (Kbd:Got != 'Esc_key')
    Win:Ptr->Text = Text:Top(Win:Ptr->Text)
    Method:Add (Win:Ptr->Text)
  Return

Script:Box(Title, Len, Wid, Text)
  New (Row, Col)
  Row = Win:Ptr->Row + Win:Ptr->CurRow + 3
  Col = Win:Ptr->Col - 4
  Win:Add (Title, Row, Col, Len, Wid, Here, Text)
  Return

Script:Else Key
  Return Null

Script:Esc_Key
  Return ('Esc_Key')

Script:Say(Line)
  Win:Ptr->Text=Text:Add (Line, Win:Ptr->Text)
  If (Kbd:Hit)
    Kbd:Get
  If (Kbd:Got="Space_Bar")
    Str:PutLine(Line)
  Else
    Script:SayLineByCharacter (Line)
  Return(Ok)

Script:SayLineByCharacter(J)
  New (I, C)
  I=1
  While (ok)
    C=Str:At (J, I, 1)
    If (Str:Len (C) < 1)
      Break
    Str:Put (C)
    ++I
    If (C<>" ")
      Win:Pause (2)
    If (Kbd:Hit)
      Kbd:Get
    If (Kbd:Got="Space_Bar")
      Break
  Str:PutLine(Str:At(J, I))

