Class:Haiku
  Index:Key     | A "Key" to store this structure
  Text          | Current Haiku Text
  Arts          | Sentence articles
  Adjs          | Adjectives
  Nouns         | Nouns
  Verbs         | Verbs
  Preps         | Preps

Haiku:Start
  New (Haiku:Haiku)
  Jorf:File ("Haiku", Here)
  Haiku=Haiku:GetStructure()
  Haiku:Thinkup(Haiku)
  Event:Add()
  Win:Add("Haiku Generator", 4, 15, 10, 50, Here)
    Menu:"&File"
      Menu:"E&xit" Action:"Return Null"
    Menu:"&Print"
      Action:"Haiku:Print(Haiku)"

    Group:"" Row:2 Col:5 Len:3 Wid:40   | Group box border
    Text:"" Field:"Haiku->Text"         | Text to show
      Before:"Null"                     | Never any input here

    Button:"&Generate" Row:8, Col:5 Wid:20 Action:"Haiku:Thinkup(Haiku)"
    Button:"E&xit"     Row:8, Col:27 Wid:20 Action:"Return Null"
  Return (Ok)

Haiku:Array (Text)
  | This routine loads words into an array.  Double words must be quoted.
  | The Array is written to the current file (HAIKU.JRF).
  New (WordCount, Arr, ArrCount, Spaces)
  Spaces = Str:Ind(Text)                | Indent level
  While (Text And Spaces <= Str:Ind(Text))
    For (WordCount = 1 thru Word:Len (Text))    | For each word
      ++ArrCount                                | Add word to
      Arr[ArrCount]=Word:At (Text, WordCount)   |   word array
    Text = Text:Next (Text)             | Next line
  Jorf:Write (Arr)                      | Write to current file
  Return (Arr)

Haiku:Generate (Haiku, Text)
  New (Spaces, CurWord, Pos)
  New (NewWord, NewLine, NewText)
  Spaces = Str:Ind (Text)
  While (Text And Spaces <= Str:Ind(Text))
    | Step backwards - so we can switch "A" to "AN" when necessary
    For (Pos = Word:Len (Text) thru 1 Step -1)
      CurWord = Word:At (Text, Pos)
      Switch (CurWord)
        Case 'Art'
          NewWord = Haiku:GetWord (Haiku->Arts)
          If NewWord = "a"
            If (Str:Aft (NewLine,"aeiou") < 2)
              NewWord = "an"
        Case 'Noun'
          NewWord = Haiku:GetWord (Haiku->Nouns)
        Case 'Adj'
          NewWord = Haiku:GetWord (Haiku->Adjs)
        Case 'Verb'
          NewWord = Haiku:GetWord (Haiku->Verbs)
        Case 'Prep'
          NewWord = Haiku:GetWord (Haiku->Preps)
        Else
          NewWord = CurWord
      If (Pos = 1)
        NewWord = To:Caps (NewWord)
      NewLine = NewWord + NewLine
    NewText = Text:Add (NewLine, NewText)
    NewLine = Null
    Text = Text:Next (Text)
  Haiku->Text = NewText
  Return (Ok)

Haiku:GetStructure
  | Get Haiku structure from file.  If not found in file, generate
  |  it from the word lists.
  New (Haiku:Haiku)
  Haiku = Struct:Find("Haiku","Key",Null)
  If (Haiku == Null)
    Haiku->Arts = Haiku:Array()
      a the
    Haiku->Adjs = Haiku:Array()
      autumn hidden bitter misty silent empty
      dry dark sighing delicate quiet
      white cool frigid winter dappled
      twilight afternoon crimson wispy azure
      blue billowing broken cold damp falling
      frosty tawny long late lingering
      little morning leafy billowing
      still small sparkling cloudy
      wandering withered wild black young
    Haiku->Nouns = Haiku:Array()
      waterfall mist breeze moon
      rain wind sea morning snow glitter forest
      Josephine cloud meadow sun glade bird brook
      butterfly tove dew savannah meadow
      flower firefly feather grass haze mountain
      night goat shade snowflake
      silence lily sky shape surf thunder
      violet water wildflower wave
    Haiku->Verbs = Haiku:Array()
      drifts "has stopped" blusters blows
      races "did gimble" stretches
      flutters has risen "is drifting" "is trickling"
      murmers "is floating" "is wafting"
    Haiku->Preps = Haiku:Array()
      on in beneath over near of
    Haiku->Key = "Key"
    Jorf:Write (Haiku)
  Return (Haiku)

Haiku:GetWord (Arr)
  New (Word, Off)
  Off = Num:Rand (1, Word:Len (Arr))
  Word = Arr[Off]
  Return Word + " "

Haiku:Print(Haiku)
  New (Dest)
  Dest=Jorf:Printer()
  If (Dest!=Null)
    File:Save("JREPORT.LST",Haiku->Text)
    File:Append("JREPORT.LST")
    File:Print("JREPORT.LST",Dest,TRUE)
  Return (Ok)

Haiku:Thinkup(Haiku)
  Switch Num:Rand (1, 4)
    Case 1
      Haiku:Generate (Haiku)
        Art Adj Noun . . .
        Art noun verb prep art noun
        Adj Adj Noun
    Case 2
      Haiku:Generate (Haiku)
        Noun Prep Art Noun
        Art Adj Noun Prep Art Noun
        Adj Noun
    Case 3
      Haiku:Generate (Haiku)
        Art Adj Noun
        Art Adj Noun
        Art Noun Verb
    Case 4
      Haiku:Generate (Haiku)
        Art Adj Noun Verb
        Art Adj Noun
        Prep Art Adj Noun
  Win:Dsp
  Return(Ok)

