Class:Cal      | Declare class Calc
  Date         |
  Day          | Current day
  Month        | Current entry value
  Year         | Current year
  Row          | Current Row
  Col          | Current Col
  DspDay       | Last displayed day
  DspMonth     | Last displayed month
  DspYear      | Last displayed year
  DspRow       | Last displayed row
  DspCol       | Last displayed col

Cal:start
  New(Cal:Cal)
  Cal->Date   = Date:Get
  Event:Add("Cal")

  Win:Add ("Calendar",0,0,9,20)
  Cal:Show(Cal)
  While (Ok)
    If (Kbd:Get()=='Esc_Key')
      Break
  Return (Cal->Date)

Cal:Ctrl_Page_Down_Key
  Cal->Date = Date:Add(Cal->Date,0,0,1)
  Cal:Show( Cal )
  Return (Ok)

Cal:Ctrl_Page_Up_Key
  Cal->Date = Date:Sub(Cal->Date,0,0,1)
  Cal:Show( Cal )
  Return (Ok)

Cal:Down_Arrow_Key
  Cal->Date = Date:Add(Cal->Date,7,0,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:End_Key
  Cal->Date = Date:Add(Cal->Date,6-(Date:Str(Cal->Date,'n')%7),0,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:Enter_Key
  Msg:Add
    Date is {Cal->Date}
  Return ("Esc_Key")

Cal:Home_Key
  Cal->Date = Date:Sub(Cal->Date,(Date:Str(Cal->Date,'n')%7),0,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:Left_Arrow_Key
  Cal->Date = Date:Sub(Cal->Date,1,0,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:Page_Down_Key
  Cal->Date = Date:Add(Cal->Date,0,1,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:Page_Up_Key
  Cal->Date = Date:Sub(Cal->Date,0,1,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:Right_Arrow_Key
  Cal->Date = Date:Add(Cal->Date,1,0,0)
  Cal:Show( Cal )
  Return (Ok)

Cal:Show(Cal)
  New (Month, Day, Dow, Pos, Cnt, End)

  If (Date:Str(Cal->Date,'y') != Cal->DspYear)
    Cal->DspMonth=0

  If (Date:Str(Cal->Date,'m') != Cal->DspMonth)
    If (Cal->DspDay)
      Move:To(Cal->DspRow,Cal->DspCol)
      Str:Put(To:Str(Cal->DspDay,"##"))
      Cal->DspDay=0
    Month=Date:Str(Cal->Date,"S")+' '+Date:Str(Cal->Date,"YYYY")
    Move:To(1,1)
    Str:Put(Str:AtSet(Null,1,' ',Win:Ptr->Wid))
    Move:To(1,(Win:Ptr->Wid-Str:Len(Month)+1)/2)
    Str:Put(Month)
    Move:To(2,1)
    Str:Put("____________________")
    Move:To(3,1)
    Str:Put("Su Mo Tu We Th Fr Sa")
    Dow  =Date:Str(Cal->Date,'n') % 7
    Day  =Date:Str(Cal->Date,'d')
    End  =Date:Add(Cal->Date,0,1)
    End  =Date:Sub(End,Day)
    End  =Date:Str(End,'d')
    Pos  =Date:Str(Date:Sub(Cal->Date,Day-1),'n') % 7
    Move:To (4,1)
    Str:Put(Str:AtSet(Null,1,' ',Win:Ptr->Wid))
    For (Cnt = 1 thru End)
      Move:To(0,(Pos*3)+1)
      Str:Put(To:Str(Cnt,"##"))
      ++Pos
      If (Pos > 6)
        Move:By(1,0)
        Move:To(0,1)
        Str:Put(Str:AtSet(Null,1,' ',Win:Ptr->Wid))
        Move:To(0,1)
        Pos=0
    If (Pos == 0 Or Win:Ptr->CurRow < 9)
      Move:To (9,1)
      Str:Put(Str:AtSet(Null,1,' ',Win:Ptr->Wid))
    Cal->DspYear  = Date:Str( Cal->Date, 'y' )
    Cal->DspMonth = Date:Str( Cal->Date, 'm' )
    Cal->DspDay   = 0

  If (Date:Str(Cal->Date,'d') != Cal->DspDay)
    If (Cal->DspDay)
      Move:To(Cal->DspRow,Cal->DspCol)
      Str:Put(To:Str(Cal->DspDay,"##"))
      Cal->DspDay=0
    Day  =Date:Str( Cal->Date, 'd' )
    Dow  =Date:Str( Cal->Date, 'n' ) % 7
    Cal->DspDay = Day
    Cal->DspRow = 4 + To:Int( ( Day - Dow + 5) / 7 )
    Cal->DspCol = ( Dow * 3 ) + 1

    Win:Attr( 5 )
    Move:To( Cal->DspRow, Cal->DspCol )
    Str:Put( To:Str( Cal->DspDay, "##" ) )
    Win:Attr( 1 )

  Return(Ok)

Cal:Up_Arrow_Key
  Cal->Date = Date:Sub(Cal->Date,7,0,0)
  Cal:Show( Cal )
  Return (Ok)

