/****************************************************************************

            Print program that bypasses DOS and BIOS print routines
                      to allow good background printing

*****************************************************************************/
/* version 1.1
      Tweaked to reduce size of executable

      Ralf Brown   1:129/31
      11/6/88
*/

#include <stdio.h>
#include <fcntl.h>
#include <ctype.h>
#ifdef __TURBOC__
#include <stdlib.h>
#include <dos.h>
#include <io.h>
void prchar(unsigned char) ;
int prfile(char *name) ;
int prind(char *name) ;

/* tweaks to let program run in minimal memory */
unsigned int _stklen = 768 ;    /* don't need 4K stack */
unsigned int _heaplen = 128 ;   /* don't need much heap */
void _setenvp(void) {}          /* don't need environment array */
#endif __TURBOC__

int port;	/*  Port address  */
int auto_ff;	/*  Set nonzero if FF is to be printed after each file  */

/*****  Routine to print one character to parallel port  *****/

void prchar(c)
unsigned char c;
{
  unsigned char status;

  while ((inportb(port+1)&0xb8)!=0x98) ;	/*  Wait for printer ready  */
  status=inportb(port+2);			/*  Get current status  */
  outportb(port,c);				/*  Output data  */
  outportb(port+2,status|1);			/*  Strobe STR line  */
  outportb(port+2,status&~1);
}

/*****  Routine to print file specified by fname.  Returns 0 if file  *****/
/*****  printed o.k., -1 if there was an error opening the file.      *****/

int prfile(fname)
char *fname;
{
  static unsigned char buff[512];
  int i,n,fd;

  fd=open(fname,O_RDONLY|O_BINARY);
  if (fd<0) return(-1);
  while ((n=read(fd,buff,sizeof(buff)))>0) {
    for (i=0; i<n; i++) prchar(buff[i]);
  }
  close(fd);
  if (auto_ff) prchar(12);	/*  Print FF after file if requested  */
  return(0);
}

/*****  Routine to print each file listed in file fname.  Handles  *****/
/*****  nested "@" files.  Returns -1 on error, 0 otherwise.       *****/

int prind(fname)
char *fname;
{
  extern char *fgets();
  static char buff[80];
  char *cp,*cp2;
  FILE *fp;

  fp=fopen(fname,"r");
  if (!fp) return(-1);
  while (fgets(buff,sizeof(buff),fp)) {
    cp=buff;
    while (*cp && isspace(*cp)) cp++;
    if (!(*cp)) continue;
    if (*cp=='@') {		/*  Handle nested @filename recursively  */
      cp++;
      while (*cp && isspace(*cp)) cp++;
      cp2=cp;
      while (*cp && !isspace(*cp)) cp++;
      *cp=0;
      prind(cp2);
    } else {			/*  Print file  */
      cp2=cp;
      while (*cp && !isspace(*cp)) cp++;
      *cp=0;
      prfile(cp2);
    }
  }
  fclose(fp);
  return(0);
}

/*****  Here we go!  *****/

main(ac,av)
int ac;
char *av[];
{
  int i,portnum;
  char c;
  char name[80] ;

  if (ac<2) {
    puts("Qupie print program   by Rob Epps\n\tv1.1 tweaked by Ralf Brown");
    puts("Usages:\n");
    puts("\tQP [options] filename");
    puts("\t    prints one file.");
    puts("\tQP [options] @filename");
    puts("\t    prints files whose names are in specified file.");
    puts("\t    The file is a simple text file containing one file name per line.");
    puts("\tQP [options] =") ;
    puts("\t    prompts for files to print") ;
    puts("Options:\n");
    puts("\t-f   print form feed after each file.");
    puts("\t-l#  print to printer # (i.e. -l2 prints to LPT2).\n");
    exit(1);
  }
  portnum=0;
  if (ac>2) {		/*  Process options  */
    for (i=1; i<ac; i++) if (*av[i]=='-') {
      c=*(av[i]+1);
      if (c=='f' || c=='F') auto_ff=1;
      if (c=='l' || c=='L') {
        portnum = atoi(av[i]+2);
        if (portnum<1 || portnum>4) {
          puts("Sorry, can't deal with that printer port selection!\n");
          fflush(stdout) ;
          exit(1);
        }
        portnum--;
      }
    }
  }
  port=peek(0x40,8+portnum+portnum);
  if (!port) {
    fputs("There's no LPT",stdout) ;
    putchar(portnum+'1') ;
    puts(" entry in BIOS table!");
    exit(1);
  }
  if (*av[ac-1]=='=' && av[ac-1][1]=='\0')  /* if filename is '=', prompt for name */
     {
     puts("Enter filename or just RETURN when done") ;
     do {
        fputs("File: ",stdout) ;
        gets(name) ;
        if (name[0] == '@')
           prind(name+1) ;
        else if (*name)
           prfile(name) ;
        } while (*name != '\0') ;
      }
  if (*av[ac-1]=='@') prind(av[ac-1]+1); else prfile(av[ac-1]);
  exit(0);
}
