/****************************************************************************

            Print program that bypasses DOS and BIOS print routines
                      to allow good background printing

*****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>

int port;	/*  Port address  */
int auto_ff;	/*  Set nonzero if FF is to be printed after each file  */

/*****  Routine to print one character to parallel port  *****/

prchar(c)
unsigned char c;
{
  unsigned char status;

  while ((inportb(port+1)&0xb8)!=0x98) ;	/*  Wait for printer ready  */
  status=inportb(port+2);			/*  Get current status  */
  outportb(port,c);				/*  Output data  */
  outportb(port+2,status|1);			/*  Strobe STR line  */
  outportb(port+2,status&~1);
}

/*****  Routine to print file specified by fname.  Returns 0 if file  *****/
/*****  printed o.k., -1 if there was an error opening the file.      *****/

prfile(fname)
char *fname;
{
  static unsigned char buff[512];
  int i,n,fd;

  fd=open(fname,O_RDONLY|O_BINARY);
  if (fd<0) return(-1);
  while ((n=read(fd,buff,sizeof(buff)))>0) {
    for (i=0; i<n; i++) prchar(buff[i]);
  }
  close(fd);
  if (auto_ff) prchar(12);	/*  Print FF after file if requested  */
  return(0);
}

/*****  Routine to print each file listed in file fname.  Handles  *****/
/*****  nested "@" files.  Returns -1 on error, 0 otherwise.       *****/

prind(fname)
char *fname;
{
  extern char *fgets();
  static char buff[80];
  char *cp,*cp2;
  FILE *fp;

  fp=fopen(fname,"r");
  if (!fp) return(-1);
  while (fgets(buff,sizeof(buff),fp)) {
    cp=buff;
    while (*cp && isspace(*cp)) cp++;
    if (!(*cp)) continue;
    if (*cp=='@') {		/*  Handle nested @filename recursively  */
      cp++;
      while (*cp && isspace(*cp)) cp++;
      cp2=cp;
      while (*cp && !isspace(*cp)) cp++;
      *cp=0;
      prind(cp2);
    } else {			/*  Print file  */
      cp2=cp;
      while (*cp && !isspace(*cp)) cp++;
      *cp=0;
      prfile(cp2);
    }
  }
  fclose(fp);
  return(0);
}

/*****  Here we go!  *****/

main(ac,av)
int ac;
char *av[];
{
  int i,portnum;
  char c;

  if (ac<2) {
    printf("Qupie print program   by Rob Epps\n\n");
    printf("Usages:\n\n");
    printf("        QP [options] filename\n");
    printf("            prints one file.\n\n");
    printf("        QP [options] @filename\n");
    printf("            prints files whose names are in specified file.\n");
    printf("            The file is a simple text file containing one\n");
    printf("            file name per line.\n\n");
    printf("Options:\n\n");
    printf("        -f   print form feed after each file.\n");
    printf("        -l#  print to printer # (i.e. -l2 prints to LPT2).\n\n");
    exit(1);
  }
  portnum=0;
  if (ac>2) {		/*  Process options  */
    for (i=1; i<ac; i++) if (*av[i]=='-') {
      c=*(av[i]+1);
      if (c=='f' || c=='F') auto_ff=1;
      if (c=='l' || c=='L') {
        sscanf(av[i]+2,"%d",&portnum);
        if (portnum<1 || portnum>4) {
          printf("Sorry, can't deal with that printer port selection!\n");
          exit(1);
        }
        portnum--;
      }
    }
  }
  port=peek(0x40,8+portnum+portnum);
  if (!port) {
    printf("There's no LPT%d entry in BIOS table!\n",portnum+1);
    exit(1);
  }
  if (*av[ac-1]=='@') prind(av[ac-1]+1); else prfile(av[ac-1]);
  exit(0);
}
