
/******************************************************************************
*                                                                             *
*   Using the internal WinHelp API to search multiple help files for a topic  *
*                                                                             *
*                    9/17/93 by Mark Gamber - Public Domain                   *
*                                                                             *
******************************************************************************/

#include "windows.h"
#include "memory.h"
#include "baggage.h"

typedef struct {                   //  This structure defines the layout of the
   FARPROC lpfnUnused;                 //  internal WinHelp functions passed by
   FARPROC lpfnHfsOpenSz;         //  WinHelp to this DLL through LDLLHandler()
   FARPROC lpfnRcCloseHfs;                       //  in the "case 10:" section.
   FARPROC lpfnHfOpenHfs;
   FARPROC lpfnRcCloseHf;
   FARPROC lpfnLcbReadHf;
   FARPROC lpfnLTellHf;
   FARPROC lpfnLSeekHf;
   FARPROC lpfnFEofHf;
   FARPROC lpfnLcbSizeHf;
   FARPROC lpfnFAccessHfs;
   FARPROC lpfnRcLLInfoFromHf;
   FARPROC lpfnRcLLInfoFromHfs;
   FARPROC lpfnErrorW;
   FARPROC lpfnErrorSz;
   FARPROC lpfnGetInfo;
   FARPROC lpfnAPI;                     //  Internal function of note this time
} BPROC;

// ----------------------------------------------------------------------------

HINSTANCE hInst;
BPROC Bp;

// ----------------------------------------------------------------------------

BOOL WINAPI DLLEntryPoint( HANDLE hDll, DWORD dwReason, LPVOID lpReserved )
{
   hInst = hDll;	                //  DLL starts...save instance and keep going
   return( TRUE );
}

// ----------------------------------------------------------------------------

LONG CALLBACK LDLLHandler( WORD wMsg, LONG lParam1, LONG lParam2 )
{
   switch( wMsg )
   {
      case 1:          //  These are apparently DW_INIT and DW_WHATMSG messages
      case 4:          //  Either way, we want a return value with all bits set
         return( 0xFFFFFFFFL );

      case 10:        //  DW_CALLBACKS...WinHelp passes internal functions here
         memcpy( (LPVOID)&Bp, (LPVOID)lParam1,     //  Block copy the structure
                 sizeof(BPROC) );             //  passed to our local structure
         return( TRUE );
   }
   return( FALSE );
}

// ----------------------------------------------------------------------------
//
//    Callable as a WinHelp macro to search multiple help files for a topic
//
// ----------------------------------------------------------------------------

BOOL CALLBACK SearchHelp( LPSTR lpPath, LPSTR lpTopic )
{
   HWND hHelp;
   HWND hList;
   HANDLE hMem;
   LPSTR lpStr;
   LPSTR lpFilename;
   int count, i;
   LONG lStatus;

                         //  Get WinHelp main window handle ot exait if invalid
   hHelp = (HWND)( *Bp.lpfnGetInfo )( (WORD)GI_MAINHWND, (HWND)0 );
   if( ! hHelp )
      return( FALSE );
                                 //  Create a hidden listbox to find help files
   hList = CreateWindow( "listbox", (LPSTR)0, WS_CHILD, 0, 0, 1, 1,
                         hHelp, (HMENU)-1, hInst, (LPVOID)0 );
   if( ! hList )
      return( FALSE );

   ShowWindow( hList, SW_HIDE );                           //  Hide the listbox
   UpdateWindow( hList );

   hMem = GlobalAlloc( GHND, 512 );
   if( ! hMem )
   {
      DestroyWindow( hList );
      return( FALSE );
   }

   lpStr = GlobalLock( hMem );             //  Create some string storage space
   lpFilename = lpStr + 256;

   lstrcpy( lpStr, lpPath );              //  Combine path and wildcard to form
   lstrcat( lpStr, "\\" );                               //  a full search path
   lstrcat( lpStr, "*.HLP" );
                                               //  Direct listbox to find files
   SendMessage( hList, LB_DIR, (WPARAM)0x0007, (LPARAM)lpStr );
   count = SendMessage( hList, LB_GETCOUNT, 0, 0 );         //  How many found?

   if( ! count )                         //  If nothing found, exit the routine
   {
      GlobalUnlock( hMem );
      GlobalFree( hMem );

      DestroyWindow( hList );
      return( FALSE );
   }
                                         //  Else, loop through each file found
   for( i = 0; i < count; i++ )
   {                                          //  Get current file from listbox
      if( SendMessage( hList, LB_GETTEXT, i, (LPARAM)(LPSTR)lpStr ) )
      {
         lstrcpy( lpFilename, lpPath );       //  Combine with user passed path
         lstrcat( lpFilename, "\\" );
         lstrcat( lpFilename, lpStr );       //  Call internal WinHelp function

         lStatus = (LONG)( *Bp.lpfnAPI )( lpFilename,
                                          (WORD)HELP_PARTIALKEY,
                                          (DWORD)lpTopic );
      }
   }

   GlobalUnlock( hMem );
   GlobalFree( hMem );

   DestroyWindow( hList );
   return( TRUE );
}


