/* Unix compatible directory functions for Windows NT
 * Patched together code from the NT port of Perl done by 
 * Clark Williams of Intergraph Corp. with the header file
 * from the Microsoft Windows NT SDK Posix subsystem.
*/

/*
 *  Portions of this code Copyright (c) 1993, Intergraph Corporation
 */

/*
 * $Log: $
 */

static char ntdirver[] = "$Id: ntdir.c,v 1.3 1993/09/16 01:10:14 ESullivan Exp ESullivan $";
#include <fcntl.h>
#include <process.h>
#include <sys/stat.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <windows.h>
#include "ntdirent.h"
#include "ntmem.h"

static void fatal( char * );
//
// File names are converted to lowercase if the
// CONVERT_TO_LOWER_CASE variable is defined.
//

#define CONVERT_TO_LOWER_CASE

#define PATHLEN 1024

//
// The idea here is to read all the directory names into a string table
// (separated by nulls) and when one of the other dir functions is called
// return the pointer to the current file name. 
//

DIR *opendir(const char *filename)
{
    DIR            *p;
    long            len;
    long            idx;
    char            scannamespc[PATHLEN];
    char	   		*scanname = scannamespc;
    struct stat	    sbuf;
    WIN32_FIND_DATA FindData;
    HANDLE          fh;

    //
    // check to see if we\'ve got a directory
    //

    if (stat (filename, &sbuf) < 0 ||
	sbuf.st_mode & _S_IFDIR == 0) {
	return NULL;
    }

    //
    // Get us a DIR structure
    //

    Newz (1501, p, 1, DIR);
    if (p == NULL)
	return NULL;
    
    //
    // Create the search pattern
    //

    strcpy(scanname, filename);

    if (strchr("/\\", *(scanname + strlen(scanname) - 1)) == NULL)
	strcat(scanname, "/*");
    else
	strcat(scanname, "*");

    //
    // do the FindFirstFile call
    //

    fh = FindFirstFile (scanname, &FindData);
    if (fh == INVALID_HANDLE_VALUE) {
	return NULL;
    }

    //
    // now allocate the first part of the string table for the
    // filenames that we find.
    //

    idx = strlen(FindData.cFileName)+1;
    New (1502, p->start, idx, char);
    if (p->start == NULL) {
	fatal ("opendir: malloc failed!\n");
    }
    strcpy (p->start, FindData.cFileName);
    p->nfiles++;
    
    //
    // loop finding all the files that match the wildcard
    // (which should be all of them in this directory!).
    // the variable idx should point one past the null terminator
    // of the previous string found.
    //
    while (FindNextFile(fh, &FindData)) {
	len = strlen (FindData.cFileName);

	//
	// bump the string table size by enough for the
	// new name and it's null terminator 
	//

	Renew (p->start, idx+len+1, char);
	if (p->start == NULL) {
	    fatal ("opendir: malloc failed!\n");
	}
	strcpy(&p->start[idx], FindData.cFileName);
	p->nfiles++;
	idx += len+1;
    }
    FindClose(fh);
    p->size = idx;
    p->curr = p->start;
    return p;
}


//
// Readdir just returns the current string pointer and bumps the
// string pointer to the next entry.
//

struct dirent *readdir(DIR *dirp)
{
    int         len;
    static int  dummy = 0;

    if (dirp->curr) {

	//
	// first set up the structure to return
	//

	len = strlen(dirp->curr);
	strcpy(dirp->dirstr.d_name, dirp->curr);
	dirp->dirstr.d_namlen = len;

	//
	// Fake inode
	//
	dirp->dirstr.d_ino = dummy++;

	//
	// Now set up for the next call to readdir
	//

	dirp->curr += len + 1;
	if (dirp->curr >= (dirp->start + dirp->size)) {
	    dirp->curr = NULL;
	}

	return &(dirp->dirstr);

    } else
	return NULL;
}

//
// Telldir returns the current string pointer position
//

long telldir(DIR *dirp)
{
	return (long) dirp->curr;	/* ouch! pointer to long cast */
}

//
// Seekdir moves the string pointer to a previously saved position
// (Saved by telldir).

void seekdir(DIR *dirp, long loc)
{
	dirp->curr = (char *) loc;	/* ouch! long to pointer cast */
}

//
// Rewinddir resets the string pointer to the start
//

void  rewinddir(DIR *dirp)
{
	dirp->curr = dirp->start;
}

//
// This just free\'s the memory allocated by opendir
//

void  closedir(DIR *dirp)
{
	Safefree(dirp->start);
	Safefree(dirp);
}

/* Print an error message containing the string TEXT, then exit.  */

static void fatal(char *string)
{
	fprintf(stderr, "%s\n", string);
	exit(2);
}




