//=======================================================================
// 
//  CHANGER.C -- A program to randomly change the look of the
//               Windows desktop
//
//  (c) Douglas Boling, 1992
//
//=======================================================================
																								
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dos.h> 

#define	NAMELEN		32
#define	ININAMELEN	13

#include "changer.h"

typedef struct {
	DWORD	lSize;
	WORD	wDate;
	WORD	wTime;
	WORD	wAttr;
	char	szName[13];
} FILEINFO;

typedef struct find_t FIND_T;

char	szBuffer[1024];
char	szNextData[512];
char 	szColorNames[21][18] = {"Background","AppWorkspace","Window",
	                              "WindowText","Menu","MenuText",
	                              "ActiveTitle","InactiveTitle",
	                              "TitleText","ActiveBorder",
	                              "InactiveBorder","WindowFrame",
	                              "Scrollbar","ButtonFace", "ButtonShadow",
	                              "ButtonText","GrayText","Hilight",
   	                           "HilightText","InactiveTitleText",
	                              "ButtonHilight"};

int	sColorIDs [21] = {COLOR_BACKGROUND, COLOR_APPWORKSPACE, COLOR_WINDOW,
                        COLOR_WINDOWTEXT, COLOR_MENU, COLOR_MENUTEXT,
                        COLOR_ACTIVECAPTION, COLOR_INACTIVECAPTION, 
                        COLOR_CAPTIONTEXT, COLOR_ACTIVEBORDER,
                        COLOR_INACTIVEBORDER, COLOR_WINDOWFRAME, 
                        COLOR_SCROLLBAR, COLOR_BTNFACE,COLOR_BTNSHADOW, 
                        COLOR_BTNTEXT, COLOR_GRAYTEXT,COLOR_HIGHLIGHT, 
                        COLOR_HIGHLIGHTTEXT, COLOR_INACTIVECAPTIONTEXT, 
                        COLOR_BTNHIGHLIGHT};
DWORD	rgbColors[21];                        
	    
#define	MAXFOCUS	8
int	sCurrFocus;
int	sFocusArray[8] = {IDD_COLORFRM, IDD_BGROUNDFRM, IDD_SSAVEFRM,
                        IDD_PATTERNFRM, IDD_EDITCAT, IDD_CHENABLED,
                        IDOK, IDD_ABOUT};
   	                     	                  
//-----------------------------------------------------------------------
//Function prototypes
//-----------------------------------------------------------------------
int	PASCAL 		WinMain (HANDLE, HANDLE, LPSTR, int);
long	FAR PASCAL	WndProc (HWND, WORD, WORD, LONG);
BOOL 	FAR PASCAL 	AboutDlgProc (HWND, WORD, WORD, LONG);
BOOL 	FAR PASCAL 	ConfigDlgProc (HWND, WORD, WORD, LONG);

void ChangeDesktop (void);

char		szAppName[] = "Changer";
char		szProfileName[] = "CHANGER.INI";
HANDLE	hInst;

char	szCurcategory[32];

//=======================================================================
//
// Program Entry Point (WinMain)
//
//=======================================================================
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
	            LPSTR lpszCmdParam, int nCmdShow) {

   HWND			hwnd;
	HANDLE		hAccel;
   MSG			msg;
   WNDCLASS		wndclass;
	int			i, j;
	DWORD			dwSeconds;
 
 	srand ((UINT) time(&dwSeconds));
 	hInst = hInstance;
 	//
 	// Check for Win 3.1
 	//
 	i = LOWORD (GetVersion());
 	j = LOBYTE (i) * 256 + HIBYTE (i);
 	if (j < 0x30A) {
 	   MessageBox (0, "Changer requires Windows 3.1", "Changer", 
 	               MB_ICONSTOP | MB_OK);
 	   return (1);
 	} 	   
	//
	// If the /c parameter is used, change the desktop and terminate
	//
  	if (GetPrivateProfileInt ("categories", "Colors", -1, szProfileName) != -1) {
		if (lpszCmdParam[0] == '/' || lpszCmdParam[0] == '-') 
			if (lpszCmdParam[1] == 'c' || lpszCmdParam[1] == 'C') {
			   ChangeDesktop();			   
				return 0;
			}		
	}
	//
	// No /c, so create a nonmodal dialog box as the main window.
	//
	if (!hPrevInstance) {
      wndclass.style          = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
      wndclass.lpfnWndProc    = WndProc;
      wndclass.cbClsExtra     = 0;
      wndclass.cbWndExtra     = DLGWINDOWEXTRA;
      wndclass.hInstance      = hInstance;
      wndclass.hIcon          = LoadIcon (hInstance, szAppName);
      wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground  = COLOR_WINDOW + 1;
      wndclass.lpszMenuName   = 0;
      wndclass.lpszClassName  = szAppName;

      RegisterClass (&wndclass);
   }
	i = GetPrivateProfileInt (szAppName, "x", 300, szProfileName);
	j = GetPrivateProfileInt (szAppName, "y", 100, szProfileName);

	hwnd = CreateDialog (hInstance, szAppName, 0, NULL);

	SetWindowPos (hwnd, NULL, i, j, 0, 0, SWP_NOSIZE);
	ShowWindow (hwnd, nCmdShow);
	hAccel = LoadAccelerators (hInstance, szAppName);

	while (GetMessage (&msg, NULL, 0, 0)) {
	   if (!TranslateAccelerator (hwnd, hAccel, &msg)) 
         if (hwnd == 0 || !IsDialogMessage (hwnd, &msg)) {
			   TranslateMessage (&msg);
   			DispatchMessage (&msg);
   		}	
	}
   return msg.wParam;
}

//----------------------------------------------------------------------
// ahtodw - ASCII hex to double word conversion
//----------------------------------------------------------------------
DWORD ahtodw (char * szInStr) {
   char *	pszDigit;
   DWORD		dwResult;
   int		sDigit;
   
   pszDigit = szInStr;
   dwResult = 0;   
   for (; *pszDigit != 0; pszDigit++) {
		sDigit = (int) *pszDigit;
		sDigit -= 48;
		if (sDigit > 9) sDigit -= 7;
		dwResult *= 16;
		dwResult += (DWORD) sDigit;
	}
	return dwResult;
}

//----------------------------------------------------------------------
// GetNextActive - Querys the INI file for the next active selection
//----------------------------------------------------------------------
BOOL GetNextActive (char *szCat, char *szSel, char *szData) {
	char		szActiveList[64];
	char *	pszNextData;
	int		i, sCount, sActive, sChangeType;

	sChangeType = GetPrivateProfileInt ("categories", szCat, 2,
	                                     szProfileName);
	if (sChangeType == 2) return FALSE;
	
	strcpy (szActiveList, szCat);
	strcat (szActiveList, " Active");
	
	sCount = GetPrivateProfileInt (szCat, "Count", 0, szProfileName);
	sActive = GetPrivateProfileInt (szCat, "Active", 0, szProfileName);
	if (sCount == 0) return FALSE;
	
	if (sChangeType == 1) {
	   sActive++;
	   if (sActive > sCount - 1) sActive = 0;
	} else {
	   i = rand();
	   sActive = i;
		sActive %= sCount;
	}	

	itoa (sActive, szNextData, 10);
	WritePrivateProfileString (szCat, "Active", szNextData, 
		                        szProfileName);	
   GetPrivateProfileString (szActiveList, 0, "None", szNextData, 
	                         sizeof (szNextData), szProfileName);
	pszNextData = szNextData;
	i = 0;
	for (i = 0; i < sActive; i++) {
		for (; *pszNextData != 0; pszNextData++)
			;
		pszNextData++;
	}
	strcpy (szSel, pszNextData);
	GetPrivateProfileString (szActiveList, szSel, szSel, szNextData, 
	                         sizeof (szNextData), szProfileName);
	strcpy (szData, szNextData);
		return TRUE;	
}

//----------------------------------------------------------------------
// ChangeColors - Changes the desktop colors
//----------------------------------------------------------------------
void ChangeColors (char *szcategory) {
	char 		szSelection[32], szColors[256], szNewColor[32], szTemp[12];
	char *	pszCurColor;
	int		i, j;
	BYTE		ucRed, ucGreen, ucBlue;
	DWORD		dwColor;
	
	if (GetNextActive (szcategory, szSelection, szColors) == FALSE) return;
	WritePrivateProfileString ("Current", "Color Schemes", szSelection, 
	                           "CONTROL.INI");
	
   pszCurColor = strtok (szColors, ",");
	i = 0;	
	while (*pszCurColor != 0) {
		dwColor = ahtodw (pszCurColor);
		ucRed = GetRValue (dwColor);
		ucGreen = GetGValue (dwColor);
		ucBlue = GetBValue (dwColor);
		rgbColors[i] = RGB (ucRed, ucGreen, ucBlue);

		itoa (ucRed, szNewColor, 10);
		strcat (szNewColor, " ");
		itoa (ucGreen, szTemp, 10);
		strcat (szNewColor, szTemp);
		itoa (ucBlue, szTemp, 10);
		strcat (szNewColor, " ");
		strcat (szNewColor, szTemp);
		WriteProfileString ("Colors", szColorNames[j], szNewColor);
		
	   pszCurColor = strtok (NULL, ",");
	   i++;
	}
	SetSysColors (i, sColorIDs, rgbColors);
   return;
}
   
//----------------------------------------------------------------------
// ChangeGeneric - Changes a parameter in an INI file
//----------------------------------------------------------------------
void ChangeGeneric (char * szcategory) {
   char	szSelection[32], szDestCat[32], szDestItem[32], szDestIni[32];
   char	szData[128];

	GetPrivateProfileString (szcategory, "DestINI", "None", szDestIni, 
	                         sizeof (szDestIni), szProfileName);
	GetPrivateProfileString (szcategory, "DestCat", "None", szDestCat,
	                         sizeof (szDestCat), szProfileName);
	GetPrivateProfileString (szcategory, "DestItem", "None", szDestItem,
	                         sizeof (szDestItem), szProfileName);

	if (!GetNextActive (szcategory, szSelection, szData)) return;
   
	WritePrivateProfileString (szDestCat, szDestItem, szData,
	                           szDestIni);
   
	return;   
}   

//----------------------------------------------------------------------
// ChangeDesk - Changes the desktop parameters
//----------------------------------------------------------------------
void ChangeDesktop (void) {

   char		szSelection[32], szData[128];
	char *	pszBuffer;
	int		i;

	i = (int) GetPrivateProfileString ("categories", 0, "None", szBuffer, 
	                                   sizeof (szBuffer), szProfileName);

	if (i == 0 || strcmp (szBuffer, "None") == 0) 
	   return;	

	pszBuffer = szBuffer;
	i = 0;
	while (*pszBuffer != 0) {

		switch (GetPrivateProfileInt (pszBuffer, "Type", 
		                              -1, szProfileName)) {
		   case 0:
				ChangeColors (pszBuffer);
	   		break;		

		   //Screen Saver
		   case 2:
		   	ChangeGeneric (pszBuffer);
		   	break;
			   	
		   //Pattern
		   case 3:
				if (!GetNextActive (pszBuffer, szSelection, szData)) break;
				SystemParametersInfo (SPI_SETDESKPATTERN, 0, szData,
				                      SPIF_UPDATEINIFILE | 
				                      SPIF_SENDWININICHANGE);

		   	break;
		   	
		   //Background
		   case 1:
				if (!GetNextActive (pszBuffer, szSelection, szData)) break;
				SystemParametersInfo (SPI_SETDESKWALLPAPER, 0, szData,
				                      SPIF_UPDATEINIFILE | 
				                      SPIF_SENDWININICHANGE);
				break;

		   //Others
		   default:
		   	ChangeGeneric (pszBuffer);
		   	break;
		}   		                                          	   
		for (; *pszBuffer != 0; pszBuffer++)
			;
		pszBuffer++;
	}
   return;
}

//======================================================================
// Routines used by WndProc
//======================================================================
//----------------------------------------------------------------------
// Setcategories - Initializes the Ini file
//----------------------------------------------------------------------
void Setcategories (void) {

	if (GetPrivateProfileInt ("categories", "Colors", -1, 
	                          szProfileName) != -1) return;
   //
   //Colors, Wallpaper and Screen Saver have custom setups
   //
	WritePrivateProfileString ("categories", "Colors", "0", 
	                           szProfileName);
	WritePrivateProfileString ("Colors", "Type", "0", 
	                           szProfileName);
	WritePrivateProfileString ("Colors", "SrcINI","CONTROL.INI", 
	                           szProfileName);		                           
	WritePrivateProfileString ("Colors", "SrcCat","color schemes", 
	                           szProfileName);		                           
	                           
	WritePrivateProfileString ("categories", "Background", "0", 
	                           szProfileName);		                           
	WritePrivateProfileString ("Background", "Type", "1", 
	                           szProfileName);
	WritePrivateProfileString ("Background", "DestINI","WIN.INI", 
	                           szProfileName);
	WritePrivateProfileString ("Background", "DestCat","Desktop", 
	                           szProfileName);
	WritePrivateProfileString ("Background", "DestItem","Wallpaper", 
	                           szProfileName);
	                           
	WritePrivateProfileString ("categories", "Screen Saver", "0", 
	                           szProfileName);
	WritePrivateProfileString ("Screen Saver", "Type", "2", 
	                           szProfileName);
	WritePrivateProfileString ("Screen Saver", "DestINI","SYSTEM.INI", 
	                           szProfileName);
	WritePrivateProfileString ("Screen Saver", "DestCat","boot", 
	                           szProfileName);
	WritePrivateProfileString ("Screen Saver", "DestItem","SCRNSAVE.EXE", 
	                           szProfileName);
	//
	// Remainder have standard setups
	//                           
	WritePrivateProfileString ("categories", "Pattern", "0", 
	                           szProfileName);
	WritePrivateProfileString ("Pattern", "Type", "3", 
	                           szProfileName);
	WritePrivateProfileString ("Pattern", "SrcINI","CONTROL.INI", 
	                           szProfileName);		                           
	WritePrivateProfileString ("Pattern", "SrcCat","Patterns", 
	                           szProfileName);		                           
	WritePrivateProfileString ("Pattern", "DestINI","WIN.INI", 
	                           szProfileName);
	WritePrivateProfileString ("Pattern", "DestCat","Desktop", 
	                           szProfileName);
	WritePrivateProfileString ("Pattern", "DestItem","Pattern", 
	                           szProfileName);
	return;
}

//========================================================================
//
// Main Window Procedure.
//
//========================================================================
long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam) {

	static	BOOL     bFirst;
	static	HANDLE	hInst;
	static	int		sActiveCat;

	int		i;
	char		szTemp[128];
	RECT		rect;
	POINT		pt;

   switch (message) {
	
      case WM_CREATE:
			hInst = ((LPCREATESTRUCT) lParam)->hInstance;
			bFirst = TRUE;
			return 0; 

		case WM_SHOWWINDOW:
			if (bFirst) {
				bFirst = FALSE;
				Setcategories ();				
				sActiveCat = IDD_COLORFRM;
				sCurrFocus = 0;
				ShowWindow (GetDlgItem (hwnd, IDD_COLORFRM), SW_SHOW);
				ShowWindow (GetDlgItem (hwnd, IDD_SSAVEFRM), SW_HIDE);
				ShowWindow (GetDlgItem (hwnd, IDD_BGROUNDFRM), SW_HIDE);
				ShowWindow (GetDlgItem (hwnd, IDD_PATTERNFRM), SW_HIDE);
			}			
			break;

		case WM_LBUTTONDBLCLK:
	      pt.x = LOWORD (lParam);
	      pt.y = HIWORD (lParam);		      
	      i = GetDlgCtrlID (ChildWindowFromPoint (hwnd, pt));
	      if (i) {
				PostMessage (hwnd, WM_COMMAND, IDD_EDITCAT, 
				             MAKELONG (0, BN_CLICKED));
			}
			break;

		case WM_LBUTTONDOWN:
	      pt.x = LOWORD (lParam);
	      pt.y = HIWORD (lParam);		      
	      i = GetDlgCtrlID (ChildWindowFromPoint (hwnd, pt));

			switch (i) {
				case IDD_COLORTXT:
				case IDD_COLORFRM:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_COLORFRM), SW_SHOW);
					sActiveCat = IDD_COLORFRM;
					break;
				case IDD_SSAVETXT:
				case IDD_SSAVEFRM:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_SSAVEFRM), SW_SHOW);
					sActiveCat = IDD_SSAVEFRM;
					break;
				case IDD_BGROUNDTXT:
				case IDD_BGROUNDFRM:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_BGROUNDFRM), SW_SHOW);
					sActiveCat = IDD_BGROUNDFRM;
					break;
				case IDD_PATTERNTXT:
				case IDD_PATTERNFRM:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_PATTERNFRM), SW_SHOW);
					sActiveCat = IDD_PATTERNFRM;
					break;
			}	
			break;

		case WM_COMMAND:
			switch (wParam) {
				//
				// Menu messages
				//
				case IDM_COLOR:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_COLORFRM), SW_SHOW);
					sActiveCat = IDD_COLORFRM;
					PostMessage (hwnd, WM_COMMAND, IDD_EDITCAT, 
					             MAKELONG (0, BN_CLICKED));
					break;
				case IDM_SSAVE:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_SSAVEFRM), SW_SHOW);
					sActiveCat = IDD_SSAVEFRM;
					PostMessage (hwnd, WM_COMMAND, IDD_EDITCAT, 
					             MAKELONG (0, BN_CLICKED));
					break;
				case IDM_BGROUND:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_BGROUNDFRM), SW_SHOW);
					sActiveCat = IDD_BGROUNDFRM;
					PostMessage (hwnd, WM_COMMAND, IDD_EDITCAT, 
					             MAKELONG (0, BN_CLICKED));
					break;
				case IDM_PATTERN:
					ShowWindow (GetDlgItem (hwnd, sActiveCat), SW_HIDE);
					ShowWindow (GetDlgItem (hwnd, IDD_PATTERNFRM), SW_SHOW);
					sActiveCat = IDD_PATTERNFRM;
					PostMessage (hwnd, WM_COMMAND, IDD_EDITCAT, 
					             MAKELONG (0, BN_CLICKED));
					break;
				case IDM_ABOUT:
					{
						FARPROC	lpfnAboutDlgFn;

						lpfnAboutDlgFn = MakeProcInstance (AboutDlgProc, hInst);
						DialogBox (hInst, "About", hwnd, lpfnAboutDlgFn);
						FreeProcInstance (lpfnAboutDlgFn);
					}
					break;
                     
				case IDM_EXIT:
					SendMessage (hwnd, WM_CLOSE, 0, 0);
					break;
				//
				// Button messages
				//
				case IDD_EDITCAT:
					if (HIWORD (lParam) == BN_CLICKED) {
						FARPROC	lpfnConfigDlgFn;
						
						switch (sActiveCat) {
						   case IDD_COLORFRM:
						   	strcpy (szCurcategory, "Colors");
						   	break;
						   case IDD_SSAVEFRM:
						   	strcpy (szCurcategory, "Screen Saver");
						   	break;
						   case IDD_BGROUNDFRM:
						   	strcpy (szCurcategory, "Background");
						   	break;
						   case IDD_PATTERNFRM:
						   	strcpy (szCurcategory, "Pattern");
						   	break;
						}   	
						lpfnConfigDlgFn = MakeProcInstance (ConfigDlgProc, 
						                                     hInst);
						DialogBox (hInst, "Config", hwnd, lpfnConfigDlgFn);
						FreeProcInstance (lpfnConfigDlgFn);
						return 0;
					}
					break;

				case IDOK:
					if (HIWORD (lParam) == BN_CLICKED) {
						SendMessage (hwnd, WM_CLOSE, 0, 0);
						return 0;
					}
					break;
			}
			break;

		case WM_DESTROY:
			//
			//Save values
			//
			if (!IsIconic (hwnd) && !IsZoomed (hwnd)) {
				GetWindowRect (hwnd, &rect);
				itoa (rect.left, szTemp, 10);
				WritePrivateProfileString (szAppName, "x", szTemp, 
				                           szProfileName);
				itoa (rect.top, szTemp, 10);
				WritePrivateProfileString (szAppName, "y", szTemp, 
				                           szProfileName);
			}
			PostQuitMessage (0);
			return 0;
	}
	return DefWindowProc (hwnd, message, wParam, lParam);
}
//======================================================================
// Routines used by Configure DlgProc
//======================================================================
//------------------------------------------------------------------------
// GetPossibleScrSav Fills listbox with possible Screen Savers
//------------------------------------------------------------------------
int GetPossibleScrSav (HWND hwnd, WORD wLBID, char * szDir, 
                       char * szSearch) {
	FIND_T	fs;
	HANDLE	hFile;
	OFSTRUCT	ofsFile;
	int		i, rc, sCount;
	char *	pszSSName;
	char		szFullName[64];
	
	SendDlgItemMessage (hwnd, wLBID, LB_RESETCONTENT, 0, 0L);
	sCount = 0;
	rc = _dos_findfirst (szSearch, 0, &fs);
	while (rc == 0) {
	   //
	   // Open the file found
	   //
		strcpy (szFullName, szDir);
		strcat (szFullName, "\\");
		strcat (szFullName, fs.name);
	   hFile = OpenFile (szFullName, &ofsFile, OF_READ);
	   if (hFile != -1) {
			//
			// See if EXE, Check for New Exe header
			//	   
	  	   _lread (hFile, szBuffer, 0x40);
  	    
	  	   if ((*(PWORD)&szBuffer == 0x5a4d) && (*(PWORD)&szBuffer[0x18] >= 0x40)) {
				//
				// Read New EXE header, check for Win EXE
				//
		      _llseek (hFile, *(PLONG)&szBuffer[0x3c], 0);
		      _lread (hFile, szBuffer, 0x40);
		      if ((*(PWORD)&szBuffer == 0x454e) && (szBuffer[0x36] == 2)) {
			      //
		   	   // Read Description from 1st entry in NonResident Names table
		      	//
			      _llseek (hFile, (LONG) *(PWORD)&szBuffer[0x2c], 0);
		   	   _lread (hFile, szBuffer, 256);
			      szBuffer[szBuffer[0]+1] = 0;
		   	   pszSSName = strchr (szBuffer+1, ':');
			      if (pszSSName != 0) {
			   	   pszSSName++;
						//
						// Find 1st char past : copy until end or other :
						//
			   	   for (;*pszSSName != 0 && *pszSSName <= 32;pszSSName++);
			   	   if (*strchr (pszSSName, ':')) {
			   	   	*strchr (pszSSName, ':') = 0;
			   	   	for (i = strlen (pszSSName); i > 0; i--) {
			   	   	   if (*(pszSSName+i) > ' ') break;
				   	   	*(pszSSName+i) = 0;
				   	   }
			   	   }	
		   	      strcat (pszSSName, "\t");

					   strcat (szBuffer, szDir);
						strcat (szBuffer, "\\");
				   	strcat (szBuffer, fs.name);
						SendDlgItemMessage (hwnd, wLBID, LB_ADDSTRING, 0, 
						                    (LPARAM)(LPSTR) pszSSName);
					}
				}	
			}
			_lclose (hFile);	
		}	
		sCount++;                    
		rc = _dos_findnext (&fs);
	}
	return sCount;
}
  
//------------------------------------------------------------------------
// GetPossibleFiles Fills listbox with possible file names
//------------------------------------------------------------------------
WORD GetPossibleFiles (HWND hwnd, WORD wLBID, char * szDir, 
                       char * szSearch, BOOL bIncPath) {
	FIND_T	fs;
	int		rc;
	WORD		i;
	
	SendDlgItemMessage (hwnd, wLBID, LB_RESETCONTENT, 0, 0L);
	i = 0;
	rc = _dos_findfirst (szSearch, 0, &fs);
	while (rc == 0) {
	   strcpy (szBuffer, fs.name);
		strcat (szBuffer, "\t");
		if (bIncPath) {
		   strcat (szBuffer, szDir);
			strcat (szBuffer, "\\");
		}	
   	strcat (szBuffer, fs.name);
		
		SendDlgItemMessage (hwnd, wLBID, LB_ADDSTRING, 0, 
		                    (LPARAM)(LPSTR) szBuffer);
		i++;                    
		rc = _dos_findnext (&fs);
	}
	return i;
}
  
//----------------------------------------------------------------------
// FillLBox Fills a list box with items from a INI file category
//----------------------------------------------------------------------
int FillLBox (HWND hwnd, WORD wLBoxID, char * szcategory, char * szIniFile) {
	int	i;
	char *	pszBuffer;
	char		szSel[512], szData[256];
   
	SendDlgItemMessage (hwnd, wLBoxID, LB_RESETCONTENT, 0, 0L);
	
	i = (int) GetPrivateProfileString (szcategory, 0, "None", szBuffer, 
	                         sizeof (szBuffer), szIniFile);	                         
	if (i == 0 || strcmp (szBuffer, "None") == 0) 
	   return 0;
	
	pszBuffer = szBuffer;
	i = 0;
	while (*pszBuffer != 0) {
	   
		GetPrivateProfileString (szcategory, pszBuffer, "-1",
		                         szData, sizeof (szData), szIniFile);
		strcpy (szSel, pszBuffer);		                         
		strcat (szSel, "\t");
		strcat (szSel, szData);		                         
		SendDlgItemMessage (hwnd, wLBoxID, LB_ADDSTRING, 0, 
		                    (LPARAM)(LPSTR) szSel);
		for (; *pszBuffer != 0; pszBuffer++)
			;
		pszBuffer++;
		i++;
	}
	return i;
}

//------------------------------------------------------------------------
// GetPossibleGeneric  Returns list from generic selection
//------------------------------------------------------------------------
void GetPossibleGeneric (HWND hwnd, WORD wLBID, char * szcategory) {
	char	szIniFile [20], szSrcCat [64];

	GetPrivateProfileString (szcategory, "SrcINI", "None", szIniFile, 
	                         sizeof (szIniFile), szProfileName);
	GetPrivateProfileString (szcategory, "SrcCat", "None", szSrcCat,
	                         sizeof (szSrcCat), szProfileName);
	FillLBox (hwnd, wLBID, szSrcCat, szIniFile);				                       
	return;
}
  
//------------------------------------------------------------------------
// WriteActiveGeneric  Writes a list for generic selection
//------------------------------------------------------------------------
void WriteActiveGeneric (HWND hwnd, WORD wLBID, char * szcategory) {
	char	szCat[64];
	char *	pszTemp;
	int	i, sCnt;

	sCnt = (int) SendDlgItemMessage (hwnd, IDD_SELACT, LB_GETCOUNT, 
	                                 0, 0L);
	itoa (sCnt, szBuffer, 10);
	WritePrivateProfileString (szCurcategory, "Count", 
	                           szBuffer, szProfileName);

	strcpy (szCat, szCurcategory);
	strcat (szCat, " Active");					                                 
	WritePrivateProfileString (szCat, 0, "", szProfileName);

	for (i = 0;i < sCnt; i++) {
		SendDlgItemMessage (hwnd, wLBID, LB_GETTEXT, i,
			                 (LPARAM)(LPSTR) szBuffer);

		pszTemp = strchr (szBuffer, '\t');
		if (pszTemp != 0) {
			*pszTemp = 0;					                 
			WritePrivateProfileString (szCat, szBuffer, 
			                 pszTemp+1, szProfileName);
		}	                 
	}	
   return;
}
//------------------------------------------------------------------------
// GetActiveSelections Returns the active selections for a category
//------------------------------------------------------------------------
void GetActiveSelections (HWND hwnd, WORD wLBID, char * szcategory) {
   char szTemp [64];
   
   strcpy (szTemp, szcategory);
	strcat (szTemp, " Active");
	FillLBox (hwnd, wLBID, szTemp, szProfileName);
}

//------------------------------------------------------------------------
// Transfer String - Transfer string from 1 list box to another
//------------------------------------------------------------------------
void TransferStr (HWND hwnd, WORD wSrcID, WORD wDestID, int sIndex) {

	SendDlgItemMessage (hwnd, wSrcID, LB_GETTEXT, sIndex,
		                 (LPARAM)(LPSTR) szBuffer);

	if (SendDlgItemMessage (hwnd, wDestID, LB_FINDSTRING, 0, 
			                  (LPARAM)(LPSTR) szBuffer) == LB_ERR) {
		SendDlgItemMessage (hwnd, wDestID, LB_ADDSTRING, 
		                    0, (LPARAM)(LPSTR) szBuffer);
		SendDlgItemMessage (hwnd, wSrcID, LB_DELETESTRING, 
		                    sIndex, 0);
	}	                    
}	                    

//------------------------------------------------------------------------
// CompareLists Compares the 2 listboxes to insure no duplicates
//------------------------------------------------------------------------
void CompareLists (HWND hwnd, WORD wSrcID, WORD wDestID) {
	int	i, sCnt;
	DWORD	dwMatch;

	sCnt = (int) SendDlgItemMessage (hwnd, wSrcID, LB_GETCOUNT, 0, 0L);

	for (i = 0;i < sCnt; i++) {
		SendDlgItemMessage (hwnd, wSrcID, LB_GETTEXT, i,
			                 (LPARAM)(LPSTR) szBuffer);
		dwMatch = SendDlgItemMessage (hwnd, wDestID, LB_FINDSTRING, 
		                              -1, (LPARAM)(LPSTR) szBuffer);
		if (dwMatch != LB_ERR) 
			SendDlgItemMessage (hwnd, wDestID, LB_DELETESTRING, 
			                    (WPARAM)dwMatch, 0);
	}	                    
}

//------------------------------------------------------------------------
// SetButtons Sets the proper states for each button in the edit LBox
//------------------------------------------------------------------------
void SetButtons (HWND hwnd) {
   
	if (SendDlgItemMessage (hwnd, IDD_SELPOS, LB_GETCOUNT, 0, 0L)) {
		EnableWindow (GetDlgItem (hwnd, IDD_SELADDALL), TRUE);
		if (SendDlgItemMessage (hwnd, IDD_SELPOS, 
						            LB_GETCURSEL, 0, 0L) != LB_ERR) {
			EnableWindow (GetDlgItem (hwnd, IDD_SELADD), TRUE);
			EnableWindow (GetDlgItem (hwnd, IDD_SELREM), FALSE);
		} else
			EnableWindow (GetDlgItem (hwnd, IDD_SELADD), FALSE);
	} else {
		EnableWindow (GetDlgItem (hwnd, IDD_SELADD), FALSE);
		EnableWindow (GetDlgItem (hwnd, IDD_SELADDALL), FALSE);
	}
		
	if (SendDlgItemMessage (hwnd, IDD_SELACT, LB_GETCOUNT, 0, 0L)) {
		EnableWindow (GetDlgItem (hwnd, IDD_SELREMALL), TRUE);
		if (SendDlgItemMessage (hwnd, IDD_SELACT, 
						            LB_GETCURSEL, 0, 0L) != LB_ERR) {
			EnableWindow (GetDlgItem (hwnd, IDD_SELREM), TRUE);
			EnableWindow (GetDlgItem (hwnd, IDD_SELADD), FALSE);
		} else
			EnableWindow (GetDlgItem (hwnd, IDD_SELREM), FALSE);
	} else {
		EnableWindow (GetDlgItem (hwnd, IDD_SELREM), FALSE);
		EnableWindow (GetDlgItem (hwnd, IDD_SELREMALL), FALSE);
	}	
	return;
}
//------------------------------------------------------------------------
// Config category box dialog procedure
//------------------------------------------------------------------------
BOOL FAR PASCAL ConfigDlgProc (HWND hwnd, WORD message, WORD wParam, 
                               LONG lParam) {
	static	int	sChgType, sCurSelType;
	int	i;
	char	szTemp[64], szTemp1[64];

	switch (message) {

		case WM_INITDIALOG:
		
			strcpy (szTemp, "Edit ");
			strcat (szTemp, szCurcategory);
			SetWindowText (hwnd, szTemp);
			sChgType = (int) GetPrivateProfileInt ("categories", 
			                      szCurcategory, -1, szProfileName);			                                
			CheckRadioButton (hwnd, IDD_CHRND, IDD_CHNO, 
			                  sChgType + IDD_CHRND);
						                                
			sCurSelType = (int) GetPrivateProfileInt (szCurcategory, "Type", 
			                                          -1, szProfileName);
			i = 200;   //Make tab stop array
			SendDlgItemMessage (hwnd, IDD_SELPOS, LB_SETTABSTOPS, 1, 
			                    (LPARAM)(LPINT)&i);
			SendDlgItemMessage (hwnd, IDD_SELACT, LB_SETTABSTOPS, 1, 
			                    (LPARAM)(LPINT)&i);
			                                          
			GetActiveSelections (hwnd, IDD_SELACT, szCurcategory);
			
			switch (sCurSelType) {
			   //Color
			   case 0:
					GetPossibleGeneric (hwnd, IDD_SELPOS, "Colors");
			   	break;
			   	
			   //Wallpaper
			   case 1:			   
					GetWindowsDirectory (szTemp, sizeof (szTemp));   
					strcpy (szTemp1, szTemp);			   
					strcat (szTemp1, "\\*.bmp");			   
			   	GetPossibleFiles (hwnd, IDD_SELPOS, szTemp, szTemp1, FALSE);
			   	break;
			   	
			   //Screen Saver
			   case 2:
					GetWindowsDirectory (szTemp, sizeof (szTemp));   
					strcpy (szTemp1, szTemp);			   
					strcat (szTemp1, "\\*.scr");			   
			   	GetPossibleScrSav (hwnd, IDD_SELPOS, szTemp, szTemp1);
			   	break;
			   	
			   //Pattern
			   case 3:
					GetPossibleGeneric (hwnd, IDD_SELPOS, "Pattern");
			   	break;
			   	
			}
			//
			//Eliminate any duplicate entries
			//
			CompareLists (hwnd, IDD_SELACT, IDD_SELPOS);

			if (SendDlgItemMessage (hwnd, IDD_SELACT, LB_GETCOUNT, 0, 0L)) 
				   SendDlgItemMessage (hwnd, IDD_SELACT, LB_SETCURSEL, 
					                    GetPrivateProfileInt (szCurcategory, 
					                                          "Active", 0, 
					                                          szProfileName),
				                       0L);
			else 			
				if (SendDlgItemMessage (hwnd, IDD_SELPOS, LB_GETCOUNT, 0, 0L)) 
				   SendDlgItemMessage (hwnd, IDD_SELPOS, LB_SETCURSEL, 0, 0L);
			SetButtons(hwnd);			
			return TRUE;
		
		case WM_COMMAND:
			switch (wParam) {
		   //
		   // Listbox controls
		   //
		      case IDD_SELPOS:
		      	if (HIWORD (lParam) == LBN_SELCHANGE) {
					   SendDlgItemMessage (hwnd, IDD_SELACT, LB_SETCURSEL, -1, 0L);
						SetButtons(hwnd);
		      	}   
		      	if (HIWORD (lParam) == LBN_DBLCLK) 
					   PostMessage (hwnd, WM_COMMAND, IDD_SELADD, 0L);

		      	break;
		      			      
		      case IDD_SELACT:
		      	if (HIWORD (lParam) == LBN_SELCHANGE) {
					   SendDlgItemMessage (hwnd, IDD_SELPOS, LB_SETCURSEL, -1, 0L);
						SetButtons(hwnd);
		      	}   
		      	if (HIWORD (lParam) == LBN_DBLCLK) 
					   PostMessage (hwnd, WM_COMMAND, IDD_SELREM, 0L);
		      	break;
		   //
		   // Button controls
		   //
				case IDD_CHRND:
				case IDD_CHSEQ:
				case IDD_CHNO:
					if (HIWORD (lParam) == BN_CLICKED) 
					   sChgType = wParam - IDD_CHRND;
					break;

				case IDD_SELADDALL:
					i = (int) SendDlgItemMessage (hwnd, IDD_SELPOS, 
					                              LB_GETCOUNT, 0, 0L);
					for (;i > 0; --i) 
					   TransferStr (hwnd, IDD_SELPOS, IDD_SELACT, 0);
					
					if (SendDlgItemMessage (hwnd, IDD_SELACT, LB_GETCOUNT, 0, 0L)) 
					   SendDlgItemMessage (hwnd, IDD_SELACT, LB_SETCURSEL, 0, 0L);
					SetButtons(hwnd);
            	return TRUE;
            	
				case IDD_SELADD:
					i = (int) SendDlgItemMessage (hwnd, IDD_SELPOS, 
						                           LB_GETCURSEL, 0, 0L);
				   if (i != LB_ERR) 
				      TransferStr (hwnd, IDD_SELPOS, IDD_SELACT, i);
					if (SendDlgItemMessage (hwnd, IDD_SELPOS, LB_GETCOUNT, 0, 0L))
			   		SendDlgItemMessage (hwnd, IDD_SELPOS, LB_SETCURSEL, 0, 0L);
					else
					   SendDlgItemMessage (hwnd, IDD_SELACT, LB_SETCURSEL, 0, 0L);
					   
					SetButtons(hwnd);
					return TRUE;
            	
				case IDD_SELREM:
					i = (int) SendDlgItemMessage (hwnd, IDD_SELACT, 
						                           LB_GETCURSEL, 0, 0L);
				   if (i != LB_ERR)  
					   TransferStr (hwnd, IDD_SELACT, IDD_SELPOS, i);
					if (SendDlgItemMessage (hwnd, IDD_SELACT, LB_GETCOUNT, 0, 0L)) 
					   SendDlgItemMessage (hwnd, IDD_SELACT, LB_SETCURSEL, 0, 0L);
					else
			   		SendDlgItemMessage (hwnd, IDD_SELPOS, LB_SETCURSEL, 0, 0L);
					SetButtons(hwnd);
					return TRUE;
					
				case IDD_SELREMALL:
					i = (int) SendDlgItemMessage (hwnd, IDD_SELACT, 
					                              LB_GETCOUNT, 0, 0L);
					for (;i > 0; --i) 
					   TransferStr (hwnd, IDD_SELACT, IDD_SELPOS, 0);
					if (SendDlgItemMessage (hwnd, IDD_SELPOS, LB_GETCOUNT, 0, 0L))
			   		SendDlgItemMessage (hwnd, IDD_SELPOS, LB_SETCURSEL, 0, 0L);
					SetButtons(hwnd);
            	return TRUE;
            	
				case IDOK:
					WriteActiveGeneric (hwnd, IDD_SELACT, szCurcategory);
               itoa (sChgType, szTemp, 10);
					WritePrivateProfileString ("categories", 
						           szCurcategory, szTemp, szProfileName);

					WritePrivateProfileString (szCurcategory, "Active", 
					                           "0", szProfileName);
					EndDialog (hwnd, 1);
					return TRUE;
					
				case IDCANCEL:
					EndDialog (hwnd, 0);
					return TRUE;
			}
			break;

		case WM_CLOSE:
			EndDialog (hwnd, 0);
			return TRUE;
	}
	return FALSE;	
}

//------------------------------------------------------------------------
// About box dialog procedure
//------------------------------------------------------------------------
BOOL FAR PASCAL AboutDlgProc (HWND hwnd, WORD message, WORD wParam, 
                               LONG lParam) {

	switch (message) {

		case WM_COMMAND:
			switch (wParam) {

				case IDCANCEL:
				case IDOK:
					EndDialog (hwnd, 1);
					return TRUE;
			}
			break;

		case WM_CLOSE:
			EndDialog (hwnd, 0);
			return TRUE;
	}
	return FALSE;	
}


