PROGRAM WinTidy;
USES WinTypes, WinProcs, Strings, Win31, WinDOS, TidyWinA, TidyWinB,
  TidyWinC, {$IFDEF VER70} ODialogs, OWindows, Objects;
{$ELSE} WObjects; {$ENDIF}
{$D Copyright (c) 1992 by Neil J. Rubenking}
{$R WINTIDY}
{$I WINTIDY.INC}
CONST AppName : PChar = 'WinTidy';
TYPE
  TMyApplication = OBJECT(TApplication)
    PROCEDURE InitMainWindow; virtual;
  END;

  PTidyWindow = ^TTidyWindow;
  TTidyWindow = OBJECT(TTidyWindowC)
    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    DESTRUCTOR Done; Virtual;
    PROCEDURE SetUpWindow; Virtual;
    FUNCTION GetClassName : PChar; Virtual;
    PROCEDURE GetWindowClass(var AWndClass: TWndClass); Virtual;
    PROCEDURE wmCommand(VAR Msg : TMessage); Virtual
      wm_First + wm_Command;
  END;

  PBitStatic = ^TBitStatic;
  TBitStatic = OBJECT(TStatic)
    PROCEDURE Paint(pDC : hDC; VAR PS : TPaintStruct); Virtual;
    PROCEDURE wmPaint(VAR Msg : TMessage); Virtual
      wm_First + wm_Paint;
  END;

  PROCEDURE TBitStatic.Paint(pDC : hDC; VAR PS :
    TPaintStruct);
  VAR
    hb, ob : hBitMap;
    bm     : tBitMap;
    bitsDC : hDC;
  BEGIN
    BitsDC := CreateCompatibleDC(pDC);
    hb := LoadBitMap(hInstance, appName);
    GetObject(hb, SizeOf(tBitMap), @bm);
    ob := SelectObject(BitsDC, hb);
    BitBlt(pDC, 0, 0, bm.bmWidth, bm.bmHeight,
      bitsDC, 0, 0, SrcCopy);
    SelectObject(BitsDC, ob);
    DeleteDC(bitsDC);
    DeleteObject(hb);
  END;

  PROCEDURE TBitStatic.wmPaint(VAR Msg : TMessage);
  BEGIN TWindow.wmPaint(Msg); END;

  CONSTRUCTOR TTidyWindow.Init(AParent : PWindowsObject;
    AName : PChar);
  VAR Ps : PStatic;
  BEGIN
    TTidyWindowC.Init(AParent, AName);
    IniName := NIL;
    PS := New(PBitStatic, InitResource(@Self, id_wtBitmap, 0));
  END;

  PROCEDURE TTidyWindow.SetUpWindow;
  VAR
    ArgBuff  : ARRAY[0..fsPathName]  OF Char;
    DirName  : ARRAY[0..fsDirectory] OF Char;
    ProgName : ARRAY[0..fsFileName]  OF Char;
    ProgExt  : ARRAY[0..fsExtension] OF Char;

    FUNCTION GetFileArg : Boolean;
    VAR ArgC : Word;
    BEGIN
      GetFileArg := FALSE;
      ArgC := GetArgCount;
      IF ArgC > 0 THEN
        BEGIN
          GetArgStr(ArgBuff, 1, fsPathName);
          IF StrLIComp(ArgBuff, '/Q', 2) = 0 THEN
            BEGIN
              Quiet := TRUE;
              IF ArgC > 1 THEN
                BEGIN
                  GetArgStr(ArgBuff, 2, fsPathName);
                  GetFileArg := TRUE;
                END;
            END
          ELSE
            BEGIN
              GetFileArg := TRUE;
              IF ArgC > 1 THEN
                BEGIN
                  GetArgStr(DirName, 2, fsDirectory);
                  Quiet := StrLIComp(DirName, '/Q', 2) = 0;
                END;
            END;
        END;
    END;

  BEGIN
    TTidyWindowC.SetUpWindow;
    IF PMWindow = 0 THEN
      BEGIN
        MessageBeep(mb_IconStop);
        MessageBox(hWindow, 'Unable to locate Program Manager',
          'WINTIDY ERROR', mb_Ok + mb_IconStop);
        cmdShow := sw_Hide;
        PostQuitMessage(hWindow);
      END
    ELSE
      BEGIN
        IF GetFileArg THEN
          BEGIN
            FileSplit(ArgBuff, DirName, ProgName, ProgExt);
            StrCopy(ArgBuff, ProgName);
            StrCat(ArgBuff, '.INI');
            StrUpper(ArgBuff);
            StrCopy(DirName, 'Save/Restore using ');
            StrCat(DirName, ArgBuff);
            StrCat(DirName, '?'#13'(NO means use WINTIDY.INI)');
            IF NOT Quiet THEN MessageBeep(mb_IconQuestion);
            IF MessageBox(hWindow, DirName, 'WINTIDY',
              mb_YesNo + mb_IconQuestion) = idYES THEN
                BEGIN
                  IniName := StrNew(ArgBuff);
                  StrCopy(DirName, 'WINTIDY - ');
                  StrCat(DirName, ArgBuff);
                  SetWindowText(hWindow, DirName);
                END;
          END;
        IF IniName = NIL THEN IniName := StrNew('WINTIDY.INI');
      END;
  END;

  DESTRUCTOR TTidyWindow.Done;
  BEGIN
    StrDispose(IniName);
    TTidyWindowC.Done;
  END;

  FUNCTION TTidyWindow.GetClassName;
  BEGIN
    GetClassName := AppName;
  END;

  PROCEDURE TTidyWindow.GetWindowClass(VAR AWndClass :
    TWndClass);
  BEGIN
    TTidyWindowC.GetWindowClass(AWndClass);
    AWndClass.hIcon := LoadIcon(HInstance, AppName);
  END;

  PROCEDURE TTidyWindow.wmCommand(VAR Msg : TMessage);
  BEGIN
    IF Msg.lParamLo = 0 THEN
      BEGIN
        CASE Msg.wParam OF
          id_ArrIcons : ArrangeAll;
          id_SaveLay  : SaveLayout;
          id_RestLay  : RestoreLayout;
          id_HowToUse : Application^.ExecDialog(New(PDialog,
                          Init(@Self, 'TidyHelp')));
          id_AboutIt  : Application^.ExecDialog(New(PDialog,
                          Init(@Self, 'TidyAbout')));
          ELSE TTidyWindowC.wmCommand(Msg);
        END;
      END
    ELSE TTidyWindowC.wmCommand(Msg);
  END;

  PROCEDURE TMyApplication.InitMainWindow;
  BEGIN
    MainWindow := New(PTidyWindow, Init(Nil, AppName));
  END;

VAR MyApp: TMyApplication;
BEGIN
  MyApp.Init(AppName);
  MyApp.Run;
  MyApp.Done;
END.
