UNIT TidyWinC;
(**) INTERFACE (**)
USES WinTypes, WinProcs, Strings, Win31, TidyWinA, TidyWinB,
  GroupType, GroupFWrite, {$IFNDEF VER70} WObjects;
  {$ELSE} ODialogs, OWindows, Objects; {$ENDIF}
TYPE
  PTidyWindowC = ^TTidyWindowC;
  TTidyWindowC = OBJECT(TTidyWindowB)
    Reloading : Boolean;
    CONSTRUCTOR Init(AParent : PWindowsObject; AName : PChar);
    PROCEDURE RestoreLayout;
    PROCEDURE Converse; Virtual;
    PROCEDURE wmDDEAck(VAR Msg : TMessage); Virtual
      wm_First + wm_DDE_Ack;
    FUNCTION LocateFromINI(IsGroup : Boolean; H : HWnd) : Boolean;
    PROCEDURE RestoreGroupWindows;
  END;

(**) IMPLEMENTATION (**)
  CONSTRUCTOR TTidyWindowC.Init(AParent : PWindowsObject;
    AName : PChar);
  BEGIN
    TTidyWindowB.Init(AParent, AName);
    Reloading := FALSE;
  END;

  PROCEDURE TTidyWindowC.RestoreLayout;
  CONST
    GroupX : PChar = 'GROUPxx';
    gBSize = 80;
  VAR
    GroupNum, HwndNum,
    ItemNum             : Word;
    GroupBuf, GpNameBuf : ARRAY[0..gBSize] OF Char;
    TGF                 : TGroupFilw;
    TWP                 : TWindowPlacement;
    TID                 : TItemData;

    FUNCTION UpdateItem : Boolean;
    CONST
      nBSize = 80;
      pBSize = 14;
    VAR
      ItemNameBuf : ARRAY[0..nBSize] OF Char;
      PosnBuf     : ARRAY[0..pBSize] OF Char;
      Px,Py       : PChar;
      vX,vY,Code  : Integer;
      L           : LongInt;
    BEGIN
      UpdateItem := FALSE;
      TGF.PCharFmOffset(TID.pName, ItemNameBuf, nBSize);
      GetPrivateProfileString(gpNameBuf, ItemNameBuf, '', PosnBuf,
        pBSize, IniName);
      IF PosnBuf[0] <> #0 THEN
        BEGIN
          Px := PosnBuf;
          Py := StrScan(PosnBuf,',') + 1;
          Px[Py-Px-1] := #0;
          Val(Px, L, Code);
          IF Code <> 0 THEN Exit;
          IF (L < -32768) OR (L > 32767) THEN Exit;
          vX := L;
          Val(Py, L, Code);
          IF Code <> 0 THEN Exit;
          IF (L < -32768) OR (L > 32767) THEN Exit;
          vY := L;
          WITH TID.Pt DO
            IF (X <> vX) OR (Y <> vY) THEN
              BEGIN
                UpdateItem := TRUE;
                X := vX; Y := vY;
              END;
        END;
    END;

  BEGIN
    IF pmWindow = 0 THEN Exit;
    OldCur := SetCursor(LoadCursor(0, idc_Wait));
    SetCapture(hWindow);
      {restore ProgMan's size and position}
    IF NOT LocateFromIni(FALSE, PMWindow) THEN Exit;
      {restore item positions in GRP files}
    ShowWindow(PMWindow, sw_Hide);
    FOR GroupNum := 1 TO MaxGroups DO
      BEGIN
        wvsprintf(Groupx, 'Group%u', GroupNum);
        GetPrivateProfileString('Groups', Groupx, '', GroupBuf,
          gBSize, 'PROGMAN.INI');
        IF GroupBuf[0] <> #0 THEN
          BEGIN
            TGF.Init(GroupBuf);
            TGF.fpName(gpNameBuf, gBSize);
            FOR ItemNum := 0 TO TGF.fcItems-1 DO
              IF TGF.GetNthItem(ItemNum, TID) THEN
                IF UpdateItem THEN
                  TGF.WriteNthItem(ItemNum, TID);
            TGF.Done;
          END;
      END;
      {initiate DDE conversation with ProgMan}
    Reloading := TRUE;
    InitDDEConversation;
  END;

  FUNCTION TTidyWindowC.LocateFromINI(IsGroup : Boolean; H : HWnd) :
    Boolean;
  CONST
    nBSize = 80;
    tBSize = 60; 
  VAR
    TWP     : TWindowPlacement;
    IniBuf  : ARRAY[0..tBSize] OF Char;
    NameBuf : ARRAY[0..nBSize] OF Char;
    Sect, P : PChar;
    N       : Word;

    FUNCTION TWPfmPChar(VAR T : TWindowPlacement; Src : PChar) :
      Boolean;
    VAR
      Pw, PNext : PChar;
      N, Code   : Integer;
      L         : LongInt;
      Words     : ARRAY[0..9] OF Word;
    BEGIN
      TWPfmPChar := FALSE;
      Pw := Src;
      FOR N := 0 TO 9 DO
        BEGIN
          PNext := Pw;
          WHILE NOT (PNext[0] IN [',',';',#0]) DO PNext := PNext+1; 
          IF PNext[0] <> #0 THEN
            BEGIN
              PNext[0] := #0;
              PNext := PNext + 1;
            END;
          Val(Pw, L, Code);
          IF Code <> 0 THEN Exit;
          IF (L < 0) OR (L > 65535) THEN Exit;
          Words[N] := Word(L);
          Pw := PNext;
        END;
      Move(Words, T.Flags, SizeOf(Words));
      T.length := 22;
      TWPfmPChar := TRUE;
    END;

  BEGIN
    LocateFromINI := FALSE;
    IF IsGroup THEN
      BEGIN
        GetWindowText(H, NameBuf, nBSize);
        Sect := GroupSect;
      END
    ELSE
      BEGIN
        StrCopy(NameBuf, 'Placement');
        Sect := ProgmanSect;
      END;
    GetPrivateProfileString(Sect, NameBuf, '', IniBuf, tBSize,
      IniName);
    IF IniBuf[0] = #0 THEN
      BEGIN
        IF NOT Quiet THEN MessageBeep(mb_IconInformation);
        IF IsGroup THEN
          MessageBox(hWindow, 'Group was added since last Save Layout',
            NameBuf, mb_Ok + mb_IconInformation)
        ELSE MessageBox(hWindow, 'INI file absent or corrupted',
          IniName, mb_Ok + mb_IconInformation);
      END
    ELSE IF TWPfmPChar(TWP, IniBuf) THEN
      BEGIN
        LocateFromINI := TRUE;
        IF IsGroup THEN
          TWP.Flags := TWP.Flags OR wpf_SetMinPosition;
        SetWindowPlacement(H, @TWP);
      END;
  END;

  PROCEDURE TTidyWindowC.Converse;
    {if Reloading from INI file, send a Reload command to ProgMan.
     Otherwise, let the default behavior of TTidyWindowB happen.}
  CONST ReloadCmd = '[Reload]';
  VAR
    PMcmdH : THandle;
    PMcmdP : PChar;
  BEGIN
    IF Reloading THEN
      BEGIN
        PMcmdH := GlobalAlloc(gmem_Moveable OR gmem_DDEShare,
          StrLen(ReloadCmd));
        PMcmdP := GlobalLock(PMcmdH);
        StrCopy(PMcmdP, ReloadCmd);
        GlobalUnlock(PMcmdH);
        IF NOT PostMessage(PMWindow, wm_DDE_Execute,
          hWindow, MakeLong(0, PMcmdH)) THEN
            GlobalFree(PMcmdH);
      END
    ELSE TTidyWindowB.Converse;
  END;

  PROCEDURE TTidyWindowC.wmDDEAck(VAR Msg : TMessage);
    {If not Reloading from INI file, let TTidyWindowB handle it.
     Otherwise, let TTidyWindowB handle the FIRST Ack, and take
     the next as a signal to END the conversation}
  BEGIN
    IF NOT Reloading THEN TTidyWindowB.wmDDEAck(Msg)
    ELSE IF NOT LinkedToPM THEN TTidyWindowB.wmDDEAck(Msg)
    ELSE
      BEGIN
        GlobalDeleteAtom(Msg.lParamHi);
        Reloading := FALSE;
        IF Msg.LParamLo AND dde_Ack <> dde_Ack THEN
          BEGIN
            IF NOT Quiet THEN MessageBeep(mb_IconStop);
            MessageBox(hWindow, 'Program Manager does not'+
              ' acknowledge command', 'ERROR',
              mb_Ok + mb_IconStop);
            SetCursor(OldCur);
            ReleaseCapture;
          END
        ELSE
          BEGIN
            PostMessage(PMWindow, wm_DDE_Terminate, hWindow, 0);
            RestoreGroupWindows;
          END;
      END;
  END;

  PROCEDURE TTidyWindowC.RestoreGroupWindows;
  VAR M : Word;
  BEGIN
    GetGroupHandles;
    FOR M := 1 TO THA[0] DO LocateFromINI(TRUE, THA[M]);
    ShowWindow(PMWindow, sw_Show);
    IF NOT Quiet THEN MessageBeep(mb_IconInformation);
    MessageBox(hWindow, 'Layout has been restored from INI file',
      IniName, mb_Ok + mb_IconInformation);
    SetCursor(OldCur);
    ReleaseCapture;
  END;
END.
