Option Explicit
'
Global lgGroupItemPointers(50) As Long      'Table of Item Pointers
Global sgGroupItemFileNames(100) As String  'Table of GRP fn's
Global lgItemsCount As Long                 'Count of ItemData Entries
Global igDetailWindowSize(4) As Integer     'Detail Window Size
'
Global sgProgramName As String              'Global Program Name
Global igFromForm As Integer                'Commercial From Switch
Global sgRegistrationStatus As String       'Registration Status
Global sgProgramVersion As String           'Version Number
Global sgCompuserveID As String             'Compuserve ID
'
Global sgGroupsDrive As String              'Groups Drive
Global sgGroupsPath As String               'Groups Path
'
Global fgBaseFormTop As Single              'Base Scale Top
Global fgBaseFormHeight As Single           'Base Scale Height
Global fgBaseFormLeft As Single             'Base Scale Left
Global fgBaseFormWidth As Single            'Base Scale Width
'
Global fgCurrentFormTop As Single           'Current Scale Top
Global fgCurrentFormHeight As Single        'Current Scale Height
Global fgCurrentFormLeft As Single          'Current Scale Left
Global fgCurrentFormWidth As Single         'Current Scale Width
'
Global fgCurrentHeightFactor As Single      'Heigth Adjustment Ratio
Global fgCurrentWidthFactor As Single       'Width Adjustment Ratio
'
Global igErrorNumber As Integer             'Error Number
Global sgErrorMessage As String             'Error Message
'
Global sgWindowsDirectory As String         'Windows Directory
'
Global igLongestDetailLine As Integer       'GrpFiles Longest Line
Global sgWorkFileName As String             'Work File DOS Filename
'
'---------------------------------------------------------
'
' Get the Windows Directory Value
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer
'' Functions for List Box Horizontal Scrolling
'
Declare Function SendMessage Lib "User" (ByVal hWnd As Integer, ByVal wMsg As Integer, ByVal wParam As Integer, ByVal lParam As Long) As Long
' Get the handle for a Window
Declare Function GetFocus Lib "User" () As Integer
' Write a Private Profile Entry
Declare Function WritePrivateProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lplFileName As String) As Integer
' Read a Private Profile Entry
Declare Function GetPrivateProfileString Lib "Kernel" (ByVal lpAppName As String, ByVal lpKeyName As Any, ByVal lpString As String, ByVal lpReturnedString As String, ByVal nSize As Integer, ByVal lplFileName As String) As Integer
'

'------------------------------------------------------
' Calls the Windows API to get a Private Profile entry
'------------------------------------------------------
Sub GetPProfileString (sSection As String, sEntry As String, sDefault As String, sFilename As String, sReturnBuffer As String, iReturnBuffer As Integer)
  '
  Dim iReturn As Integer
  Dim sTemp As String
  Dim sDialogTitle As String
  '
  sDialogTitle = "GetPProfileString"
  '
  iReturn = GetPrivateProfileString(sSection, sEntry, sDefault, sReturnBuffer, iReturnBuffer, sFilename)
  '
  If iReturn = 0 Or Left$(sReturnBuffer, 5) = "ERROR" Then
    sTemp = "           WARNING           " & Chr$(13) & Chr$(10)
    sTemp = sTemp & "** Error reading .INI File **" & Chr$(13) & Chr$(10)
    ' Extra spaces on following lines compensate for proportional font
    sTemp = sTemp & "Section     : " & sSection & Chr$(13) & Chr$(10)
    sTemp = sTemp & "Entry        : " & sEntry & Chr$(13) & Chr$(10)
    sTemp = sTemp & "Filename  : " & sFilename & Chr$(13) & Chr$(10)
    sTemp = sTemp & Chr$(13) & Chr$(10) & "A new .INI will be created when you use File/Exit" & Chr$(13) & Chr$(10)
    MsgBox sTemp, MB_ICONEXCLAMATION, sDialogTitle
    sReturnBuffer = "ERROR"
  End If

End Sub

'------------------------------------------------------
' Convert 2 adjacent bytes of a String to a single Long Integer
'------------------------------------------------------
Function lgBytesToLong (sSource As String, ByVal iPosition As Integer) As Long
  '
  Dim lWork1 As Long
  '
  lWork1 = Val("&H" & Hex(Asc(Mid$(sSource, iPosition + 1, 1)))) * 256
  lWork1 = lWork1 + Val("&H" & Hex(Asc(Mid$(sSource, iPosition, 1))))
  lgBytesToLong = lWork1

End Function

'--------------------------------------------------
' Calls the windows API to get the windows directory
'--------------------------------------------------
Function sGetWindowsDir () As String
  '
  Dim sWork As String
  Dim iGWD As Integer
  '
  sWork = String$(145, 0)                  ' Set Buffer size
  iGWD = GetWindowsDirectory(sWork, 145)  ' Make API Call
  sWork = Left$(sWork, iGWD)             ' Trim Buffer
  '
  If Right$(sWork, 1) <> "\" Then          ' Add \ if necessary
    sGetWindowsDir = sWork + "\"
  Else
    sGetWindowsDir = sWork
  End If
  
End Function

'---------------------------------------------------------
' Formats an AsciiZ String with a Max. char. limit
'---------------------------------------------------------
Sub sub_gAsciiZ (sSource As String, sTarget As String, iLimit As Integer)
  '
  'Sample Call:
  '  Call sub_gAsciiZ(sWork2, sWork3, 30)
  '
  Dim sWork1 As String
  Dim iWork1 As Integer
  '
  sWork1 = Mid$(sSource, 1, 1)
  iWork1 = 1
  sTarget = ""
  Do Until Asc(sWork1) = 0
    If iWork1 > iLimit Then Exit Do
    sTarget = sTarget + sWork1
    iWork1 = iWork1 + 1
    sWork1 = Mid$(sSource, iWork1, 1)
    Loop

End Sub

'------------------------------------------------------
' Calls the Windows API to put a Private Profile entry
'------------------------------------------------------
Sub WritePProfileString (sSection As String, sEntry As String, sString As String, sFilename As String)
  '
  Dim iResult As Integer
  Dim sDialogTitle As String
  Dim sTemp As String
  '
  sDialogTitle = "WritePProfileString"
  '
  iResult = WritePrivateProfileString(sSection, sEntry, sString, sFilename)
  '
  If iResult = 0 Then
    sTemp = "** Error updating INI File **" & Chr$(10)
    ' Extra spaces on following lines compensate for proportional font
    sTemp = sTemp & "sSection     : " & sSection & Chr$(10)
    sTemp = sTemp & "sEntry         : " & sEntry & Chr$(10)
    sTemp = sTemp & "sString        : " & sString & Chr$(10)
    sTemp = sTemp & "sFilename  : " & sFilename & Chr$(10)
    MsgBox sTemp, MB_ICONSTOP, sDialogTitle
  End If

End Sub

