VERSION 2.00
Begin Form Form_Main 
   ClientHeight    =   4860
   ClientLeft      =   1140
   ClientTop       =   1680
   ClientWidth     =   8070
   Height          =   5550
   Icon            =   FILEDUMP.FRX:0000
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4860
   ScaleWidth      =   8070
   Top             =   1050
   Width           =   8190
   Begin CommandButton cbNext 
      Caption         =   "Next"
      Height          =   212
      Left            =   6840
      TabIndex        =   2
      Top             =   4560
      Visible         =   0   'False
      Width           =   615
   End
   Begin CommandButton cbPrev 
      Caption         =   "Prev"
      Height          =   212
      Left            =   600
      TabIndex        =   1
      Top             =   4560
      Visible         =   0   'False
      Width           =   615
   End
   Begin CommonDialog CMDialog1 
      FontName        =   "Courier New"
      FontSize        =   10
      InitDir         =   "C:\"
      Left            =   0
      Top             =   4320
   End
   Begin ListBox GrpDetail 
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   3600
      Left            =   0
      TabIndex        =   0
      TabStop         =   0   'False
      Top             =   0
      Width           =   8055
   End
   Begin Label lblFileSize 
      Alignment       =   2  'Center
      Height          =   210
      Left            =   1440
      TabIndex        =   3
      Top             =   4560
      Width           =   5175
   End
   Begin Menu M_File 
      Caption         =   "&File"
      Begin Menu M_FileOpen 
         Caption         =   "&Open"
      End
      Begin Menu M_FilePrint 
         Caption         =   "&Print"
      End
      Begin Menu M_FileBar1 
         Caption         =   "-"
      End
      Begin Menu M_FileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu M_Help 
      Caption         =   "&Help"
      Begin Menu M_HelpAbout 
         Caption         =   "&About"
      End
   End
End
Option Explicit
'
'--------------------------------------------------------
' Module Level Globals
'--------------------------------------------------------
Dim imPixelsPerChar As Integer
Dim fmForm_MainTopDefault As Single
Dim smSourceFileName As String
Dim imMaxRecord As Integer
Dim imPriorShow As Integer
'
Dim imBlockStarts(50) As Integer
Dim imBlockNumber As Integer
'
Const ICON_TWIPS = 540
Const MIN_WIDTH = 8070
Const MIN_HEIGHT = 4650
Const BLOCK_SIZE = 4096
'

'--------------------------------------------------------
'--------------------------------------------------------
Sub cbNext_Click ()
  '
  Dim sBuffer As String
  Dim iEndOfFileFlag As Integer
  '
  ' Update BlockStarts Vector Pointer
  If imBlockStarts(imBlockNumber + 1) > imBlockStarts(imBlockNumber) Then
    imBlockNumber = imBlockNumber + 1
  End If
  '
  cbNext.Visible = False
  cbPrev.Visible = False
  '
  iEndOfFileFlag = False
  GrpDetail.Clear
  Form_Main.MousePointer = HOURGLASS
  Call ReadBack(sgWorkFileName, imBlockStarts(imBlockNumber), imMaxRecord, iEndOfFileFlag, sBuffer)
  Form_Main.MousePointer = DEFAULT
    Debug.Print "cbNext_Click: ";
    Debug.Print "imBlockStarts("; imBlockNumber; ")=";
    Debug.Print imBlockStarts(imBlockNumber)
  '
  ' Update BlockStarts Vector
  If imBlockStarts(imBlockNumber + 1) <= imBlockStarts(imBlockNumber) Then
    imBlockStarts(imBlockNumber + 1) = imBlockStarts(imBlockNumber) + GrpDetail.ListCount
      Debug.Print "cbNext_Click: GrpDetail.ListCount=";
      Debug.Print GrpDetail.ListCount;
      Debug.Print " imMaxRecord="; imMaxRecord;
      Debug.Print "  imBlockStarts("; imBlockNumber + 1; ")=";
      Debug.Print imBlockStarts(imBlockNumber + 1)
  End If
  '
  '
  If imBlockNumber > 1 Then
    cbPrev.Visible = True
  End If
  '
  If imBlockStarts(imBlockNumber + 1) < imMaxRecord Then
    cbNext.Visible = True
  End If

End Sub

'--------------------------------------------------------
'--------------------------------------------------------
Sub cbPrev_Click ()
  '
  Dim sBuffer As String
  Dim iEndOfFileFlag As Integer
  '
  ' Update BlockStarts Vector Pointer
  imBlockNumber = imBlockNumber - 1
  '
  cbNext.Visible = False
  cbPrev.Visible = False
  '
  iEndOfFileFlag = False
  GrpDetail.Clear
  Form_Main.MousePointer = HOURGLASS
  Call ReadBack(sgWorkFileName, imBlockStarts(imBlockNumber), imMaxRecord, iEndOfFileFlag, sBuffer)
  Form_Main.MousePointer = DEFAULT
    Debug.Print "cbPrev_Click: ";
    Debug.Print "imBlockStarts("; imBlockNumber; ")=";
    Debug.Print imBlockStarts(imBlockNumber)
  '
    Debug.Print "cbPrev_Click: GrpDetail.ListCount=";
    Debug.Print GrpDetail.ListCount;
    Debug.Print " imMaxRecord="; imMaxRecord;
    Debug.Print "  imBlockStarts("; imBlockNumber + 1; ")=";
    Debug.Print imBlockStarts(imBlockNumber + 1)
  '
  '
  If imBlockNumber > 1 Then
    cbPrev.Visible = True
  End If
  '
  If imBlockStarts(imBlockNumber) < imMaxRecord Then
    cbNext.Visible = True
  End If

End Sub

'---------------------------------------------------------
' Process Form_Load Event
'---------------------------------------------------------
Sub Form_Load ()
  '
  '' Set Global Program ID Values
  sgProgramName = App.EXEName               'Set Program Name
  sgRegistrationStatus = "Un-Registered Shareware"
  sgProgramVersion = "1.02"
  sgCompuserveID = "71055,1043"
  '
'  Debug.Print "CurDir$="; CurDir$
'  Debug.Print "App.Path="; App.Path
  If Right(App.Path, 1) <> "\" Then
    sgWorkFileName = App.Path & "\FILEDUMP.TMP"
  Else
    sgWorkFileName = App.Path & "FILEDUMP.TMP"
  End If
'  Debug.Print "sgWorkFileName="; sgWorkFileName
  '
'  fmForm_MainTopDefault = 10               'Set Production Top
  fmForm_MainTopDefault = 1065              'Set Debugging Top
  imPixelsPerChar = 8
  '
  GrpDetail.Height = 4230                   'Force Height
  '
  Form_Main.Caption = sgProgramName & " " & sgProgramVersion
  '
  '' Insure only one instance is running
  If App.PrevInstance Then
    MsgBox App.EXEName & " is already running!" & Chr$(10) & "  Second instance has been cancelled.", MB_ICONEXCLAMATION
    End
  End If
  '
  '' Set Default Screen Sizing Values
  Form_Main.ScaleMode = TWIPS
  '
  fgCurrentHeightFactor = 1
  fgCurrentWidthFactor = 1
  '
  fgBaseFormLeft = Form_Main.Left
  fgBaseFormTop = Form_Main.Top
  fgBaseFormWidth = Form_Main.Width
  fgBaseFormHeight = Form_Main.Height
'    Debug.Print "Form_Load Base: "; fgBaseFormLeft; fgBaseFormTop; fgBaseFormWidth; fgBaseFormHeight
'    Printer.Print Tab(25); " Left"; Tab(33); "Top"; Tab(40); "Width"; Tab(47); "Height"
'    Printer.Print "Form_Load Base: "; Tab(25); fgBaseFormLeft; Tab(33); fgBaseFormTop; Tab(40); fgBaseFormWidth; Tab(47); fgBaseFormHeight
'    Printer.Print "          GrpDetail: "; Tab(25); GrpDetail.Left; Tab(33); GrpDetail.Top; Tab(40); GrpDetail.Width; Tab(47); GrpDetail.Height
'    Printer.Print "          cbPrev:"; Tab(25); cbPrev.Left; Tab(33); cbPrev.Top; Tab(40); cbPrev.Width; Tab(47); cbPrev.Height
'    Printer.Print "          cbNext:"; Tab(25); cbNext.Left; Tab(33); cbNext.Top; Tab(40); cbNext.Width; Tab(47); cbNext.Height
'    Printer.Print "          lblFileSize:"; Tab(25); lblFileSize.Left; Tab(33); lblFileSize.Top; Tab(40); lblFileSize.Width; Tab(47); lblFileSize.Height
  '
  '' Make sure Form will fit the Screen Size
  If fgBaseFormLeft + fgBaseFormWidth > Screen.Width Then
    MsgBox "The program calls for Higher Horizontal Resolution." & Chr$(10) & " -- The Default Maximum will be used.", MB_ICONEXCLAMATION
    fgBaseFormLeft = 10
    fgBaseFormWidth = Screen.Width - fgBaseFormLeft
  End If
  '
  If fgBaseFormTop + fgBaseFormHeight > Screen.Height Then
    MsgBox "The program calls for Higher Vertical Resolution." & Chr$(10) & " -- The Default Maximum will be used.", MB_ICONEXCLAMATION
    fgBaseFormTop = fmForm_MainTopDefault
    fgBaseFormHeight = Screen.Height - fgBaseFormTop
  End If
  '
    'TRIGGERS Form_Resize EVENT, if different
  Form_Main.Move fgBaseFormLeft, fgBaseFormTop, fgBaseFormWidth, fgBaseFormHeight
  '
  Call Load_Private_Profile
  '
  '' Display Commercial Form Asynchronously
  igFromForm = 1
    'TRIGGERS Form xWare Form_Load EVENT
  Form_xWare.Enabled = True
  Form_Main.Visible = False
  Form_xWare.Visible = True

End Sub

'---------------------------------------------------------
' Process Form_Resize Event
'---------------------------------------------------------
Sub Form_Resize ()
  '
  Form_Main.ScaleMode = TWIPS
  '
'  Debug.Print "ScaleWidth="; ScaleWidth; " Screen.Width="; Screen.Width; "ScaleHeight="; ScaleHeight; " Screen.Height="; Screen.Height
  '
  '' If not Iconized, insure sizing greater then Minimum Useable Form Size
  If (ScaleWidth > ICON_TWIPS And ScaleWidth < MIN_WIDTH) Or (ScaleHeight > ICON_TWIPS And ScaleHeight < MIN_HEIGHT) Then
      Debug.Print "("; ScaleWidth; ">"; ICON_TWIPS; "&"; ScaleWidth; "<"; MIN_WIDTH; ") or ("; ScaleHeight; ">"; ICON_TWIPS; "&"; ScaleHeight; "<"; MIN_HEIGHT; ")"
      'TRIGGERS Form_Resize EVENT
    Form_Main.Move fgBaseFormLeft, fgBaseFormTop, fgBaseFormWidth, fgBaseFormHeight
    Form_Main.Refresh
  End If
  '
  '' If not 1st Form_Resize, Calculate new ratio
  If fgCurrentFormWidth <> 0 Then
    ' Calculate Width Change Ratio
    If ScaleWidth <> fgCurrentFormWidth And ScaleWidth <> ICON_TWIPS And fgCurrentFormWidth <> 0 Then
      fgCurrentWidthFactor = Form_Main.Width / fgCurrentFormWidth
    Else
      fgCurrentWidthFactor = 1
    End If
    ' Calculate Heigth Change Ratio
    If ScaleHeight <> fgCurrentFormHeight And ScaleHeight <> ICON_TWIPS And fgCurrentFormHeight <> 0 Then
      fgCurrentHeightFactor = Form_Main.Height / fgCurrentFormHeight
    Else
      fgCurrentHeightFactor = 1
    End If
  End If
  '
  '' Apply Form Change Ratio to ALL Form Controls
  If fgCurrentHeightFactor <> 1 Or fgCurrentWidthFactor <> 1 Then
    GrpDetail.Move GrpDetail.Left * fgCurrentWidthFactor, GrpDetail.Top * fgCurrentHeightFactor, GrpDetail.Width * fgCurrentWidthFactor, GrpDetail.Height * fgCurrentHeightFactor
    cbPrev.Move cbPrev.Left * fgCurrentWidthFactor, cbPrev.Top * fgCurrentHeightFactor, cbPrev.Width * fgCurrentWidthFactor, cbPrev.Height * fgCurrentHeightFactor
    cbNext.Move cbNext.Left * fgCurrentWidthFactor, cbNext.Top * fgCurrentHeightFactor, cbNext.Width * fgCurrentWidthFactor, cbNext.Height * fgCurrentHeightFactor
    lblFileSize.Move lblFileSize.Left * fgCurrentWidthFactor, lblFileSize.Top * fgCurrentHeightFactor, lblFileSize.Width * fgCurrentWidthFactor, lblFileSize.Height * fgCurrentHeightFactor
  End If
  '
  '' If not Iconized, Save Current Form Size
  If ScaleWidth <> ICON_TWIPS And ScaleHeight <> ICON_TWIPS Then
    fgCurrentFormLeft = Form_Main.Left
    fgCurrentFormTop = Form_Main.Top
    fgCurrentFormWidth = Form_Main.Width
    fgCurrentFormHeight = Form_Main.Height
'      Printer.Print Tab(25); " Left"; Tab(33); "Top"; Tab(40); "Width"; Tab(47); "Height"
'      Printer.Print "Form_Resize Current: "; Tab(25); fgCurrentFormLeft; Tab(33); fgCurrentFormTop; Tab(40); fgCurrentFormWidth; Tab(47); fgCurrentFormHeight
'      Printer.Print "            GrpDetail: "; Tab(25); GrpDetail.Left; Tab(33); GrpDetail.Top; Tab(40); GrpDetail.Width; Tab(47); GrpDetail.Height
'      Printer.Print "            cbPrev:"; Tab(25); cbPrev.Left; Tab(33); cbPrev.Top; Tab(40); cbPrev.Width; Tab(47); cbPrev.Height
'      Printer.Print "            cbNext:"; Tab(25); cbNext.Left; Tab(33); cbNext.Top; Tab(40); cbNext.Width; Tab(47); cbNext.Height
'      Printer.Print "            lblFileSize:"; Tab(25); lblFileSize.Left; Tab(33); lblFileSize.Top; Tab(40); lblFileSize.Width; Tab(47); lblFileSize.Height
  End If
  '
  Form_Main.Refresh
 
End Sub

'---------------------------------------------------------
' Process Form_Unload Event
'---------------------------------------------------------
Sub Form_Unload (Cancel As Integer)
  '
  igFromForm = 3
  Form_Main.Enabled = False
  Form_Main.Visible = False
  On Error GoTo FormUnloadError
  Kill sgWorkFileName
  Unload Form_Main
  '
  Form_xWare.Enabled = True
  Form_xWare.Visible = True
  Exit Sub
'
'
FormUnloadError:
  '
  igErrorNumber = Err
  '
  If Err = 53 Then
    ' No Temp File to Kill
    Resume Next
  End If
  '
  Select Case Err
    Case 0: Exit Sub
    Case 5: sgErrorMessage = "ERROR 5: Illegal Function Call"
    Case 7: sgErrorMessage = "ERROR 7: Out of Memory"
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - Form_Unload"
  Resume Next
  '
 
End Sub

'--------------------------------------------------------
' Load Private Profile Values
'
'   Uses: sgWindowsDirectory, sgProgramName,
'         sgGroupsDrive, sgGroupsPath, fgBaseFormLeft,
'         fgBaseFormTop, fgBaseFormWidth, fgBaseFormHeight,
'         fgCurrentWidthFactor, fgCurrentHeightFactor
'
'   Sets: sgWindowsDirectory, GrpDrive.Drive, GrpDir.Path,
'         sgGroupsDrive, sgGroupsPath, fgCurrentWidthFactor,
'         fgCurrentHeightFactor
'
'--------------------------------------------------------
Sub Load_Private_Profile ()
  '
  Dim sIniFile As String
  Dim sIniString As String * 150
  Static fFormSZ(4) As Single
  '
  '' Set .INI File Path value
  sgWindowsDirectory = sGetWindowsDir()
  sIniFile = sgWindowsDirectory & sgProgramName & ".INI"
  '
  '' Load .INI Values
  ' Get 'Window/Left'
  Call GetPProfileString("Window", "Left", "ERROR", sIniFile, sIniString, Len(sIniString))
  If Left$(sIniString, 5) = "ERROR" Then
    '' Process 'Source/Path' Error
    '' Set Default Profile Values, if no .INI 'Path'
    '
    fFormSZ(0) = fgBaseFormLeft
    fFormSZ(1) = fgBaseFormTop
    fFormSZ(2) = fgBaseFormWidth
    fFormSZ(3) = fgBaseFormHeight
  Else
    '
    fFormSZ(0) = Val(sIniString)
    '
    ' Get 'Window/Top'
    Call GetPProfileString("Window", "Top", "ERROR", sIniFile, sIniString, Len(sIniString))
    If Left$(sIniString, 5) = "ERROR" Then
      fFormSZ(1) = fgBaseFormTop
    Else
      fFormSZ(1) = Val(sIniString)
    End If
    '
    ' Get 'Window/Width'
    Call GetPProfileString("Window", "Width", "ERROR", sIniFile, sIniString, Len(sIniString))
    If Left$(sIniString, 5) = "ERROR" Then
      fFormSZ(2) = fgBaseFormWidth
    Else
      fFormSZ(2) = Val(sIniString)
    End If
    '
    ' Get 'Window/Height'
    Call GetPProfileString("Window", "Height", "ERROR", sIniFile, sIniString, Len(sIniString))
    If Left$(sIniString, 5) = "ERROR" Then
      fFormSZ(3) = fgBaseFormHeight
    Else
      fFormSZ(3) = Val(sIniString)
    End If
    '
    '' Make sure Form will fit the Profile Screen Size
    If fFormSZ(0) + fFormSZ(2) > Screen.Width Then
      MsgBox "The current profile calls for Higher Horizontal Resolution." & Chr$(10) & " -- The Default Maximum will be used."
      fFormSZ(0) = 10
      fFormSZ(2) = Screen.Width - fFormSZ(0)
    End If
    If fFormSZ(1) + fFormSZ(3) > Screen.Height Then
      MsgBox "The current profile calls for Higher Vertical Resolution." & Chr$(10) & " -- The Default Maximum will be used."
      fFormSZ(1) = fmForm_MainTopDefault
      fFormSZ(3) = Screen.Height - fFormSZ(1)
    End If
    '
    '' Calculate Resize Coefficients for Profile Values
    fgCurrentWidthFactor = fFormSZ(2) / fgBaseFormWidth
    fgCurrentHeightFactor = fFormSZ(3) / fgBaseFormHeight
    '
    '' Resize Screen Based on Profile Values
      'TRIGGERS Form_Resize EVENT
    Form_Main.Move fFormSZ(0), fFormSZ(1), fFormSZ(2), fFormSZ(3)
    '
  End If
 
End Sub

'---------------------------------------------------------
' Process Menu 'File/Exit' Selection Event
'---------------------------------------------------------
Sub M_FileExit_Click ()
  '
  Call Save_Private_Profile
  '
  igFromForm = 3
  Form_Main.Enabled = False
  Form_Main.Visible = False
  On Error GoTo FileExitError
  Unload Form_Main
  '
  Form_xWare.Enabled = True
  Form_xWare.Visible = True
  Exit Sub
'
'
FileExitError:
  '
  igErrorNumber = Err
  '
  Select Case Err
    Case 0: Exit Sub
    Case 5: sgErrorMessage = "ERROR 5: Illegal Function Call"
    Case 7: sgErrorMessage = "ERROR 7: Out of Memory"
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FileExit"
  Resume Next

End Sub

'--------------------------------------------------------
'--------------------------------------------------------
Sub M_FileOpen_Click ()
  '
  Dim lBlockOffset As Long
  Dim iEndOfFileFlag As Integer
  Dim sBuffer As String
  Dim lFileSize As Long
  Dim iStartRecord As Integer
  '
  ' Specify Input File via Windows API
  On Error GoTo FileOpenError
  '
  CMDialog1.Flags = OFN_FILEMUSTEXIST Or OFN_PATHMUSTEXIST Or OFN_HIDEREADONLY
  CMDialog1.DialogTitle = sgProgramName & " Open File to Dump"
  CMDialog1.InitDir = "C:\"
  CMDialog1.CancelError = True
  CMDialog1.Filter = "Any(*.*)|*.*"
    ''TRIGGERS Open File Dialog
  CMDialog1.Action = DLG_FILE_OPEN
  '
  ' Save Input File Name
  smSourceFileName = CMDialog1.Filename
  '
  ' If not error or Cancel, insert Input File Name in
  '  Window Caption
  If igErrorNumber = 0 Then
    Form_Main.Caption = sgProgramName & " " & sgProgramVersion & " -- " & smSourceFileName
  Else
    igErrorNumber = 0
    Exit Sub
  End If
  '
  On Error GoTo 0
  '
  If Len(smSourceFileName) Then
    If Len(Dir$(smSourceFileName)) Then
      '
      ' Display File Size in Label
      lFileSize = FileLen(smSourceFileName)
      lblFileSize = Format$(lFileSize, "###,###,##0") & " == " & Hex(lFileSize - 1)
      Form_Main.Refresh
      '
      iEndOfFileFlag = False
      imMaxRecord = 0
      lBlockOffset = 0
      '
      ' Format Entire Input File into Work File
      Form_Main.MousePointer = HOURGLASS
      '
      While iEndOfFileFlag = False And igErrorNumber = 0
        Call ReadBlock(smSourceFileName, lFileSize, iEndOfFileFlag, lBlockOffset, sBuffer)
        Call WorkBlock(sgWorkFileName, lBlockOffset, sBuffer)
        lBlockOffset = lBlockOffset + BLOCK_SIZE
      Wend
      '
      Form_Main.MousePointer = DEFAULT
      '
      '
      lFileSize = FileLen(sgWorkFileName)
'        Debug.Print "M_FileOpen: Work-FileLen="; Format$(lFileSize, "###,###,##0")
      '
      '
      imBlockNumber = 1
      imBlockStarts(imBlockNumber) = 0
      '
      imPriorShow = 0
      iEndOfFileFlag = False
      '
      ' Display the 1st Block of Formatted Data
      GrpDetail.Clear
      Form_Main.MousePointer = HOURGLASS
      Call ReadBack(sgWorkFileName, imBlockStarts(imBlockNumber), imMaxRecord, iEndOfFileFlag, sBuffer)
      Form_Main.MousePointer = DEFAULT
        Debug.Print "M_FileOpen_Click: ";
        Debug.Print "imBlockStarts("; imBlockNumber; ")=";
        Debug.Print imBlockStarts(imBlockNumber)
      '
      ' Update BlockStarts Vector
      imBlockStarts(imBlockNumber + 1) = GrpDetail.ListCount
        Debug.Print "M_FileOpen_Click: GrpDetail.ListCount=";
        Debug.Print GrpDetail.ListCount;
        Debug.Print " imMaxRecord="; imMaxRecord;
        Debug.Print "  imBlockStarts("; imBlockNumber + 1; ")=";
        Debug.Print imBlockStarts(imBlockNumber + 1)
      '
      ' Display Next Button, if appropriate
      If imBlockStarts(imBlockNumber + 1) < imMaxRecord Then
        cbNext.Visible = True
      End If
      '
    End If
  End If
  '
  If igErrorNumber Then igErrorNumber = 0
  '
  Exit Sub
'
'
FileOpenError:
  '
  igErrorNumber = Err
  '
  If Err = 32755 Then
    sgErrorMessage = "No Source File was Selected"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FileOpen"
    Resume Next
  End If
  '
  If Err = 5 Then
    sgErrorMessage = "ERROR 5: Illegal Function Call" & " - M_FileOpen"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName
    Resume Next
  End If
  '
  If Err = 7 Then
    sgErrorMessage = "Out of Memory"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FileOpen"
    Resume Next
  End If
  '
  Select Case Err
    Case 0: Exit Sub
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FileOpen"
  Resume Next
  '

  End Sub

'---------------------------------------------------------
' Process Menu 'File/Print' Selection Event
'---------------------------------------------------------
Sub M_FilePrint_Click ()
  '
  Dim lFileSize As Long
  Dim sWork1 As String
  Dim iWork1 As Integer
  Dim iPageCounter As Integer
  Dim iLineCounter As Integer
  '
  On Error GoTo ErrHandler
  '
  '' Specify Print Action
  CMDialog1.CancelError = True
  CMDialog1.Flags = PD_NOPAGENUMS
  CMDialog1.DialogTitle = sgProgramName & " Print"
    'TRIGGERS Print Dialog
  CMDialog1.Action = DLG_PRINT
  '
  If igErrorNumber = 32755 Then
    ' User cancelled Print Dialog
    igErrorNumber = 0
    Exit Sub
  End If
  '
  lFileSize = FileLen(smSourceFileName)
  '
  If (CMDialog1.Flags And PD_PRINTTOFILE) > 0 Then
    '' Specify Save File
    CMDialog1.Flags = OFN_NOREADONLYRETURN Or OFN_PATHMUSTEXIST Or OFN_HIDEREADONLY Or OFN_OVERWRITEPROMPT
    CMDialog1.DialogTitle = sgProgramName & " Print to File"
    CMDialog1.InitDir = "C:\"
    CMDialog1.Filename = sgProgramName & ".PRN"
      'TRIGGERS Print-to-File
    CMDialog1.Action = DLG_FILE_SAVE
    '
    If igErrorNumber = 32755 Then
      ' User cancelled Print-to-File Dialog
      igErrorNumber = 0
      Exit Sub
    End If
    '
    '' Open Save File
    Open CMDialog1.Filename For Output As #2
    ' Print to Save File
    Form_Main.MousePointer = HOURGLASS
    iPageCounter = 1
    iLineCounter = 1
    iWork1 = 0
    Do Until Len(Form_Main.GrpDetail.List(iWork1)) < 1
      If iLineCounter < 2 Then
        Print #2, Tab(3); sgProgramName; " "; sgProgramVersion;
        Print #2, Tab(49); Date$; " "; Time$;
        Print #2, Tab(70); "Page "; iPageCounter
        sWork1 = smSourceFileName & "  " & Format$(lFileSize, "###,###,##0") & " == " & Hex(lFileSize - 1)
        Print #2, Tab(38 - (Len(sWork1) / 2)); sWork1
        sWork1 = "(c)TecLogic,Inc. 1993  " & sgRegistrationStatus
        Print #2, Tab(38 - (Len(sWork1) / 2)); sWork1
        Print #2, Tab(3); "(c)TecLogic,Inc. 1993";
        Print #2, Tab(30); sgRegistrationStatus
        Print #2, " "
        iLineCounter = 4
      End If
      If Mid$(Form_Main.GrpDetail.List(iWork1), 2, 1) = ":" Then
        Print #2, " "
        iLineCounter = iLineCounter + 1
      End If
      Print #2, Tab(5); Form_Main.GrpDetail.List(iWork1)
      iLineCounter = iLineCounter + 1
      iWork1 = iWork1 + 1
      If iLineCounter > 52 Then
        Print #2, Chr$(12);
        iPageCounter = iPageCounter + 1
        iLineCounter = 1
      End If
    Loop
    Close #2
    ' Save File is Complete
  Else
    ' Print to Printer
    Form_Main.MousePointer = HOURGLASS
    iPageCounter = 1
    iLineCounter = 1
    iWork1 = 0
    Do Until Len(Form_Main.GrpDetail.List(iWork1)) < 1
      If iLineCounter < 2 Then
        Printer.Print Tab(3); sgProgramName; " "; sgProgramVersion;
        Printer.Print Tab(49); Date$; " "; Time$;
        Printer.Print Tab(70); "Page "; iPageCounter
        sWork1 = smSourceFileName & "  " & Format$(lFileSize, "###,###,##0") & " == " & Hex(lFileSize - 1)
        Printer.Print Tab(38 - (Len(sWork1) / 2)); sWork1
        sWork1 = "(c)TecLogic,Inc. 1993  " & sgRegistrationStatus
        Printer.Print Tab(38 - (Len(sWork1) / 2)); sWork1
        Printer.Print " "
        iLineCounter = 4
      End If
      If Mid$(Form_Main.GrpDetail.List(iWork1), 2, 1) = ":" Then
        Printer.Print " "
        iLineCounter = iLineCounter + 1
      End If
      Printer.Print Tab(5); Form_Main.GrpDetail.List(iWork1)
      iLineCounter = iLineCounter + 1
      iWork1 = iWork1 + 1
      If iLineCounter > 52 Then
        Printer.NewPage
        iPageCounter = iPageCounter + 1
        iLineCounter = 1
      End If
    Loop
    Printer.EndDoc
    ' Print to Printer is Complete
  End If
  '
  Form_Main.MousePointer = DEFAULT
  '
  Exit Sub
'
ErrHandler:
  '
  igErrorNumber = Err
  '
  ' User cancelled Dialog
  If Err = 32755 Then
    Resume Next
  End If
  '
  If Err = 5 Then
    sgErrorMessage = "ERROR 5: Illegal Function Call"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FilePrint"
    Resume Next
  End If
  '
  If Err = 7 Then
    sgErrorMessage = "Out of Memory"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FilePrint"
    Resume Next
  End If
  '
  Select Case Err
    Case 0: Exit Sub
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - M_FilePrint"
  Resume Next
  '
 
End Sub

'---------------------------------------------------------
' Process Menu 'Help/About' Selection Event
'---------------------------------------------------------
Sub M_HelpAbout_Click ()
  '
  Form_About.Enabled = True
  Form_Main.Visible = False
  Form_About.Visible = True
 
End Sub

'--------------------------------------------------------
' Read back formatted dump records by line, skipping records
'  between iRecordCount and iStartRecord and reading from
'  and displaying, in the ListBox, from iStartRecord until
'  Error #7 (out of memory) occurs.
'--------------------------------------------------------
Sub ReadBack (sSourceFileName As String, iStartRecord As Integer, iMaxRecord As Integer, iEndOfFileFlag As Integer, sBuffer As String)
  '
  Dim iRecordCount As Integer
  '
  igErrorNumber = 0
  On Error GoTo ReadBackError
  '
  If iEndOfFileFlag = False Then
    '
    ' Open the Work File
    Open sSourceFileName For Input As #1
    iRecordCount = 0
    '
    ' Skip Prior Records
    While iRecordCount < iStartRecord
      Input #1, sBuffer
      iRecordCount = iRecordCount + 1
    Wend
    '
    ' Read and Display Formatted Lines
    While iRecordCount < iMaxRecord And igErrorNumber = 0
      Input #1, sBuffer
      GrpDetail.AddItem sBuffer
      If igErrorNumber = 0 Then
        iRecordCount = iRecordCount + 1
      End If
    Wend
    '
    If igErrorNumber = 0 Then iEndOfFileFlag = True
    '
    Close #1
  '
  End If
  '
  On Error GoTo 0
  '
  Exit Sub
'
'
ReadBackError:
  '
  igErrorNumber = Err
  '
  If Err = 5 Then
    sgErrorMessage = "ERROR 5: Illegal Function Call"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - ReadBack"
    Resume Next
  End If
  '
  If Err = 7 Then
    Resume Next
  End If
  '
  Select Case Err
    Case 0: Exit Sub
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - ReadBack"
  Resume Next
  '

End Sub

'--------------------------------------------------------
' Read a block, from the input file, from lOffset.
'  Adjust the size of sBuffer and set iEndOfFileFlag
'  when a short record is read.
'--------------------------------------------------------
Sub ReadBlock (sSourceFileName As String, lFileSize As Long, iEndOfFileFlag As Integer, lOffset As Long, sBuffer As String)
  '
  On Error GoTo ReadBlockError
  '
  If iEndOfFileFlag = False Then
    '
    ' Open the Input File as Binary
    Open sSourceFileName For Binary Access Read As #1
    '
    ' Read a Block of Data
    sBuffer = String$(BLOCK_SIZE, " ")
    Get #1, lOffset + 1, sBuffer
    '
    Close #1
    '
    If Len(sBuffer) < BLOCK_SIZE Then iEndOfFileFlag = True
    If lOffset + Len(sBuffer) >= lFileSize Then
      iEndOfFileFlag = True
      sBuffer = Left$(sBuffer, lFileSize - lOffset)
    End If
    '
  End If
  '
  On Error GoTo 0
  '
  Exit Sub
'
'
ReadBlockError:
  '
  igErrorNumber = Err
  '
  If Err = 5 Then
    sgErrorMessage = "ERROR 5: Illegal Function Call"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - ReadBlock"
    Resume Next
  End If
  '
  If Err = 7 Then
    sgErrorMessage = "Out of Memory"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - ReadBlock"
    Resume Next
  End If
  '
  Select Case Err
    Case 0: Exit Sub
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - ReadBlock"
  Resume Next
  '

End Sub

'--------------------------------------------------------
' Save Private Profile Values
'
'   Uses: sgWindowsDirectory, sgProgramName, GrpDir.Path
'
'   Sets: none
'
'--------------------------------------------------------
Sub Save_Private_Profile ()
  '
  Dim sIniFile As String
  Dim fLeft, fTop, fWidth, fHeight As Single
  '
  sIniFile = sgWindowsDirectory
  If Right$(sIniFile, 1) <> "\" Then
    sIniFile = sIniFile & "\" & sgProgramName & ".INI"
  Else sIniFile = sIniFile & sgProgramName & ".INI"
  End If
  '
  '
  fLeft = Form_Main.Left
  fTop = Form_Main.Top
  fWidth = Form_Main.Width
  fHeight = Form_Main.Height
  '
  If fLeft < 2 Then fLeft = 5
  If fTop < 2 Then fTop = 5
  If fWidth > Screen.Width Then fWidth = Screen.Width - 45
  If fHeight > Screen.Height Then fHeight = Screen.Height - 5
  '
  ' Write 'Window/Left'
  Call WritePProfileString("Window", "Left", Str$(fLeft), sIniFile)
  ' Write 'Window/Top'
  Call WritePProfileString("Window", "Top", Str$(fTop), sIniFile)
  ' Write 'Window/Width'
  Call WritePProfileString("Window", "Width", Str$(fWidth), sIniFile)
  ' Write 'Window/Height'
  Call WritePProfileString("Window", "Height", Str$(fHeight), sIniFile)
 
End Sub

'--------------------------------------------------------
' Format the dump image of a block of data from sBuffer
'  into Work File records, addressed starting from
'  lBlockOffset.  Count Work File records into imMaxMaxRecord.
'--------------------------------------------------------
Sub WorkBlock (sWorkFileName As String, lBlockOffset As Long, sBuffer As String)
  '
  Dim sWork1, sWork2 As String
  Dim iWork1, iWork2, iWork3 As Integer
  '
  ' Open a WORK file to hold the Dump output
  On Error GoTo WorkBlockError
  If lBlockOffset = 0 Then
    Open sgWorkFileName For Output As #2
  Else
    Open sgWorkFileName For Append As #2
  End If
  '
  ' Dump the full block
  iWork1 = 0
  While iWork1 < Len(sBuffer) And igErrorNumber = 0
    '
    ' Format the 5 Hex Digit Address followed by a space
    sWork1 = Hex(lBlockOffset + iWork1)
    If Len(sWork1) < 5 Then sWork1 = String$(5 - Len(sWork1), "0") & sWork1
    sWork2 = sWork1 & " "
    '
    ' Format the 16 byte Hex area
    iWork2 = 1
    While iWork2 <= 16 And iWork1 + iWork2 <= Len(sBuffer)
      sWork1 = Hex(Asc(Mid$(sBuffer, iWork1 + iWork2, 1)))
      If Len(sWork1) < 2 Then sWork1 = String$(2 - Len(sWork1), "0") & sWork1
      sWork2 = sWork2 & sWork1 & " "
      If iWork2 = 8 Then sWork2 = sWork2 & "- "
      iWork2 = iWork2 + 1
    Wend
    '
    ' Space-fill any unused Hex area
    sWork2 = sWork2 & String$(56 - Len(sWork2), " ")
    '
    ' Format the Ascii area Left Margin
    sWork2 = sWork2 & "|"
    '
    ' Format the 16 byte Ascii area
    iWork2 = 1
    While iWork2 <= 16 And iWork1 + iWork2 <= Len(sBuffer)
      iWork3 = Asc(Mid$(sBuffer, iWork1 + iWork2, 1))
      If iWork3 < 32 Or iWork3 > 126 Or iWork3 = 44 Then
        sWork1 = "."
      Else
        sWork1 = Chr$(iWork3)
      End If
      sWork2 = sWork2 & sWork1
      iWork2 = iWork2 + 1
    Wend
    '
    ' Format the Ascii area Right Margin
    sWork2 = sWork2 & "|"
    '
    ' Print the Formatted Line into the Work File
    Print #2, sWork2
    '
    ' Count the Formatted Lines
    imMaxRecord = imMaxRecord + 1
    '
    iWork1 = iWork1 + 16
  Wend
  '
  ' Close the Work File
  Close #2
  '
  On Error GoTo 0
  '
Exit Sub
'
'
WorkBlockError:
  '
  igErrorNumber = Err
  '
  If Err = 5 Then
    sgErrorMessage = "ERROR 5: Illegal Function Call"
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - DumpBlock"
    Resume Next
  End If
  '
  If Err = 7 Then
    sgErrorMessage = "Out of Memory!" & Chr$(10) & "What you can see should be good." & Chr$(10) & "This version can only handle a dump of about 14,100 bytes."
    MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - DumpBlock"
    Resume Next
  End If
  '
  Select Case Err
    Case 0: Exit Sub
    Case 53: sgErrorMessage = "ERROR 53: That file doesn't exist."
    Case 62: sgErrorMessage = "ERROR 62: Attempt to Input past End-of-File."
    Case 68: sgErrorMessage = "ERROR 68: Drive " & Left$(smSourceFileName, 1) & ": not available."
    Case 76: sgErrorMessage = "ERROR 76: That path doesn't exist."
    Case Else: sgErrorMessage = "ERROR " & Err & " occurred." & "  " & Error$(Err)
  End Select
  MsgBox sgErrorMessage, MB_ICONEXCLAMATION, sgProgramName & " - DumpBlock"
  Resume Next
  '
End Sub

