#include "WTIME.H"
#include<ctype.h>
#include<dos.h>
#include<errno.h>
#include<time.h>
#ifdef __TURBOC__
    #define _dostime_t dostime_t
    #define _dosdate_t dosdate_t
#endif
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,
LPSTR lpszCmdLine,int nCmdShow){
    MSG msg;
    int nRc;
    lstrcpy(szAppName,"WTime");
    lstrcpy(szHelpFile,"WTime.hlp");
    iInHelp=0;
    hInst=hInstance;
    iTargetTime=TIMER_TARGET_INACTIVE;
    wEachSecondCmdToPost=wTimedTargetCmdToPost=
    TIMER_NEVER_POST;
    if(lpszCmdLine){
        LPSTR tmpptr=lpszCmdLine;
        while(*tmpptr){
            if(*tmpptr=='a'||*tmpptr=='A'){
                /*CNICE-*/
                if(
                (tmpptr[1]=='u'||tmpptr[1]=='U')&&
                (tmpptr[2]=='t'||tmpptr[2]=='T')&&
                (tmpptr[3]=='o'||tmpptr[3]=='O')&&
                (tmpptr[4]=='m'||tmpptr[4]=='M')&&
                (tmpptr[5]=='a'||tmpptr[5]=='A')&&
                (tmpptr[6]=='t'||tmpptr[6]=='T')&&
                (tmpptr[7]=='i'||tmpptr[7]=='I')&&
                (tmpptr[8]=='c'||tmpptr[8]=='C')
                ){
                    /*CNICE+*/
                    iAutomatic=1;
                }
                break;
            }
            else tmpptr++;
        }
    }
    if(!hPrevInstance){
        if((nRc=nCwRegisterClasses())==-1){
            if(iAutomatic){
                LoadString(hInst,IDS_ERR_REGISTER_CLASS,
                szString,sizeof(szString));
                MessageBox(NULL, szString, NULL,
                MB_ICONEXCLAMATION);
            }
            return 1;
        }
        else;
    }
    else{
        if(!iAutomatic){
            LoadString(hInst, IDS_ERR_MULT_INSTANCES,
            szString,sizeof(szString));
            MessageBox(NULL,szString,NULL,
            MB_ICONEXCLAMATION);
        }
        return 1;
    }
    hWndMain = CreateWindow(
                szAppName,
                szAppName,
                WS_CAPTION|WS_SYSMENU|WS_MINIMIZEBOX|
                WS_MAXIMIZEBOX|WS_THICKFRAME|
                WS_CLIPCHILDREN|WS_OVERLAPPED,
                CW_USEDEFAULT,0,
                CW_USEDEFAULT,0,
                NULL,
                NULL,
                hInst,
                NULL);
    if(hWndMain == NULL){
        if(!iAutomatic){
            LoadString(hInst,IDS_ERR_CREATE_WINDOW,
            szString,sizeof(szString));
            MessageBox(NULL,szString,NULL,
            MB_ICONEXCLAMATION);
        }
        CwUnRegisterClasses();
        return 1;
    }
    else{
        int charWidth,charHeight,startX,startY;
        TEXTMETRIC tm;
        HDC devcon=GetDC(hWndMain);/* get device context */
        GetTextMetrics(devcon,&tm);/* get text size info */
        iRowHeight=tm.tmHeight; /* for multirow display */
        charWidth=tm.tmAveCharWidth*60;
        charHeight=tm.tmHeight*15;
        ReleaseDC(hWndMain,devcon);/* release dev ctx */
                                /* center the screen */
        startX=(GetSystemMetrics(SM_CXSCREEN)-charWidth)/2;
        startY=(GetSystemMetrics(SM_CYSCREEN)-charHeight)
        /2;
                                /* change window size */
        SetWindowPos(hWndMain,NULL,startX,startY,charWidth,
        charHeight,SWP_NOZORDER);
    }
    szDisplayString[0]=0;       /* no string for window */
    szDisplayString2[0]=0;      /* no string for window */
    ShowWindow(hWndMain,nCmdShow);
    while(GetMessage(&msg,NULL,0,0)){
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    CwUnRegisterClasses();
    return msg.wParam;
}
LONG FAR PASCAL WndProc(HWND hWnd,WORD Message,
                        WORD wParam,LONG lParam){
    HMENU hMenu=0;
    HBITMAP hBitmap=0;
    HDC hDC;
    PAINTSTRUCT ps;
    int nRc=0;
    switch(Message){
    case WM_COMMAND:
        if(iInHelp){
            int help_topic=0;
            iAutomatic=0;
            iInHelp=0;
            if(wParam==IDM_F_EXIT)help_topic=
            HLP_WTIME_MEXIT;
            else if(wParam==IDM_M_CALL)help_topic=
            HLP_WTIME_MCALL;
            else if(wParam==IDM_M_HANGUP)help_topic=
            HLP_WTIME_MHANGUP;
            else if(wParam==IDM_M_SETUP)help_topic=
            HLP_WTIME_MSETUP;
            else if(wParam==IDM_H_PROCEDURES)help_topic=
            HLP_WTIME_MPROCS;
            else if(wParam==IDM_H_USINGHELP)help_topic=
            HLP_WTIME_MUSING;
            else if(wParam==IDM_H_ABOUTWTIME)help_topic=
            HLP_WTIME_MABOUT;
            else MessageBox(hWnd,
            "Could not find help topic","Program Error",
            MB_ICONSTOP);
            if(help_topic){
                if(!WinHelp(hWnd,szHelpFile,HELP_CONTEXT,
                help_topic)){
                    MessageBox(NULL,"Could not start "
                    "Windows Help\nor WTIME.HLP not found",
                    "Windows Error",MB_ICONSTOP);
                }
            }
            break;
        }
        switch(wParam){
        case IDM_F_EXIT:
            PostMessage(hWnd,WM_CLOSE,0,0L);
            break;
        case IDM_M_SETUP:
            iAutomatic=0;
            {
                FARPROC lpfnCONFIGMsgProc,lpfnMsgFilter;
                /* first, hook messages for help */
                lpfnMsgFilter=
                MakeProcInstance((FARPROC)SetupDlgMsgHook,
                hInst);
                oldfilter=SetWindowsHook(WH_MSGFILTER,
                lpfnMsgFilter);
                /* now do the dialog box */
                lpfnCONFIGMsgProc=
                MakeProcInstance((FARPROC)CONFIGMsgProc,
                hInst);
                nRc=DialogBox(hInst,MAKEINTRESOURCE(100),
                hWnd, lpfnCONFIGMsgProc);
                FreeProcInstance(lpfnCONFIGMsgProc);
                /* unhook the message queue */
                UnhookWindowsHook(WH_MSGFILTER,
                lpfnMsgFilter);
                FreeProcInstance(lpfnMsgFilter);
            }
            iReadyToGo=iGetConfigurationInformation();
            SetCallOption();
            szDisplayString[0]=0;
            UpdateStatusLine();
            break;
        case IDM_H_PROCEDURES:
            iAutomatic=0;
            if(!WinHelp(hWnd,szHelpFile,HELP_CONTEXT,
            HLP_WTIME_MPROCS)){
                MessageBox(NULL,
                "Could not start Windows Help\n"
                "or WTIME.HLP missing",
                "Windows Error",MB_ICONSTOP);
            }
            break;
        case IDM_H_USINGHELP:
            iAutomatic=0;
            if(!WinHelp(hWnd,szHelpFile,
            HELP_HELPONHELP,0)){
                MessageBox(NULL,
                "Could not start Windows Help\n"
                "or WTIME.HLP not present",
                "Windows Error",MB_ICONSTOP);
            }
            break;
        case IDM_H_ABOUTWTIME:
            iAutomatic=0;
            {
                FARPROC lpfnABOUTMsgProc;
                lpfnABOUTMsgProc=
                MakeProcInstance((FARPROC)ABOUTMsgProc,
                hInst);
                nRc=DialogBox(hInst,MAKEINTRESOURCE(600),
                hWnd,lpfnABOUTMsgProc);
                FreeProcInstance(lpfnABOUTMsgProc);
            }
            break;
        case IDM_M_HANGUP:
            if(!iCleaningUp){
                iAutomatic=0;
                EnableMenuItem(hMainMenu,IDM_M_HANGUP,
                MF_GRAYED|MF_BYCOMMAND);
                FailCall("User chose Modem|Hang Up");
            }
            break;
        case IDM_M_CALL:
            if(iInCall||iCleaningUp){MessageBeep(0);break;}
            iThisRunFailed=1;
            iInCall=1;
            iCleaningUp=0;
            iMustHangUp=0;
            szFailString[0]=0;
            szCommError[0]=0;
            iTimerCount=TIMER_TOTAL_CALLTIME;
            iTargetTime=TIMER_TARGET_INACTIVE;
            EnableMenuItem(hMainMenu,IDM_M_CALL,
            MF_GRAYED|MF_BYCOMMAND);
            EnableMenuItem(hMainMenu,IDM_M_SETUP,
            MF_GRAYED|MF_BYCOMMAND);
            EnableMenuItem(hMainMenu,IDM_M_HANGUP,
            MF_ENABLED|MF_BYCOMMAND);
            if(!iHaveTimer){            /* start timer */
                if(SetTimer(hWnd,1,1000,NULL))iHaveTimer=1;
                else {
                    FailCall("No timers available");
                    break;
                }
            }
            {                           /* get COM port */
                LPSTR string;
                if(string=init_comm_port()){
                    FailCall(string);
                    break;
                }
            }
            UpdateStatusLineText("Initializing modem");
            WaitSecondsCommand(TIMER_FIRST_ESCAPE,
            IDM_CMD_FIRST_ESCAPE);
            break;
        case IDM_CMD_FIRST_ESCAPE:
            UpdateStatusLineText("Sending "
            "escape sequence");
            if(WriteComm(dcb.Id,"+++",3)!=3){
                FailCall("Could not get "
                "modem's attention");
                break;
            }
            WaitSecondsCommand(TIMER_AT_CMD,
            IDM_CMD_AT_CMD);
            break;
        case IDM_CMD_AT_CMD:
            if(!iInCall)break;
            UpdateStatusLineText("Resetting modem");
            if(WriteComm(dcb.Id,"ATZ\n\r",5)!=5){
                FailCall("Could not initialize modem");
                break;
            }
            WaitSecondsCommand(TIMER_FIRST_RESET,
            IDM_CMD_DIALTIME);
            break;
        case IDM_CMD_DIALTIME:
            if(!iInCall)break;
            UpdateStatusLineText("Dialing modem");
            iMustHangUp=1;
            wsprintf(szString,"%s\n\r",
            (LPSTR)szModemDialString);
            if(WriteComm(dcb.Id,szString,lstrlen(szString))
            !=(int)lstrlen(szString)){
                FailCall("Could not dial");
                break;
            }
            WaitSecondsCommand(TIMER_DIAL,
            IDM_CMD_WAITDATA);
            break;
        case IDM_CMD_WAITDATA:
            if(!iInCall)break;
            {
                static int gotspecials=0;
                static char newbuf[101],*p;
                int read_chars,got_firstspecial,need_chars;
                NISTDATA *nist;
                LPSTR failstring=NULL;
                /* on first call, chg to call ea. second */
                if(wTimedTargetCmdToPost==
                IDM_CMD_WAITDATA){
                    wEachSecondCmdToPost=IDM_CMD_WAITDATA;
                    iTargetTime=TIMER_TARGET_INACTIVE;
                    wTimedTargetCmdToPost=TIMER_NEVER_POST;
                    gotspecials=0;
                    p=newbuf;
                    UpdateStatusLineText("Looking for "
                    "data");
                }
                /*
                **  now gather the data
                **  first, read 90 chars at a time
                **  we won't do anything until we find
                **  '*' or '#' three separate times
                **  then we'll show a string
                */
                GetDisplayCommError(dcb.Id,&comstat);
                read_chars=ReadComm(dcb.Id,
                p,100-(p-newbuf));
                if(read_chars<0)read_chars*=-1;
                if(gotspecials<3){
                    while(read_chars--){
                        if(*p=='#'||*p=='*')gotspecials++;
                        p++;
                    }
                    p=newbuf;
                    break;
                }
                /* ok we want to proceed, clean start */
                FlushComm(dcb.Id,1);    /* rx queue */
                p=newbuf;
                got_firstspecial=0;
                for(;;){
                    p=newbuf;
                    GetDisplayCommError(dcb.Id,&comstat);
                    read_chars=ReadComm(dcb.Id,
                    newbuf,100-sizeof(NISTDATA));
                    if(read_chars<0)read_chars*=-1;
                    while(read_chars--){
                        if(*p=='*'||*p=='#'){
                            got_firstspecial=1;
                            nist=(NISTDATA *)p;
                            break;
                        }
                    }
                    if(got_firstspecial||!iInCall)break;
                }
                if(!iInCall)break;
                if(!got_firstspecial){  /* resync */
                    p=newbuf;
                    gotspecials=0;
                    need_chars=sizeof(NISTDATA)-read_chars;
                    break;
                }
                /*
                **  Now nist and p point to same char --
                **  that char is a special char
                **  there is room for the whole NISTDATA
                **  structure there. We need need_chars
                **  chars still to fill struct -- now we'll
                **  loop until we have our actual data
                **  and we'll convert it then, then we'll
                **  break out to wait for next special
                **  char
                */
                while(iInCall){
                    GetDisplayCommError(dcb.Id,&comstat);
                    read_chars=ReadComm(dcb.Id,p,
                    need_chars);
                    if(read_chars<0)read_chars*=-1;
                    p+=read_chars;
                    if(p>=nist->junk3)break;
                }
                /*
                **  if all valid data post ASAP
                */
                if(!iInCall)break;
                {
                    struct tm tims,*tm_ptr;
                    time_t Time;
                    struct _dosdate_t dosdate;
                    struct _dostime_t dostime;
                    if(!isdigit((int)nist->year[0])||
                    !isdigit((int)nist->year[1])||
                    !isdigit((int)nist->month[0])||
                    !isdigit((int)nist->month[1])||
                    !isdigit((int)nist->day[0])||
                    !isdigit((int)nist->day[1])||
                    !isdigit((int)nist->hour[0])||
                    !isdigit((int)nist->hour[1])||
                    !isdigit((int)nist->minute[0])||
                    !isdigit((int)nist->minute[1])||
                    !isdigit((int)nist->second[0])||
                    !isdigit((int)nist->second[1])){
                        /* got invalid data so retry */
                        gotspecials=0;
                        p=newbuf;
                        break;
                    }
                    tims.tm_year=
                    (((int)nist->year[0]-'0')*10)+
                    ((int)nist->year[1]-'0');
                    if(tims.tm_year<90)tims.tm_year+=100;
                    tims.tm_mon=
                    (((int)nist->month[0]-'0')*10)+
                    ((int)nist->month[1]-'0')-1;
                    tims.tm_mday=
                    (((int)nist->day[0]-'0')*10)+
                    ((int)nist->day[1]-'0');
                    tims.tm_hour=
                    (((int)nist->hour[0]-'0')*10)+
                    ((int)nist->hour[1]-'0');
                    tims.tm_min=
                    (((int)nist->minute[0]-'0')*10)+
                    ((int)nist->minute[1]-'0');
                    tims.tm_sec=
                    (((int)nist->second[0]-'0')*10)+
                    ((int)nist->second[1]-'0');
                    tims.tm_isdst=-1;
                    daylight=0;
                    timezone=0L;
                    if((Time=mktime(&tims))==-1L){
                        failstring="Time conversion error";
                        break;
                    }
                    timezone=-60L*(long)iTimeOffset;
                    daylight=iUseDaylightSavings?~0:0;
                    if(!(tm_ptr=localtime(&Time))){
                        failstring="Local time error";
                        break;
                    }
                    dosdate.day=
                    (unsigned char)tm_ptr->tm_mday;
                    dosdate.month=
                    (unsigned char)(1+tm_ptr->tm_mon);
                    dosdate.year=
                    (unsigned int)1900+tm_ptr->tm_year;
                    dostime.hour=
                    (unsigned char)tm_ptr->tm_hour;
                    dostime.minute=
                    (unsigned char)tm_ptr->tm_min;
                    dostime.second=
                    (unsigned char)tm_ptr->tm_sec;
                    if(_dos_settime(&dostime)){
                        failstring="Couldn't set DOS time";
                        break;
                    }
                    if(_dos_setdate(&dosdate)){
                        failstring="Couldn't set DOS date";
                        break;
                    }
                    UpdateStatusLineText("Time set");
                }
                /*
                **  clean up
                **  use failstring to drive failure
                */
                wEachSecondCmdToPost=TIMER_NEVER_POST;
                iTargetTime=TIMER_TARGET_INACTIVE;
                wTimedTargetCmdToPost=TIMER_NEVER_POST;
                if(failstring)FailCall(failstring);
                else{
                    iInCall=0;
                    iThisRunFailed=0;
                    PostMessage(hWnd,WM_COMMAND,
                    IDM_CMD_CALLDONE,0L);
                }
            }
            break;
        case IDM_CMD_CALLDONE:
            iCleaningUp=1;
            iTargetTime=TIMER_TARGET_INACTIVE;
            wEachSecondCmdToPost=wTimedTargetCmdToPost=
            TIMER_NEVER_POST;
            if(iGotComPort&&iMustHangUp){
                UpdateStatusLineText(iThisRunFailed?
                "Abort: waiting to send escape sequence":
                "Success: waiting to send escape "
                "sequence");
                iTimerCount=1000;
                WaitSecondsCommand(TIMER_PREBREAK,
                IDM_CMD_PREBREAK);
                break;
            }
            else goto break_is_done;
        case IDM_CMD_PREBREAK:
            GetDisplayCommError(dcb.Id,&comstat);
            WriteComm(dcb.Id,"+++",3);
            UpdateStatusLineText(iThisRunFailed?
            "Abort: sending escape sequence":
            "Success: sending escape sequence");
            WaitSecondsCommand(TIMER_POSTBREAK,
            IDM_CMD_POSTBREAK);
            break;
        case IDM_CMD_POSTBREAK:
            UpdateStatusLineText(iThisRunFailed?
            "Abort: sending hang-up sequence":
            "Success: sending hang-up sequence");
            WriteComm(dcb.Id,"ATH0\n\r",6);
            /*
            ** next is to allow hang-up to occur
            ** before resetting modem
            */
            WaitSecondsCommand(6,IDM_CMD_CALLQUIT);
            break;
        case IDM_CMD_CALLQUIT:
break_is_done:
            iCleaningUp=0;
            iTimerCount=0;
            iTargetTime=TIMER_TARGET_INACTIVE;
            wEachSecondCmdToPost=wTimedTargetCmdToPost=TIMER_NEVER_POST;
            close_comm_port();
            EnableMenuItem(hMainMenu,IDM_M_CALL,
            MF_ENABLED|MF_BYCOMMAND);
            EnableMenuItem(hMainMenu,IDM_M_SETUP,
            MF_ENABLED|MF_BYCOMMAND);
            EnableMenuItem(hMainMenu,IDM_M_HANGUP,
            MF_GRAYED|MF_BYCOMMAND);
            if(iAutomatic)PostMessage(hWnd,WM_CLOSE,0,0L);
            if(!iAutomatic){
                if(!iThisRunFailed){
                    MessageBox(hWnd,"Time and date\n"
                    "successfully set","Call Complete",
                    MB_ICONINFORMATION);
                }
                else{
                    if(szFailString[0])MessageBox(hWnd,
                    szFailString,"Time Set Aborted",
                    MB_ICONSTOP);
                    else MessageBox(hWnd,"Time and date\n"
                    "not set","Call Complete",MB_ICONSTOP);
                }
            }
            szCommError[0]=0;
            szDisplayString[0]=0;
            UpdateStatusLine();
            break;
        default: return DefWindowProc(hWnd,Message,
        wParam,lParam);
        }
        break;                      /* End of WM_COMMAND */
    case WM_TIMER:
        if(iTimerCount>0){
            if(TIMER_NEVER_POST!=wEachSecondCmdToPost){
            /* each second */
                PostMessage(hWnd,WM_COMMAND,
                wEachSecondCmdToPost,0L);
            }
            iTimerCount--;
            if(iTimerCount==iTargetTime){
                /* timed execution... */
                if(wTimedTargetCmdToPost!=
                TIMER_NEVER_POST){
                    PostMessage(hWnd,WM_COMMAND,
                    wTimedTargetCmdToPost,0L);
                }
                iTargetTime=TIMER_TARGET_INACTIVE;
            }
            UpdateStatusLine();
            if(!iTimerCount)FailCall("Call timed out");
        }
        break;
    case WM_KEYDOWN:
        if((wParam==VK_F1)){
            PostMessage(hWnd,WM_COMMAND,IDM_H_PROCEDURES,
            0);
        }
        else return DefWindowProc(hWnd,Message,
        wParam,lParam);
        break;
    case WM_ENTERIDLE:
        if((wParam==MSGF_MENU)&&
        (GetKeyState(VK_F1)&0x8000)){
            iInHelp=1;
            PostMessage(hWnd,WM_KEYDOWN,VK_RETURN,0L);
        }
        break;
    case WM_CREATE:
        hMainMenu=((CREATESTRUCT *)lParam)->hMenu;
        iReadyToGo=iGetConfigurationInformation();
        if(iAutomatic){
            if(iReadyToGo)PostMessage(hWnd,WM_COMMAND,
            IDM_M_CALL,0L);
            else PostMessage(hWnd,WM_CLOSE,0,0L);
        }
        else SetCallOption();
        EnableMenuItem(hMainMenu,IDM_M_HANGUP,
        MF_GRAYED|MF_BYCOMMAND);
        break;
    case WM_MOVE:
        break;
    case WM_SIZE:
        break;
    case WM_PAINT:
        memset(&ps, 0x00, sizeof(PAINTSTRUCT));
        hDC = BeginPaint(hWnd, &ps);
        SetBkMode(hDC, OPAQUE);
        SetTextColor(hDC,GetSysColor(COLOR_WINDOWTEXT));
        SetBkColor(hDC,GetSysColor(COLOR_WINDOW));
        if(szDisplayString[0]){
            if(iTimerCount&&!iCleaningUp){
                wsprintf(szDisplayString2,"%s: %d "
                "second%s left",
                (LPSTR)szDisplayString,iTimerCount,
                iTimerCount==1?(LPSTR)"":(LPSTR)"s");
            }
            else lstrcpy(szDisplayString2,szDisplayString);
        }
        else{
            if(iTimerCount&&!iCleaningUp){
                wsprintf(szDisplayString2,"%d second"
                "%s left",iTimerCount,iTimerCount==1?
                (LPSTR)"":(LPSTR)"s");
            }
            else lstrcpy(szDisplayString2,iReadyToGo?
            "Ready to call":"Configuration needed");
        }
        TextOut(hDC,0,0,szDisplayString2,
        lstrlen(szDisplayString2));
        if(szCommError[0])TextOut(hDC,0,iRowHeight,
        szCommError,lstrlen(szCommError));
        EndPaint(hWnd, &ps);
        break;
    case WM_CLOSE:
        if(iInCall){
            iAutomatic=1;
            FailCall("User quit");
        }
        else if(!iCleaningUp)DestroyWindow(hWnd);
        break;
    case WM_DESTROY:
        WinHelp(hWnd,szHelpFile,HELP_QUIT,0);
        PostQuitMessage(iAutomatic?iThisRunFailed:0);
        break;
    default:
         return DefWindowProc(hWnd,Message,wParam,lParam);
    }
    return 0L;
}                                   /* End of WndProc */
BOOL FAR PASCAL CONFIGMsgProc(HWND hWndDlg,WORD Message,
WORD wParam,LONG lParam){
    switch(Message){
    case WM_INITDIALOG:
        cwCenter(hWndDlg, 0);
        /* save window handle for help hook */
        hWndSetupDlg=hWndDlg;
        /* Load up the time zone list box */
        iEst=SendDlgItemMessage(hWndDlg,
        IDC_SETUPDLG_TIMEZONE,CB_ADDSTRING,NULL,
        (LONG)(LPSTR)"Eastern Standard Time (New York)");
        iCst=SendDlgItemMessage(hWndDlg,
        IDC_SETUPDLG_TIMEZONE,CB_ADDSTRING,NULL,
        (LONG)(LPSTR)"Central Standard Time (Chicago)");
        iMtn=SendDlgItemMessage(hWndDlg,
        IDC_SETUPDLG_TIMEZONE,CB_ADDSTRING,NULL,
        (LONG)(LPSTR)"Mountain Time (Denver)");
        iPst=SendDlgItemMessage(hWndDlg,
        IDC_SETUPDLG_TIMEZONE,CB_ADDSTRING,NULL,
        (LONG)(LPSTR)"Pacific Standard Time (Seattle)");
        iOther=SendDlgItemMessage(hWndDlg,
        IDC_SETUPDLG_TIMEZONE,CB_ADDSTRING,NULL,
        (LONG)(LPSTR)"User-Specified TimeOffset in "
        "WIN.INI");
        if(iEst==CB_ERRSPACE||iEst==CB_ERR||
        iCst==CB_ERRSPACE||iCst==CB_ERR||
        iMtn==CB_ERRSPACE||iMtn==CB_ERR||
        iPst==CB_ERRSPACE||iPst==CB_ERR||
        iOther==CB_ERRSPACE||iOther==CB_ERR){
             MessageBox(NULL,"Insufficient memory to "
             "create list box",NULL,MB_ICONSTOP);
             EndDialog(hWndDlg, FALSE);
             break;
        }
        /* if no preexisting data do Reset Defaults */
        if(iReadyToGo){                 /* current prefs */
            for(;;){
                WORD i;
                /* set time zone */
                switch(iTimeOffset){
                case TZOFF_EST: i=(WORD)iEst; break;
                case TZOFF_CST: i=(WORD)iCst; break;
                case TZOFF_MTN: i=(WORD)iMtn; break;
                case TZOFF_PST: i=(WORD)iPst; break;
                default:      i=(WORD)iOther; break;
                };
                SendDlgItemMessage(hWndDlg,
                IDC_SETUPDLG_TIMEZONE,CB_SETCURSEL,i,0);
                /* set daylight savings preference */
                SendDlgItemMessage(hWndDlg,
                IDC_SETUPDLG_DAYLIGHT,BM_SETCHECK,
                iUseDaylightSavings?1:0,0);
                /* put in old dial string */
                SetDlgItemText(hWndDlg,
                IDC_SETUPDLG_DIALSTRING,szModemDialString);
                /* set right COM radio button */
                if(iComPort==1){
                    CheckRadioButton(hWndDlg,
                    IDC_SETUPDLG_COM1,
                    IDC_SETUPDLG_COM4,IDC_SETUPDLG_COM1);
                }
                else if(iComPort==2){
                    CheckRadioButton(hWndDlg,
                    IDC_SETUPDLG_COM1,IDC_SETUPDLG_COM4,
                    IDC_SETUPDLG_COM2);
                }
                else if(iComPort==3){
                    CheckRadioButton(hWndDlg,
                    IDC_SETUPDLG_COM1,IDC_SETUPDLG_COM4,
                    IDC_SETUPDLG_COM3);
                }
                else if(iComPort==4){
                    CheckRadioButton(hWndDlg,
                    IDC_SETUPDLG_COM1,IDC_SETUPDLG_COM4,
                    IDC_SETUPDLG_COM4);
                }
                else iReadyToGo=0;
                break;
            }
        }
        if(!iReadyToGo)PostMessage(hWndDlg,WM_COMMAND,
        IDC_SETUPDLG_DEFAULTS,0L);
        break;                  /* end of WM_INITDIALOG */
    case WM_CLOSE:
        PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
        break;
    case WM_COMMAND:
        switch(wParam){
        case IDC_SETUPDLG_HELP:
            {
                int help_topic=0;
                if(lParam==IDC_SETUPDLG_COM1)
                help_topic=HLP_WTIME_SDPORTS;
                else if(lParam==IDC_SETUPDLG_COM2)
                help_topic=HLP_WTIME_SDPORTS;
                else if(lParam==IDC_SETUPDLG_COM3)
                help_topic=HLP_WTIME_SDPORTS;
                else if(lParam==IDC_SETUPDLG_COM4)
                help_topic=HLP_WTIME_SDPORTS;
                else if(lParam==IDC_SETUPDLG_DAYLIGHT)
                help_topic=HLP_WTIME_SDDAYLT;
                else if(lParam==IDC_SETUPDLG_DIALSTRING)
                help_topic=HLP_WTIME_SDDIALSTR;
                else if(lParam==IDC_SETUPDLG_TIMEZONE)
                help_topic=HLP_WTIME_SDTIMZON;
                else if(lParam==IDC_SETUPDLG_DEFAULTS)
                help_topic=HLP_WTIME_SDRESTDEF;
                else if(lParam==IDOK)help_topic=
                HLP_WTIME_SDSAVCNF;
                else if(lParam==IDCANCEL)help_topic=
                HLP_WTIME_SDCANCEL;
                else if(lParam==IDC_SETUPDLG_HELPBUTTON)
                help_topic=HLP_WTIME_SDHELP;
                else MessageBox(hWndDlg,"Couldn't find "
                "help topic","Program Error",MB_ICONSTOP);
                if(help_topic){
                    if(!WinHelp(hWndMain,szHelpFile,
                    HELP_CONTEXT,help_topic)){
                        MessageBox(NULL,"Could not start"
                        " Windows Help\n"
                        "or WTIME.HLP absent",
                        "Windows Error",MB_ICONSTOP);
                    }
                }
                break;
            }
        case IDC_SETUPDLG_DEFAULTS:
            SendDlgItemMessage(hWndDlg,
            IDC_SETUPDLG_TIMEZONE,CB_SETCURSEL,(WORD)iEst,0);
            SendDlgItemMessage(hWndDlg,
            IDC_SETUPDLG_DAYLIGHT,BM_SETCHECK,1,0);
            LoadString(hInst,IDS_MODEM_DIALSTRING,szString,
            sizeof(szString));
            SetDlgItemText(hWndDlg,IDC_SETUPDLG_DIALSTRING,
            szString);
            CheckRadioButton(hWndDlg,IDC_SETUPDLG_COM1,
            IDC_SETUPDLG_COM4,IDC_SETUPDLG_COM1);
            break;
        case IDOK:
            {
                DWORD rv;
                int success=0;
                for(;;){
                    /* get tz offset unless User-Defined */
                    rv=SendDlgItemMessage(hWndDlg,
                    IDC_SETUPDLG_TIMEZONE,
                    CB_GETCURSEL,0,0);
                    if(rv==iEst)iTimeOffset=TZOFF_EST;
                    else if(rv==iCst)iTimeOffset=TZOFF_CST;
                    else if(rv==iMtn)iTimeOffset=TZOFF_MTN;
                    else if(rv==iPst)iTimeOffset=TZOFF_PST;
                    else if(rv!=iOther)break;
                    /* get daylight savings selection */
                    rv=SendDlgItemMessage(hWndDlg,
                    IDC_SETUPDLG_DAYLIGHT,BM_GETCHECK,0,0);
                    iUseDaylightSavings=rv?1:0;
                    /* get modem dial string */
                    if(!GetDlgItemText(hWndDlg,
                    IDC_SETUPDLG_DIALSTRING,
                    szModemDialString,
                    sizeof(szModemDialString)))break;
                    /* get com port selection */
                    if(SendDlgItemMessage(hWndDlg,
                    IDC_SETUPDLG_COM1,BM_GETCHECK,0,0))
                    iComPort=1;
                    else if(SendDlgItemMessage(hWndDlg,
                    IDC_SETUPDLG_COM2,BM_GETCHECK,0,0))
                    iComPort=2;
                    else if(SendDlgItemMessage(hWndDlg,
                    IDC_SETUPDLG_COM3,BM_GETCHECK,0,0))
                    iComPort=3;
                    else if(SendDlgItemMessage(hWndDlg,
                    IDC_SETUPDLG_COM4,BM_GETCHECK,0,0))
                    iComPort=4;
                    else break;
                    /* now save it all */
                    success=iSetConfigurationInformation();
                    break;
                }
                if(!success){
                    MessageBox(hWndDlg,
                    "Could not save "
                    "configuration information",
                    "Configuration Error",MB_ICONSTOP);
                }
                UpdateStatusLineText("");
                EndDialog(hWndDlg,FALSE);
                break;
            }
        case IDCANCEL:
            EndDialog(hWndDlg, FALSE);
            break;
        case IDC_SETUPDLG_HELPBUTTON:
            if(!WinHelp(hWndMain,szHelpFile,HELP_CONTEXT,
            HLP_WTIME_SDHELP)){
                MessageBox(NULL,
                "Couldn't start Windows Help\n"
                "or WTIME.HLP absent",
                "Windows Error",MB_ICONSTOP);
            }
            break;
        }
        break;              /* End of WM_COMMAND */
    default:
        return FALSE;
    }
    return TRUE;
}                           /* End of CONFIGMsgProc */
BOOL FAR PASCAL ABOUTMsgProc(HWND hWndDlg,WORD Message,
WORD wParam,LONG lParam){
    switch(Message){
    case WM_INITDIALOG:
        cwCenter(hWndDlg, 0);
        break;
    case WM_CLOSE:
        PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
        break;
    case WM_COMMAND:
        EndDialog(hWndDlg,FALSE);
        break;
    default:
        return FALSE;
    }
    return TRUE;
}                           /* End of ABOUTMsgProc */
int nCwRegisterClasses(void){
    WNDCLASS wndclass;
    memset(&wndclass,0x00,sizeof(WNDCLASS));
    wndclass.style=CS_HREDRAW|CS_VREDRAW|
    CS_BYTEALIGNWINDOW;
    wndclass.lpfnWndProc=WndProc;
    wndclass.cbClsExtra=0;
    wndclass.cbWndExtra=0;
    wndclass.hInstance=hInst;
    wndclass.hIcon=LoadIcon(hInst,"WTimeIcon");
    wndclass.hCursor=LoadCursor(NULL,IDC_ARROW);
    wndclass.hbrBackground =(HBRUSH)(COLOR_WINDOW+1);
    wndclass.lpszMenuName=szAppName;
    wndclass.lpszClassName=szAppName;
    if(!RegisterClass(&wndclass))return -1;
    return(0);
}                       /* End of nCwRegisterClasses() */
void cwCenter(HWND hWnd,int top){
    POINT pt;
    RECT swp,rParent;
    int iwidth,iheight;
    GetWindowRect(hWnd,&swp);
    GetClientRect(hWndMain,&rParent);
    iwidth=swp.right-swp.left;
    iheight=swp.bottom-swp.top;
    pt.x=(rParent.right-rParent.left)/2;
    pt.y=(rParent.bottom-rParent.top)/2;
    ClientToScreen(hWndMain,&pt);
    pt.x=pt.x-(iwidth/2);
    pt.y=pt.y-(iheight/2);
    if(top)pt.y=pt.y+top;
    if(pt.y<0)pt.y=0;
    if(pt.x<0)pt.x=0;
    MoveWindow(hWnd,pt.x,pt.y,iwidth,iheight,FALSE);
}
void CwUnRegisterClasses(void){
    WNDCLASS wndclass;
    memset(&wndclass,0x00,sizeof(WNDCLASS));
    UnregisterClass(szAppName,hInst);
}

void SetCallOption(void){
/*
**  this function grays or ungrays the Menu|Call option
**  depending on if iReadyToGo is nonzero
*/
    if(iReadyToGo)EnableMenuItem(hMainMenu,IDM_M_CALL,
                                 MF_ENABLED|MF_BYCOMMAND);
    else EnableMenuItem(hMainMenu,IDM_M_CALL,
                        MF_GRAYED|MF_BYCOMMAND);
}
int iGetConfigurationInformation(void){
/*
**  this function gets the setup stuff from the .INI file
**  writes to szModemDialString,iTimeOffset,
**  iUseDaylightSavings,iComPort
**  returns 0 for fail, 1 for success
*/
    if(2>GetProfileString(szAppName,"ModemDialString","",
    szModemDialString,sizeof(szModemDialString))){
        return 0;
    }
    iTimeOffset=MyGetProfileInt(szAppName,"TimeOffset",
    9999);
    if(iTimeOffset<-1439||iTimeOffset>1439)return 0;
    iUseDaylightSavings=MyGetProfileInt(szAppName,
    "UseDaylightSavings",-1);
    if(iUseDaylightSavings<0||iUseDaylightSavings>1)
    return 0;
    iComPort=MyGetProfileInt(szAppName,"ComPort",-1);
    if(iComPort<1||iComPort>4)return 0;
    return 1;
}
int iSetConfigurationInformation(void){
/*
**  writes the stuff to the .INI file
**  writes to ModemDialString, TimeOffset,
**  UseDaylightSavings, ComPort
**  returns 0 for fail, 1 for success
*/
    if(!WriteProfileString(szAppName,"ModemDialString",
    szModemDialString))return 0;
    wsprintf(szString,"%d",iTimeOffset);
    if(!WriteProfileString(szAppName,"TimeOffset",
    szString))return 0;
    wsprintf(szString,"%d",iUseDaylightSavings);
    if(!WriteProfileString(szAppName,"UseDaylightSavings",
    szString))return 0;
    wsprintf(szString,"%d",iComPort);
    if(!WriteProfileString(szAppName,"ComPort",szString)){
        return 0;
    }
    return 1;
}
DWORD FAR PASCAL SetupDlgMsgHook(int nCode,WORD wParam,
LPMSG lpMsg){
    DWORD retval=0L;
    int did_it=0;
    if(nCode==MSGF_DIALOGBOX){
        if(lpMsg->message==WM_KEYDOWN){
            if(lpMsg->wParam==VK_F1){
                if(!(lpMsg->lParam&0x40000000L)){
                    did_it=1;
                    PostMessage(hWndSetupDlg,WM_COMMAND,
                    IDC_SETUPDLG_HELP,
                    (long)GetDlgCtrlID(lpMsg->hwnd));
                    retval=1L;
                }
            }
        }
    }
    if((nCode<0)||(!did_it&&oldfilter))retval=
    DefHookProc(nCode,wParam,(LONG)lpMsg,&oldfilter);
    return(retval);
}
void UpdateStatusLine(void){
    if(!IsIconic(hWndMain)){
        InvalidateRect(hWndMain,NULL,TRUE);
        UpdateWindow(hWndMain);
    }
}
void UpdateStatusLineText(LPSTR string){
    lstrcpy(szDisplayString,string);
    UpdateStatusLine();
}
LPSTR init_comm_port(void){
    /*
    **  Sets up the COM port for access.
    **  Returns LPSTR to fail description,
    **  or NULL if success
    **  Uses the global variable DCB dcb.
    **  Also sets iGotComPort if success.
    */
    int rv;
    wsprintf(szString,"COM%d",iComPort);
    rv=OpenComm(szString,2048,2048);    /* tx rx buffs */
    dcb.Id=(BYTE)rv;
    if(rv<0){
        LPSTR p;
        switch(rv){
        case IE_BADID:
            p="Invalid or unsupported ID";
            break;
        case IE_BAUDRATE:
            p="Unsupported baud rate";
            break;
        case IE_BYTESIZE:
            p="Invalid byte size";
            break;
        case IE_DEFAULT:
            p="Error in default parameters";
            break;
        case IE_HARDWARE:
            p="Hardware not present";
            break;
        case IE_MEMORY:
            p="Unable to allocate queues";
            break;
        case IE_NOPEN:
            p="Device not open";
            break;
        case IE_OPEN:
            p="Device already open";
            break;
        default:
            p="Unknown communication error";
            break;
        }
        return p;
    }
    else iGotComPort=1;
    dcb.BaudRate=1200;
    dcb.ByteSize=8;
    dcb.Parity=NOPARITY;
    dcb.StopBits=ONESTOPBIT;
    dcb.RlsTimeout=0;
    dcb.CtsTimeout=0;
    dcb.DsrTimeout=0;
    dcb.fBinary=1;
    dcb.fRtsDisable=0;
    dcb.fParity=0;
    dcb.fOutxCtsFlow=0;
    dcb.fOutxDsrFlow=0;
    dcb.fDummy=0;
    dcb.fDtrDisable=0;
    dcb.fOutX=0;
    dcb.fInX=0;
    dcb.fPeChar=0;
    dcb.fNull=1;
    dcb.fChEvt=1;
    dcb.fDtrflow=0;
    dcb.fRtsflow=0;
    dcb.fDummy2=0;
    dcb.XonChar=0;
    dcb.XoffChar=0;
    dcb.XonLim=10;
    dcb.XoffLim=10;
    dcb.PeChar=0;
    dcb.EofChar=0;
    dcb.EvtChar='>'; /* end of line, start of data */
    dcb.TxDelay=0;
    if(SetCommState(&dcb))return "SetCommState() fail";
    GetCommEventMask(dcb.Id,EV_ERR|EV_RXCHAR|EV_RXFLAG|
    EV_TXEMPTY);
    GetDisplayCommError(dcb.Id,NULL);
    FlushComm(dcb.Id,0);    /* stop transmitting */
    FlushComm(dcb.Id,1);     /* stop receiving */
    return NULL;
}
void close_comm_port(void){
    /*
    **  Releases the COM port allocated into dcb.
    **  Does nothing unless iGotComPort is nonzero.
    */
    if(!iGotComPort)return;
    EscapeCommFunction(dcb.Id,RESETDEV);
    FlushComm(dcb.Id,0);/* stop transmitting */
    CloseComm(dcb.Id);  /* release port, buffers */
    iGotComPort=0;
}
void FailCall(LPSTR failure){
    /*
    **  Turns off iInCall, displays a message box with
    **  failure string (if not iAutomatic), and posts
    **  IDM_CMD_CALLDONE command to hWndMain
    */
    if(!iInCall)return;
    iInCall=0;
    iTimerCount=0;
    iCleaningUp=1;
    UpdateStatusLineText(failure);
    iThisRunFailed=1;
    if(failure&&failure[0])lstrcpy(szFailString,failure);
    PostMessage(hWndMain,WM_COMMAND,IDM_CMD_CALLDONE,0L);
}
void WaitSecondsCommand(int seconds,WORD command){
    iTargetTime=iTimerCount-(1+seconds);
    if(iTimerCount<1)iTimerCount=10;
    if(iTargetTime<1)iTargetTime=1;
    if(iTargetTime>=iTimerCount)iTargetTime=iTimerCount-1;
    wTimedTargetCmdToPost=command;
}
WORD MyGetProfileInt(LPSTR lpAppName,LPSTR lpKeyName,
int nDefault){
    /*
    **  This is simply an implementation of
    **  GetProfileInt(), necessary because OS/2 2.0's
    ** Windows box version of GetProfileInt() chokes
    **  on negative numbers.
    */
    char nearbuffer[20];/* big enough to hold my ints */
    char *nearptr=nearbuffer;
    int got_int=0,got_negative=0,this_character,retval=0;
    if(1>GetProfileString(lpAppName,lpKeyName,"",
    nearbuffer,sizeof(nearbuffer)))return (WORD)nDefault;
    /* ensure null termination */
    nearbuffer[sizeof(nearbuffer)-1]=0;
    while(this_character=(int)*nearptr++){
        if(isspace(this_character)&&!got_int)continue;
        if(this_character=='-'&&!got_int&&!got_negative){
            got_negative=1;
            continue;
        }
        if(isdigit(this_character)){
            got_int=1;
            retval*=10;
            retval+=this_character-'0';
            continue;
        }
        if(got_int)break;
        return (WORD)nDefault;
    }
    if(got_int){
        if(got_negative)retval*=-1;
        return (WORD)retval;
    }
    return nDefault;
}
int GetDisplayCommError(int nCid,COMSTAT FAR *lpStat){
    /*
    **  wrapper for GetCommError()
    **  same function as GetCommError() but displays
    **  found errors on second line of text window
    */
    char local_buffer[9];
    int temp,retval=GetCommError(nCid,lpStat);
    if(retval){
        temp=retval;
        wsprintf(szCommError,"Comm Error %04X",retval);
        if(temp&CE_BREAK){
            lstrcat(szCommError,", break");
            temp&=~CE_BREAK;
        }
        if(temp&CE_CTSTO){
            lstrcat(szCommError,", CTS timeout");
            temp&=~CE_CTSTO;
        }
        if(temp&CE_DSRTO){
            lstrcat(szCommError,", DSR timeout");
            temp&=~CE_DSRTO;
        }
        if(temp&CE_FRAME){
            lstrcat(szCommError,", framing error");
            temp&=~CE_FRAME;
        }
        if(temp&CE_MODE){
            lstrcat(szCommError,", bad device or mode");
            temp&=~CE_MODE;
        }
        if(temp&CE_OVERRUN){
            lstrcat(szCommError,", read overrun");
            temp&=~CE_OVERRUN;
        }
        if(temp&CE_RLSDTO){
            lstrcat(szCommError,
            ", RX line signal detect timeout");
            temp&=~CE_RLSDTO;
        }
        if(temp&CE_RXOVER){
            lstrcat(szCommError,", RX queue overflow");
            temp&=~CE_RXOVER;
        }
        if(temp&CE_RXPARITY){
            lstrcat(szCommError,", RX parity error");
            temp&=~CE_RXPARITY;
        }
        if(temp&CE_TXFULL){
            lstrcat(szCommError,", TX buffer full");
            temp&=~CE_TXFULL;
        }
        if(temp){
            if(temp==retval){
                lstrcat(szCommError,", unknown error!");
            }
            else{
                lstrcat(szCommError," -- leftover: ");
                wsprintf(local_buffer,"%04X",temp);
                lstrcat(szCommError,local_buffer);
            }
        }
        if(szCommError[15])szCommError[15]=':';
        szCommError[17]=
        (char)toupper((int)szCommError[17]);
    }
    return retval;
}
#ifdef __TURBOC__
/*
**  Turbo C's localtime(), contrary to the documentation,
**  calls tzset() before doing its own work. This will
**  obviously overwrite any data you've put into daylight
**  or timezone. This null function makes the behavior
**  unimportant -- unless you need tzset() for some
**  other reason in your program!
*/
void tzset(void){}
#endif
