#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include <bios.h>

#define MAX_SIZE

typedef unsigned char BYTE;
typedef unsigned short int WORD;
typedef BYTE BOOL;
#define bYES    ((BOOL)1)
#define bNO     ((BOOL)0)
#define bNOT(b) ((BYTE)1-(b))

#define keyASCII(key)           (((WORD)key) % 256)
#define keySCANCODE(key)        (((WORD)key) / 256)
#define keyUP           72
#define keyLEFT         75
#define keyRIGHT        77
#define keyDOWN         80
#define keyR            19
#define keyW            17
#define keyF            33
#define keyT            20
#define keyS            31
#define keySHIFT        3

BYTE far *Video = (BYTE far *)0xA0000000L;

int     width,height;
BYTE    map[65535];
BYTE    kind[65535];
#define kROAD   0       /* BLACK */
#define kWATER  1       /* BLUE  */
#define kGRASS  2       /* GREEN */
#define kFRONT  4       /* RED   */
#define kTOP    3       /* CYAN  */
#define kSIDEWALK 7     /* GRAY  */
#define HILIGHT 8

#define mU      1
#define mD      2
#define mL      4
#define mR      8
#define mUL     16
#define mUR     32
#define mDR     64
#define mDL     128

#define DO_IF(pm,ps,k,bit) \
        *((ps)++) = !((*(pm)) & (BYTE)(bit)) ? (BYTE)(k | HILIGHT) : (BYTE)k;

void DrawTile(int x,int y)
        {
        BYTE far *pscreen;
        BYTE far *pmap;
        BYTE    k;

        pscreen = &Video[(320 * (4*y)) + 4*x];
        pmap = &map[width * y + x];
        k = kind[width * y + x];
        DO_IF(pmap,pscreen,k,mUL);
        DO_IF(pmap,pscreen,k,mU);
        DO_IF(pmap,pscreen,k,mU);
        DO_IF(pmap,pscreen,k,mUR);
        pscreen += (320 - 4);
        DO_IF(pmap,pscreen,k,mL);
        *pscreen++ = (BYTE)k;
        *pscreen++ = (BYTE)k;
        DO_IF(pmap,pscreen,k,mR);
        pscreen += (320 - 4);
        DO_IF(pmap,pscreen,k,mL);
        *pscreen++ = (BYTE)k;
        *pscreen++ = (BYTE)k;
        DO_IF(pmap,pscreen,k,mR);
        pscreen += (320 - 4);
        DO_IF(pmap,pscreen,k,mDL);
        DO_IF(pmap,pscreen,k,mD);
        DO_IF(pmap,pscreen,k,mD);
        DO_IF(pmap,pscreen,k,mDR);
        }

void DrawCursor(int x,int y,BOOL bOn)
        {
        BYTE far *pscreen;
        BYTE far *pmap;
        BYTE    k;

        pscreen = &Video[(320 * (4*y)) + 4*x];
        pmap = &map[width * y + x];
        k = kind[width * y + x];
        pscreen += 320 + 1;
        *(pscreen) = bOn ? (BYTE)15 : k;
        *(pscreen+1) = bOn ? (BYTE)15 : k;
        *(pscreen+320) = bOn ? (BYTE)15 : k;
        *(pscreen+320+1) = bOn ? (BYTE)15 : k;
        }

void DrawScreen()
        {
        int     x,y;
        for (x = 0; x < width; x++) {
                for (y = 0; y < height; y++) {
                        DrawTile(x,y);
                        }
                }
        }

void doit()
        {
        int     cx=0,cy=0;
        int     k;
        BOOL    bCursor=bYES;
        BYTE    key=0;
        WORD    shift;

        DrawScreen();
        while (key != (BYTE)1) {
                while (!_bios_keybrd(_KEYBRD_READY)) {
                        DrawCursor(cx,cy,bCursor);
                        bCursor = bNOT(bCursor);
                        }
                key = keySCANCODE(_bios_keybrd(_KEYBRD_READ));
                shift = _bios_keybrd(_KEYBRD_SHIFTSTATUS);
                if (shift & keySHIFT) {
                        switch (key) {
                            case keyUP:
                                if (cy==0) break;
                                map[cy * width + cx] ^= mU;
                                map[(cy-1) * width + cx] ^= mD;
                                DrawTile(cx,cy);
                                break;
                            case keyDOWN:
                                if (cy==(height-1)) break;
                                map[cy * width + cx] ^= mD;
                                map[(cy+1) * width + cx] ^= mU;
                                DrawTile(cx,cy);
                                break;
                            case keyLEFT:
                                if (cx==0) break;
                                map[cy * width + cx] ^= mL;
                                map[cy * width + (cx-1)] ^= mR;
                                DrawTile(cx,cy);
                                break;
                            case keyRIGHT:
                                if (cx==(width-1)) break;
                                map[cy * width + cx] ^= mR;
                                map[cy * width + (cx+1)] ^= mL;
                                DrawTile(cx,cy);
                                break;
                                }
                        }
                switch (key) {
                    case keyR:
                        kind[width * cy + cx] = kROAD;
                        DrawTile(cx,cy);
                        break;
                    case keyW:
                        kind[width * cy + cx] = kWATER;
                        DrawTile(cx,cy);
                        break;
                    case keyF:
                        kind[width * cy + cx] = kFRONT;
                        DrawTile(cx,cy);
                        break;
                    case keyT:
                        kind[width * cy + cx] = kTOP;
                        DrawTile(cx,cy);
                        break;
                    case keyS:
                        kind[width * cy + cx] = kSIDEWALK;
                        DrawTile(cx,cy);
                        break;
                    case keyUP:
                        if (cy==0) break;
                        DrawCursor(cx,cy,bNO);
                        cy--;
                        DrawTile(cx,cy);
                        DrawCursor(cx,cy,bYES);
                        break;
                    case keyDOWN:
                        if (cy==(height-1)) break;
                        DrawCursor(cx,cy,bNO);
                        cy++;
                        DrawTile(cx,cy);
                        DrawCursor(cx,cy,bYES);
                        break;
                    case keyLEFT:
                        if (cx==0) break;
                        DrawCursor(cx,cy,bNO);
                        cx--;
                        DrawTile(cx,cy);
                        DrawCursor(cx,cy,bYES);
                        break;
                    case keyRIGHT:
                        if (cx==(width-1)) break;
                        DrawCursor(cx,cy,bNO);
                        cx++;
                        DrawTile(cx,cy);
                        DrawCursor(cx,cy,bYES);
                        break;
                        }
                }
        }

int main(int argc, char *argv[])
        {
        width = 40;
        height = 15;

        argc;
        argv;

        _asm    {
                mov     ax,13h
                int     10h
                }

        memset(kind,kWATER,width*height);
        doit();

        _asm    {
                mov     ax,03h
                int     10h
                }

        return 0;
        }
