
 ==========================
 == THE ELECTRONIC GAMER ==
 ==========================

 ULTIMA VII PART II: SERPENT ISLE

 The following is a very detailed walkthru of Origin's ULTIMA VII PART II:
SERPENT ISLE. It's based on the three games I played myself, and on
the comments and suggestions of a great many members of the Gamers' Forum.
For players who want to find just the portion of the game they're having 
trouble with, I've included headers identifying the game's major locations 
and puzzles.

 A word about flags: Serpent Isle appears to be a non-linear game, but in fact 
it has a strongly linear story line. This narrative structure is supported by 
a series of software flags that must be set by the player's actions before 
another action may be taken. For example, a player must often talk to NPC
"A" before NPC "B" will display a keyword that will produce the information
or the item the player is seeking. In other instances, a door in one location
will remain locked until the player performs an action in another location.

 It's sometimes possible to do things out of order by brute force (blowing up
locked doors with powder kegs, f'rinstance). While you may not get into 
trouble doing this, you may also thoroughly screw up the game's flags and
cause yourself a restart. Other than following the walkthru slavishly,
there are two ways to minimize potential flag problems: first, save your game
fairly often; and second, talk to everybody, read everything that's readable,
make notes, and don't enter any of the game's major locations unless you have 
a pretty good idea of why you're going there.

 A word about magic scrolls: It's possible to cast a spell from a scroll you
find during the game. But I suggest you save any scrolls you find before
you get a new spellbook and then transcribe them into the book. That way,
you won't have to buy these spells from the game's mages, who charge fairly
steep prices for their wares.

 INTRODUCTION

 Eighteen months after you foiled the Guardian's plot to enter the Black Gate, 
Lord British has discovered a magic scroll from the Guardian to his henchman, 
Batlin. In it, he commands Batlin to follow Gwenno to the Serpent Isle, where 
he will reveal his new plot to destroy Britannia.  Lord British sends you and 
your companions, Iolo, Dupre and Shamino, to the Serpent Isle to find Batlin 
and stop the Guardian. Finding Gwenno is also a high priority.

 After a turbulent trip in which you seemed to be flying rather than sailing,
you arrive on the shores of Serpent Isle. As soon as you leave the ship,
you are hit by an eerie lightning storm that exchanges your most important
possessions for various odd objects, and causes your companions to disappear.

 Walk south and you'll meet Thoxa, a monk, who administers a copy-protection 
test and then hails you as a long-awaited hero from another world. She gives 
you the hourglass of fate, which enables you and your companions to be 
resurrected by the monks if you're killed. She tells you more about your 
quest, and points you to a cave (with an invisible entrance) to the south, 
near a red bush. Follow the coast to Monitor, she says, where an old friend 
(Iolo) awaits you.

 Among other things, she tells you to seek your three companions, because they
must all be at your side to fulfill the visions of Xenka, the monks' vanished 
prophetess. You must also seek out three artifacts -- a ring, a necklace,
and an earring -- that will allow an ancient Power to communicate with you.
As Thoxa is explaining things, another monk, Karnax, appears and warns her not 
to interfere in your quest. They have a magic duel, and both vanish, leaving 
you with a great many unanswered questions.

 Continue walking south, and you'll meet Shamino. He tells you his possessions
have also been exchanged for strange items, and he begins making a list to
compare against the list of items Lord British gave you to aid in your quest.

 Follow the shoreline south until you find the red bush. The invisible cave
entrance is to its right (click on it and it reads "illusion"). Inside,
you'll find a bedroll, a bag with lockpicks and torches, and a chest. Open
the chest with the lockpicks, or by bashing it with Shamino's hammer. There
are more useful items inside, including a sextant.

 There's another illusionary wall on the north side of the cave. Go through
it, and you'll find the skeleton of Drogeni (beloved of the Mad Mage Erstam).
She has some serpent scales (a reagent), and a scroll. The scroll is
Erstam's translation of an ancient Ophidian manuscript (the Ophidians, you'll
learn, were the people who lived on Serpent Isle before the current human
population emigrated from Sosaria, which has since become Britannia). The
scroll tells you about the Ophidians and their beliefs, which you'll need to
become very familiar with as the game progresses. Its original author was
Ssithnos, the last Chaos Hierophant, whom you'll meet (sort of) much later.
In Drogeni's chest, you'll find gold, some boots, a sword, and a buckler.

 Before you leave the cave, practice drawing water out of the well. You don't 
need the water, but you'll need to know how to use a bucket later on.

 Outside the cave, Shamino finds his magic bow, and deduces that the lightning
storm has exchanged it for the bear's skull in his inventory. He explains
that if you find out where the other strange items came from, you'll find 
your other missing possessions.

 Continue south and east along the coast, and you'll come to Monitor's west
gate. Talk to Flicken, the guard captain there. He'll tell you that there
have been some strangers in town recently (Batlin and his gang); that there's 
a strange enchanter (Iolo) in the town jail; and that you should speak to the 
town's leader, Marsten, about him. 

 Note: whenever an NPC says or infers that you should speak to another NPC 
about something, do it. The second NPC undoubtedly has information or an
item you'll need.

 Flicken will tell you that Marsten is at the crematorium, attending a funeral
for some pikemen who have been killed by goblins. The goblins have stolen
the Helm of Monitor (also called the Helm of Courage, and an item you'll need
to recover for use in a later quest). Ask Flicken to open the gate, and go
looking for Marsten.

 IN MONITOR

 Go north to the crematorium. Talk to Renfry, the proprietor, who'll tell you 
that Marsten, Spektor, Brendann and Caladin are in the crypts. Go through
the green curtains in the SW corner to enter the crypts. Go south, west,
south and east to find the four lords. 

 Note: There's a door you can't reach yet to the SE. Remember it.

 Talk to the four lords:

 Caladin (knight in red and yellow) will tell you that his grandfather's urn
was stolen (swapped for Iolo's crossbow by the storm). Only the Champion 
Knight of Monitor may wear the Helm of Courage (Helm of Monitor), but the 
goblins now have it. Someone (guess who) needs to recover the helm and 
avenge Astrid, the late Champion Knight. He's the leader of the Bear Command, 
and he trains (in strength) at the List Field at noon. The Fawn tower was 
taken by goblins recently. He suspects that a traitor -- a knight -- gave 
critical information to the gobbies. He suspects Krayg, the provisioner. 
He tells you about the other commands (Wolves and Leopards), and suggests 
you ask Marsten's permission to take the Test of Knighthood (many people in 
Monitor won't talk to you unless you're a Knight). He gives you three clues 
about the test, and directs you to Cantra and Shmed (the test's administrator) 
for more information. Cantra is the daughter of Harnna, the town's healer; 
her father has turned up missing recently.

 Brendann (in green) is the leader of the Wolves command. He has little more
to add to what Caladin has already told you. Talk to him anyway.

 Spektor (in gray) is the town's administrator and money exchanger. Ask him
about Iolo, and he'll refer you to Marsten.

 Marsten says the goblins took Astrid's body to their secret camp somewhere in 
the woods. He tells you about the residents of Serpent Isle and how they fled 
the tyrant Lord British under Erstam's leadership (say nothing about Lord 
British; he's viewed as a major baddie by everyone on Serpent Isle, and you'll 
get into serious trouble if you say you're his ally). He tells you about the 
island's three cities, saying that the mages on Moonshade have given up the 
virtue of Truth; that the people of Fawn have dismissed Love for Beauty; and 
that the people of Monitor hold Courage to be the only important virtue. He
suggests that you talk to Krayg about the serpent ruins; that you ask Templar,
another knight, about the goblins; and that you visit Iolo in jail. Ask
his permission to take the Test of Knighthood; he'll agree, and will give you
the password to say to Shmed when you go to the testing area. 

 Note: Your avatar will speak all passwords automatically at the right moment, 
but only if you've talked to and gotten the information from an NPC. Even if 
you know the correct words, you can't use them without having had the correct 
conversations.

 When you've finished talking, Caladin suggests that you're a spy, and Brendann
mentions the other suspicious strangers that have visited Monitor lately -- a 
fat sage (Batlin) and a woman scholar (Gwenno).

 At this point, Dupre arrives, and adds to your list of swapped items.

 Go back to the crypt entrance. Go west and north, and you'll pass a serpent 
gate (a carving of a serpent's head on the floor). It will serve as a
teleporter once you've gained the tools to operate it. In this part of the
crypts, you'll find Iolo's crossbow on a pedestal next to Caladin the Elder's
tomb. You can take the bow now.

 There's nothing else of importance in the crypts. There's a blocked passage
that you can't clear, but there's nothing on the other side.

 Go back into the crematorium and talk to Renfry again. Answer "No" when he 
asks if you're a stranger. He tells you about the cremator, and how to
operate it (you'll need to know this later). He also says that a person's 
ashes, as distilled by the cremator's mystical processes, represent the 
essence of the person's life, and have a power greater than mere magic. (This 
will be an important clue very late in the game.)  On a more mundane note, 
he'll pay you 100 monetari (the local currency) for each dead pikeman's body 
you return to Monitor and cremate (you have to do it yourself). He has some 
additional clues for you, as well: Andral the sculptor has suffered a recent 
theft; ask Andral about the strange sage (Batlin) who was in town. In the 
Knight's Test, if you mix the ashes of the slain goblin leader Gurnordir with 
your blood, your totem animal will appear, signifying that you've been deemed
acceptable for membership in the command that bears the animal's name. And
finally, he'll tell you (incorrectly) that the serpent gate was made by
the Daemons (gargoyles, actually) who still live in a dungeon called Furnace. 

 At this point, you now have six quests: find Batlin; find Gwenno; free Iolo;
find your missing items; find the traitors who have betrayed Monitor to the
goblins; and find the Helm of Monitor (Courage).

 Go to the jail (in the NE section of town) and talk to Iolo. He hasn't much 
to say at this point, except to tell you to talk to Marsten.

 On the way (or later) you can check out various houses and shops. It's OK
with the game's ethical system to steal whatever you find lying around. In
some cases, you'll have to steal to get keys and other essential items. But
be sure nobody is watching when you lift something. They tend to get rather
nasty about it, and you may have to kill someone you'll need later. By the
way, you can't steal from Standarr's armory at this point in the game --
there's always a pikeman or two on duty there.

 Talk to Krayg the provisioner. He says Monitor was built on Ophidian ruins, 
and that the sign of the serpent can be seen all over the island. He'll also 
tell you that he takes long walks in the woods.

 Talk to Andral the sculptor (don't commission a work of art). He tells you
about the robbery. You'll learn more about Batlin and his companions, 
including the fact that Batlin was very interested in serpent ruins, and 
that the stolen article was a blackrock serpent, facing opposite the one
the lightning storm zapped away from you. Simon, the innkeeper, said that 
Batlin came to Monitor from Fawn (a place you'll need to visit soon). Andral 
suggests you talk to Simon about Batlin's cloaked companion (a gargoyle), and 
to Standarr (the armorer) about Brunt, Batlin's warrior companion. He tells 
you that Wilfred (a knight you'll meet later) has been tracking Batlin ever 
since he visited the Sleeping Bull Inn (another place you'll want to visit).

 Talk to Simon at the inn. (The Inn's register shows visits by Gwenno, Batlin,
and Draygan, whom you'll meet later). Simon tells you a pack of lies about 
his history. He suspects that Krayg is the traitor. Batlin was fascinated 
by the serpent gate in the crypts, and went from Monitor NE to the Sleeping 
Bull. Gwenno went east to Monk Isle. He suggests you talk to Shazzana (a 
trainer) about Batlin's sailor companion, Deadeye, and to Spektor about 
Gwenno. Most important of all, he mentions his taste for Fawn ale, and offers 
you a drink. Accept, and note the distinctive brown color of the ale bottle.
Remember that he's the only one outside Fawn who drinks it.

 Ask Standarr about Brunt, and you'll learn only that he was unusually strong.

 Talk to Marsten again -- you'll probably find him at the city hall, where he,
Spektor, Caladin and Brendann meet each day at noon to discuss town business.
Ask him about the enchanter (Iolo) and tell him he's your friend, who's not
a sorcerer but was zapped by the lightning. He says that if you become a 
knight, he'd accept your word and let Iolo go.

 Talk to Cantra, whom you'll meet on the street somewhere. She says that her 
father found something suspicious, and then disappeared. She says Caladin and 
Shazzana are the best trainers. And she gives you some clues about the 
Knight's Test -- move swiftly at first to avoid the explosions; look up as 
well as side to side, and be prepared to climb; timing is essential to outrun 
the fireballs; search with your hands as well as your eyes, since some things 
are invisible; watch for the last chamber, which is kept secret.

 At the training hall, talk to Shazzana about the mysterious sailor, Deadeye.

 Talk to Luther, but don't insult him yet (he has Dupre's shield, but you won't
be able to get it from him until you've talked to a few more people). He's
a braggart and a bully, and your companions will throw a fit if you ask him
to join your party. Ask him about Lucilla (the barmaid) and he'll tell you
that she's very impressed with him. Later, Lucilla will tell another story.

 Talk to Spektor again. He says Gwenno left for Monk Isle, and suggests you 
hire a ship in Fawn or at the Sleeping Bull. He also says you can get Iolo 
out of jail by paying him a fine of 30 monetari. Pay it and he'll give you a 
gold key that fits Iolo's cell (and nothing else in the game). You can also 
get Iolo out of jail free by asking Marsten after you pass the knight's test.

 Talk to Harnna, the town healer (her house and field are south of the western
gate -- if she's not in the house, look in the field). Harnna is the town's
best-informed person. She can tell you quite a bit about people, places and
your strange objects, but she'll only go about three rounds before she'll
claim to be too busy to talk. Come back as many times as it takes to get her
input on your objects. She'll have a lot of "go sees" for you, and you MUST
talk to Harnna first before the keywords will appear in the others' lists.
Ask her about Cantra; she'll mention Cantra's wooden sword, which is an 
important item later in the game. She also sells garlic and ginseng along 
with other food items.

 Note: Templar, Cellia, Lydia (the tattoo artist) and Lucilla won't talk to you
before you become a knight.

 Optionally, you can visit the town tavern before becoming a knight. Lucilla
will sell you food and drink, and you may find other NPCs there around meal
times and in the evening. You can also train at List Field before you're a
knight. The trainers are there between 9AM and 6PM. Talk to the pikeman at
the desk to arrange for training.

 Note: You can sleep anywhere your bedroll will fit in this game. When
you're awakened, check your companions' weapons. They'll put them away when
they sleep, and will sometimes draw ones you don't want them to use the next 
time you're attacked.

 THE TEST OF KNIGHTHOOD

 Now is a good time to take the Test of Knighthood. Exit Monitor by the north
gate and follow the road north. There's an interesting lightning-strike spot
near the Monitor tower. Mostly, the lightning brings garbage, but sometimes
it gives you goodies like magic boots or weapons. Go north to the first
signpost, and then west to Shmed's office.

 Talk to Shmed, and say you want to take the test. He'll put your possessions 
in a chest in his office, and will lead you to the testing area dressed only 
in leather armor and armed with a mace.

 Inside the test, disregard the door to your left. It's the way out, and can
only be opened from the other side. Go north, turn right, and move quickly to
the first intersection (there'll be explosions behind you). Go south into
the first room. Kill the gremlins and smash the chest open with your mace.
Take the key and use it to open the door down the hallway to your right.

 You'll come to an intersection with three doors. The north door is open, but
the other two are locked. Drop the gold key (it'll stay where you put it)
and go north into a room with an obelisk and many stones. There's a key on
top of the obelisk that you can reach by building a "stairway" with the
stones in the room. Be careful -- there are snakes under some of the rocks.

 The brown key from the obelisk opens the south door. Drop the key and enter
the room. You'll have to fight a Cyclops and dodge a roomful of fireball
traps to reach a key in the SW corner. Walk diagonally from NE to SW and 
you'll avoid setting off at least some of the traps.

 The brown key from the fireball room opens the east door. Drop the key with
the two others and go east into the long N/S hallway. Go north and you'll
find a bag with a cure-poison and a healing potion. Put the bag on your belt.
The north door is locked and trapped. Stay close to the right wall to avoid
setting off the traps.

 Go back south, staying close to the right wall. Turn the corner east, and go
north. Turn right at the intersection into the hallway with four chests.
Don't touch the chests -- they'll explode. Walk east into the illusion wall
just across from the intersection. You'll come to a small, square room with
a brown key. Take the key and go back the way you came. (The key opens the
door where you found the bag, and which you don't absolutely have to open.)

 Go north at the intersection west of the chests. At the next intersection,
go north again. You'll reach two doors, one after another. The brown key
you just got will open the first door. Go south beyond this door. At the
end of this hallway, you'll find a lever and a vertical gray key. The lever
opens a hidden door in the west wall. The gray key opens the second door at
the north end of the hallway.

 Go through the south door into a roomful of rats and pick up a red-and-blue 
key in the NW corner. Then go back up the N/S hallway and open the second
door. Continue west and open the next door with the red-and-blue key.

 Beyond the door, go north and turn east. Go north at the second intersection
and west at the next opportunity. You'll find a claw and a scroll telling
you how to use it. Use the claw on yourself (double click on the claw and
click the crosshairs on your avatar). Go back the way you came until you 
reach the last door you opened. (Somewhere in this area, you may be attacked
by an invisible knight and/or a Cyclops. You can fight them or run from
them as you wish.)

 From the door, go south down a long hallway. Near the south end, you'll be
attacked by an assassin-knight. Kill him and examine his body. You'll find
a scroll ordering him to kill you, signed "X". In the west wall near where
the assassin emerged, there are two torches fairly close together. There's
a secret door there, which can be opened by double-clicking on it.

 Go through the secret door into the cavern. Go west and south, and double-
click on the south wall you come to. Reenter the hallway through the new
secret door, and go west and north into a room with fountains. Read the
scroll on the table. Use the bloody claw on the urn on the table, and your
totem animal (a wolf) will appear. Kill the wolf and examine its body. Take
the wolf steaks, and pick up the wolf's body. Take the blue key.

 Go east and south from the room, and open the wooden door to the west with
the blue key.

 When you reach the end of the hallway, Shmed will appear, saying "she
seduced me into trying to kill you." When he attacks, kill him, and take the
scroll and red vertical key he's carrying.

 Leave the knight's test (through the door and south) and go back to Shmed's
office. You'll find your possessions in the chest on the left. You can
leave all the keys you found during the test -- you won't need them later.
Ask your companions to join you. WARNING: DON'T ask any of them about
"belongings" or you'll spend the next half-hour sorting out your and their
inventories, which will all be mixed together in your packs and bags.

 BACK IN MONITOR

 Back in Monitor, talk to Marsten. He tells you what to do with the wolf meat 
and carcass. Cellia the furrier will make you a wolf cloak, but it will take 
her a full day to complete it. Finally, he sends you to Lydia to get a wolf 
tattoo. Your knighting will occur when all of these are accomplished.

 Lydia says a warlock from Moonshade (Fedabiblio, whom you'll meet later) stole
her sister Selene when she was a child. (You'll meet the sister as Selina 
later -- be careful, she's NOT a nice person.)  Get a tattoo from Lydia, and 
don't ask if it will hurt.

 In a little while, you'll probably get very sick. Lydia is the one who put
Shmed up to killing you, and has poisoned you. When you do get sick, talk to
Harnna the healer. She'll send you up to Fawn to see Delphynia, an herbalist.
You'll need to get some leaves from Delphynia and bring them back to Harnna,
who will then heal you. Fawn is to the north of Monitor, and Delphynia's
house is just east of the Fawn palace. (Go past the gatehouse and the area
with fountains, across a narrow bridge, and turn right.)  If you confront
Lydia after the poisoning, she'll attack you. It's OK to kill her, although
you won't get or learn anything especially critical.

 In the meantime, while you're waiting for your cloak, ask Harnna about more
of your strange objects and follow up on her leads. You may also want to do
some training, or to explore outside Monitor a bit. You can poke into the
Monitor side of the dungeon Furnace. Its entrance is just south of Monitor,
at 136S 27E. There are some trolls there who carry diamonds, and a pikeman's
body that you can bring back to the crematorium for a reward. You'll come
to a bridge across some lava fairly soon in your explorations, and your 
companions will begin to complain about the heat. Later in the game, you'll 
get a magic spell that will protect you from Furnace's heat. For now, don't 
cross the bridge or you and your friends will roast alive. 

 There's a ruined castle at 137S 43E, inhabited by more trolls, and a curious 
sheep pen north of the castle. It has teleporters that lead to a locked area 
of the Temple of Chaos, which you won't get to until later. You can climb 
into the sheep pen, but BE WARNED: some players have gotten in but couldn't 
get out again. I suggest you just leave it alone -- you don't need to use 
the teleporters, and there's nothing else useful inside.

 Talk to Marsten after you pick up your wolf cloak from Cellia. He'll tell 
you to go to the banquet hall in an hour. When you arrive, you'll find almost
everyone in town is there.

 Someone will ask you what part of the test you found most harrowing. If you 
say the gremlins, the Cyclops, or the invisible man, you'll learn that the
test was rigged by persons unknown -- these things weren't supposed to happen.

 Harnna will come in and report that Cantra is missing. Templar will say that 
there's a traitor among you, and Shazzana and Luther will fight about who the 
traitor might be. Marsten will declare that the banquet is over.

 Talk to all the people who were at the banquet.

 Brendann, who's now your knight commander, says Krayg's not the traitor, but
maybe Luther is. He says Shmed's treachery sounds like wizardry, and asks
you if you have enemies in Moonshade. He asks you to continue to search for
the spy. (If you're a female avatar, he'll also come on to you, and will ask
you to, um, tryst with him after midnight. If you do, he'll give you a
gwani cloak and an interesting experience.)

 Cellia, Flicken, Luther and Shazzana have nothing new to say.

 Templar tells you some useful things about the goblins (attack them early in 
the morning) and the Helm of Courage (it has mystical powers and was not made 
by humans or goblins). He also thinks Krayg is the traitor. And he tells you 
someone is stealing money from the Monitor treasury.

 Spektor admits that there is a thief, but asks you not to tell anyone else.

 Marsten tries to convince you that Shmed was the one and only traitor.

 Caladin says the traitor was a knight, but couldn't have been Shmed, who was
terrified of goblins. He suspects Krayg, and also thinks you must have an 
unknown enemy among the mages of Moonshade.

 Lucilla has no new information about the traitor, but she tells you about
the goblins' secret camp, the location of which remains a mystery. She also
tells you that she hates Luther, but that he's been invincible ever since
he got a new magic shield (Dupre's). If you're a male avatar, she'll invite 
you to a secret tryst, and, if you go, will give you a gwani cloak. If you're 
a female avatar, she'll dish the dirt with you about all the men in Monitor. 
She seems to know them all VERY well <g>.

 Talk to Harnna. She lets you look in her crystal ball, which shows Batlin
threatening Cantra in an abandoned castle (Shamino's). Cantra reveals that
she's possessed by a bane (about which more later), and they have a magic 
duel. Harnna asks you to rescue Cantra, and says you'll need two things: 
Cantra's wooden practice sword (which she gives you) and the Hound of Doskar, 
which she doesn't know where to find. She prophecies that you'll also need 
three ancient and powerful artifacts (the Helm of Courage, the Rose of Love, 
and the Mirror of Truth). She also says you'll need to go north through 
caves that lie to the west (beyond the swamp).

 Talk to Krayg. He says that someone else also takes long walks in the woods 
-- someone who may not be human. Ask him about "evidence" and he'll tell you 
about a goblin meeting site in the woods north of the Knights' Test. He says 
look for a strange black obelisk.

 LOOKING FOR EVIDENCE

 Go to look for evidence at the strange black obelisk Krayg told you about.
Follow the road north to the "Fawn" sign. Go west on the Fawn road. You'll
have to fight the goblins that have taken over the Fawn tower, which will
become important when you finally get to Fawn. You'll know you've retaken
the tower when you see pikemen inside it. (Be sure none of the goblins
escape -- if they do, you'll fail to set a flag that's important to your
quest in Fawn.)

 Continue north until you reach the Fawn gates, then go west into the woods.

 The black obelisk is at 82S 18W. You'll find a bottle of Fawnish ale there.
Take it with you -- and don't drink it.

 Some other things to find in the woods:

 A house where everyone has been massacred at 72S 20W -- there's nothing vital
here, but the chickens and wild pigs make good eating.

 The House of Wares at 77S 28W -- you can't get in now, but you'll find a key
in the caves you'll take to get to the northern mountains.

 Hollow trees with treasure at 78S 16W (Destroy Traps scroll) and at 85S 23W
(serpent crown <very important>, money and other goodies).

 A jester at 85S 31W whose house contains a trapped chest and a few goodies.
He won't talk, and it's OK to kill him.

 And the secret entrance to the goblins' caves at 69S 32W. Don't go in now,
because you need a key that's back in Monitor.

 BACK IN MONITOR

 Take the bottle of Fawnish ale to Lucilla, who will tell you it belongs to
Simon. Confront Simon with the bottle. Question him and accuse him of
lying. He'll change into a goblin and will attack you. Kill him -- and
with his dying breath he'll tell you that the goblin king Pomdirgun has the
helmet, where to find the goblins' lair, and that the key you need is around
his neck. Take his keys -- the gray vertical one fits the chest in his room;
the brown one doesn't fit anything I ever found; the red-and-blue one fits
the locked door inside the goblins' cave.

 THE GOBLINS

 Go back to the entrance to the goblins' lair (69S 32W). Inside, head north
to a locked door, which will open to your red-and-blue key. Continue heading
north. The first tunnel to the left leads to a beer cellar and nothing
important. The next tunnel to the left leads to a pair of stairs down. At
the bottom, you'll find a checkerboard that's trapped and guarded. In the
center is a firedoom staff (a powerful weapon). Continue heading north in
the main tunnel. You'll come to two stairs down. The one to the north leads
to a dead end, guarded by headlesses (there are some gems to be had). The
one to the west leads to a fountain of healing, guarded by a water beast.
Take the stairs up in the NW corner of the room. In quick succession, you'll
find two more stairs up. After the second one, you'll come to a roomful of
bats. If you go east from here, you'll find a dead end, a statue that's
trapped, and a fire wand. On the way, you'll pass a brass chest behind a
cavern wall. The brass chest holds a magic bow and some magic arrows, but 
you can't get to them without using magic or cheating.
 
 The route to the goblins' camp lies to the north from the bat room. You'll
come across a circle of stones with a chest inside. The chest is trapped, 
and contains nothing but some poison potions. A little farther north, on 
the right, you'll find a locked door, behind which is the goblin king's
treasure room (and the Helm of Courage). You can't open it except with the
goblin king's key, so keep on traveling north for now.

 Shortly, you'll come to the end of the caverns and the north side of the
goblins' camp. Check your watch, and wait until early morning to enter the
camp. Most of the goblins will be sleeping then, and won't come out to
attack unless you go inside their huts.

 Follow the mountains south to another cave mouth. It will take you to the
south end of the camp near the king's hut. Confront the goblin king (at
31S 21W) and kill him. He has a magic axe and the bronze key to the
treasure room. In his hut, you'll also find your burst arrows (swapped for
the strange hairbrush), money and gems, and another bronze key that doesn't
seem to fit anything in the game.

 Back up toward the northern end of the camp, you'll find a cooking area that
contains the bodies of Astrid and other pikemen. They have some useful
weapons, and you can take them back to Monitor for cremation and reward. In
a pen nearby, you'll find the pikeman Johnson, who wrote a book on how to be
a successful soldier. Apparently, he writes better than he fights, because
he's gotten himself captured and put on tomorrow's goblin menu. Release him,
and he'll follow you part way back to Monitor (but he won't join you, fight,
or go past the first stairway.)

 In the farthest-north hut, there's a magic bow and a magic sling.

 Go back to the treasure room and loot it to your heart's content. Be sure
to take the Helm of Courage and the two scrolls near it. They're the proof
you need to identify Marsten and Spektor as traitors. Be sure to take BOTH 
scrolls. If you don't expose both traitors at the same time, one will go 
free, which will thoroughly mess up the rest of your game.

 BACK IN MONITOR

 Go back to Monitor and tell Brendann or Caladin about the traitors. They'll
take care of having them arrested. Ask about the Helm, and they'll give it 
to you. (Take care of it -- you'll need it later.)

 Now's a good time to retrieve Dupre's shield. Talk to Luther, who'll lie
about having the shield. Call him names, and he'll get mad and challenge you
to a fight. Go to List Field and tell the pikeman you want to train with
Luther. Beat him on the field, and he'll be your friend. Talk to him again
later, and he'll give you Dupre's shield. 

 NOTE: Make sure you have room in your backpack for the shield. Otherwise, 
he'll say he's giving it to you, but it won't appear in your inventory.

 Talk to Marsten in jail, and he'll tell you about his secret weapon. He says
it's well hidden and you'll never find it.

 Talk to Spektor in jail. He'll tell you that Cantra's father stumbled onto
their secret cave and that he and Marsten killed him. He'd found their
secret explosive weapons.

 Talk to Standarr, and he'll tell you that he created a combustible powder
for Marsten and Spektor.

 Talk to Lucilla. Ask her about Spektor, and she'll give you the key to their
secret cave.

 The secret cave is behind an illusory mountain wall just south of the
crematorium (154S 12W). Walk through the illusion, and open the door with
Spektor's key. (It's the door you saw from inside the crypts but couldn't
reach.)  Inside the cave, you'll find Cantra's murdered father, four chests
of treasure (Spektor's thieving), and ten kegs of gunpowder (DON'T DOUBLE
CLICK ON THEM!!!)  You won't actually need the gunpowder until you're almost
at the end of the game, and when you do need them, you'll find more at a
nearby location. Bottom line, you don't really need THESE kegs, but you
know where they are.

 Take the pikemen's bodies to the crematorium. Be sure to talk to Renfry
after you cremate each body, or you'll only get paid for the last one you
fed to the machine.

 Talk to Harnna about the scroll you found on her husband's body. It's not
really required, but it's the civilized thing to do.

 You've now completed the quest sequence in Monitor, and are ready to move on
to Fawn. (If you have enough money, you can buy gwani cloaks, fur hats and
fur boots from Cellia. You'll need them later in the frozen northland.)
 
 FAWN

 It's okay to go to the Sleeping Bull next, or even over to Moonshade. But 
Fawn is probably your best bet for the next quest. If you haven't been
there yet (if you didn't get poisoned), follow the road north to the
second signpost and turn left.

 Ruggs, a sailor from the ship Batlin came on, will meet you at the gate and
ask you for a favor. He wants you to carry a letter to his significant
other, Delphynia the herbalist. You should agree to do this, but you don't
have to do it immediately.

 From the Fawn gate guard, you'll learn that the city gates are closed at
night, that there's a traveler's shelter west of the gate, and that justice
is swift (if not always just) for any form of troublemaking. There's a 
little food in the shelter, but it's not restocked if you take it.

 As soon as you enter the city, a sailor (Olon) will run up to you asking
Iolo to sing. Have Iolo oblige him with a sad song about Gwenno. (If this
DOESN'T happen, search out Olon at the inn and talk to him. It's important 
to the rest of the Fawn plot.)

 Talk to Olon after the song. He'll tell you about the gwani, but his info
is wrong -- the gwani are friendly, and you'll need them as allies later.

 If Olon meets you beyond the gate, Kylista (a priestess), Delphynia, and
Jorvin (the captain of the guard) will also be nearby.

 Talk to Jorvin. He thanks you for retaking the Fawn tower, and tells you 
about the Fellowship folks who came on Batlin's ship. (Lady Yelinda, the 
city's ruler, had them banned for spreading heresy. In this game, however, 
unlike in the Black Gate, the Fellowship people are the good guys.)

 Jorvin also says that Lady Yelinda will wish to welcome you formally (for 
saving the tower), and that he'll see that you're properly escorted when she 
wants to see you. He'll tell you about Lady Yelinda, Kylista, the Oracle (he 
says ask Kylista), the ruler's chancellor, Zulith, and the Great Captains who 
are Yelinda's advisors. He'll also tell you about Alyssand, who makes fishnet 
stockings. It seems a storm took away her engagement ring (he recognizes the 
one you're wearing as Alyssand's). She's also one who listens to the 
Fellowship's "babbling," he says.

 Kylista tells you about the city's Oracle, whose revelations only she can 
interpret. She'll also tell you about the false prophets (Ruggs and his 
friends) who came preaching blasphemy and brought on the lightning storms. 
(She's wrong, of course, but she has her own agenda working here.)  She'll 
also tell you her views of Lady Yelinda, the Great Captains (Joth, Garth, and 
Voldin, whom she obviously favors), and Zulith.

 If you're wearing Kylista's white armor when you meet her, she'll exchange
it for your magic armor. If you're not, you can find your armor in her
house, which is just west of the temple. You don't need to return hers.

 Talk to Delphynia and give her Ruggs' letter. She'll tell you some unsettling 
things about Fawn's Beauty-based religion, and will give you a letter to take
back to Ruggs. She'll also tell you that Batlin came to her, seeking to buy
reagents and asking about blackrock carvings. She sent him to Pothos in
Moonshade for reagents, and to Delin (Fawn's provisioner) for serpent ruin
information. She'll also tell you that Alyssand is headstrong and has a
weird notion that the town's Oracle is a sham (which, of course, it is).
Delphynia also sells black pearls, nightshade, garlic, ginseng, mandrake,
and fruits and veggies.

 You can continue exploring Fawn at this point, or you can go to the 
Fellowship camp to deliver Delphynia's letter. I went to the camp first.
It's at the end of the dirt path just east of the Fawn gate.

 I found Alyssand at the camp. (In Fawn, she's usually at her father's
provisions shop on the small island just beyond the main gate, or their house
just across the plaza.)

 Ask Alyssand about her ring, and she'll give you your magic gauntlets which
were swapped for her ring. She'll ask you if you're willing to help free
the city from its false traditions and evil schemes. Say yes. She'll tell
you that she suspects that the Oracle legends are false, and that Kylista
and Voldin are using it for their own purposes, corrupting Fawn's religion
in the process. She tells you to look everywhere and talk to everyone to
find the clues that have evaded her and the members of her Cause. (This is
the main plot in Fawn, so pay attention to what she has to say.)

 Talk to Ruggs, and give him Delphynia's letter. He'll introduce you to Scots,
another sailor, who will give you a map of Serpent Isle. It's not entirely
accurate, but it's better than nothing. He'll also tell you a bit more about
Batlin and his companions.

 Talk to Kalen, another sailor. He's a surly lout, who turns out to be
another bane host, like Cantra.

 Talk to Leon, who'll try to get you to join the Fellowship. Ask him about
other subjects before you bring up the Fellowship -- he'll stop talking to
you when you tell him the Fellowship has been disbanded. He'll agree with
Alyssand, and will tell you that Kylista is manipulating the Oracle, but he
doesn't know how she does it. He'll also tell you that Lady Yelinda is a
figurehead, and that Zulith is a puppet but can be vicious if he's slighted.

 Zulith showed up in camp while I was there, too. He tells you that he
exchanges money. He'll also talk about the Oracle and the Great Captains, 
but he'll tell you a very different story. From here on out, he'll follow
you until you ASK if he's following you. Then he'll go away mad, but it's
OK -- you don't really need to stay on his good side.

 Scots says that Kylista has the soul of a viper, and you shouldn't trust her.
He'll also tell you how Gwenno and Batlin got to Serpent Isle.

 BACK IN FAWN

 Go back to the city after you've talked to everyone at the camp.

 Some other folks in Fawn to talk to:

 Garth (one of the Great Captains) tells you that the Fawn lighthouse was
zapped by a teleport storm and exchanged for a haunted building. (It's the
Britannia Mint, and you'll get to visit it with Selina, whom you'll meet at
the Sleeping Bull). Garth also has some rather negative opinions of Voldin, 
Kylista, and the Oracle.

 Note that Garth's house (far SW corner), like most in Fawn, is pickable. He
has a suit of plate armor there. In his warehouse (far NW corner), there's
a Great Ignite scroll on the balcony. There's also a crate on a very high
shelf. If you're a major masochist, you can reach it by building steps out
of crates, bales, and bolts of cloth. But it's not worth the bother -- 
there's just a gwani cloak and some conventional weapons in it.

 Delin, the provisioner, tells you that the storm exchanged his cashbox full
of filari for your food. He also mentions that his son, Freli, was taken
away by the Moonshade mages. (You'll meet Freli when you get to Moonshade.)

 Voldin, Joth, and Yelinda have nothing of interest to say at this point.

 Jendon, the innkeeper, is a wealth of information, though. He's Fawn's
equivalent of Monitor's Harnna, and will give you leads about your strange
objects. He'll also tell you that the Sleeping Bull was once a pirate fort.

 There's a gold key in Jendon's rooms that doesn't fit anything I found in
the game. In the inn's basement, there's a chest under the stairs. To
reach it, move the spear next to the wine cask. A lever there will open a 
secret door in the wall next to the chest, which is pickable.

 There are things to pilfer all over Fawn, but you'll find only a few items of
real utility. In Yelinda's house (to the right of the throne room), there's a
bronze key that opens a door on the SW side of the throne room. The passage
beyond leads to Fawn's serpent gate. In a palace room, you'll find two magic 
scrolls in a chest, and a red key that doesn't open anything. There's also a 
secret door in the small room in the SE corner of the throne room. It leads 
to Fawn's treasury, but you won't be able to get into it until much later.

 Along about this time, you'll be attacked by the surly sailor, Kalen. He'll
tell you that Batlin will soon have more power than you can dream of. When
he dies, a bane will exit his body. By the way, if Kalen attacks when you're
talking to any of the town officials, try to get him to follow you away from
them before you go into combat mode. Otherwise, you may wind up with all of
Fawn attacking you, and you'll have to restore to an earlier save.

 Kalen's attack will trigger the unfolding of the rest of the Fawn plot. In
a few minutes, Jorvin will approach you and say that Lady Yelinda is ready to
receive you formally. Come to see her in the throne room in the afternoon,
and be sure to bring Iolo.

 THE FORMAL AUDIENCE

 Yelinda praises Iolo for his song, and gives him a diamond necklace for
Gwenno. Everyone toasts: Hail to Beauty. Dupre, always rash, toasts Lord
British, and is promptly arrested for being an ally of "Beast British."
Jorvin knocks you cold with the wand of detainment. When you wake up, you're
in a room at the inn. A gold key on the nightstand unlocks the door, and a
scroll tells you to go to the temple for Dupre's trial. There's nothing you
can do about any of this, so just sit back and watch it unfold.

 THE TRIAL

 Go immediately to the temple (the doors will open for you). Don't worry
about what to do at the trial -- Dupre's guilty no matter what you do. The
whole scene is pretty funny, though, so just watch and chuckle. When
everyone's done trashing Dupre's reputation, the trial will be adjourned
until tomorrow, at which time the defense will be presented. You'll be
ushered out of the temple, with one day to uncover and foil the plot.

 Walk around for a while and Alyssand will find you. She'll tell you that
Dupre is being held in a cell under the temple, and will give you a gold
key that will unlock the door to the left of the entrance in the temple.
She'll tell you that the temple won't be guarded that night. (You can go
there at any time, though. You don't have to wait for nightfall.)

 Go to the temple and unlock the left door. Go downstairs, and you'll find
Dupre. He can't talk to you, though, and you can't unlock his cell. Pull
the switch on the left, near the cell. Go up the stairs, and you'll find
Voldin, who will spill that he and Kylista use the levers you see behind
him to rig the Oracle's revelations. He's just set them to condemn Dupre.
He'll attack, so kill him.

 Try resetting the levers to any pattern. You'll find that the farthest-
right lever is jammed. After you've reset several others, the Oracle will
say "Stop!" Then, try the right lever again, and the Oracle will speak to
you. Tell the Oracle to say that the trial is corrupt, and to denounce the
true traitors. She'll thank you for freeing her.

 Now, you have to wait for the trial to resume. If there's nothing else you
want to do, just bed down by the main doors and wait until noon.

 When the trial resumes, call your witnesses. You don't really have to, but
the rest of the testimony is pretty funny stuff. The Oracle will proclaim 
that Dupre is innocent, and that the true criminals are Kylista and Voldin. 
Yelinda will express her regrets, and will give Dupre the Crystal Rose of 
Love. (Take care of it -- you'll need it later.)  Jorvin reports that Kylista 
has been captured and has confessed, and that Voldin has been found dead.

 Once the trial is over, you're done in Fawn for now. You can talk to Kylista
in jail, but she has nothing new to say.

 Time to head for the Sleeping Bull Inn.

 SOME THINGS ON THE MAINLAND BELOW THE SWAMP

 At 46S 36E, you'll find the Swamp Cathedral. There's a dead troll nearby,
with a dead child inside. The child has a fire wand. The doorways to the
cathedral are all trapped. Go through the red doorway and you'll be 'ported
to a little ruin in a lava field. Push the button to open the sliding door.
The corpses have jewelry, magic arrows, serpent weapons, and other loot.
There's a teleport that will take you back to the surface.

 At 62S 44E, there's a small stone building with wooden walkways on either 
side. There's a secret door on the east side. There's nothing useful in the
whole complex, so I'd advise not bothering with it.

 At 54S 73E, there's a stone stairs leading down. You'll find some serpent
scales here, and an illusion wall to the south. Beyond it, there's another
small building, some more serpent scales, and a stairway leading up to a
stone temple. You'll find some ordinary weapons there, along with still
more serpent scales.

 At 59S 66E, you'll find a ruin with a Blink scroll.

 At 71S 52E, you'll find a ruined powder mill and a ghost that will play a
major role in the endgame. He's Ssithnos, the last Great Chaos Hierophant,
which won't mean much to you now, but will later. Anyway, he was a major
power among the Ophidians. 

 Note: Save your game before talking to Ssithnos, then restore afterward.
There's something buggy hereabouts. Much later in the game, you'll find
another way to talk to Ssithnos, in another location. If you've already 
talked to him here, you may hit a bug with the prophetess Xenka that will keep 
you from finishing a major part of the game.

 Ssithnos will tell you a lot about the game's REAL quest, which is to restore 
the balance that was destroyed by the actions of Exodus, one of the avatar's 
earlier foes, and by the civil wars that followed. Basically, he tells you 
how to complete the next-to-last quest in the game -- restoring the Chaos 
Serpent. He'll tell you about the banes, and about a mystery force that 
you'll need to find before you can complete the quest. He'll give you a 
scroll that covers most of what he tells you. Don't worry about restoring
and losing the scroll. He'll do it all over again when you meet him later.

 There's a bunch of very nasty skels in the mill's basement, guarding a chest 
with a few paltry gems in it.

 At 76S 82E, you'll find the transplanted Britannian Mint. You can't get into
it now, but you will get in after you visit the Sleeping Bull.

 At 83S 40E, you'll find a corpse under a rock who has some plate leggings.

 At 100S 39E, there's an invisible chest on top of an obelisk. You can build a 
stairway to the chest using rocks from the area. The key to the chest is in a 
hollow tree just south of the Sleeping Bull (at 117S 35E). Inside are: a 
magic sword, an invisibility ring, magic bolts, gems, gold, and potions.

 AT THE SLEEPING BULL

 There are many people at the Sleeping Bull with a lot to say.

 Talk to Byrin, the bard, and pay him one coin after every song to keep him
singing. His songs and tales contain many clues to the later portions of
the story. He'll tell you about the northern savages (gwani); the lost
culture of the Ophidians; a lost king (Shamino!) in whose castle trapped
souls await the return of the one who deserted them; the dreadful story of 
the White Dragon King; the land of dreams (in Gorlab Swamp); and the Forest 
Master (whom you'll meet beyond the swamp).

 Miggim, a monk from Monk Isle, says someone will make an attempt on your life 
soon (it's Selina, whom you'll meet shortly); and that the monks' prophetess, 
Xenka, will return when the end of the world (and the game) is near.

 Ensorcio, an exiled mage, will tell you about virtually everyone in Moonshade.
All his information is useful, although it comes from a highly biased source. 
He'll tell you: Batlin stole his serpent jawbone (the game's teleportation 
instrument); Flindo, a merchant, had Captain Hawk thrown in jail because he 
refused to sail to Moonshade; Flindo trades in merchandise and information; 
the Mountains of Freedom on Moonshade is a prison full of magic traps; 
stoneheart (your glowing stone) comes from Freedom and is used in death 
spells; Erstam, the Mad Mage, moved to an island off Moonshade; his mentor, 
Vasculio, was executed for his experiments with stoneheart; and Silverpate, a 
pirate, hired Erstam to do magic at the Sleeping Bull.

 For a price, Ensorcio will tell you how to turn stoneheart into bloodspawn,
the reagent used in death spells. (Don't pay -- others will tell you for
free.)  After you've gotten a spellbook (beyond Moonshade), he'll also sell 
you some of the nastiest spells in the game.

 Argus, the innkeeper, says the pikemen at the Bull Tower are holding Hawk; 
that the Moonshade mages are split into warring factions; and that Silverpate 
disappeared after building the inn. He'll also tell you about his other 
guests, and will rent you room #3. (The other rooms are pickable, but you 
need the key to enter room #3. You'll find the diary of one of Batlin's 
henchmen in room #6, and a trunk containing some antique armor in room #7. 
The switches in each room are all red herrings. Don't bother with them.)

 Devra, Argus' mother, will exchange money. She'll also trade your mysterious
slippers for your swamp boots. She says her husband, Angus, disappeared one 
night when Batlin and his gang were staying at the inn. She heard voices in 
the cellar late at night, and in the morning she found the cellar in disarray 
and both Batlin and Angus gone. She'll ask you to find out what happened to 
Angus. (I never found a trace of Angus, but I did find quite a lot in and 
beyond the cellar, of which more later.)

 Kane, another guest, tells you that his brother, Edrin, was taken by a storm,
after which he found only a parrot named Ale (who is really Edrin in drag).
Edrin, he'll tell you, had a crystal that had strange effects on his dreams.
He's going to Moonshade to ask the mages there to help him find his brother.

 Flindo, the Moonshade merchant, will be an important contact to have once
you get to Moonshade. He tells you that he has "connections" in Moonshade,
and that you should ask him about them again when you get there. Be sure
you do. He'll also tell you that Vasculio was executed, but that his tomb
turned up empty within a week. (You'll meet Vasculio much later, in a very
unpleasant encounter.)  He'll also tell you about Mortegro, a mage whose
specialty is speaking to the dead, and about the MageLord's mistress,
Frigidazzi, who specializes in cold spells.

 Another guest, Selina, will lead you on a dangerous quest. But before you 
talk to her, take a tour of the cellars. The stairs are in the kitchen.

 SLEEPING BULL CELLAR

 Downstairs, go through a hidden door between the wine casks in the NW corner.
Walk north to a small room with a switch and two chests. Throw the switch,
which opens a sliding door in the SW corner of the cellar. Open the left
chest and take the tan key. Don't touch the right chest -- it explodes.

 Go back into the cellar, through the sliding door in the SW corner, and down
the stairs. You'll find a corpse in a prison cell. Open the cell door with
the tan key and search the corpse. You'll find a scroll that will explain
the mysterious switches in the inn's rooms. (Silverpate used them to spy on
his guests from a secret "wardrobe room" in the catacombs. Don't bother
with the switches -- they're not important.)  The scroll will also tell you 
that two torches mark the entrance to a hidden serpent gate.

 Go north and west from the cell, and you'll find a locked door that your tan
key will open. You've found Silverpate's wardrobe room. On the north wall,
there's a pickable invisible chest containing two magic scrolls (False Coins
and Mass Cure). There are five chests along the west wall. The fourth one
from the top has a map to Silverpate's treasure, which is not under the inn
but in a cave in the frozen northern mountains (you'll be able to get there
later in the game). The antique key doesn't open anything I found in the game.
Don't touch the other chests -- they're empty and they explode.

 Go back the way you came and continue east and north from the intersection.
At the end of the north tunnel is a wine room that's unimportant. The two
torches the prisoner's scroll mentioned are in the middle of the N/S tunnel
leading to the wine room. Go east at the torches, through an illusionary 
wall. In the tunnel to the south (trapped), you'll find some plate armor and
other loot in a trapped chest. In the tunnel to the east of the illusionary
entrance, you'll find some empty trapped chests and a Create Food scroll.
In the tunnel to the north, you'll find a serpent gate and a brass chest.
The pickable chest holds an Explosion scroll, a gray key that unlocks the
door to the right, and a map that describes the entire layout of the serpent
gate teleportation network. Unlock the door on the right, and take the 
teleporter to the Sleeping Bull's office.

 BACK AT THE INN

 Stop by the Bull Tower (NW of the inn) at this point and inquire about paying
Captain Hawk's fine. However much money you offer, the guards will demand
more, and will continue raising the fine.

 To solve this problem, go back to the inn and talk to Selina. She'll propose
going to the building that was swapped for a lighthouse. She'll say that it's 
supposed to be full of treasure, and that she found a key outside. Agree to 
go with her without your companions (they'll stay at the inn until you come 
back). She'll give you a tan key that will unlock the haunted building (look 
in your own inventory for it). Look in HER inventory, and you'll find a blue 
key that will unlock several doors in the Temple of Order (which you won't 
find until much later), and a Columna's Intuition scroll.

 Note: Despite Selina's instructions, you CAN take your companions with you on
the quest.

 Go with her along the coastline to the transplanted Britannia Mint (76S 82E).
Unlock the door with the tan key. Go straight to the room in the NE corner
and grab the gold bars. Then, get the heck out of there, or you'll spend
all eternity fighting spirits and teleports. You CAN'T clean the place out,
no matter how hard you try.

 Once outside, you'll be ambushed by a bunch of fighters, and Selina will
vanish. On one of the assassins, you'll find a scroll from Batlin, telling
them to kill you. Don't be fooled by Selina's pretty eyes -- she's a pal
of Batlin's, and was an accessory to this murder attempt. She's also Lydia's
sister (the tattoo artist from Monitor who tried to poison you), and was a 
rebel on Moonshade until things got too hot for her there. You'll meet her 
again later, in the northern mountains.

 Go back to the Bull Towers and offer the pikemen your gold bars. They'll
take them and give you the gold key to Hawk's cell. Go downstairs in the
tower and unlock the cell. Hawk will say he'll meet you at the inn.

 Go back to the inn, get your companions, and talk to Hawk. He'll tell you
about his treasure map (but you've already found his treasure, in a hollow
tree in the goblin forest). He'll also tell you a bit about Selina and
Batlin. Most important, he'll agree to take you to Moonshade.

 Go out to the ship. On the way, you'll probably meet Wilfred, Argus' brother.
He'll tell you some things you already know, and will be quite a jerk about
it. He's not really worth talking to, but Dupre's comment about him is
priceless ("What a butthead!").

 Note: Wilfred is also a trainer -- the only one outside of Monitor.

 Get on Hawk's ship and sit down. Shortly, Hawk, Flindo, and Kane will get
on board, and you're off to Moonshade. (Note: if Flindo and/or Kane don't get 
aboard, they're probably sleeping. You'll have to go back to the inn and wake 
them up before Hawk will set sail. Don't worry, he won't leave without you).

 IN MOONSHADE

 Once your ship lands, go north and east to find the town. Don't worry about 
exploring the island yet. There'll be plenty of time for that later.

 The first building you come to will be the Rangers' headquarters and winery.

 Flindo, the merchant, was there when I entered. He has lots to say, and it's
pretty much all useful. He'll tell you tales about ancient passages that 
connect Moonshade to the other islands, and will suggest you ask Fedabiblio
about them. He'll also direct you to Bucia, his assistant, who, he says,
talks a lot (and he's right!). He'll tell you that she has a farfetched
notion that Pothos, the apothecary, is connected to the mad mage in some way.
Bucia also exchanges money. About Erstam, the mad mage, he'll suggest you
talk to Pothos (who is out of town at the moment). He'll also tell you
juicy (and important) tidbits about several Moonshade mages, including
Frigidazzi, who, it seems, isn't so frigid after all.

 Ask Flindo again about his connections. He'll agree to set up a meeting for 
you with Filbercio, the Mage Lord. (This is a key conversation, because it 
sets a flag that moves the plot forward. You'll have to talk to Flindo again 
about his promise, but this first step is essential.)

 Talk to Julia, the head Ranger. She'll list some of Moonshade's rules --
like it's illegal to own stoneheart or bloodspawn. She'll also tell you that
it's unhealthy to cross Filbercio's whims, and that Erstam, the mad mage,
hacks up his assistants for his experiments with creating life. She'll
reveal that the Moonshaders believe in truth, but only within reason. (Don't
say you work for Lord British during this conversation, and shush Dupre when
he tries to speak up.)  She'll send you to Pothos for reagents, and to
Fedabiblio to learn more about magic. Finally, she'll identify your ice wine
as being of the same vintage as the wine that disappeared recently. (The wine
was swapped for a map of Britannia, according to Origin's cluebook, but
I never found the map.)

 There's another Ranger named Ernesto you can talk to. He's a great-looking
dude, but he hasn't much of interest to tell you. The other Rangers are
just there for show, and all say basically the same thing -- talk to Julia.

 There's a curious secret room quest in the winery, beginning in the office
in the NW corner. There's a tan key in the desk drawer that fits the upstairs
office door. (Make sure none of the Rangers is watching when you take it.)
Go upstairs and unlock the door. There's a Enchant Missiles scroll on the
desk, and a lever behind the table, next to the chest (which contains mundane
items). The lever opens the way into the sub-basement, where you'll find 
another lever between a chair and a table. This one opens a secret door in 
the wall. Behind it, you'll find a scroll telling you the secret of
winemaking: sorcery makes it easy, but the real secret is to use great grapes.
So far as I can tell, there is absolutely nothing of value in the basement,
nor any value in knowing the secret of winemaking. Go figure!

 AT THE BLUE BOAR INN

 Various Moonshade NPCs drop in here from time to time. The owner, Rocco, and 
his metal spouse, Petra, are always here. Hawk, Kane, Ducio (the master 
artisan) and Bucia, Flindo's assistant are often here in the evening hours.

 Talk to Rocco (who'll rent you a room and will sell you food and drink). He'll
tell you that Batlin was here two months ago, stole an ancient artifact, and
fled by ship. He'll also tell you that Gwenno was here, too, but left months
ago for Monk Island.

 Talk to Petra, the automaton. She'll give you the lowdown on Torrissio, who
created her to be more complex than the other automatons he has made for the
mages. Torrissio, she says, is willful, vicious and mean (an understatement).
She says his magic isn't his own, but came from scrolls he found in ancient
Ophidian ruins. She'll also tell you about Mosh, the rat woman, who likes
fish. (Petra, too, will sell you food and drink. Buy some fish -- it's
good nourishment, and you'll eventually need one to give to Mosh.)

 A note about buying things: you can haggle with just about anyone in the
game, and you'll save money by doing so. But be warned that if you make
frivolous offers, the seller won't negotiate with you. And if at some point
in the negotiations the seller merely repeats his last offer, take it. He's
hit his rock-bottom price, and if you persist in haggling, you may hang the
game or cause the seller to refuse to talk to you any further.

 About this time, you'll be approached by an automaton who identifies himself
as belonging to Rotoluncia, a powerful mage who's a member of the Council of
Mages. He'll give you a magic scroll from her. Use it by double clicking
on it. (Do it right away, since it's also a flag-setting trigger.)  She'll
tell you that she met Batlin and his gargoyle companion Palos, and demands
that you tell her Batlin's secret of controlling what she calls "daemons."
Since you don't know the secret, you'll have to say no to her. You don't
really have a choice here -- whatever you do, you'll make a dangerous enemy
in Rotoluncia (who was Filbercio's mistress before Frigidazzi, BTW).

 If Bucia's at the inn, talk to her. She's Moonshade's equivalent of Harnna
or Jendon -- she'll tell you useful things about people and places, and will
give you leads about your strange objects. She'll only talk for a little
while at first, but if you meet her at the inn in the evening, she'll talk
a little longer. She'll ask you for the pine cone, and it's OK to give it to 
her. DON'T ask her about the bird's egg or the bloody hand -- she'll stop 
talking to you until you drop them. She'll tell you that Pothos is out of
town on a secret errand for the Mage Lord. Be sure to ask her about Pothos
later, after he's returned to town.

 If Ducio is there, he'll tell you that he can create or repair anything --
magic apparatus, magic weapons, etc. He'll also tell you to talk to his
apprentice, Topo. If you show him the apparatus here in the inn, he'll tell
you to bring it to his shop and he'll examine it. He'll also direct you to
Torrissio to ask about automaton magic, and to Fedabiblio for answers to your
questions about history.

 Hawk will tell you that the pine cone comes from the woods north of the swamp,
and that the only way to get past the swamp is by ship (he's wrong).

 EXPLORING MOONSHADE

 Now is a good time to explore the rest of the city and see who's doing what
to whom. By the way, if you explore OUTSIDE the city and find Gustacio's
lightning experiment at 37S 143E, DON'T touch anything. He'll send you there 
later, and if anything is missing, it will mess up your game royally.

 You can visit the following houses in any order. The occupants may or may
not be home when you visit, so try again later. If you steal anything, make
sure no one (including the automatons) sees you do it.

 Mortegro's House (65S 143E)

 If Morty's home, he'll tell you that he's a necromage, and specializes in
speaking with the dead. He has baaaad spells to sell when you've gotten a
spellbook. He also holds seances, in which you'll meet some interesting
dead folks. He says he and Gustacio, another mage, are studying the weird 
lightning storms -- a detail that will be useful later. There's a gray key 
on his entry table that opens the front door. There's also a Restoration 
scroll in his desk, and some reagents on another table. The glowing gold key 
doesn't open anything I found. There's a lever behind the northernmost slab 
that opens his seance room. The "magic ball" there is useless but funny.

 Rotoluncia's House (74S 153E)

 Roto won't be home when you call, but her house is open. You'll find some
reagents and a bag containing a serpent's tooth on a side table. Make sure
you take the tooth -- it will fit in a serpent jawbone you'll get later. The 
chest in her bedroom (pickable) holds a red key that unlocks the naga's cell, 
a Fire Snake scroll <this spell doesn't work, BTW>, a Paralyze scroll, and two
interesting letters from Filbercio -- one is an old love letter, and one is
a hate letter, accusing her of flirting with Torrissio. Roto's shifting
relationship with Filbie becomes important later.

 Frigidazzi's House (77s 150E)
 
 Frigi will be out, too, but her goblin servant (who's harmless and doesn't
talk) will be home. You'll find a key to her frozen lab area under a flower 
pot on a side table in her dining room. In her lab are reagents, magic 
scrolls, a fire wand, and a note saying she lost her serpent tooth near the 
savages (the gwani, whom you'll meet later up north). The door north of the 
entrance is locked, and you won't be able to get through it until Frigi 
invites you to visit her later in the game.

 Stefano's House (82S 152E)

 Stef's out, too, and there's nothing useful in his house. The glowing green
key on his table doesn't fit anything I found in the game.

 Gustacio's House (92S 152E)

 Gus is probably home, but he's much too busy to talk to you. Later on, he'll
be more accommodating. There's a set of stairs to his basement in the NW
corner of his tropical plant garden. At the moment, there's just a Summon
scroll to be found down there, but this location will become very important
later in the game. There are some reagents on the first floor, and a magic
telescope on the roof. Look through it, and you'll see random scenes of
locations that are in some way important in the game.

 The Seminarium (93S 150E)

 There's a lot of stealable stuff here (reagents, scrolls), but you'll have
a hard time finding a moment when nobody's watching you. There's a tan key
in the anteroom desk, but it doesn't fit anything. In one of the dorm
chests, there's a magic compass, but it doesn't work. In the library, there's
a book that tells you about stoneheart and bloodspawn. You don't really have 
to make bloodspawn, by the way. There's plenty of it to be found later; just 
be sure to search all the corpses and chests and such that you come across.

 Talk to Fedabiblio, the schoolmaster. He'll tell you some interesting things 
about the other mages. He'll say he sent Gwenno to Monk Island, and that
Batlin was obsessed with the Ophidians. He won't, however, tell you about the 
catacombs under the city (a non-functioning flag, it seems). The most 
important thing he has to say at the moment is that he'll give you a new 
spellbook if you bring him three FRESH mandrake roots from Monk Isle. You 
can't get to Monk Isle yet, but now you know why to go there.

 Talk to Andrio, the older of Fedabiblio's two students. He'll tell you some
useful things about Torrissio. He'll also tell you that Freli, the younger
boy, is researching a stone-to-flesh spell like one of Torrissio's. You
can't buy this spell, but later on, you'll find a wand belonging to Torrissio
that will allow you to cast it when you need it.

 Talk to Freli. He'll tell you that Batlin bought some spells from Torrissio
before he left. He'll also warn you not to mess around with Frigi, or Filbie
will toss you into the Mountains of Freedom. (You will, and he will, but
that comes later.)  He'll also give you a scroll for his father, who is
Delin, the Fawn provisioner. If you ever get up that way again, Delin will
sell you supplies at half price for bringing him word of his long-lost son.

 Columna's and Melino's House (85S 150E)

 Columna and Melino won't talk to you until you have a spellbook, but there's
some stealable stuff available here now. In the chest in the hallway, there's
a tan key that unlocks the basement door. Be sure to save your game before
going down there, though. There's a horrendous buzzsaw trap at the foot of
the stairs. The best way to avoid it is to double-click on your avatar the
moment your party appears on the stairs. Once you've brought up your avatar's
screen, you can take the items in the basement at your leisure. Just be ready
to run quickly back upstairs as soon as you close all your windows, or the
buzzsaw will make hamburger out of your party. What's down there?  A green
key that fits a chest hidden in the back yard; a scroll that tells you about
a magic Comb of Beauty (which you'll need later), and reveals that Columna
and Mosh, the rat lady, are actually twins; and a Time Stop scroll (which
you could also have used to get the other items).

 When you're safely back upstairs, go into the bedroom and look for a secret
door in the north wall. Open it and walk around to the back yard. Look for
a chest that's nearly hidden among the trees. Open it with the green key and
take the Comb of Beauty.

 After you've gotten your spellbook, Columna and Melino will sell you spells.

 Torrissio's House (84S 142E)

 If Torrissio's home, talk to him (BUT DON'T MENTION THE STRANGE STOCKINGS --
he'll take them and give you nothing in return.)  He'll tell you some useful
information about Rotoluncia, Columna, Batlin and Gwenno. Among other things,
he'll tell you that he did indeed sell spells to Batlin. (He'll also bore
you to tears with details of his own life, but you gotta wade through it all
to get to the good stuff.)

 In his house, you'll find some reagents in the bedroom chest, and a Reveal
scroll in the nightstand. In his lab are two partly assembled automatons.
You can revive them with the Create Automaton spell, and they'll join your
party. (If you're a party of four, only one will join.)  They're not very
good fighters, but they're good at carrying stuff. Be sure Torrissio's not
in the house when you cast the spell. Early in the game, he goes to the inn
every morning at 9AM. Later, he's mostly at the MageLord's house.

 Pothos' Shop (79S 139E)

 Pothos' shop is at the top of the wooden stairs next to the water. The shop
area upstairs is guarded by a very vigilant automaton. If you wait until it
goes downstairs for a moment, you can nab the reagents and scrolls in the
two pickable chests, and the potions on the counter. In Pothos' office
downstairs, there's a tan key under the chair on the left. Look carefully,
because it's almost entirely under the table. It opens his downstairs
storeroom, which has a few nice magic items inside. Once again, make sure
the downstairs automaton is looking the other way when you open the door.

 When he's there, Pothos will sell you reagents and some magic items.

 There's also an amusing beta-testers' area under his outside stairs. Look 
for an illusionary wall in the east side of the stairs. It leads to a small
room which has another illusionary wall to the north. The tan key from
Pothos' office opens the locked door, which leads to a football field (yes,
really!) with cheerleaders and a troll team for opponents. At the goal line,
there's a chest with some nice magic items inside. BE WARNED, though, that
the teleporter beyond the goal line doesn't seem to work, and you'll be
trapped here unless you (1) cheat, or (2) arrange for the trolls to kill you
after you've gotten the goodies.

 Ducio's Shop

 If Ducio is in, show him the strange apparatus and he'll tell you it belonged 
to Vasculio, the mage who is alleged to have risen from his grave in revenge
for his execution. 

 His apprentice, Topo, will buy gems. He'll also tell you that Mosh, the rat
lady, claims to be Columna's twin sister, and that Stefano makes his living
stealing things from one mage for another.

 There's a magic sword in a crate near the blacksmith-automaton, and a two-
handed axe on a table.

 Mosh the rat lady may make an appearance about now. Don't kill her rats --
tell her you like them. She'll tell you that she was once a powerful mage,
but that her power was stolen by another. She'll tell you to ask Columna
about it (which you can't do until you get a spellbook).

 BACK TO THE MAIN PLOT

 Now that you've toured the place, find Flindo again and ask him about his
promise to introduce you to the MageLord. He'll say that it's all set up,
and that the MageLord will summon you.

 Walk around for a few minutes, and you'll be teleported to the MageLord's
banquet. This is a cut scene, so you can't do anything but watch. Basically, 
Rotoluncia will attack you, Gustacio will defend you, and Pothos will come in 
saying he hasn't been able to find any bloodmoss for Filbercio.

 That will break up the banquet, giving you an opportunity to explore the
MageLord's palace. (The outside doors will remain open for the rest of the
game, but you won't be able to get into the SE rooms or to the teleporter
in the bedroom until later.)

 There are some Create Food scrolls in the kitchen, and a Translate scroll
in the library. Most important, there's a treasure room next to the stairs.
To open the room, pull the lever behind the throne. To open the chests, look
for a purple key under a flower pot in the bedroom. There's a fire sword,
a magic axe, and a lot of gold and gems in the chests. It all will stay
right where it is until you need it, so you don't need to carry any of it
away with you. If someone in your party carries the fire sword, by the way,
you'll never need any other light source.

 THE ERSTAM CONNECTION

 Now that Pothos is back, ask Flindo about him. He'll tell you that Pothos
may be Erstam's son, but that he won't talk about it.

 Ask Bucia again about Pothos (she may make you wait until she goes to the
inn at 10PM). She'll tell you there's a rumor that he looks like Erstam.

 Note: These two conversations set flags, so they're essential to the plot.
They won't happen until after the banquet scene.

 Now, talk to Pothos. Among other things, he'll tell you that if you get sent
to Freedom and escape, your crimes will be forgotten. He'll also tell you
some useful things about Batlin and Gustacio. He'll identify your bloody
hand as a product of Erstam's experiments. And he'll tell you that he'd
trade his dearest secret for some bloodmoss. Confront him about his secret,
and he'll admit to being Erstam's son. He'll tell you that if you bring him
some bloodmoss, he'll help you contact Erstam.

 TO THE SWAMP

 To get the bloodmoss, go south from the city steps near the serpent gate.
Follow the coastline to the south tip of the island. Enter the swamp at
about 127S 153E. Follow the path to an area with standing stones; there's 
bloodmoss growing all around. It'll grow back after you pick it, but since 
you only need a few to satisfy Pothos, you can leave the rest for yourself.

 Take the bloodmoss back to Pothos. He'll tell you how to get to Erstam's
island, and will give you a password that will identify you as a friend.

 THE KIDNAPPING

 Before you get more than a few steps toward the dock Pothos directed you to,
one of your companions will be kidnapped by Rotoluncia. You'll have to
rescue him before you can get to Erstam's island. Go to the palace and talk
to Filbercio. Tell him you suspect Rotoluncia, and he'll send you to search
her house. When you get there, one of Roto's automatons will attack you.
Kill it, and go back to see Filbercio again. He'll tell you that he and
Roto renewed their relationship a while back, and that he built a passion
palace for her on an island in the center of the city's lake. Roto has
probably taken your companion there. He'll give you permission to use his
boat to get to her island. You can get to the boat from the upstairs
hallway. Double click on the engine (in the rear of the boat) to start it.
Then move the boat with your right-hand mouse button. Double click on the
boat again when you want to disembark.

 Take the boat to the center of the island and get off. Go inside and up the
stairs. Get the gray key in the dresser, and go down to the basement.
Unlock the gate with the gray key. Roto will attack you, assisted by some
gremlins. Waste 'em all. The gremlins all have black pearls, and Roto has
two purple keys and a fire wand. One of the keys unlocks your companion's
cell, the teleporter next to the cell, and the door in Filbercios' bedroom
(the other end of the teleport). The other key doesn't unlock anything.
Get your companion and zap back to the city.

 ERSTAM'S ISLAND

 Head for the northern tip of the island by going past Roto's house and along
the eastern coastline. You'll find Erstam's dock at 15S 129E. There's a
fetching nude sunbather at 21S 127E, by the way. Her name is Cindy, but
she's only window-dressing. She won't talk (or do anything else <g>).

 Ring the bell on the dock, and Erstam's turtle will come to get you. Get on
his back and he'll take you to Erstam's island. (He'll only do this once,
so save your game before you call him.)

 Note: There's another beta testers' room with magic stuff and pretty ladies
in the mountains west of Erstam's house. To get to it without using the
cheat mode, go to Stefano's old house on Moonshade (82S 100E). Put a crate
next to the tree stump out front, and climb onto the stump. You'll teleport
to a tiny island with a teleport pad. Work your way around until you find
an invisible path north that leads to a cave in the mountains. You can also
get here by using the super cheat mode (teleporting to hex 7de, 51a, or 
picking up sections of the mountains with the hack mover function). Be 
warned that you can corrupt your game files doing either of these things.

 Go into Erstam's house and have a look around. You'll find a Stop Storm
scroll in one crate, Flash and Deter scrolls in another, and an Erstam's
Surprise scroll in the chest in the bedroom. You'll also find your missing
dagger behind the stairway.

 Talk to Erstam. Among other things, he'll tell you NOT to ask him about 
teleportation, and NOT to ask his assistant Vasel about it. He'll also say
the strange apparatus you found is his, even though Ducio said it was
Vasculio's. This is, I believe, a text error, and not anything important to
the game. He'll also tell you that he's missing some critical ingredients
for his experiments, and that you can use the magic telescope on the roof.
Like Gustacio's telescope, it will show you random important game locations.

 Talk to Vasel and ask him about teleportation. He'll tell you about the
serpent jawbone.

 Talk to Erstam again, and he'll 'fess up to having the jawbone. He says he'll
give it to you if you retrieve a phoenix egg for him. Say yes, and he'll
teleport you to the phoenix's island.

 This is a small island, and you should be able to find the phoenix's lair
with little trouble. Flip the switch to let the lava flow into the room,
and the phoenix will arise from the flames. Talk to the phoenix. She'll tell
you that now that there's a living phoenix in the world, the balance between
order and chaos can be restored. As a reward, she'll give you her egg.
Go to the nearby teleporter and return to Erstam's island.

 Talk to Erstam. He'll ask you to help with his experiment. Gather the body
parts near the machine (a talking head, a torso in a crate, an arm, a forearm,
two legs -- don't use any twitching parts). Put the parts in the machine's
funnel. Each correct one will produce a swirl in the funnel. Incorrect ones
will be spit out. When you've put in all the body parts, chuck in the phoenix 
egg. Erstam's creation, named Boydon, will emerge. If you talk to him, he'll 
ask to join your party. Say no -- he smells awful and will keep people from 
talking to you. And if he gets killed, the monks won't restore him.

 Talk to Erstam again. He'll give you the key to his storeroom and a serpent
tooth, and he'll tell you to come back when you have the jawbone.

 Go to the storeroom (it's behind his house) and get the jawbone. It's the
V-shaped item in the NW corner. Double click on it, and you'll get a large-
screen view of it that shows eighteen empty sockets. Pick up one of your
two serpent teeth and place it over one of the sockets. It will find its
proper place. (The one you got from Roto's house will go into slot #11,
counting from the top left, and will take you to the tunnels of Furnace;
Erstam's goes in slot #12, and will bring you back to Erstam's island.)  

 Note: Don't do this yet, but to teleport using the jawbone, stand on one 
of the serpent gates and double click on the carving. You'll be teleported 
to "serpent central," a large hall floating in the void with eight irising 
gates. When you walk by an iris gate with the proper tooth installed in the 
jawbone, that gate will open. Go down the corridor and double click on the 
serpent gate there. You'll be teleported to that gate's corresponding 
location on Serpent Isle. Eventually, you'll find all eighteen teeth and
will have access to all the gates in serpent central. You found a map of
the whole layout in the catacombs under the Sleeping Bull, but the gates
aren't identified. It's a good idea to test each tooth shortly after you
find it. That way, you can make your own gate layout and label each
gate as you learn where it takes you.

 Go back to the house and talk to Erstam again. He'll give you two more
teeth: #13, Moonshade; and #6, Monk Isle.

 Go back to the serpent gate and use it to take you to Monk Isle. (It's the 
first gate to the north off the eastern corridor at serpent central.)

 MONK ISLAND

 From the serpent gate, go south to reach the monastery. (You can't open the
north gate yet.)

 Be sure to read all the books in the library (use the lens of translating)
and the book of Xenka's prophecies on the altar.

 Talk to all the monks who can or will talk. Karnax says that Xenka will
return to deliver the final key to saving the world. Draxta says you'll need
a thief-braggart for an ally. She also says you must triumph even in your
dreams, and she invites you to the Place of Visions (7N 139E) to see one of
Xenka's visions. (You'll see the automaton Petra walking through a field
of acid while you stand by watching. You'll actually do this, sort of, a
little later in the game.)  And Thoxta says that Gwenno was seeking 
information about the ice people of the north (gwani) while she was here.

 The mystic monk, Braccus, has the most useful information for you at the
moment. He says fresh mandrakes grow in their swamp, but you can only find
them when the salt tides are low (which they aren't at the moment, of course).

 While you're waiting for the tide, tour the island. Look for a ruin in the 
swamp at about 13N 144E. A tan key in the hollow tree will open the gate 
downstairs. Under the swamp is a ruin on a small island. In its basement are 
magic bolts, a lightning wand, a magic axe, and a blue key.

 The blue key opens the gate to the east, which leads to another ruin. A 
corpse there has a red key that opens the south gate in the main cavern. 
That passage will bring you back to the serpent gate and the monastery.

 When you've returned to the monastery, ask Braccus again about the tides.
He says they're right for mandrake picking now. Go back up to the swamp
and walk around its muddy banks. You should find a dozen or so mandrakes
lying on the mud (they're brown, and look like gingerbread men).

 Use the serpent gate to go back to Moonshade. Take your fresh mandrake to
Fedabiblio and he'll give you a spellbook (after asking you several more
copy-protection questions). As soon as you can, transcribe all the spell
scrolls you've collected into your spellbook.

 Now that you're officially a mage again, Columna and Melino will talk to
you and sell you spells. (You can also buy spells now from Mortegro and
Torrissio, and from Ensorcio back at the Sleeping Bull. Before you leave
Moonshade, though, Gustacio will offer to teach you many spells for free.
And after you rescue him later in the game, Mortegro will sell you his
spells for half-price, so spend your money wisely.)

 Columna and Melino don't have much new information for you. DON'T ASK
EITHER ONE OF THEM ABOUT THE STOCKINGS. Melino says that most of the mages
in Moonshade have stolen a serpent tooth from Erstam at some point. (Neither
he nor Columna has one.)  Columna denies hotly that she's related to Mosh.

 Gustacio still won't talk to you, so it's time to drop in on Frigidazzi
again. She should be in her house now, although you may have to wait for
her a bit. She'll trade the fur hat for your magic helmet. And she'll
invite you back to her house after midnight to, ah, discuss magic.

 After midnight, leave your companions outside and go into her bedroom. Say
yes to whatever she asks, and you'll have an interesting evening, no matter
what gender your avatar is. (You can say no, if you prefer. It'll all come
out the same anyway.)  In a while, Filbercio will burst in on the two of you
and haul you off to court. No matter what you do, you'll get thrown into
the Mountains of Freedom.

 MOUNTAINS OF FREEDOM

 When you arrive in Freedom, you'll have with you only your spellbook and
reagents, some scale armor, and a staff. The automaton that meets you will
tell you that Stefano is here, and that there are two rogue mages here
looking for stoneheart.

 Get the scythe in the next room, and wait until the automaton opens the door
to his office to go on rounds. When he does, kill him and search him. Be 
sure to loot his office -- it's your beginning supply depot. And get the red 
key in the bag. It unlocks the chest in the office, the office door, and 
several more doors throughout Freedom.

 Unlock the door north of the teleport with the red key. Walk through the
illusion wall in the NW corner, by the sign that reads "Escape is Impossible."

 From the illusion wall, go east, south, west, south, and west until you see
some bloody footprints on the floor. Follow the footprints south through
another illusion wall. To the east is a pickable door leading to a chest
guarded by harpies. You'll find a sword, a magician's staff, and some magic
arrows there. To the west are a gargoyle, a monk, and a pickable door to a
storeroom where you'll find some reagents, including bloodspawn.

 To the south of this area is a teleporter behind a pickable locked door. 
From the teleport landing, go east and north to a locked door. Unlock it
with the red key. Inside, you'll meet one of the rogue mages, who'll turn
into a bear and attack you. When he teleports out, collect his reagents
and follow him through the teleporter.

 At the other end, you'll meet Stefano. He'll tell you about Celennia (who
is Selina) and how she fled town after a fight with Frigidazzi. More critical
to your quest, he'll tell you that to escape Freedom, you must pull two
switches simultaneously. He'll suggest that you and he should work together
to escape. Ask him to join you.

 Unlock the door to the east with the red key. Two men will attack you, one
of whom has your blackrock sword. The demon in the sword will speak to you, 
urging you to release it. Don't release it at this point. When you've
killed the knight, MAKE SURE you have the blackrock sword. It should be
somewhere in your inventory, most likely on your back. DON'T leave this area
until you're sure you have it. You can't get back here later to look for it.

 Take the gold glowing key in the bag on the table, and go east and north to
another locked door. Open it with the red key and fight the woman warrior.
Teleport to a cavern with doors to the east and west. Open the west door
with the gold key. You'll see the mage Lorthondo kill his aide and turn him
into a skeleton dragon. He'll then teleport out.

 Kill the dragon and open the door to the south with the gold key. The chest
there has a firedoom staff, a Great Heal scroll, a bag with lockpicks, and
a blue glowing key.

 Unlock the door to the east with the blue key. The chests in the next room
are all trapped, and contain some good magic armor items. East of the chests
you'll see the two levers that Stefano mentioned. Double click on one lever
and Stef will get the other. Move quickly into the teleporter to avoid
the explosions behind you.

 You'll be in a branching tunnel. To the north, there's a trapped chest with
Cold Blast and Telekinesis scrolls. To the west are many bodies around a
teleport pad. Search them and find a regeneration ring, some magic arrows,
and another Telekinesis scroll.

 To the east, you'll see a chasm with a raised drawbridge. Cast Telekinesis
on the drawbridge's winch to lower it. On the other side, step near the desk
and sign and the sliding door will open. Walk around the sleep fields into
the room with many levers.

 THE LEVER ROOM

 The lever room has nine locked rooms, and twelve levers arranged as two rows 
of four levers inside a larger square formed by levers in each corner.

 In the outside square:

NW raises and lowers doors around the lever area
NE opens the ice room full of trolls
SW opens the door to the south after some others have been pulled
SE opens the hidden exit in a tunnel beyond the room

 In the inside square, top row:

#1 (from left) opens the room with the mushrooms and rabbit
#2 opens the supply room
#3 opens the room with rats and bones
#4 opens the room with the sleeping woman

 In the inside square, bottom row:

#1 opens the ranger's room
#2 opens the room with the knight statues
#3 opens the room with the nightmare (horse)
#4 opens the room with the teleport pad -- it's stuck, and you need the
   ranger to fix it.

 Start with the sleeping woman. She'll say "lead me to my nightmare." Open 
the room with the horse and let it kill the woman. Search her body and take
the carrots and the arrow key. Now, open the room with the mushrooms and put
the carrots on the gold plate. The rabbit becomes a woman who thanks you
with some flowers. Take the flowers and open the ranger's room. Talk to
him and put the flowers on the dead woman's body. The ranger will thank you
by fixing the jammed lever. Now open the teleport pad room, and step on the
teleporter. Throw the glowing blue lever in the meadow. Walk in any
direction and you'll be teleported back to the lever room.

 Pull the SW and SE levers, and go through the south door to the firepit room.
Unlock the door with the red key and walk around the fire. When it goes out,
walk into the firepit.

 You'll be teleported to another tunnel area. Go south into what seems to be
an endless tunnel. Feel your way along the right tunnel wall, and you'll find
a secret exit.

 From there, you'll be teleported to an area with an automaton selling potions.
To the south, the next chest is trapped, and contains an axe and a helm.

 The next room has a sign reading "reach bell for freedom." Here, you must
build a stairway to the bell with crates and other items. When you reach the
bell, you'll be teleported to a tunnel with a sign reading "pick one or die."
Pick tunnel one, on the far left.

 At the next tunnel area, there's a mostly empty storeroom to the north, and
another automaton vendor to the west. Kill him or cast Vibrate to get his
key. Open the gate to the west with the automaton's key (it's also pickable).

 You'll now have a final confrontation with Lorthondro. You can't kill him 
without releasing the demon from the black sword, so do so as soon as you can. 
Ignore the demon's taunts; you need the sword empty later in the game.

 Go south to another gate (use the automaton's key, or pick it). You'll be
teleported to Filbercio's back room.

 BACK IN MOONSHADE

 Stefano will leave you as soon as you're back, but he'll return any items
from MOF he may have been carrying. Your possessions are in the chest.
There are three keys in and on the desk. One of them opens the gate to the
left (the others are worthless). Beyond the gate, there's a secret door in
the back wall. You can use this door to come back for your MOF items.

 Go to the inn and find Dupre. He'll tell you that Iolo has gained Gustacio's
confidence and has been helping him with his experiments. Shamino has been
hunting in the woods. You can find him on the road west of the city.
Shamino will give you a message and two presents from Frigidazzi, who is
sorry about what happened. Her presents are the serpent earrings (which will
appear on your avatar's ears, and will allow you to hear the Earth Serpent),
and a Chill scroll. Transcribe the scroll -- you'll need to cast a lot of
them when you get to the Lost City in Furnace.

 You may encounter Mosh again on your way to Gustacio's. Tell her you believe
her about Columna. Give her a fish, and she'll give you a magic harp that
will pacify the ratmen in the catacombs.

 Gustacio will tell you that a lightning storm exchanged Mortegro for a stone
altar that's now in the basement (it's from the Temple of Tolerance, which
you'll find later). He'll also tell you that he'll teach you all his spells
for free if you'll help with his experiments. Agree, and he'll give you a
power globe and instructions about how to use it.

 Go to Gustacio's tower (37S 143E), and follow his instructions. (Put the
globe on the platform at the south end of the platform, use the winch, and
pull all the levers.)  Your companions will observe the lightning effects.

 Go back to Gustacio's and tell him about your observations. He'll send you
to Fedabiblio, who'll tell you to look in his crystal ball. There, you'll
see Kane's brother Edlin being transformed into Ale, the parrot.

 Go back to Gustacio's again. He'll tell you to take the parrot to the tower
and place him where the lightning will strike him. He'll give you a cage
for the parrot and a new globe. Double click on the cage and click the
crosshairs on the parrot.

 Take the caged parrot back to the tower and place the cage on the third
platform on the left. Put the globe on the platform, use the winch, and pull
the lever. The bird will turn into Edrin, who'll tell you about his dreams
of a beautiful woman named Siranush (you'll meet her later).

 Go back to Gustacio's. Talk to him and he'll give you the Mirror of Truth
(keep it -- you'll need it). He'll also teach you all his spells for free.

 You're ready to leave Moonshade now, but be sure to buy the rest of the
spells you need get from Columna, Melino and Torrissio. You may not be able
to get them the next time you're in Moonshade. Also, check the reagents
needed to cast Chill (garlic, ginseng and worm heart), and make sure you have 
enough of them to cast the spell ten to fifteen times.

 Note: When you get a chance, go back to the Sleeping Bull and buy the spell
Vibrate from Ensorcio. He's the only mage who sells it, and you may need it
badly at some point in the game.

 Now, talk to Hawk about leaving Moonshade. He'll send you to Julia. Since
you now have the Chill spell, she'll give you a blue key that will open the
door to the catacombs. Go to the burned-out house SW of Torrissio's house
and open the door with the blue key.

 THE CATACOMBS

 There isn't much to find in the catacombs themselves. Wind around past the
ratmen and the wildmen until you find a stairs up. (Don't bother with the
bellows -- you can't get them to work.)

 THE LOST CITY

 At the top of the stairs, you'll see a raised drawbridge, and a gargoyle on 
the battlements. Talk to him (his name is Zhelkas). He'll say that he has
dreamed of your coming, and if you're really the hero, he has an ancient
artifact for you (the serpent ring). To prove yourself, he'll ask you to
take a test of purity: find the twin pillars in the NE part of the city, and 
grasp the fire pillar to begin the test. Agree, and he'll lower the
drawbridge. He'll also tell you that humans aren't strong enough to pull
the drawbridge levers, so don't bother trying to pull any of them yourself.

 From the gatehouse, there's a passage to the SW that leads to Monitor, but
you'll have to complete the test before Zhelkas will lower that drawbridge.
There's a wall button that will open the door to the east passage into the
city. There's also a passage to the south that takes you through some 
sulfurous ash and also ends up going east into the city. Take the south
route, and you won't need to bother with locked doors.

 Note: You'll need to begin casting Chill spells as soon as you reach the
Lost City. Otherwise, you and your companions will die from the heat.

 Once in the city, look for the library just east of the buildings with the
sleeping gargoyles. Look for three intact books among the ruins. One tells
you about some special reagents and mentions a location called the conjury.
One tells about the civil wars that destroyed the Ophidians' civilization.
And one gives you hints about where to find the fire and ice keys you'll
need to open the way to the city's serpent gate.

 A corpse in the library has the key to the library's basement, where you'll
find some magic scrolls and worm gems.

 The conjury is at the end of the passage north of the library. You'll find
some reagents there (you can make phosphor if you like). There's also an
everlasting goblet here, which you can give to Zhelkas for the serpent ring 
if you flunk the test of purity.

 South of the library is the city's spa. A corpse near the water has the fire
key. In the SW corner, there's a Chill scroll.

 East of the spa is the arena. Walk S around it, and you'll find a locked door 
to the east and the arena doors to the west. Use the winch to open the arena
door. You'll be attacked by a series of four gladiator automatons. After
you defeat the fourth one, you'll find an open door in the far NE corner.
Take the gray key you'll find there.

 Unlock the door east of the arena with the gray key. Go east and south to
the park. There are many corpses among the mushrooms. Look for one in the
far SE corner that has the ice key and a serpent tooth. It's #16, and it
goes to Monitor. There are also some magic scrolls and worm gems here.

 Now, unlock the magic-locked door leading north. You'll find the Great Temple
and the twin pillars at the end of this northerly passage.

 Double click on the fire pillar to begin the test of purity. You'll find 
yourself in an area with three corridors. To the west are some people who
implore you to save them, and a false Shamino who'll try to get you to
exploit them instead. Press the right button to free the people and prove
your ethicality. To the north, a false Iolo will try to convince you to
enter a moongate and escape. Say no, and you'll prove your logic. To the
right, you'll be asked to kill ten worms without stopping. A false Dupre
will try to distract you. Don't listen to him. Kill the ten worms, and 
you'll prove your discipline.

 Now that you've passed the test, Zhelkas will give you the serpent ring (it
will appear on your finger, like the earrings). Check your inventory -- some 
of your things may have been moved to your companions' backpacks.

 To open the serpent gate, go north into the Great Temple. Put the fire and
ice keys on the altar, and they'll fuse into a blackrock key. You may have 
to try placing the keys several times before they'll fuse -- this puzzle is 
very position-sensitive. Once you have the blackrock key, go upstairs. To
the NE, you'll find a locked door that the blackrock key will open. Behind
it is a teleporter that will take you to the serpent gate.

 There's another way out of the Lost City. Talk to Zhelkas and ask him about
leaving the city. He'll agree to open the drawbridge leading to the passage
to Monitor. Go back to the gatehouse where you entered the city, and he'll
let you out by the SW route.

 On your way back to Monitor via the caverns, look for a troll lair with a
locked room. One of the trolls in the lair has the key. The Serpent Staff,
one of the three artifacts you'll need for the endgame, is in the locked
room. You'll also find your original spellbook nearby. It's ruined, though,
and if you try to read it, it'll explode.

 If you take the serpent gate back to Monitor, be sure to go back into the
Furnace catacombs through the cave south of the city to get the Serpent Staff.

 SWAMP DREAMING

 Make sure you have the Helm of Courage, the Crystal Rose of Love, and the
Mirror of Truth in your own inventory. Then head north up the road and into
the swamp. Keep walking until you fall asleep.

 Note: Once you've begun the quest and picked up any useful items, DON'T leave
the dream world by walking into the firepit. The items you've found will
be lost, and you can't get them back again.

 You may wake up anywhere in the dream world. You'll want to visit all of
it, but there are a couple of places you'll want to find first. 

 Lord British is dreaming in his ruined castle somewhere in the NE. He'll tell
you a sad tale of what's happening in Britannia. But more important, there's
a full set of magic armor and an infinity bow in a brass chest behind his
throne. And a slain soldier has a halberd and an invisibility ring.

 The key to the dream quest is a woman named Siranush, who lives in the
farthest NW corner of the dream world. She'll tell you how the dream world
came to be, and will ask you to help her free her people by confronting the
evil mage Rabindrinath. He can't be killed but he can be overpowered by the
three artifacts you carry -- the helm, rose and mirror. When he's dead,
get his dream crystal and bring it to Siranush.

 Rab's castle is in the extreme SW corner of the dream world. Speaking to
Siranush should cause his front door to open. Before you go in, put on the
Helm of Courage. Rab will meet you just inside the door, but his spell will
fizzle on the helm and he'll disappear. Go south from the main hall into
the dining room. You'll meet Rab again, so hold the rose in one hand.
Again, his spell will fail on the rose. Go east into the torture room. Get
a gold key from the corpse on the embalming table, and pull the switch.

 Now, go back to the main hall and unlock the door to the north with the gold
key. Hold the mirror and go north into Rab's bedroom. He'll attack you a
third time, but again his spell will fail. This time, he'll die. Get the
tan key from his body.

 Go east into the music room, and open the door with the tan key. Walk across
the void (which is trapped) to get the dream crystal.

 Note: If you haven't seen everything in the dream world, you may want to
walk around a bit before going back to Siranush's house. Once you've given
her the crystal, you won't be able to get back here any more.

 Go back to Siranush and give her the crystal. She'll have a touching reunion
with Edrin, her dream lover. Then she'll give you the serpent necklace. Like
the ring and earrings, it will appear on your avatar, not in your inventory.

 Note: You're now able to communicate with the Earth Serpent, who is your 
spiritual guide in the game. After he's spoken to you the first time, you 
can get his advice by double clicking on the necklace's pendant.

 When you've gotten the necklace, you'll awaken near the swamp with your
companions. Once again, check your inventory before going on. You'll have
nothing from the dream world except the three artifacts (which you don't need
any more). But your own stuff may be scrambled in peculiar ways.

 NORTH OF THE SWAMP

 Go through the swamp to the northern forest. Keep an eye out for bloodmoss
growing in the swamp. When you leave the swamp, you'll see the White
Dragon King's castle on your right. Shamino's castle is to the NE. You
can't get into either of them now, so ignore them both and explore the forest.

 Note: When you get near Shamino's castle, he will draw a map of it for you, 
and will tell you how to find the secret entrance. When you're ready to go
there, the secret entrance is at 2N 79E.

 Work your way west through the forest. Among the things you'll find:

At 3S 78E, a serpent gate.
At 0S 66E, Draygan's compound. Don't go in yet.
At 22S 53E, some abandoned houses.
At 15S 49E, a hollow tree with some burst arrows.
At 29S 48E, a shipwreck. Its logbook tells of Draygan's treachery.
At 26S 45E, a ghost town, the remnants of Draygan's gold miners.
At 18S 29E, Hazard the trapper's lodge. Inside, you'll find a note from
Hazard saying he's taken your glass sword north with him.
At 28S 3E, the cave leading to the frozen northland. Don't go in yet.

 MORGHRIM THE FOREST MASTER

 You'll find Morghrim's house at about 54S 22W. Don't kill the wolf -- he's
Morghrim's friend Windrunner. Morghrim will tell you that the Guardian
destroyed his planet, Pagan, but that he escaped with the Silver Seed that
will restore Elerion, the tree of life. (It's rumored that either the Serpent 
Isle add-on disc or ULTIMA 8 is called The Silver Seed, so be nice to this
old geezer <ggg>.)  He'll tell you that he can call the Hound of Doskar, but
not without his orb, which was stolen by Draygan. The orb has made Draygan
impervious to harm by weapons. Agree to help him recover the orb.

 Now, go back to Draygan's fortress and talk to Beryl. She won't talk freely
to you unless you're alone with her, so you may have to go into the mines to
get her information. She'll tell you that Draygan's a major baddie. He can't
be harmed, but he could be defeated another way. You'll need to treat an
arrow with a plant called King's Savior. Shoot Draygan with the arrow and
he'll fall into a deep sleep and you can steal back the orb.

 Go back to Morghrim's and ask him about King's Savior. He'll tell you that 
it's a green plant with yellow flowers, and that it grows along the western 
shore near the mountains. 

 Go west and north to about 37S 40W. Pick the King's Savior plants and use
them on some arrows. The arrows will fall to the ground near your feet. Put
the sleep arrows in your quiver and arm yourself with a bow.

 Go back to Draygan's and talk to him. He'll tell you a pack of lies. Go
into combat mode and shoot him with a sleep arrow. Now, you can kill him.
Search the body and take the orb.

 The Forest Master will teleport in at this point and ask for the orb. Give
it to him and he will give you the whistle to summon the Hound of Doskar. Be
sure to ask him about the hound before he leaves. This sets a flag that will
enable you to talk to the hound.

 You can search Draygan's mines for treasure if you like. There are gold
nuggets aplenty if you want them, but be careful of trapped chests. There's
also a secret room behind an illusory wall at the east end of one of the 
first-level tunnels.

 FINDING CANTRA/SHAMINO'S CASTLE

 Go back out into the forest and summon the Hound of Doskar by using the 
whistle. Put Cantra's wooden sword on the ground and ask the Hound to track.
He'll point toward Shamino's castle. You don't need the sword anymore,
unless you need to have the hound track again to find the castle.

 You can use the secret entrance to Shamino's castle (an illusory wall between
two tree stumps at 2N 79E), or you can get in by casting Telekinesis on two
portcullis winches. In the NE corner of the secret entrance tunnels, you'll
find a magic shield, a magic helmet, some magic bolts, and a crossbow.

 Once you're inside the castle, go to the barracks room on the middle of the
east side. Open the secret door on the north end of the room, and put all
the levers in the down (toward you) position. This will unlock all the rooms
around the central keep. In the chest room (left of the lever room), the
chests in the front room are all empty. You'll have to hack open the ones
in the back row. They contain some magical items, including a dragonslayer
sword, and a note from Shamino's late wife, Beatrix.

 Beatrix's spirit will attack you several times, hurling fireballs and angry
words at Shamino. Later, she'll forgive him, and will even provide a free
resurrection if he gets killed later in the game.

 Be careful in the kitchen -- the ovens will spit fire at you. Beyond the
ovens, the corpse of one of Batlin's henchmen has an interesting diary. It
tells of capturing a bane in the frozen north, and of trapping another in
the Skullcrusher mountains. They tracked the third one to this castle.

 You'll find some reagents outside the southern bedroom. A red key in an
invisible chest in the bedroom opens the locked closet. The closet contains
some magic scrolls and a chest with reagents and an invisibility ring.

 The barrier around the keep should now be down. On the left side, you'll
find one of Batlin's lesser henchmen. Kill him. On the right side, the
gargoyle Palos and two others will attack you. Batlin will come in, saying
he now has all three banes and Cantra is dead. He takes Palos and vanishes,
saying he's going beyond the frozen mountains.

 Go upstairs (on your way, look for some magic scrolls in the hallway desk,
and for a gwani cloak and some armor in the hall closet). You'll find 
Cantra's mangled body in the bedroom. In a moment, a monk will appear and 
take her away with him to Monk Island. The Earth Serpent will speak to you, 
saying that you should seek the temple (of Emotion) and the Eye of the Moon 
(which will show you where Batlin has gone).

 Take the amulet Batlin has dropped and leave the castle. Call the Hound of
Doskar again, and have him sniff Batlin's amulet. He'll point north. (Be
sure you do this even if you know where Batlin is. It sets a major flag.)

 GOING NORTH

 It's now time to head north into the frozen icelands. Be sure all your party 
members have fur cloaks, fur boots and fur hats, or everyone will freeze to 
death. If you haven't yet found enough for everyone, you can buy them from
Cellia in Monitor.

 Enter the caverns leading north at 28S 3E.

 As you might expect, the caverns lead in a northerly direction. Look for a 
stairs down. Then go east, north, and east until you come to a black obelisk
in the middle of an intersection. Go north, east and south from the obelisk
to find the stairs up that lead to the exit. Watch out for traps in the
middle section.

 The passage north just before you get to the obelisk leads to Gannt's tomb
(Gannt was the poet who wrote all those soppy poems you've been reading all
through the game <ggg>.)  The antique key near his tomb opens the House of
Wares back in the forest west of Fawn.

 The passage south of the obelisk leads to an endless set of passages and
stairs.

 The first passage east after the first stairs down leads to a series of 
stairs up. One of the crates holds some magic armor pieces. If you build
a stairway out of the crates in the last room going up, you'll come out in
a weird shrine high above the mountains. There's a statue there, and some
skeletons that will attack you. But there's no loot.  Why?  Who knows?

 ON THE ICE FIELDS

 As you exit the caverns, you'll meet a dying trapper named Fitch. Search
him after he croaks, and you'll find a gwani cloak, a fur hat, and some
fur boots.

 Going north, you'll find a bear cave at 20S 4W.

 At 10S 4W, you'll find the cave Fitch mentioned. The loot here includes
more fur cloaks and an invisibility ring.

 The caves at 2N 8E and 2N 5E don't hold anything interesting.

 The cave at 2N 1E is the entrance to the City and Temple of Chaos. The
corpse here has some fur items and a scroll. The scroll identifies the place
and tells you you can't get in without a password. Go on for now, but
remember where you found this place -- you'll need to come back later.

 THE GWANI

 Continue north, following the mountains. You'll soon meet the gwani named
Bwundai. Talk to him -- don't fight, he's friendly. Among other things,
he'll tell you that the temporarily late Gwenno is on the gwani death temple
island, which is to the north, and west of the ice dragon caves.

 The gwani live in caves at 22N 0E, 22N 3E, 21N 10E, and 22N 14E. Talk to
all of them. You'll learn more about Gwenno and Hazard. You'll also learn
about the Great Horn of the Gwani, which "makes ice dance" and which was
stolen and taken into Skullcrusher. Finally, you'll learn that a gwani child
is very ill, and that only ice dragon's blood can cure her. The gwani healer
Baiyanda will give you a bucket, and will ask you to slay a dragon and bring
its blood to Yenani, the gwani leader.

 Go north from the gwani caves. You'll find an abandoned gwani cave at 44N
11E. At about 50N 5E, you'll meet two gwani hunters, Gilwoyai and Kapyundi,
who have been hunting an ice dragon. They'll tell you to use their ice raft
to find the dragon. They'll also tell you that the lair's front opening is
very dangerous, and that there must be another way in.

 Get on the raft and double click on it. Then use your right mouse button to
move the raft. Go north.

 At about 64N 0E, you'll find a shipwreck. Double click on the raft to exit
to the ice island. Among the wreckage, you'll find magic boots, a magic helm, 
a sword of defense, and other loot. There's also a book that describes the 
treasure the dragons are guarding, and mentions rear tunnels that are 
magically trapped.

 Get back on the raft and go north from the shipwreck to about 78N 3W. Step
onto the ice island and follow the mountains east. The entrance to the magic
tunnels is at 93N 11E. The tunnels are full of teleports and traps. To 
reach the treasure room, go west from the entrance to the first intersection;
go south and east to the first teleport; go west to the next intersection, 
cast Destroy Trap, and continue west to the next teleport; go west, north and
west to reach the treasure room. Among the copious loot, you'll find a fire
sword and a magic axe. Kill the baby dragons; double click on the bucket and 
click the crosshairs on the dead dragon to get a bucket of dragon blood. 

 From here, you can either go back through the tunnels or go past the rubble
to the dragons' front entrance. If you go past the rubble, you'll face more
dragons, but they're not so hard to kill. Outside the cave mouth, one of the
corpses has some magic leggings.

 If you'd rather go back through the tunnels, go east from the treasure room
and straight past the first intersection. You'll teleport to the tunnel that
leads to the exit. Go straight to go out.

 Note: If you walk into any of the traps in the tunnels, especially those near 
corpses, you'll wind up facing trolls and ice creatures. After you've killed
them, use the nearby moongates to return to the tunnels.

 MAGEBANE/PENGUIN ISLAND

 While you're out here in the ice water, stop by and pick up Magebane. The
penguins' island is at 54N 33W. Go west and then SW to navigate around the
ice floes. Watch out for sea serpents.

 The gwani death temple is out this way, too, but you can't rescue Gwenno
until you get the gwani horn in Skullcrusher. Go back the same way you came,
and leave the ice raft somewhere you can find it again. (You'll need it again
to get Gwenno.) Its original dock is at about 50N 5E.

 Find Yenani and give her the dragon blood. In return, she'll tell you her
secret - the password to the City of Chaos under Skullcrusher.

 CITY OF CHAOS

 Go back to the Chaos cave entrance. Put the runes on their correct pedestals
(you may need to cast Translate to be sure). Double click on the runes in
the sequence of the password phrase's initials: ISCGI. Start with the "I" to
the west. If you do it right, you'll get green magic stars after each rune
you use. If you don't get stars, try resetting the runes on their pedestals.
(They don't work if they're off-center on the pedestals.)  With the fifth 
correct rune, your avatar will say the password phrase and the gate will open.

 Go east inside the city to Vasculio's house. In the main room, you'll find
Gustacio's flux analyzer, Torrissio's green wand (Philanderer's Friend), and
some other stolen items. There's a book there describing each item. Keep
the wand for use later, and use the flux analyzer to fix your blackrock
sword. Put the sword on the floor and double click on the analyzer. When
it starts to shake, click the crosshairs on your sword. You'll see magic
stars, and your sword is fixed. (You don't need the analyzer any more.)

 You'll also see the gwani horn under a protective field. You can't get to it
yet, so don't bother trying.

 Go into the room to the west. Cast Magic Unlock on the skeleton's cell door,
and when he attacks you, kill him. The corpse in the cage has two serpent
teeth, and a book about Vasculio, saying he hasn't yet located the Grand
Shrine within the labyrinth. The two serpent teeth are #8 and #9, and they
go to Fawn and the forest near Shamino's castle.

 Go through the double doors to the east and confront Vasculio, who'll open his
coffin when you approach. When he asks who sent you, I just said 'vengeance.'
He'll ask to trade Magebane for a deadly spell. Don't agree -- you already
have the spell. He'll attack, but Magebane will turn his magic back on him.
Take his red-and-blue key -- it opens the eastern exit from Chaos.

 Note: The gwani here are vicious. Don't hesitate to kill them.

 From Vasculio's, go south to the library. A friendly ghost will give you a
book about penguins. It's a clue to finding Magebane, which you already
have. There are two more books of interest here: one tells about the Wall of
Lights, the Great Hierophant, and the serpent artifacts;  the other gives the
doctrines of Chaos, and talks about Tolerance, Enthusiasm, and Emotion.
You'll need to know some of this stuff later, so take a few notes.

 There's some food in the restaurant next door, and another friendly ghost.
In the storage room next door, you'll find some torches and a powder keg in
the SW corner.

 Listen to and talk to the ghosts in the theater north of the restaurant.
They'll tell you quite a bit about what happened to the Ophidians, and
about what you need to do to restore balance.

 The building to the east is Vasculio's lab. You'll find Rudyom's wand there,
but it's now useless. A book tells you that great magical secrets lie behind
the sealed entrances (the double gold doors).

 Now, go east across the bridge. In the first house you come to, you'll find
two more powder kegs behind a table, along with some gold and gems. In the
next building to the north, there's a set of gold double doors facing east.
You can't open these doors, and there's nothing you need behind them.

 Continue north and you'll come to a building defended by automatons. Its 
double doors lead to the Temple of Chaos. You'll need to blow them open with 
a powder keg. Save your game before you try -- placing the keg can be tricky. 
Try putting it just left of the center line between the two doors. Double 
click on it to set it off (don't stand too close). It should make a giant 
hole in the doors. You can explore the temple now if you like, but this 
location won't become important until much later in the game.

 A small gold door to the east of the temple entrance takes you to the eastern 
ice fields and Batlin. Unlock it with Vasculio's red-and-blue key.

 ON THE EASTERN ICE FIELDS

 Go south and a bit east from the door, to 22N 50E. You'll find the Temple of
Emotion, which holds the Moon's Eye. Pick up the three lodestones on the
pedestals as you're walking through the temple. (There's also a Mass Cure
scroll.)  When you get to the water, look in the pink moongate (the Moon's
Eye) and you'll see Batlin in the Temple of Order instructing his henchmen
to stop you from reaching him until he opens the Wall of Light.

 Now, go back to the room with the broken pedestal and double click on the 
green patch on the wall. Shriash, a little Ophidian girl, is trapped in the
wall. She'll tell you what happened here, and how to make the water of
Emotion (which you'll need later). Go into combat mode and smash the broken
pedestal to free her. You'll find the fourth lodestone under the pedestal.

 Put the four lodestones on the four skinny pedestals at the water's edge.
Each one will disappear in magic stars, and the water will be turned into the
water of Emotion. If you have a bucket with you, double click on it and
click the crosshairs on the water. You'll have a bucketful of water of
Emotion. (If you don't have a bucket, you can come back for it later.)

 From here, you can hunt for Silverpate's treasure, or explore the other five
temples, or go straight to Batlin, which is your next quest.

 To find Silverpate's treasure, go north along the west side of the mountains
to 50N 40E. Behind the ruin, look for an illusionary wall in the mountain.
Follow Silverpate's map to the treasure chests -- and watch carefully for
traps and caltrops. The six chests are pickable. One has an important
artifact in it -- the blackrock serpent of balance. Be sure you find it.
You'll also find Silverpate's diary, some magic armor bits, and other loot.

 Note: I'll write about the other five temples a bit later, since you really
don't need to do them now.

 THE CITY/TEMPLE OF ORDER/BATLIN

 To find Batlin and the City of Order, you can call the Hound of Doskar again.
You'll need to go east of the mountains you're near now, to 39N 96E. 

 Once inside, an automaton speaking with Batlin's voice will attack you. Kill
it and take its arrow-shaped key, which will unlock the door to the left.
Up this corridor is a storage area with some reagents in crates. (Some of
the other dead automatons here also have arrow keys.)

 The right-hand corridor will take you to an automaton who'll ask you for a
password. There's no way to find this password, but there's a button you
can't reach near the automaton. Use Telekinesis on it, and then kill the
automaton (it has an arrow key, too).

 Go east to the button-operated doors leading north and south. Brunt will meet
you there, and will ask you to follow him. Don't -- the hallway to the south
is seriously trapped. Go north instead and walk through the illusionary wall
to the north. The dark passage goes north, east, south and then west, back
into the N/S hallway beyond the traps. Don't bother with the pirate's body;
it's trapped and has nothing useful.

 Go east at the end of the hall. The room at the east end (opened with an
arrow key), has bows and many types of magic arrows. To your left, you'll
see a trapper in a dark passage. Go back to the E/W hallway and search the
north wall near where you saw the trapper. There's a secret door, and another
dark passage leading north into the city.

 Once in the city, go to the second floor of the building just to the south.
You'll find a scroll explaining the Temple of the Order Hierophant, his Great
Library, the pedestal before the temple door, the symbols needed to open the
door, and the portal to the Great Library inside the temple.

 The Hierophant's Temple is in the center of town; the pedestal is on its east
side, near the serpent gate. To get the three objects you need for the
pedestal, go to the three meditation rooms on the city's SW, SE and NW sides.

 In the SW (Reflect on Ethicality), take any of the three scrolls; in the SE
(Meditate on Locic), take the abacus; in the NW (Examine Discipline), take
the dagger.

 In the mage's lab (on the north side), you'll find a poem that tells you even
more explicitly about the three symbols. There's also some reagents and 
potions there. There's some food in the restaurant full of rats.

 Go to the Temple's pedestal and read the plaque. When it says "Order symbol
that doth speak of principles and wisdom," put the scroll on the pedestal.
When it says "Order symbol for the strength of the mind and willpower," put
the dagger on the pedestal. When it says "Order symbol for a straight path
of truth," put the abacus on the pedestal. The temple's doors will open.

 Inside the temple, go downstairs and talk to the Hierophant's automaton.
Tell it you are the Hierophant, and it will give you the Serpent Scepter.
(There are a fire wand and a lightning wand in the nightstands.)

 Go upstairs and put the scepter on the blue pedestal, and you'll be teleported
to the Library. Read and look under all the books. One of them tells about
Hierophant funerals, which will help you later on the Isle of Crypts; one 
gives you very useful information about the symbols you'll encounter later in
the Temple of Balance; one tells you about the Ophhidians' nine temples, all
of which you'll eventually visit.

 Take the tan key on a table, and the yellow key under a red book. Unlock 
the steel doors to the NW with the yellow key. Read the book "The Structure
of Order" on the spotlighted pedestal (reading this book sets a flag).

 The tan key opens the doors to the two teleporters, both of which take you
back to the serpent gate area. 

 Northeast of the serpent gate, you'll find a door labeled "Vault of the Dead."
You can't open it until you get the key inside the Temple of Order (to the 
east). The northeast entrance to the temple is blocked; there's a magic bow 
and some magic arrows downstairs.

 Take the southeast entrance to the temple, and push the button on the
pedestal. Pothos, Batlin's gargoyle, meets you, challenges, and leaves as
the gate opens. The next room is heavily trapped, so cast Destroy Traps on
the serpent sculptures and in the center of the room. There's nothing useful
downstairs here.

 Talk to the automaton at the gate to the right of the pool of water. Say you
follow Order. Answer his test with the name of the fourth book, "The 
Structure of Order."

 Press the button at the next gate, and Deadeye will meet you. Go north up 
the hallway (which is trapped every four or five steps). You'll find a gold
door (locked) and a dead pirate. If you still have the blue-and-white key
you took from Selina at the transplanted Britannia Mint, it will unlock this
door (and the back entrance/exit from the temple).

 If you don't have that key, take the pirate's red-and-blue key and go back to
the city. His key will unlock the Vault of the Dead. Beyond the corpses,
go through the tall wooden door onto the green carpet. It's an elevator,
operated by a green button on its north edge. Go up, east across a bridge,
and down the steps. The gold door to the north is the back entrance/exit. 
Continue east to another tall wooden door. Go north, and through the next 
wooden door.

 You'll come out in the temple's antechamber, and will be attacked by Batlin's
four henchmen, including Selina. They're hard to kill, but you have to get
them all. Be sure to search Selina's body. She has a Dispel Field scroll,
which you'll need later (put it in your spellbook immediately). She also
has a blink ring.

 Note: At this point, check your companions' inventory. You're going to lose
them in a few minutes (temporarily), and although they'll leave their stuff
on the floor, you'll have a mess to sort out if they have any small items
such as keys or food. If you can't carry those kinds of items yourself, just
leave them on the floor somewhere. They won't go anywhere.

 Go through the big wooden doors into the temple's inner sanctum. On the left
side, you'll find a gold key that's useless, a Create Automaton spell, a gray
key that opens one of the chests, a trapped chest (empty), and an untrapped
chest with some cold potions. On the right side, you'll find a Fire Snake
scroll, some potions, and some powder kegs.

 Up the middle, you'll find Batlin, trying his best to open the Wall of Lights.
You'll be frozen in place in a cut scene, so don't bother trying to do
anything until it's over. Batlin will fail to open the Wall, and the Guardian
will kill him. When he dies, the Banes of Chaos will get loose and will take
over your companions' bodies. Shamino will say "I am Anarchy." Dupre will
say "I am Wantonness." And Iolo will say "I am Insanity." Then they'll 
vanish, leaving all their possessions on the floor.

 At this point, the Earth Serpent will tell you to seek the gwani horn. It's
in Vasculio's house back in Chaos, and you now have the Dispel Field spell
needed to free it.

 Before you go, search Batlin's body and take the blackrock Chaos Serpent and
the serpent jawbone. His yellow key seems to be useless. Note the slot in 
the floor -- it's facing the other way from Batlin's serpent. He was trying 
to use the Chaos Serpent in the Temple of Order, which was why he failed.

 Batlin's jawbone has six teeth in it. They are: #3 Chaos; #4 Order; #5
Temple of Discipline; #10 Sleeping Bull; #14 Temple of Enthusiasm; and #18
Temple of Logic. Put these teeth in your jawbone, and you can now gate to
any of these locations.

 If you go out the back entrance, you'll find two trapped chests behind a blue
fire-field wall. They hold some magic scrolls and a lightning whip. There's
also a powder keg and some serpent arrows hereabouts. Look for a winding 
dark passage behind an illusionary wall west of the post in the NW corner
of the cavern. It takes you out of the temple at about 67N 123E

 FREEING GWENNO

 From here, head back to the City of Chaos and cast Dispel Field to get the
gwani horn. The Earth Serpent will tell you to "Free Gwenno. Free her from
the ice."

 Go north and pick up the gwani ice raft again. You're heading to an island
that's at about 91N 52W, but you'll need to go north and then west to get
around the ice floes. Gwenno's tomb (an ice obelisk) is in the center of the
farthest-west ice cavern. Use the horn to shatter the ice. You can call the
monks to resurrect Gwenno where she is, or you can carry her body back to
Monk Isle yourself. If you call the monks, Gwenno will be back at Monk Isle
when you get there.

 After you've gotten Gwenno resurrected, the Earth Serpent will tell you that
one of the Chaos banes has twisted her soul. Indeed, if you try to talk to
her, you'll discover that she's nutty as a fruitcake. Talk to Karnax (the
head monk) and ask him about the Banes of Chaos. He'll send you to find
Fedabiblio and the original Serpent Scroll. Bring it to Karnax, and he'll
be able to help you cure Gwenno.

 BACK TO MOONSHADE

 When you return to Moonshade, you'll find that Shamino the Anarch, driven by
his Chaos Bane, has devastated the place. Almost everyone is dead, and wild
beasties are roaming the streets.

 Find Andrio and Freli, Fedabiblio's students. Andrio will tell you that
Fedabiblio has been turned into a statue, and that Torrissio's wand may be
the way to release him. Freli will tell you that the Serpent Scroll is in
the Seminarium library, but that only Fedabiblio can get it for you.

 Go to the Seminarium and use the green wand you got from Vasculio's house on
Fedabiblio. (DON'T ask Torrissio about it -- he'll take it away from you
and you'll have to use Vibrate to get it back from him.)

 Note: Somewhere near the Seminarium, you'll find Gustacio's body. He has a
scroll from Melino that talks about your blackrock sword's ability to contain
bound spirits -- like banes, f'rinstance.

 Talk to Fedabiblio. He'll tell you what happened in Moonshade. He'll also
give you the green key to Hawk's chest at the inn. (You already have Hawk's
treasure, including the serpent crown, so don't bother looking for it.)
He'll also tell you that Stefano is still alive, but is being pursued by
a monster of some sort (you'll need to rescue him). And he'll tell you that
Torrissio and Ducio are still alive (you'll need help from both of them).
Finally, he'll suggest that you search the dead mages' houses for useful
items like scrolls and serpent teeth.

 He'll give you the Serpent Scroll. Use Translate to read it. It's by
Ssithnos, the last Chaos Hierophant, and it's the original of the translated
fragment you found at the very beginning of the game. It tells about balance
and the forces of Chaos and Order, and it should make more sense to you now
than the fragment did. Make a few notes: you'll need this information later.

 You need to go back to Monk Island, but it's probably a good idea to explore
the devastated Moonshade and look for more serpents' teeth. You'll find
the #2 tooth (Temple of Emotion) in a brass chest in Torrissio's house. While
you're there, you can reanimate the two broken automatons in Torrissio's lab
if you haven't already done so. They're good for carrying stuff, and can
fight a bit if you give them good weapons.

 Note: When you've added the automatons to your party, you might want to go
back to the Temple of Order and pick up your companions' stuff. The
automatons can use it until you get your companions back, and they can 
easily carry it all. If you need to ask your automatons to leave your party
for any reason before you get your companions back, try casting Serpent Bond
and just slithering away from them. They'll stay where you leave them until
you talk to them again. If you just ask them to leave, they'll dump all their
possessions into your inventory and on the ground, creating a gawdawful mess.

 Note: Petra's still alive at the Blue Boar Inn, but she won't offer to join
your party until you've been to the Temple of Discipline and seen the acid.

 Tooth #17 (Temple of Ethicality) is in a brass chest in Gustacio's basement.
There are duplicate teeth (#8 and #9) to the ones you got from Vasculio's
house in Frigidazzi's house and Filbercio's palace. Since you don't need
them, don't bother to get them.

 CURING GWENNO

 Go back to Monk Isle and talk to Karnax again. He'll take the scroll and tell
you about the six Chaos/Order virtues and their anti-virtues, which take over
when there's no balance. You should recognize three of them as the banes
that have taken over your companions, even though the first one is listed as
"amorality" instead of "anarchy." (It's a text error, not a legitimate clue.)

 He'll make you a chart of this information, and will tell you that a lack of
the virtue Discipline has produced Wantonness in Gwenno. To cure her, he'll
say, have the victim drink the water from the temple dedicated to the virtue
that the person lacks. (This is the same process you'll need to use to cure
your companions later in the game.)

 Now, you'll need to go to the Temple of Discipline to get water for Gwenno.
Take two empty buckets, by the way -- you'll need another bucketful for Dupre.
To get there, use the serpent gate. From serpent central, use the east gate
off the NE corridor. (The temple's coordinates on the ground are 44N 86E.)

 TEMPLE OF DISCIPLINE

 Once inside the temple, cast Destroy Traps on the altar. Talk to the
automaton in the NE room. It'll speak in fragments, but the gist of what it's
saying is that only an automaton can get through the acid that leads to the
water of Discipline. Don't bother with the force field blocking the entrance
to the bane-jail room. The jail's empty.

 Go down the stairs on the left. In the south room downstairs, find the secret 
door in the tomb wall. Inside the tomb, pick open the invisible chest and get 
the brown key. Go back to the main floor. 

 Press the button on the right wall, and the door to the right-hand stairs up
will open. Go up the right-hand stairs. Find the secret door that opens the
room to the south. Get the arrow key and the obsidian Y in the desk. Unlock
the room to the north with the brown key. Take the quartz Y in the brass
chest. In the center room, the invisible chest holds serpent arrows.

 Go back to the main floor and push the button on the left wall. It will open
the left-hand stairs up. Go upstairs. The room to the north has some empty
buckets. In the center room to the south, read the books: one tells about
body transference, one explains about the test of discipline, and one tells
how to use the Y-shaped keys with the slots on the altar to open a bridge to
the water of Discipline.

 Go back to the main floor. Put the quartz Y in the left-hand altar slot, and
the obsidian Y in the right-hand slot. Now, despite what the book said,
swap the positions of the Y pieces. When you put the obsidian Y in the left
slot, a bridge leading to the stairs behind the serpent statue should appear.

 Go down the serpent stairs and unlock the south room with the arrow key. Take
the blue key from the chest, and unlock the door to the north. Take one step
inside that door, and you'll discover the acid. Go back out to the serpent
gate and head for Moonshade.

 Note: You can make it through the acid yourself if you cast Vas Mani every 
few steps, but you'll miss setting a flag and an interesting bit of business.

 Once in Moonshade, head for the Blue Boar Inn and talk to Petra. She should
now have 'acid' as a keyword. Ask her about acid, and she'll join your party.

 Note: Petra's a pretty good fighter if you give her a good weapon, and she's 
trainable. When she has a few training points, go to the Sleeping Bull and 
look for Wilfred, the only survivor. He'll train you and Petra, and your 
companions (when you get them back). He'll also join your party, but he'll 
leave you high and dry if he gets hurt.

 Go back to the Temple of Discipline and enter the body transference room.
Talk to Petra, and she'll get on the left-hand platform. Press the button;
your avatar will get on the right-hand platform and the transference will
proceed. DON'T talk to Petra after you've swapped bodies, or she'll follow
you through the acid wearing YOUR body. Go downstairs, walk through the acid,
and get TWO bucketfuls of water of Discipline. Walk back through the acid
and go back to the transference room. Now, talk to Petra and she'll follow
you again. You'll be hit by lightning, and you'll have your own body back.

 Go back to Monk Isle and use the water of Discipline on Gwenno. (Double click
on the bucket and click the crosshairs on Gwenno.)  Now that she's cured,  
she'll have a lot to say. Most important, she'll tell you that you have to
cage the banes again before you can restore balance. Go to Moonshade, she'll
say, and find out who gave Batlin the secret of trapping souls.

 MAKING BANE CAGES

 Go to Moonshade and find Torrissio (he'll probably be in Filbercio's palace).
He'll tell you that Batlin bought the spell you're seeking, too, but that
the soul prisms it makes are not strong enough to contain souls of great
power. He wants his wand as the price for the spell. Give it to him, and
he'll stop talking to you. Talk to him again, and he'll give you the Soul
Prism spell. He'll tell you to seek out Ducio for the worm gems you'll need
to make the soul prisms. If you ask him about Stefano, he'll tell you that
he plans to have him killed for messing up his affair with the late Columna.

 Go to Ducio's workshop and ask him about Worm Gems. He'll make one for you if
you have some worm hearts (you'll need nine, altogether). Since you need
three Soul Prisms, you'll need to ask three times about the Worm Gems. Now,
transcribe Torrissio's Soul Prism spell into your spellbook, and cast it on
each of the worm gems. The gems will change from round to diamond-shaped,
and will now ID as empty soul prisms.

 From here, go back to Monk Island and talk to Gwenno again. She'll tell you
that to make the prisms strong enough, you need to bathe the prisms in the
waters that are connected to the banes (Emotion, Enthusiasm, and Tolerance).
She'll also tell you about the devices in each of these temples that will
show you the banes' current location.

 If you already have the water of Emotion, you won't need to go back to that
temple. To bathe a prism, double click on the bucket and click the crosshairs
on the prism. If you're using the water of Emotion, the prism you bathe in
it will turn blue.

 TEMPLE OF ENTHUSIASM

 Take the serpent gate to the Temple of Enthusiasm (SW corridor, W gate, or by
land, 81N 143E).

 Enthusiasm has a nasty little maze inside. Don't bother trying to get to the
brass chest. All it holds are some old boots. Go to the farthest NW corner,
and walk around and up the stairs. Then go to the third floor, and down the
stairs in the SW corner. Turn right and go under the overhang to find
another stairs down.

 In the west end of the black-and-red checkerboard area, get the gold key from
the brass chest. Use it to unlock the door to the north. The wand in the
chest is useless, as far as I can tell.

 In the library, most of the books contain useful information. One is by the
brother of a fellow named Sethys, whom you'll meet later. It says Sethys has
the key to the altar of Tolerance, and that the Great Chaos Hierophant
(Ssithnos) was killed in the garden here. Another one talks about magic
candles, and gives you a few hints about the Temple of Balance. The Scepter
of Enlightenment also has no use that I could discern.

 Go to the well. Double click on a bucket and click the crosshairs on the
dark center of the well. You'll get a bucketful of water of Enthusiasm.
Bathe another of your prisms in the water, and it'll turn red.

 While you're here, look in the Lens. It's one of the three devices Gwenno
spoke of, and it will show the banes plotting more mayhem in the White
Dragon King's castle. The other two devices (Moon's Eye and Web) will now
show you nothing but stars and planets.

 You can walk to the Temple of Tolerance from here, but your best bet is to go
back to Moonshade and save Stefano, who'll give you the Tolerance tooth.

 SAVING STEFANO

 Stefano's in his house, hiding from the Death Knight that Torrissio and
Columna sicced on him. He'll join you without being asked, and will tell you
the whole sordid tale. If you kill the Death Knight, he says, you can have
his most prized possession (your blackrock Order serpent, which got swapped 
for Columna's stockings). He'll give you tooth #17 (Temple of Tolerance) for
letting him stay with you.

 When the Death Knight appears, kill him. Talk to Stefano again, and he'll 
give you the tan key to his vault, which is behind his old house west of town.
Take the west road out of the city. Go west from the steps to 82S 100E.
Open the vault with the tan key and get your blackrock Order serpent.

 The key to Stef's house is in the hollow tree out front. The house is 
trapped, and contains some magic scrolls, some burst arrows, a crossbow, some
money and some food.

 TEMPLE OF TOLERANCE

 Now, gate to the Temple of Tolerance (SW corridor, S gate, 61N 64E). You'll
find another old friend inside -- Mortegro, the necromage, who was hit by
lightning and swapped for an odd pedestal in Gustacio's basement.

 Talk to Morty, who'll tell you that he'll teach you his best spells if you
get him out. Most important, he'll offer you Summon Shade, which will allow
you to talk to the shade of a dead person as long as you have something the
person valued in life.

 Go to the NE corner of the temple and cast Telekinesis on the winch; that will
lower the drawbridge to Morty's island. Now, open a secret door in the wall
to your south, and another next to the drawbridge. Walk to Morty's island and
talk to him again. He'll give you the Summon Shade scroll, and he'll offer to 
sell you any of his other spells at half price. He'll also ask to go with
you back to Moonshade. If you have room, take him along for a while. But
note that as soon as you step outside the temple, he'll get zapped by 
lightning again, and will be gone for the rest of the game. If you don't
have room in your party, that's OK too. There's no penalty for leaving him.

 Go to the farthest-west room in the temple and get the gold key. Now, go
downstairs and open the locked gate with the gold key. Go to the cell
farthest south, and you'll meet Sethys, who's been locked up here for many
hundreds of years, sustained by the temple's power. Unlock his cell with the
gold key and talk to him. He'll tell you that the key to the temple's altar
was stolen by a rat, which fled down the small hole in his cell. He'll also
tell you that the water of Tolerance flows from the altar if you put a sacred 
container on it.

 Cast Serpent Bond and you'll be transformed into a snake. Go through the
rathole and into the treasure room. Pull the lever to open the door. Take
the gold key. It opens the winch room, so you really don't need it -- but
something in this sequence sets a flag, so you're better off taking it and
dropping it somewhere. You'll be zapped back to your own body as soon as
you leave the treasure room.

 Now, go back to Moonshade to get the water of Tolerance. (Remember, Morty
will get zapped when you leave the temple, so don't take him outside if you 
haven't bought all the spells you need from him.)

 Go to Gustacio's basement and put an empty bucket on the pedestal (altar).
You'll get magic stars, and a bucketful of water of Tolerance. Bathe your
last prism in it, and it'll turn blue. You now have a full set of treated
bane cages, ready to hold the three banes.

 BANE CATCHING/WHITE DRAGON KING'S CASTLE

 Go to the White Dragon King's castle. (It's the big one just north of the
swamp; you can gate to the nearby forest area from the last gate to the south 
on the eastern corridor.)  The main doors should be unlocked now. You'll
meet some hostile jesters outside, and will find a scroll that invites you to
"come in and join the party." Inside the door, the king's ghost will conjure
a dragon to attack you.

 Go through the double doors and to the right. Open the unlocked door to the
mirror room. Iolo will conjure a roomful of avatars to attack you. Look for
a secret door in the east wall. Use it to enter the lab to the east. Get 
the corpse's gold key, which will unlock the lab door.

 Go back to the entrance hall, up the left stairs, and down into the music
room. Iolo will conjure some ghosts. Take the gray key under the panpipes
on the table. Go back up the stairs to the entrance hall.

 Go north to the library (first door on the right). Unlock the door with your
gold key. Don't read the books -- they explode. Go up the stairs, across
the hall, and down into the trophy room. Shamino will conjure a nightmare.
Take the gold, glowing key in the desk drawer.

 Go back upstairs and down the left-hand stairs into the diamond-floor room.
Iolo will conjure headlesses. Go to the SE corner of the room and pick the
lock on the pantry door. Iolo will conjure a ghost. Open the secret door in
the north wall and enter the dining room. Shamino will attack with gremlins.
Take the antique-looking key under a plate on the table and use it to unlock
the dining room door.

 Go back to the entrance hall, and to the left end of the hallway. Unlock the
door to the spinning-wheel room with the gold glowing key. It's trapped, so
throw a few Destroy Traps spells ahead of you. Look for a lever behind the
bales of wool. Pull it to open a secret door to the west.

 Go west and through the illusion wall under the stairs. Take the green
glowing key from the chest. Unlock the door to the north with the gray key.
This room (Iolo's shooting gallery) is heavily trapped. Pull the lever on
the NW corner of the carpet, and go north.

 In this room, Dupre will conjure harpies. Unlock the door to the hallway with
the antique-looking key. Pick the door at the NW end of the hallway (the
nursery). Take the blue key in the dresser.

 Now, go downstairs. Open the first bedroom door on the left with the blue
key. Open the secret door in the west wall. It leads into an outer hallway
that goes around the area, but there are some locked doors blocking your way.

 Go back into the main hallway. Look in the second bedroom on the left, and
cast Telekinesis on the lever next to the clock. Now, go back into the 
secret outer hallway and follow it around to the north, east and south.

 About halfway down the eastern side is another lever. Pull it and enter the
second bedroom on the right. Go on into the first bedroom on the right and
take the purple key in the dresser. Unlock the bedroom door with the purple
key, and then the door at the south end of the hall.

 Open the unlocked torture room door and pull the lever in the middle of the
right side. Now, go back into the outer hallway. You should now be able to
get into the purple-carpeted royal bedroom on the lower right side. The door
to the south is unlocked, and will take you into the banes' throne room.

 This room is heavily trapped, so cast a few Destroy Traps on the statues.
As you get near the thrones at the west end, the banes will ignite a bunch
of fire-field spells. You may want to cast Dispel Field a few times to clear
some working room for yourself. Don't worry if you run out of mana -- you
won't need any to capture the banes.

 Walk toward the thrones and the banes will challenge you. Double click on the
blackrock sword and click the crosshairs on one of the banes -- instant death.
Do this twice more, and the banes will be gone from your companions' bodies.
They will have moved into your blackrock sword, which the flux analyzer tuned
to contain them temporarily. Double click on a soul prism and click the
crosshairs on the sword. The appropriate bane will be transferred to the
prism, which will be surrounded by a wavy gray halo that indicates the bane is 
inside. Do this twice more, and you'll have the banes all safely put away.

 Your companions, however, are bleedin' demised. As with Gwenno, you can
call the monks to resurrect them, or you can carry their bodies back to Monk
Isle. I strongly recommend that you take them to Monk Isle -- several players
have reported nasty bugs cropping up when the monks are called to the castle.

 When you get to Monk Isle, ask Karnax to resurrect your friends. They'll be
off their noggins, too, so you'll have to get the appropriate temple waters
to cure them. If you got two buckets of water of Discipline while you were
there, use the remaining one on Dupre. You'll need to get the water of
Logic to help Iolo, and the water of Ethicality to help Shamino.

 TEMPLE OF LOGIC

 Go to the Temple of Logic (SE corridor, E gate, 23N 64E). If you travel by
serpent gate, you'll find yourself in a dragon cave. The first dragon you'll
see is dead; but when you go west from the gate, you'll soon find a live one.

 Work your way north until your way is blocked by several ice obelisks. Each
one has a body inside. Go into combat mode and whack them until the bodies
are freed. Among their possessions -- food, non-magical arms and armor, and
a blue book that contains two logic problems. Solve them, and you'll know
how to get into the Temple of Logic.

 You'll find a set of four teleporters nearby, each one flashing a different
color of light. They're arranged as follows:

                 Blue             Yellow

                 Red              White

 The solution to the book's first logic problem will tell you to step on the
teleporters in the following sequence: Red/Yellow/Blue/Red/White. When you
finish the sequence, you'll be teleported to the temple door. Solve the
second logic problem, and you'll know how to place the runes on the floor in
front of the gate. The correct sequence is: B/C/O/W.

 The gate will open, and you'll meet the temple's automatons. They'll tell
you that one of them killed another (#7) and stole the key to the fountain
room. You must determine who killed #7 and accuse him. Talk to all six
automatons and write down their statements about where and who they were with
when #7 was killed. Compare the stories, and you'll see that #4's story is
not substantiated by any of the others. He's the culprit.

 When you accuse #4, he'll confess, give you the key, and then attack you.
The key unlocks the doors to the water of Logic. Use a bucket on the basin
to get the water.

 You don't really have to do the coin puzzle, but if you want the solution,
put the farthest left coin on TOP of the coin that's in the center of the
two intersecting rows.

 TEMPLE OF ETHICALITY

 Now, go to the Temple of Ethicality (SE corridor, S gate, 29N 133E). The
upper temple is ruined, so look for a stairway down just to the right of the
ice serpent statue.

 Almost all the corpses in the cubicles have scrolls or books. Read them, and
they'll tell you all about the virtue of Ethicality. You'll find  a serpent
rug at the east end of the hallway. Click on it and you'll learn that it's
a meditation mat. Double click on it, and you'll be teleported to the
"educator," an automaton that administers the temple's test of Ethicality.

 He'll ask you three questions: (1) would you risk death to save a doomed
person: answer YES; (2) would you take wealth you found without knowing the
owner: answer NO; (3) would you yield to an unethical man if you were facing
death at his hands: answer NO.

 When you answer all three questions correctly, you'll be teleported to the
Ethicality test itself. You'll have only a gem, a gold bar, and some gold
coins with you. In your first test, you'll enter a room in which you'll see 
a man being engulfed in flames. Walk into the flames and push the button on 
the pillar to save the man.

 Next, you'll be teleported to a long hallway. Don't take anything, no matter
how attractive the loot looks. When you reach a gold pedestal, put your gem, 
coins and gold bar on it. Walk to the end of the hall and push the button.

 In the last test, you'll face Batlin in battle and will be defeated. Batlin
will ask you to yield. Don't yield -- let him kill you. You'll be teleported
back to your companions.

 Check your inventory and go back upstairs. Go to the basin at the north end 
of the waterway and use a bucket to get the water of Ethicality.

 CURING YOUR COMPANIONS/XENKA'S RETURN

 Go back to Monk Isle and use the water of Logic on Iolo and the water of
Ethicality on Shamino. With the last cure, there will be a great uproar among
the monks, and Xenka, their lost prophetess, will return.

 Talk to Xenka, and she'll tell you to journey north and speak to the remaining
gwani. She'll also give you a serpent tooth (#7, Isle of Crypts), and will
tell you to seek the dead on the Isle of Crypts.
 
 Before you go on, replace your automaton party with your cured companions.
If you've retrieved your companions' items from the Temple of Order and given
them to your automatons, swap party members one at a time, transferring items
as you go. If you dismiss all three automatons at once, you'll have a nasty
mess of items on the floor.

 HAZARD THE TRAPPER

 Go north again and talk to the surviving gwani. Yenani will tell you that
nearly all the gwani were killed by Hazard the Trapper. She'll ask you to
retrieve an amulet once owned by their healer and stolen by Hazard.

 Go north to Hazard's cave at 59N 25E. His door, which has been locked until
now, is unlocked. Talk to Hazard, who will refuse to stop killing the gwani
and will attack you. Kill him and take his red key. In the northern area of
his cave, you'll find some loot and a brass chest. Unlock the chest with
the red key and take the gwani amulet and your glass sword.

 Take the amulet back to Yenani and give it to her. In return, she'll give
you serpent tooth #1, which goes to the Temple of Balance.

 ISLE OF CRYPTS

 Now, use Xenka's serpent tooth and go to the Isle of Crypts.

 There's an impassable teleport trap in the northern corridor, so take the
southern corridor to the meditation room. A sign will tell you to put your
offerings on the altar table. Put any of your blackrock serpents on the
table, and a door to the south will open. Pick the brass chest to get a
juggernaut hammer.

 Take your blackrock serpent and continue north and west from the meditation
room. Read the book in the next crypt -- it tells about Sunrise Isle and the
Temple of Balance. Go west to an area with four crypts. Press the button on
the west wall to open a door to the north. Signs in this secret room tell
you "To Continue in Balance, Stand Here." Stand near the north wall, and if
you have the balance serpent in your inventory, you'll be teleported to the
NE corner of the crypts, beyond the hallway with the teleport trap.

 Go west along the "Path of Serpents." A corpse nearby has some reagents. At 
the gold doors, press the button on the north wall. The next room is heavily 
trapped, so cast Destroy Traps in each corner. You'll find a gold serpent on 
a pedestal and another empty pedestal. A sign reads "Balance is Wisdom."

 Don't touch the gold serpent. Go on through the south door, and follow the
serpent path to another tomb with a mummy walking around inside. Open the
secret door in the tomb's south side and let the mummy out. Cast Vibrate on
him, or kill him, and take the scroll he's carrying.

 Read the scroll and it will tell you that it IS wisdom, and is thus the 
balance for the gold serpent. Take it back to the scale room and put it on
the empty pedestal. You'll be teleported to a square room with many ruined
books and one whole one on a pedestal. Read the book on the pedestal (it
tells how the last Ophidians left Serpent Isle) and you'll be teleported to
a hallway just east of two large serpent statues. Fight the skeleton dragon
and go west into the shrine.

 Cast Dispel Field to get the Chaos Serpent eye. Press the button near the 
Chaos serpent statue, and find the secret door in the wall behind the statue. 
Go north into a short hallway and step onto the teleporter to the right. 

 You'll be teleported to a large crypt with a tomb on a raised platform. Use
the secret door to open the tomb, and then open the coffin. Cast Summon Shade
on the mummy, and you'll find yourself speaking to the last Great Hierophant.
He'll tell you to restore the land to balance. If you don't have all three 
pieces of the Great Hierophant's regalia (staff, crown, and armor), he'll
tell you where to find them. (Since we haven't gone to find the serpent
armor yet, he tells us to "ease the troubled heart of Love - she who was once
Beauty itself. Thus, a trip to Fawn is in order shortly.)

 He'll also tell you how the War of Imbalance started in the first place, and
he'll send you on a quest to unite the Chaos serpent. You'll need to find
the Chaos Hierophant (Ssithnos) to learn how to do this, but he doesn't know
where his remains lie.

 When you unite the Chaos serpent, he'll say, go to the Grand Shrine of Balance
to complete your work.

 FINDING THE SERPENT ARMOR

 Go to Fawn. You'll find Zulith's body just inside the gatehouse. He has a
scroll that tells of Iolo's attack. It also tells you where to find the 
treasure room, and that you'll need to find Yelinda in the Gorlab Swamp to 
get the key.

 Look for Ruggs in the city. He's the only survivor, and he'll tell you that
Yelinda left her diamond necklace in the throne room. Get the necklace and
leave Fawn. Call the Hound of Doskar and let him sniff Yelinda's necklace.
He'll lead you to her in the swamp.

 Yelinda is in desperate shape, having been tortured by anti-Iolo. She'll
ask for the Comb of Beauty that Columna stole from her. Give it to her, and
she'll give you the key to the treasury. A monk will come to care for her.

 Go back to the city and find a tiny room in the SE corner of the throne room.
Walk north, through an illusionary wall, and you'll be in the treasure vault.
Open the gate with Yelinda's antique-looking key. In the chests, you'll find
the serpent armor -- along with an infinity bow and a considerable store of
magic weapons, armor pieces, furs, and other valuables.

 HOUSE OF WARES

 While you're in the neighborhood, you might want to drop by the House of
Wares (in the woods at 77S 28W). Open the door with the antique-looking key
you got from Gannt's tomb. You'll find... well, I'll let you do that for
yourself <ggg>.

 FINDING SSITHNOS

 Go back to the Temple of Tolerance and have another chat with Sethys. He'll
tell you that he knows where the master lies, and can go to the Temple of
Enthusiasm briefly, even though he's unimaginably old. Let him join your
party and head for the serpent gate. Sethys will die of old age as soon as
he leaves the temple, but he'll tell you to take the serpent stone from his
body, and to look for Ssithnos' body in the garden at Enthusiasm.

 Take the blue serpent eye and go to the Temple of Enthusiasm. You'll find
Ssithnos' corpse in the NE corner of the garden, near the serpent gate. Cast
Summon Shade, and he'll tell you all about uniting the Chaos serpent. He'll
tell you the exact same things his curious twins did in the ruined powder
mill on the mainland, and he'll give you a copy of the same scroll. And he'll
mention the unknown binding force you'll need to complete the ceremony. Then
he'll disappear into the void.
 
 THE SACRIFICE

 Go back to Monk Isle and talk to Xenka again. She should now have a keyword
'sacrifice.'  Ask her about the sacrifice, and she'll tell you that things
have now gone too far out of balance, and that only the sacrifice of one who
is in balance can put things right again. After drawing straws, you're
elected to be the sacrifice.

 Go to the crematorium in Monitor, step onto the cremation machine, and pull
the lever. Dupre will intervene and will sacrifice himself in your place.
Pick up Dupre's items from the top of the machine, and his ashes from the
machine's conveyor belt.

 Go back to Monk Isle and talk to Xenka again. She'll tell you to take Dupre's
ashes to the Chaos Shrine under Skullcrusher. Ask her about your 'final 
task,'  and she'll give you a gold Ophidian sword. Go to Sunrise Isle (the
Temple of Balance), she'll say.

 Stop by the library and pick up Gwenno. She'll join your party now, and will
put Dupre's arms and armor to good use.

 UNITING THE CHAOS SERPENT

 Now, go back to the City of Chaos. If you haven't blown open the northern
double doors in the temple entrance, do so now. Work your way to the NE
corner and take the stairs down to the dungeon level one. Now, work your way
to the SE corner and take the stairs down to the dungeon level two. Head for
the SW corner of this level and take the stairs up two levels.

 Follow the hallways to the SW until you come to another set of double golden
doors. Open them and go in to the Grand Shrine of Chaos. Search the back
wall carefully, and you'll find a secret door. Go through into the shrine's
inner sanctum.

 Follow Ssithnos' instructions to perform the ceremony. Put the blackrock
Chaos serpent into the slot on the table, and the Wall of Lights will open.
Put each bane (soul prism) on its proper pedestal (madness/emotion;
wantonness/enthusiasm; anarchy/tolerance). Each will disappear in flames.
Finally, put Dupre's ashes on the fourth pedestal. You'll see four big
explosions, and then Dupre will speak. He says his soul is now fused with
the Chaos serpent, which he's holding back. He says to go quickly to the
Temple of Balance. Xenka may or may not appear, saying the same thing.

 Get your blackrock Chaos serpent and head back for the serpent gate.

 TEMPLE OF BALANCE

 Take the last path (due north) from serpent central to the Temple of Balance.
Walk under the serpent gate and read the book you find there. Pick up the
two red serpents and the two blue serpents in the room's corners. Put one
red (Chaos) and one blue (Order) serpent on the scales at the north and south
entrances. Six symbols of the Chaos and Order virtues will appear on the
six red and blue pedestals, and the doors will be unlocked. Take the six
symbols and go out either door.

 Go west along the rocky walkways, and you'll find a book that will explain
how to balance the six virtues of Chaos and Order. It works like this:

   Tolerance (chain) balances Ethicality (torch)
   Emotion (heart) balances Logic (abacus)
   Enthusiasm (rose) balances Discipline (dagger)

 Walk along the rocky pathways until you've found all six virtue shrines. At
each shrine, place the BALANCING symbol on the pedestal, not the symbol that
matches the sign. Each time you place a symbol correctly, you'll see magic
stars and your avatar will say "That did it!" If you place one incorrectly,
you'll see lightning instead, and may also be attacked. After you've placed
the sixth symbol correctly, a book will appear in its place on the pedestal.
The book will advise you to stand between the pillars and read its words.

 Note: You can't go back once you've done the next step here. If you don't
have everything you need (three blackrock serpents, serpent crown, armor and
staff, Chaos serpent eye, serpent ring, necklace and earrings) go back and
get them before proceeding.

 Go back to the room with the serpent gate. You'll find the pillars on its
north edge. Stand between the pillars and "use" the book. Walk north across
the ice bridge that forms from the pillars. Stand between the next set of
pillars and read the book again. Walk north across the fire bridge, and open
the big wooden doors.

 You'll see a red pedestal with a sign saying "Symbol of Chaos" and a blue
pedestal with a sign saying "Symbol of Order." To get the items for these
pedestals, go to the farthest-west room. Get the green key on the table.
Cast Dispel Field on the brass chest and open it with the green key. You'll
find an infinity bow, some magic scrolls, and a book. Read the book: it tells
you what to do to open the gold double doors.

 Now, go to the eastern-most room and unlock the brass chest with the green key
Take a serpent candle and go back west to the ice altar room. There's a
pedestal with a sign saying "fire balances ice." Put the serpent candle on
the pedestal and the ice wall will melt, leaving large chunks of ice. Take
one of the ice chunks; walk forward and take the ice gem.

 Go east to the fire altar room. Put the chunk of ice on the red pedestal, and 
a black walkway will form over the lava. Walk forward and get the fire gem.

 Go back to the golden doors and put the fire gem on the red pedestal and the
ice gem on the blue pedestal. The golden doors will open.

 In the next room, you'll find a starry void, and near the wooden doors, a
pedestal that says "Place here the cubes of both Chaos and Order."

 To get the cubes, you'll have to work a button-and-teleport puzzle in the
buildings to your right and left. Here's a diagram of the puzzle:

  B = button      G = gate      D = door     T = teleport    K = key

  Note: Buttons and gates without numbers need not be used; it's also not
        necessary to use the secret door on the right, or the T2 teleports
        if you can cast Telekinesis

      2nd Floor Left                               2nd Floor Right
     |------------------|                          |------------------|
     | B4        B1     |                          |                  |
     |------G3------|   |                          | st dn            |
     |              | st|                          |                  |
     |     rose     | dn|                          |                  |
     |              |                              |-----------D1-----|
     |------G4------|                              |                  |
     | ch        ch |                              | B3               |
     | K1           |                              |      abacus      |
     |              |                              |                  |
     |------G-------|                              |                  |
     | T2        T2 |                              |-------G2---------|
     |              |                              | T1           T1  |
     |-----trap-----|                              |                  |
     |              |                              | B    chain       |
     | B5  torch    |                              |                  |
     |--------------|                              |------------------|

      1st Floor Left                                1st Floor Right
     |------------------|                          |-----|------------|
     | B2               |illusionary               | T2  |         T2 |
     |------G1------|   |wall                      |--SD-|            |
     | T1        T1 |   |                          |st up             |
     |              |st |                          | B                |
     |------G5------|up |                          |--------G6--------|
     |              |   |                          | B              B |
     |    heart     |                              |                  |
     | B6           |                              | ch   dagger      |
     |------D2------|                              | K2               |
     |              |                              |--------D3--------|
     | cubes of ice |                              |                  |
     |              |                              |  cubes of fire   |
     |   ch/K3      |                              | B                |
     |--------------|                              |------------------|

 To solve the puzzle: Go up the left stairs and press B1 (opens G1);  go
downstairs and walk through the illusionary wall; press B2 (opens G2); go 
through G1 and cast Telekinesis on B6 (opens G6); take T1 to the right side;
go north through G2 and press B3 (opens G3);  take T1 back to the left side;
go back out through the illusionary wall; go upstairs and press B4 (opens
G4); go through G3 and G4, open the chest on the left and take K1; cast
Telekinesis on B5 (opens G5); go back downstairs and take T1 to the right 
side; open D1 with K1 and go downstairs; go through G6, cast Destroy Traps on 
the brass chest, and take K2; go back upstairs and take T1 to the left side;
go through G5 and open D2 with K2; take two cubes of ice, cast Destroy Traps
on the brass chest, and take K3;  Take T1 to the right side; go through G6
and open D3 with K3; take two cubes of fire; go back upstairs and take T1 to
the left side; go back through the illusionary wall.

 Put two cubes of ice and two cubes of fire on the pedestal, and a bridge will
appear across the starry void. Put on the serpent armor and crown, and carry 
the serpent staff. Walk to the next-to-top step of the bridge and take the 
scroll. Read it: it will tell you what you need to complete the next step.

 Now, step on the top step and you'll be teleported to a new location. The 
Earth Serpent will tell you to put the staff, crown and armor on the altar.
Walk north and up the steps; place the three items on the gold table.

 You'll learn that you're in balance and worthy to bear the emblems of the
Great Hierophant. The Order Serpent eye (and the three serpent artifacts)
are now in your inventory, and the wooden doors are now open.

 You'll be teleported back to your companions; you can put your own armor back
on now, and can carry the weapon of your choice.

 Go through the wooden doors. There are some magic scrolls and an infinity
bow on the left and right sides of this room, but the main action is up the
middle. As soon as you cross the stone steps, the Order Serpent will
challenge you with a group of ice creatures. When you've killed them, put
away your own weapon and carry Xenka's Ophidian sword.

 Walk north and put the three blackrock serpents into their slots. Your
avatar will walk forward and open the Wall of Lights. Now, place the Chaos
and Order serpent eyes on the altar before the Earth Serpent statue. The
serpent will command you to slay him with the serpent sword. Go into combat
mode and double click on the serpent statue. The serpent will collapse and
your avatar will disappear into the void.

 In the endgame scene, you'll see the three serpents intertwine and join, thus
restoring balance. You'll learn that you've completed your quest, and that
Dupre is with the Ophidians and is content.

 Then, the Guardian will reach out of the void and drag your avatar off to...

                    >>>  ULTIMA 8  <<<

 ULTIMA VII PART II: SERPENT ISLE is published and distributed by Origin
Systems.

 This walkthru is copyright (c) 1993 by Belisana (71700,2130) and THE
ELECTRONIC GAMER. All rights reserved. Not to be distributed without 
permission.
