

  'This is a sample application as described in the chapter
  'Liberty BASIC Graphical Features

    'The purpose of this application is to allow the entry of three
    'sets of numerical data and then to plot them in contrasting
    'colors superimposing each other.    The concepts utilized here
    'include handling the spreadsheet, using buttons, and drawing
    'into a graphical window using several colors

    'create 3 arrays
    dim columnOne(10)
    dim columnTwo(10)
    dim columnThree(10)

    'set up the size of the spreadsheet window
    WindowWidth = 500
    WindowHeight = 348

    'set up the buttons
    button #sheet, Graph, [graph], LR, 45, 5
    button #sheet, Quit, [quit], LR, 5, 5

    'open the window
    open "GRAPHER, a Liberty BASIC application"  for spreadsheet as #sheet

    print #sheet, "indirect"        'use indirect control mode
    print #sheet, "select B4"       'position the selector at B4

    'display some simple instructions and also the column headings
    print #sheet, "cell A1 'Please enter 3 columns of data below and click on Graph."
    print #sheet, "cell A3 'Item #     Set 1      Set 2      Set 3"

    'place the numbers 1 to 10 to the left of the column information
    for index = 1 to 10
        print #sheet, "cell A"; trim$(str$(index+3)); " '"; str$(index)
    next index

    'specify columns B,C,D from 4 to 13 as user (entry) columns and to accept numbers
    for index = 4 to 13
        print #sheet, "user B"; trim$(str$(index)); " number"
        print #sheet, "user C"; trim$(str$(index)); " number"
        print #sheet, "user D"; trim$(str$(index)); " number"
    next index

    'display title header and set up the cell to hold it to accept a string
    print #sheet, "cell A15 'Title for the graph:"
    print #sheet, "user A16 string"

    'force display of the spreadsheet
    print #sheet, "flush"


[inputLoop]    ' wait for input (button clicks)
    input r$
    goto [inputLoop]


[graph]     'display a graph of the data in the spreadsheet

    'if a graph is already displayed, then close its window
    if plotFlag > 0 then close #graph
    plotFlag = 1


    'get the column data from the spreadsheet
    'and look for the peak (greatest) y value
    peak = 0
    for index = 4 to 13
        print #sheet, "result? B"; trim$(str$(index))
        input #sheet, r$ : columnOne(index-3) = val(r$)
        if val(r$) > peak then peak = val(r$)
        print #sheet, "result? C"; trim$(str$(index))
        input #sheet, r$ : columnTwo(index-3) = val(r$)
        if val(r$) > peak then peak = val(r$)
        print #sheet, "result? D"; trim$(str$(index))
        input #sheet, r$ : columnThree(index-3) = val(r$)
        if val(r$) > peak then peak = val(r$)
    next index

    'set up the size of the graph window based on peak
    WindowWidth = 320
    WindowHeight = 64 + peak + 20

    'get the title of the graph from the spreadsheet
    print #sheet, "result? A16"
    input #sheet, title$

    ' open a window for the graph with one button
    button #graph, Done, [done], LR, 5, 5
    open title$ for graphics as #graph

    'set the size of the graphics pen
    print #graph, "size 2"

    'add ten to peak to move it away from the top of the window
    peak = peak + 10

    'plot columnOne in red
    print #graph, "color red"
    print #graph, "up"
    print #graph, "goto 10 "; peak - columnOne(1)
    print #graph, "down"
    for x = 10 to 250 step 25
        print #graph, "goto "; x; " "; peak - columnOne(int((x+15)/25))
    next x

    'plot columnTwo in green
    print #graph, "color green"
    print #graph, "up"
    print #graph, "goto 10 "; peak - columnTwo(1)
    print #graph, "down"
    for x = 10 to 250 step 25
        print #graph, "goto "; x; " "; peak - columnTwo(int((x+15)/25))
    next x

    'plot columnThree in blue
    print #graph, "color blue"
    print #graph, "up"
    print #graph, "goto 10 "; peak - columnThree(1)
    print #graph, "down"
    for x = 10 to 250 step 25
        print #graph, "goto "; x; " "; peak - columnThree(int((x+15)/25))
    next x

    'display the title in black in the upper left corner
    print #graph, "color black"
    print #graph, "up"
    print #graph, "goto 0 12"
    print #graph, "font System 8 20"
    print #graph, "\"; title$

    'force display of the graph
    print #graph, "flush"

    goto [inputLoop]    ' drawing finished, go back and poll for input


[done]      'close graph window if Done button is clicked

    plotFlag = 0
    close #graph
    goto [inputLoop]


[quit]      'exit the Grapher application if desired

    confirm "Quit Grapher?"; quit$
    if quit$ = "no" then [inputLoop]
    if plotFlag = 1 then close #graph
    close #sheet

    end
