; Generic battery clock progam
;
         codeseg     segment
         assume      cs:codeseg, ds:codeseg
         org    100h
hbc      proc   far
start:
         jmp    short gotsr     ; go set ourselves up as TSR
hour     dw     0               ; used to store total hours, yowza!
minut    dw     0               ; used to store total minutes
count    dw     0               ; used to store ticks within a minute
istart:                         ; here on each int 08 in TSR mode
         push   ax
         push   bx
         push   cx
         push   dx
         push   ds
         mov    ds,cs           ; be sure we are in our own segment
         mov    cx,[count]      ; get last tick count
         add    cx,0001         ; increment by 1
         mov    [count],cx      ; 18.20664 ticks/second  1092.398 ticks/min
         cmp    cx,1093         ; is a minute up yet
         jne    nuttin          ; no, so just get out of here
         mov    cx,0            ; yes minute is up
         mov    [count],cx      ; clear the tick count for last minute
         mov    dx,[hour]       ; load up hour since we need it anyhow
         mov    cx,[minut]      ; get the count of minutes elapsed
         inc    cx              ; increment by one
         cmp    cx,60           ; hour up yet?
         jne    nohour          ; nope
         inc    dx              ; increment the hour
         mov    [hour],dx       ; save it
         xor    cx,cx           ; zero register
nohour:
         mov    [minut],cx      ; save it
; Here is the display stuff.  It does direct writes to the b8 video segment.
         mov    ax,0b800h       ; set up b8 segment
         mov    ds,ax           ; put in data segment register
         mov    ax,cx           ; pick up minute count
         aam                    ; unpack to bcd
         or     ax,3030h        ; mask it to ascii digits
         mov    bl,ah           ; move to proper register
         mov    bh,74h          ; character attribute, light color
         mov    [009ch],bx      ; move to video buffer
         mov    bl,al           ; move the other character
         mov    [009eh],bx      ; send to buffer
         mov    ax,dx           ; pick up hours
         aam                    ; unpack binary to bcd
         or     ax,3030h        ; mask bcd to ascii digits
         mov    bl,al           ; to output register
         mov    [0098h],bx      ; and put in screen buffer
         mov    bl,0f9h         ; how about a bizarre separator
         mov    [009ah],bx      ; put it on screen
nuttin:                         ; now prepare to leave
         pop    ds
         pop    dx
         pop    cx
         pop    bx
         pop    ax
bozo:
         jmp    0000:0000       ; go back up interrupt chain
gotsr:                  ;on dos invocation we set up int 8 and go resident
         push   ds              ; save the good stuff
         xor    ax,ax           ; zero register
         mov    ds,ax           ; set segment to 0
         mov    ax,ds:20h       ; pick up current int 08
         mov    dx,ds:22h
         pop    ds              ; back to our own segment
         mov    ds:bozo+1,ax    ; chain old interrupt
         mov    ds:bozo+3,dx
         lea    dx,istart       ; set up our own handler
         mov    ax,2508h
         int    21h
         mov    dx,gotsr
         int    27h             ; terminate and stay resident
hbc      endp
         codeseg     ends
         end start
