/*-------------------------------------------------------------------
 *  KYBDCTL -- Controls the state of the Numlock, Capslock,
 *             and scroll lock.
 *-------------------------------------------------------------------*/

#define INCL_BASE
#include <os2.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

main(int argc, char **argv[])
{
   SHIFTSTATE keyboard;
   HKBD        handle;
   char        option;
   char        modifier;
   int         count;
   USHORT      rc;
   char        temp[80];
   BYTE        machinemode;
   char far    *farbyte;

   if (argc < 2)
   {
      printf("KYBDCTL  -- This program is designed to change the status\n");
      printf("            of the numlock, scroll lock, and capslock keys.\n");
      printf("            It should run under DOS or OS/2 1.3 or above.\n");
      printf(" Format:\n");
      printf("   KYBDCTL {Num[+/-] Caps[+/-] Scroll[+/-]\n");
      printf("   Each parameter is optional and only the first letter is required\n\n");
      printf("   Example:  KYBDCTL N+ Scroll-\n");
      printf("             Would turn on the Numlock, turn off the Scroll lock,\n");
      printf("             and leave the Capslock alone\n");
      return(1);
   }

   DosGetMachineMode(&machinemode);
   if (machinemode  == MODE_PROTECTED)
   {
      if ((rc =KbdOpen(&handle)) != 0)
      {
         printf("Unable to open the Keyboard\nProgram Aborts\nRC = %d\n",rc);
         return(2);
      }

      if ((rc = DosDevIOCtl(&keyboard, 0L, 0x0073, 0x0004, handle)) != 0)
      {
         printf("rc = %d\n",rc);
         printf("Unable to get keyboard status\nProgram Aborts\n");;;
         return(4);
      }
   }
   else
   {
      farbyte = 0x400017;
      keyboard.fsState = *farbyte;
   }

   for (count = 1; count <argc; count ++)
   {
      strcpy(temp, (char *)argv[count]);
      option = (char) toupper(temp[0]);
      modifier = temp[strlen(temp) - 1];
      if ((modifier != '+') && (modifier != '-'))
      {
         printf("Option must end in either + or -.\nProgram Aborting\n");
         return(5);
      }
      switch(option)
      {
         case 'N':
            if (modifier == '+')
               keyboard.fsState = keyboard.fsState | NUMLOCK_ON;
            else
               keyboard.fsState = keyboard.fsState &~ NUMLOCK_ON;
            break;
         case 'C':
            if (modifier == '+')
               keyboard.fsState = keyboard.fsState | CAPSLOCK_ON;
            else
               keyboard.fsState = keyboard.fsState &~ CAPSLOCK_ON;
            break;
         case 'S':
            if (modifier == '+')
               keyboard.fsState = keyboard.fsState | SCROLLLOCK_ON;
            else
               keyboard.fsState = keyboard.fsState &~ SCROLLLOCK_ON;
            break;
         default:
            printf("Option Must be Num, Caps, or Scroll\nProgram Aborts\n");
            return(6);
      }
   }


   if (machinemode  == MODE_PROTECTED)
   {
      if ((rc = DosDevIOCtl(0L, &keyboard, 0x0053, 0x0004, handle)) != 0)
      {
         printf("Unable to set status bytes\nProgram Aborts\nRc = %d\n",rc);
         return(7);
      }
   }
   else
   {
      memmove(farbyte, &keyboard.fsState, 1);
   }
   return(0);
}
