Unit UCH;
{ user configurable help system }
{
Copyright (C) 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}

interface
uses Crt, FParser;
const
  ExitUCHMenu = -1;

Procedure ReadUCHMenu(var F : text);

Procedure DisplayUCHMenu;

Function SelectUCHMenuItem : integer;

Procedure ShowUCHMenuItem(n : integer; FName : string);

implementation
const
  MaxMenu = 20;
type
  MenuList = ARRAY[1 .. MaxMenu] of String;
var
  MenuCount : integer;
  MyMenu : MenuList;

Procedure PressEnter(var c : char);
var
  S : string;
  Defcol,X,Y : integer;

BEGIN
  Defcol := TextAttr and 15;
  X := WhereX; Y := WhereY;
  TextColor(White);
  GotoXY(1,22); Write('======================================');
  GotoXY(1,23); Write('Press ENTER to continue, ESC to exit. ');
  REPEAT
  c := ReadKey;
  UNTIL ((c = #13) or (c = #27));
  TextColor(Defcol);
END;

Procedure ReadUCHMenu(var F : text);
var
  i : integer;
  S : string;
  IsMenuItem : boolean;
  toks : integer;
  tokstr : string;
  P : ParseType;
BEGIN
  tokstr := ' '+#8+#9+#10+#12+#13;
  MenuCount := 0;
  For i := 1 to MaxMenu do
    MyMenu[i] := '';
  IsMenuItem := FALSE;
  While NOT eof(F) do begin
    ReadLn(F,S);
    If IsMenuItem then begin
      IsMenuItem := FALSE;
      If (MenuCount < MaxMenu) then begin
        Inc(MenuCount);
        MyMenu[MenuCount] := S;
      end;
    end
    else begin
      toks := Parse_Str(tokstr,S,P);
      if toks = 1 then begin
        If MatchToken(P.s[0],'.menu') then
          IsMenuItem := TRUE;
      end;
    end;
  end;
  Close(F);
END;

Procedure DisplayUCHMenu;
var
  C : char;
  S : string;
  i,X : integer;
BEGIN

  ClrScr;
  TextColor(LightRed);
  TextBackground(Black);
  If MenuCount > 0 then begin
    GotoXY(27,2); Write('User Configurable Help Menu');
    TextColor(Cyan);
    for i := 1 to MenuCount do begin
      if i <= (MaxMenu div 2) then
        X := 1
      else X := 41;
      GotoXY(X,((i-1) mod 10) + 5);
      C := chr(i+$40);
      TextColor(Yellow);
      Write(C,') ');
      TextColor(Cyan);
      S := MyMenu[i];
      If (length (MyMenu[i]) > 36) then
        S := copy(MyMenu[i],1,35);
      Write(S);
    end;
    GotoXy(X,((MenuCount-1) mod 10) + 6);
    TextColor(Yellow); Write('X) ');
    TextColor(Cyan); WriteLn('Exits Help');
  end
  else begin
    TextColor(White);
    TextBackGround(Red);
    GotoXY(20,2); Write(' User Configurable Help Menu == No Menu Items Found ');
    TextBackGround(Black);
  end;
END;

Function SelectUCHMenuItem : integer;
var
  C : char;
  i : integer;

BEGIN
  REPEAT
    REPEAT UNTIL KeyPressed;
    C := ReadKey;
    C := UpCase(C);
    If (C = 'X') then { exit condition }
      i := -1
    else begin
      i := ord(C) - ord('@');
      if (i < 1) or (i > MenuCount) then
        i := 0;
    end;
  UNTIL (i < 0) or (i > 0);
  SelectUCHMenuItem := i;
END;

Procedure ShowUCHMenuItem(n : integer; FName : string);
var
  S,Header : string;
  F : text;
  c : char;
  Done,PageFound,TitleFound,HeaderFound : boolean;
  isHeader,isTitle,isPage : boolean;
  toks,i : integer;
  tokstr : string;
  P : ParseType;

BEGIN
  tokstr := ' '+#8+#9+#10+#12+#13;
  TextColor(White);
  TextBackground(Black);
  Assign(F,FName);
  Reset(F);
  i := 0;
  While ((NOT eof(F)) and (i < n)) do begin
    ReadLn(F,S);
    toks := Parse_Str(tokstr,S,P);
    if toks = 1 then
      If MatchToken(P.s[0],'.menu') then
        Inc(i);
  end;
  If (i < n) then begin
    ClrScr;
    WriteLn('Error-Menu Item Not Found. ');
    PressEnter(c);
  end
  else begin
    ClrScr;
    Done := FALSE;
    PageFound := FALSE;
    TitleFound := FALSE;
    HeaderFound := FALSE;
    isHeader := FALSE;
    isTitle := FALSE;
    isPage := FALSE;
    While (NOT Eof(f)) and (NOT Done) do begin
      ReadLn(F,S);
      toks := Parse_Str(tokstr,S,P);
      if PageFound then begin
        If (toks > 0) and MatchToken(P.s[0],'.endpage') then begin
          PageFound := FALSE;
          Done := TRUE;
          PressEnter(c);
          If (c = #27) then
            Done := TRUE;
        end
        else if (toks > 0) and MatchToken(P.s[0],'.page') then begin
          PageFound := TRUE;
          isPage := TRUE;
          PressEnter(c);
          If (c = #27) then
            Done := TRUE;
        end
        else if isPage then begin
          if NOT isTitle then begin
            ClrScr;
            if isHeader then begin
              TextColor(LightRed);
              WriteLn(Header);
            end;
          end
          else isTitle := FALSE;
          WriteLn;
          TextColor(Yellow);
          WriteLn(S);
          isPage := FALSE;
        end
        else WriteLn(S);
      end
      else if HeaderFound then begin
        Header := S;
        HeaderFound := FALSE;
        isHeader := TRUE;
      end
      else if TitleFound then begin
        TextColor(LightCyan);
        If MatchToken(P.s[0],'.endtitle') then
          TitleFound := FALSE
        else if MatchToken(P.s[0],'.header') then begin
          TitleFound := FALSE;
          HeaderFound := TRUE;
        end
        else if MatchToken(P.s[0],'.page') then begin
          TitleFound := FALSE;
          PageFound := TRUE;
          isPage := TRUE;
        end
        else begin
          WriteLn(S);
        end;
      end
      else if (toks > 0) and NOT Done then begin
        If MatchToken(P.s[0],'.menu') then begin
          Writeln('Error-Next menu item found before text found.');
          Done := TRUE;
          PressEnter(c);
          If (c = #27) then
            Done := TRUE;
        end;
        If MatchToken(P.s[0],'.endpage') then begin
          Writeln('Error-Page End found before text found.');
          Done := TRUE;
          PressEnter(c);
          If (c = #27) then
            Done := TRUE;
        end;
        If MatchToken(P.s[0],'.title') then begin
          TitleFound := TRUE;
          isTitle := TRUE;
          ClrScr;
        end;
        If MatchToken(P.s[0],'.header') then begin
          HeaderFound := TRUE;
        end;
        If MatchToken(P.s[0],'.page') then begin
          PageFound := TRUE;
          isPage := TRUE;
        end;
      end;
    end; { While }
  end; { else if }
  Close(F);
END;

BEGIN { uch module init }
  MenuCount := 0;
END.