Unit FParser;
{
Copyright (C) 1986, 1993 by David Myers.  All rights reserved.  Personal
copying and use of this code permitted.  This source cannot be
sold or distributed for more than the cost of media.
}

interface
Uses
  Crt;
Const
  MaxParse = 20;
  MaxRArray = 10;
Type
  ParseRange = 0 .. MaxParse;
  ParseType = RECORD
    Count : ParseRange;
    S : ARRAY[ParseRange] of String;
  END;
  RealArray = ARRAY[1 .. MaxRArray] of real;

Procedure BuildString(var S : string);

{ ReadLn replacement that allows left arrow and right arrow keys    }
{ to be used in editing the string.  ESC returns '', an empty       }
{ string, and CR returns the string entered regardless of position. }

Function Parse_Str( SepStr, S : String; Var P : ParseType ) : Integer;

PROCEDURE UpCaseTokens(Var P : ParseType );

FUNCTION MatchToken(S,Tok : String) : Boolean;

FUNCTION TokenIsPresent(style : integer; Tok : String ;
                        P : ParseType) : Boolean;

FUNCTION CharInTokens( c : char; var P : ParseType) : integer;

Procedure ReturnXY(S,T : String ;var X,Y : integer);

Procedure ReturnSTXY(S : String ;var X,Y : integer);

Function GetReals(n : integer; var R : RealArray) : boolean;

implementation


  Procedure BuildString(var S : string);
  const
    blank = '                                  ';
  var
    i,j,X,XC,Y,XMin,XMax,XDif : integer;
    c : char;
  begin
    S := '';
    i := 0;
    c := ReadKey;
    XMin := WhereX;
    XC := XMin;
    While NOT ((c = #27) or (c = #13)) do begin
      X := WhereX;
      XMax := i + XMin;
      XDif := X - XMin;
      If (c <> #0) then begin
        If (XMax = X) then begin
          If (c = #8) then begin
            If (i > 0) then begin
              Dec(i);
              Write(c);
              Write(' ');
              Write(c);
              S[0] := Chr(i);
            end;
          end
          else begin
            Inc(i);
            S[i] := c;
            S[0] := chr(i);
            Write(c);
          end
        end
        else if (X < XMax) then begin
          if (c = #8) then begin
            if (X > XMin) then begin
              Write(c);
              for j := XDif to i-1 do
                S[j] := S[j+1];
              Dec(i);
              S[0] := Chr(i);
              for j := XDif to i do
                Write(S[j]);
              Write(' ');
              GoToXY(X-1,Y);
            end; { else do nothing }
          end
          else begin
            S[XDif+1] := c;
            Write(c);
          end
        end;
        { else do nothing }
      end
      else begin
        c := ReadKey;
        Y := WhereY;
        case c of
        #75 : if (XMin < X) then
                GotoXY(X-1,Y);         { left arrow }
        #77 : if (X < XMax) then
                Write(S[XDif+1]);      { right arrow }
        end { case };
      end;
      c := ReadKey;
    end;
    If (c = #27) then begin
      Write(#13);
      i := length(S);
      S := Copy(blank,1,i+1);
      GoToXY(XMin,Y);
      Write(S);
      S := '';
    end;
  end;


FUNCTION Tonumber(c : Char) : Integer;
VAR
 N : integer;
BEGIN
  N := Ord(c)-Ord('0');
  If (N > 9) or (N < 0) THEN
    N := 0;
  Tonumber := N;
END;



Function Parse_Str( SepStr, S : String; Var P : ParseType ) : Integer;
(* SepStr defines the separators used, such as blanks, commas   *)
(* etc                                                          *)
(* S is the string to be parsed                                 *)
(* P passes the parsed string back to the user                  *)
(* The Function returns the number of tokens back to the user.  *)
(* and is equal to P.count.                                     *)
(* The tokens will be located in strings P.s[0] to              *)
(* P.s[P.count - 1]                                             *)
(*                                                              *)
(*                                                              *)
(* David Myers                                                  *)
(* Biochemistry Dept                                            *)
(* Rice Univ                                                    *)
(* Houston TX 77251                                             *)
(* March 4 1986                                                 *)

CONST
  ch0 = #0;
VAR
  SEP : SET of Char;
  s_index,i,j : integer;

BEGIN
  SEP := [];
  for i := 1 to length(SepStr) do
    SEP := SEP + [SepStr[i]];
  for i := 0 to MaxParse do
    P.s[i][0] := ch0;
  s_index := 1;
  P.count := 0;
  j := 0;
  While (chr(s_index) <= S[0] ) do
    BEGIN
      If S[s_index] in SEP THEN
        BEGIN
          If (P.s[P.count][0] > ch0) THEN
            BEGIN
              Inc(P.count);
              if P.count >= MaxParse then
                P.count := MaxParse - 1;
              j := 0;
            END
        END
      ELSE BEGIN
        Inc(j);
        P.s[P.count][j] := S[s_index];
        P.s[P.count][0] := chr(j);
      END;
      Inc(s_index);
    END;
  If (P.s[P.count][0] > ch0) THEN
    Inc(P.count);
  Parse_Str := P.count;
END;

PROCEDURE UpCaseTokens(Var P : ParseType );
VAR
  i, j : integer;
BEGIN
  for i := 0 to P.count-1 do
    for j := 1 to length(P.s[i]) do
      P.s[i][j] := UpCase(P.s[i][j]);
END;

FUNCTION MatchToken(S,Tok : String) : Boolean;
Var
  t : boolean;
  i , max : integer;
BEGIN
  t := true;
  max := length(Tok);
  if length(S) < max then
    t := false
  else for i := 1 to max do
    if (UpCase(s[i]) <> UpCase(Tok[i])) then
      t := false;
  MatchToken := t;
END;

FUNCTION TokenIsPresent(style : integer; Tok : String ;
                        P : ParseType) : Boolean;

(* if style = 0 .. match occurs if Tok subset of Ps[i], case nonsignif *)
(* if style = 1 .. match occurs if Tok = Ps[i], case nonsignif *)
(* if style = 2 .. match occurs if Tok = Ps[i], case significant *)
VAR
  t : boolean;
  i : integer;
  max, j : integer;

BEGIN
  style := style and 2;
  t := FALSE;
  case style of
  0 : for i := 0 to P.count - 1 do
        if MatchToken(P.s[i],Tok)
          then t := TRUE;
  1 : for i := 0 to P.count - 1 do
        BEGIN
          while (t = false) do
            BEGIN
              t := true;
              max := length(Tok);
              if length(P.s[i]) = max then
                for j := 1 to max do
                  if UpCase(P.s[i][j]) <> UpCase(Tok[j]) then
                    t := false;
            END
        END;
  2 : for i := 0 to P.count - 1 do
        BEGIN
          while (t = false) do
            BEGIN
              t := true;
              max := length(Tok);
              if length(P.s[i]) = max then
                for j := 1 to max do
                  if (P.s[i] <> Tok) then
                    t := false;
            END
        END;
  END; { case }
  TokenIsPresent := t;
END;

FUNCTION CharInTokens( c : char; var P : ParseType) : integer;
var
  j,ctok : integer;
  s : string[3];

BEGIN
  ctok := 0;
  s := c;
  for j := 0 to P.count-1 do
    BEGIN
      If (ctok = 0) THEN
        If (pos(s,P.s[j]) > 0) THEN
        ctok := j + 1;
    END;
  CharInTokens := ctok;
END;


Procedure ReturnXY(S,T : String ;var X,Y : integer);
VAR
  s1,s2 : String;
  code : integer;
BEGIN
  X := 0; Y := 0;
  case length(S) of
    6 :
    BEGIN
      Y := 10*Tonumber(s[2]) + Tonumber(s[3]);
      X := 10*Tonumber(s[5]) + Tonumber(s[6]);
    END;
    5 :
    BEGIN
      Y := 10*Tonumber(s[1]) + Tonumber(s[2]);
      X := 10*Tonumber(s[4]) + Tonumber(s[5]);
    END;
    4 :
    BEGIN
      Y := Tonumber(s[1]);
      X := 10*Tonumber(s[3]) + Tonumber(s[4]);
    END;
    3 :
    BEGIN
      Y := 10*Tonumber(s[1]) + Tonumber(s[2]);
      X := Tonumber(t[1]);
    END;
    2 :
    BEGIN
      Y := Tonumber(s[1]);
      X := Tonumber(t[1]);
    END;
  END;
END;

Procedure ReturnSTXY(S : String ;var X,Y : integer);
VAR
  s1,s2 : String;
  code : integer;
BEGIN
  X := 0; Y := 0;
  case length(S) of
    6 :
    BEGIN
      Y := 10*Tonumber(s[2]) + Tonumber(s[3]);
      X := 10*Tonumber(s[5]) + Tonumber(s[6]);
    END;
    5 :
    BEGIN
      Y := 10*Tonumber(s[1]) + Tonumber(s[2]);
      X := 10*Tonumber(s[4]) + Tonumber(s[5]);
    END;
    4 :
    BEGIN
      case pos('-',S) of
        2 :
        BEGIN
          Y := Tonumber(s[1]);
          X := 10*Tonumber(s[3]) + Tonumber(s[4]);
        END;
        3 :
        BEGIN
          Y := 10*Tonumber(s[1]) + Tonumber(s[2]);
          X := Tonumber(s[4]);
        END;
      END;
    END;
    3 :
    BEGIN
      Y := Tonumber(s[1]);
      X := Tonumber(s[3]);
    END;
  END;
END;

Function GetReals(n : integer; var R : RealArray) : boolean;
  var
    toks, i, code : integer;
    instring,tokstr : string;
    P : ParseType;
    t : boolean;

BEGIN
  for i := 1 to n do
    R[i] := 0.0;
  Tokstr := ' ,:;'+#8+#9+#10+#13;
  BuildString(instring);
  toks := Parse_Str(TokStr,instring,P);
  if (toks >= n) then begin
    t := TRUE;
    for i := 1 to n do begin
      Val(P.s[i-1],R[i],code);
      if code <> 0 then
        t := FALSE;
    end;
    GetReals := t;
  end
  else GetReals := FALSE;
END;
end.