


        ORG     0D000H
        WIDTH   80

        ORG     0D000H  ;main program

REG0    EQU     00H     ;register for I/O port 2000H
REG1    EQU     01H     ;......................2001H
SELPRS  EQU     0AH     ;register for SWSEL
SPCNT   EQU     0BH     ;.............SPMEET
T816    EQU     0CH     ;.............SSP816
XPOS    EQU     0D1H    ;.............SORG
YPOS    EQU     0D2H    ;..................
PAGE    EQU     0D3H    ;..................
CLRSTRL EQU     0E1H    ;.............SCLRTB
CLRSTRH EQU     0E2H    ;....................
JSEL    EQU     0B5H    ;.............SJPRS
JSTAS1  EQU     0B6H    ;..................
JSTAS2  EQU     0B7H    ;..................
JTEST   EQU     0B8H    ;.............SJTEST
ADRH    EQU     0B1H    ;.............SDISP
ADRL    EQU     0B2H    ;..................
NUMR    EQU     0B3H    ;..................
DSTRL   EQU     0C1H    ;..................
DSTRH   EQU     0C2H    ;..................
SND3    EQU     0A1H    ;.............SOU3
SND4    EQU     0A2H    ;.............SOU4
SND5    EQU     0A3H    ;.............SOU5
MIC0    EQU     0A4H    ;.............SMIC
MIC1    EQU     0A5H    ;.................


        CLD
        SEI
        LDA     #00H
        STA     2000H
        STA     2001H
L0      LDA     2002H
        BPL     L0
        JSR     SPRT
        JMP     SCRT
L1      LDA     2002H
        BPL     L1
        LDX     #0FFH
        TXS

        LDA     #08H
        STA     REG0
        LDA     #0EH
        STA     REG1
        LDA     #00H
        STA     JTEST
        STA     T816

        LDA     #20H
        STA     SND3    ;disable sound channel 3
        STA     SND4    ;disable sound channel 4
        LDA     #10H
        STA     SND5    ;disable sound channel 5

        LDA     #00H
        STA     SND5    ;enable sound channel 5

        LDA     #80H
        STA     CLRSTRL
        LDA     #0FFH
        STA     CLRSTRH
        JSR     SCLRTB

        JSR     SORG    ;set display original point

        LDA     REG0
        ORA     #80H
        STA     2000H

        JSR     STDLY   ;STDLY delay 1/2 sec
        JSR     STDLY

        JSR     SCBAR   ;establish color bar
        JSR     SCHXY   ;change display original point

        JSR     STDLY
        JSR     STDLY
        JSR     SORG

        JSR     SPMOT   ;sprite diagonal motion

        JSR     STDLY
        JSR     SSP64

        JSR     STDLY
        JSR     SSP816

        JSR     STDLY


        JSR     SJTEST  ;joy stick test
        INC     53H     ;loop operation
L3      LDA     53H
        BNE     L3

;--------------------------------------------------------------

        ORG     0F000H  ;interrupt
        PHA
        TXA
        PHA
        TYA
        PHA
        LDA     #00H
        STA     2003H
        LDA     #02H
        STA     4014H   ;sprite data DMA t0 PPU
        LDA     REG1
        STA     2001H

        JSR     SOU3
        JSR     SOU4
        JSR     SOU5

        LDA     #00H    ;joy stick 1
        STA     JSEL
        JSR     SJPRS   ;detect whether joy stick be pressed
        LDA     #01H    ;joy stick 2
        STA     JSEL
        JSR     SJPRS

        JSR     SSELP   ;detect whether SEL be pressed

        LDA     T816    ;when test SP816, T816=#1
        BNE     I2

        JSR     SSCROL  ;screen scrolling
                        ;this SUB. will repeat trigger I/O addr.
                                                       2000H
I2      LDA     JTEST
        CMP     #01H
        BNE     I1

        LDA     #08H
        STA     2000H
        JSR     STWAIT
        LDA     #00H
        STA     2001H
        JSR     SMIC    ;test MIC function
        JSR     SJSTAS
        LDA     #00H    ;relocated display original point
        STA     2005H
        STA     2005H
        LDA     #88H
        STA     2000H
        LDA     #0EH
        STA     2001H


I1      PLA
        TAY
        PLA
        TAX
        PLA

        RTI

;--------------------------------------------------------------

        ORG     0D200H  ;subroutine beginninng address

SPRT    LDX     #20H    ;PPU RAM test,PPU RAM assumed using
        LDA     #00H                          page 1,3
        STX     2006H
        STA     2006H
        LDY     #10H    ;think over changing value ?????
        LDX     #00H
        LDA     #0AAH
P1      STA     2007H
        INX
        BNE     P1
        DEY
        BNE     P1

        LDY     #20H
        LDX     #00H
P2      STY     2006H
        STX     2006H
        LDA     2007H   ;first read open I/O 2007H read function
        LDA     2007H
        CMP     #0AAH
        BNE     P3
        STY     2006H
        STX     2006H
        LDA     #55H
        STA     2007H

        STY     2006H
        STX     2006H
        LDA     2007H   ;first read open I/O 2007H read function
        LDA     2007H
        CMP     #55H
        BNE     P3
        INX
        BNE     P2
        INY
        CPY     #24H    ;think over changing value ?????
        BNE     P2

        LDY     #28H
        LDX     #00H
P5      STY     2006H
        STX     2006H
        LDA     2007H
        LDA     2007H
        CMP     #0AAH
        BNE     P3
        STY     2006H
        STX     2006H
        LDA     #55H
        STA     2007H

        STY     2006H
        STX     2006H
        LDA     2007H
        LDA     2007H
        CMP     #55H
        BNE     P3
        INX
        BNE     P5
        INY
        CPY     #2CH    ;think over changing value ?????
        BNE     P5
        JSR     SPROK
        RTS

P3      JSR     SPRFL
        RTS

;-----SUB. CPU RAM  test---------------------------------------

SCRT    LDX     #00H
        LDA     #0AAH
C0      STA     00H,X
        INX
        BNE     C0
C1      STA     100H,X
        INX
        BNE     C1
C2      STA     200H,X
        INX
        BNE     C2
C3      STA     300H,X
        INX
        BNE     C3
C4      STA     400H,X
        INX
        BNE     C4
C5      STA     500H,X
        INX
        BNE     C5
C6      STA     600H,X
        INX
        BNE     C6
C7      STA     700H,X
        INX
        BNE     C7

C10     LDA     00H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     00H,X
        LDA     00H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C10

C11     LDA     100H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     100H,X
        LDA     100H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C11

        BNE     C12

C13     LDA     300H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     300H,X
        LDA     300H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C13
        JMP     C14

C8      JSR     SCRFL   ;C8 in this position has equal distance
        JMP     L1                       from C10 and C17

C14     LDA     400H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     400H,X
        LDA     400H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C14

C15     LDA     500H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     500H,X
        LDA     500H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C15

C16     LDA     600H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     600H,X
        LDA     600H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C16

C17     LDA     700H,X
        CMP     #0AAH
        BNE     C8
        LDA     #55H
        STA     700H,X
        LDA     700H,X
        CMP     #55H
        BNE     C8
        INX
        BNE     C17

        JSR     SCROK
        JMP     L1

;-------SUB. color table filled--------------------------------

SCLRTB  LDA     #00H    ;color table filled
        STA     2001H
        LDY     #00H
        LDX     #3FH
        LDA     #00H
        STX     2006H
        STA     2006H
CL1     LDA     (CLRSTRL),Y
        STA     2007H
        INY
        CPY     #1CH    ;total 28 byte
        BNE     CL1
        RTS

;-------SUB. time delay----------------------------------------

STDLY   LDX     #20H    ;delay 1/2 sec
T1      JSR     STWAIT
        DEX
        BNE     T1
        RTS

;-------SUB. time waiting for 1 blanking-----------------------

STWAIT  LDA     2002H   ;waiting 1/60 sec
        BMI     STWAIT
ST1     LDA     2002H
        BPL     ST1
        RTS

;-------SUB. detect whether joy stick be pressed---------------

SJPRS   LDX     JSEL    ;joy stick 1, JSEL=0
                        ;joy stick 2, JSEL=1
        LDA     #01H
        STA     4016H
        LDA     #00H
        STA     4016H
        STA     JSTAS1,X
        LDY     #07H
J1      LDA     4016H,X
        AND     #01H
        LSR     A
        ROL     JSTAS1,X
        DEY
        BPL     J1
        RTS

;-------SUB. detect whether SEL be pressed---------------------

SSELP   LDA     JSTAS1  ;when SEL be pressed,SELPRS=#1
        AND     #20H
        BEQ     SE1
        LDA     #01H
        STA     SELPRS
SE1     RTS

;-------SUB. display PPURAM TEST OK title----------------------

SPROK   JSR     SCSCR   ;PPU RAM test OK
        LDA     #21H
        STA     ADRH
        LDA     #06H
        STA     ADRL
        LDA     #10H
        STA     NUMR
        LDA     #0A0H
        STA     DSTRL
        LDA     #0FFH
        STA     DSTRH
        JSR     SDISP
        RTS

;-------SUB. display PPURAM TEST FAIL title--------------------

SPRFL   JSR     SCSCR   ;PPU RAM test fail
        LDA     #21H
        STA     ADRH
        LDA     #6CH
        STA     ADRL
        LDA     #10H
        STA     NUMR
        LDA     #0B0H
        STA     DSTRL
        LDA     #0FFH
        STA     DSTRH
        JSR     SDISP

        JSR     SFAIL
RF1     JMP     RF1     ;when test fail program halt
        RTS

;-------SUB. RAM test fail ,display red screen-----------------

SFAIL   LDA     #80H
        STA     CLRSTRL
        LDA     #0FFH
        STA     CLRSTRH
        JSR     SCLRTB

        LDX     #3FH
        LDA     #00H
        JSR     SADR
        LDA     #16H
        STA     2007H

        JSR     SORG
        LD
ter-------------------------

SDISP   LDX     ADRH    ;screen starting address
        LDA     ADRL
        STX     2006H
        STA     2006H
        LDY     #00H
D1      LDA     (DSTRL),Y       ;data
        STA     2007H
        INY             ;str
        BNE                                                                                -----------

SCSCR   LDX     #20H    ;clear screen
        LDA     #00H
        STX     2006H
        STA     2006H
        LDY     #10H    ;clear 4 page
        LDX     #00H
PN1     STA     2007H
        INX
        BNE     PN

;-------SUB. display CPURAM TEST OK title----------------------

SCROK   LDA     #21H    ;CPU RAM test OK
        STA     ADRH
        LDA     #0C6H
        STA     ADRL
        LDA     #10H
        STA     NUMR
        LDA     #0C0H
        STA     DSTRL
        LDA     #0FFH
        STA     DSTRH
        JSR     SDISP
        RTS

;-------SUB. display CPURAM TEST FAIL title--------------------

SCRFL   LDA     #22H    ;CPU RAM test fail
        STA     ADRH
        LDA     #2CH
        STA     ADRL
        LDA     #10H
        STA     NUMR
        LDA     #0D0H
        STA     DSTRL
        LDA     #0FFH
        STA     DSTRH
        JSR     SDISP

        JSR     SFAIL
RF2     JMP     RF2
* bar on 1st page & 256 patterns on the 4th page----

SCBAR   LDA     REG1    ;establish color bar
        AND     #0F7H   ;disable TEXT
        STA     2001H
        LDA     REG0
        AND     #7FH
        STA     2000H

        JSR     SOU1

        LDX     #20H
        LDA     #00H
        STX     2006H
        STA     2006H
        LDY     #78H
L11     LDA     #01H

