#define WINDOWS
#include <windows.h>
#include <winsock.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#include <stdio.h>
#include <memory.h>
#include "winwhois.h"
#define NICHOST "rs.internic.net"

HANDLE hInst;
HANDLE saveinst;

char szQueryhost[128] = NICHOST;
char szHost [256];
char szServHost[128];
REQUEST FAR *HeadReq = NULL;
HANDLE hHeadReq = NULL;
HWND hDialog;
 //
int APIENTRY WinMain(HANDLE hInstance, HANDLE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)

{
    MSG msg;
    HWND hMainWindow;

    saveinst = hInstance;

    if (!hPrevInstance)
    if (!InitApplication (hInstance))
        return FALSE;

    if (!InitInstance (hInstance, nCmdShow, &hMainWindow))
    return FALSE;

    LoadString (hInstance, IDC_WHOISLISTSERVER,
                (LPSTR)szServHost, 128);

    SendMessage (hMainWindow, WM_COMMAND, IDC_STARTDIALOG, 0);

    while (GetMessage (&msg, 0, 0, 0))
    {
    TranslateMessage (&msg);
    DispatchMessage (&msg);
    }
    return (msg.wParam);
}

BOOL InitApplication (HANDLE hInstCurrent)
{
    WNDCLASS wc;
    WNDCLASS windc;
 
    memset(&windc, 0x00, sizeof(WNDCLASS));
    memset(&wc, 0x00, sizeof(WNDCLASS));

    windc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
    windc.lpfnWndProc = QueryWndProc;

    windc.cbClsExtra = 0;
    windc.cbWndExtra = 0;
    windc.hInstance = hInstCurrent;
    windc.hIcon = LoadIcon (saveinst, "QMARK");
    windc.hCursor = LoadCursor (NULL, IDC_ARROW);
    windc.hbrBackground = GetStockObject (WHITE_BRUSH);

    windc.lpszMenuName = NULL;
    windc.lpszClassName = "PurposelessWindow";
    if (!RegisterClass (&windc))
    {
        MessageBox (NULL, "Cannot start program",
                    "Whois", MB_OK|MB_ICONHAND);
        return 0;
    }

    wc.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
    wc.lpfnWndProc = MainWndProc;

    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstCurrent;
    wc.hIcon = LoadIcon (saveinst, "QMARK");
    wc.hCursor = LoadCursor (NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject (WHITE_BRUSH);
   // Create brush for erasing background

    wc.lpszMenuName = NULL;
    wc.lpszClassName = "UselessWindow";

    return (RegisterClass (&wc));
}

BOOL InitInstance (HANDLE hInstCurrent, int nCmdShow,
           LPHANDLE lphMainWindow )
{
    HWND hWnd;

    hInst = hInstCurrent;
    hWnd = CreateWindow ("UselessWindow",
             "whois for Windows",
             WS_OVERLAPPEDWINDOW,
             CW_USEDEFAULT,
             CW_USEDEFAULT,
             CW_USEDEFAULT,
             CW_USEDEFAULT,
             NULL,
             NULL,
             hInstCurrent,
             NULL);
    if (hWnd == NULL)
    return FALSE;

    *lphMainWindow = hWnd;

    return TRUE;

}


 


LONG FAR APIENTRY MainWndProc (HWND hWnd, UINT message, WPARAM wParam,
                LPARAM lParam)

{
    FARPROC lpfnProcDialog;
    WORD suword; WSADATA WSAData;
   
    switch (message) {
    case WM_COMMAND:
        if (LOWORD(wParam) != IDC_STARTDIALOG)
        return (DefWindowProc (hWnd, message, wParam, lParam));
        else
        {
            suword = MAKEWORD (1,1);
            WSAStartup (suword, &WSAData);
            lpfnProcDialog = MakeProcInstance ((FARPROC) MainDialog,
                             hInst);
            DialogBox (hInst,
                   "WinWhoIs",
                   hWnd,
                   lpfnProcDialog);
            FreeProcInstance (lpfnProcDialog);
            PostMessage (hWnd, WM_DESTROY, 0, 0);
            break;
        }
    case WM_DESTROY:
        WSACleanup ();
        PostQuitMessage (0);
        break;

    default:
        return (DefWindowProc (hWnd, message, wParam, lParam));
     }
    return 0;

}

BOOL FAR PASCAL ChangeHost (HWND hDlg, WORD message, WPARAM wParam, LPARAM lParam)

{
    char szHost [128];
    switch (message) {
    case WM_INITDIALOG:
        strcpy (szHost, szQueryhost);
        SendDlgItemMessage (hDlg, IDC_HOSTINPUT, (UINT) WM_SETTEXT,
                   (WPARAM) 0,
                   (LPARAM) ((LPSTR) szHost));
        SendDlgItemMessage (hDlg, IDC_HOSTINPUT, (UINT) EM_SETSEL,            
                   (WPARAM) 0,
                   MAKELPARAM (0, -1));
        SendMessage (GetDlgItem (hDlg, IDC_HOSTINPUT), EM_LIMITTEXT, 128, 0L);
        return TRUE;

    case WM_COMMAND:
        switch (LOWORD(wParam))
        {
        case IDC_HOSTINPUT:
            if (HIWORD (lParam) == EN_CHANGE) {
            if (SendDlgItemMessage (hDlg, IDC_HOSTINPUT,
                        EM_LINELENGTH, 0, 0L))
                EnableWindow (GetDlgItem (hDlg, IDC_CHANGEHOST), TRUE);
            else
                EnableWindow (GetDlgItem (hDlg, IDC_CHANGEHOST), FALSE);
            return TRUE;
            }
            else return FALSE;
        case IDC_CHANGEHOST:
                SendDlgItemMessage (hDlg, IDC_HOSTINPUT, (UINT) WM_GETTEXT,
                        (WPARAM) 128,
                        (LPARAM) ((LPSTR) szHost));
                SendDlgItemMessage (hDlg, IDC_HOSTINPUT, (UINT) EM_SETSEL,
                        0, MAKELPARAM (0,-1));
                if (*szHost)
                {
                    strcpy (szQueryhost, szHost);
                }
                else {
                MessageBox (NULL, "No hostname specified!",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                }
                EndDialog (hDlg, TRUE);
                return TRUE;
        case IDCANCEL:
            EndDialog (hDlg, TRUE);
        }
    }
    return FALSE;
}

BOOL FAR PASCAL About (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)

{
    switch (message) {
    case WM_INITDIALOG:
        return TRUE;

    case WM_COMMAND:
        if (wParam == IDOK
        || wParam == IDCANCEL)
        {
        EndDialog (hDlg, TRUE);
        return (TRUE);
        }
        break;
    }
    return FALSE;
}


void DoWhoIsQuery (HWND hDlg, LPSTR lpszName, LPSTR lpszQHost)
{
    struct sockaddr_in;
    HANDLE hWind;
    REQUEST FAR *thisreq;
    
    hWind = CreateWindow ("PurposelessWindow",
         "Whois/Win query",
         WS_OVERLAPPEDWINDOW,
         CW_USEDEFAULT,
         CW_USEDEFAULT,
         CW_USEDEFAULT,
         CW_USEDEFAULT,
         hDlg,
         NULL,
         hInst,
         NULL);
    if (hWind == NULL)
    {    
        MessageBox (NULL, "Could not start query",
                       "WinWhois", MB_OK|MB_ICONHAND);
        return;
    }

    thisreq = HeadReq;
    if (thisreq != NULL)
    {
        while (thisreq->NextReq != NULL)
        {
            thisreq = thisreq->NextReq;
        }
        thisreq->hNextReq = GlobalAlloc (GHND, sizeof (REQUEST));
        thisreq->NextReq = (REQUEST FAR*)GlobalLock (thisreq->hNextReq);
        thisreq = thisreq->NextReq;
    }
    else
    {
        hHeadReq = GlobalAlloc (GHND, sizeof (REQUEST));
        HeadReq = (REQUEST FAR*)GlobalLock (hHeadReq);
        thisreq = HeadReq;
    }
    thisreq->hWin = hWind;
    thisreq->hHost = GlobalAlloc (GHND, 256);
    thisreq->lpHost = GlobalLock (thisreq->hHost);
    lstrcpy (thisreq->lpHost, lpszName);
    thisreq->hQuery = GlobalAlloc (GHND, 128);
    thisreq->lpQuery = GlobalLock (thisreq->hQuery);
    lstrcpy (thisreq->lpQuery, lpszQHost);
    thisreq->NextReq = NULL;
    thisreq->hNextReq = NULL;
    PostMessage (hWind, START_QUERY, 0, 0);
    
    return;
}

BOOL FAR PASCAL MainDialog (HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)

{
 
    switch (message)
    {
    case WM_INITDIALOG:
        {
        hDialog = hDlg;
        SendDlgItemMessage (hDlg, IDC_RESPONSES, EM_LIMITTEXT,0,0);
        SendDlgItemMessage (hDlg, IDC_RESPONSES, EM_FMTLINES, 1, 0L);
        EnableWindow (GetDlgItem (hDlg, IDC_MAKEQUERY), FALSE);
        return TRUE;
        }
    case WM_CLOSE: {
        EndDialog (hDlg, 0);
        break;
        }

    case WM_COMMAND:
        switch (LOWORD(wParam)) {
        case IDM_ABOUT:
            {
            FARPROC lpfnAboutDialog;
            lpfnAboutDialog = MakeProcInstance (About, hInst);
            DialogBox (hInst,
                   "AboutBox",
                   hDlg,
                   lpfnAboutDialog);
            FreeProcInstance (lpfnAboutDialog);
            return TRUE;
            }
        case IDM_CHANGEHOST:
        {
            FARPROC lpfnChangeDialog;
            lpfnChangeDialog = MakeProcInstance (ChangeHost, hInst);
            DialogBox (hInst, "GetHostBox", hDlg, lpfnChangeDialog);
            FreeProcInstance (lpfnChangeDialog);
            return TRUE;
        }
        case IDM_CUT:
        case IDM_COPY:
        case IDM_CLEAR:
            /* if the selection is empty, make it all... */
            {
            DWORD dwStartAndEnd;
            WORD wStartChar;
            WORD wEndChar;

            dwStartAndEnd = SendDlgItemMessage (hDlg,
            IDC_RESPONSES, EM_GETSEL, 0, 0L);
            wStartChar = LOWORD (dwStartAndEnd);
            wEndChar = HIWORD (dwStartAndEnd);

            if (wStartChar == wEndChar)
            {
                SendDlgItemMessage (hDlg, IDC_RESPONSES,
                        EM_SETSEL, 0,
                        MAKELPARAM (0, -1));
                dwStartAndEnd = SendDlgItemMessage (hDlg,
                IDC_RESPONSES, EM_GETSEL, 0, 0L);
                wStartChar = LOWORD (dwStartAndEnd);
                wEndChar = HIWORD (dwStartAndEnd);
                if (wStartChar == wEndChar)
                break;
            }

            if (wParam == IDM_CUT)
            SendDlgItemMessage (hDlg, IDC_RESPONSES,
                        WM_CUT, 0,0);
            else if (wParam == IDM_COPY)
            SendDlgItemMessage (hDlg, IDC_RESPONSES,
                        WM_COPY, 0, 0);
            else
            SendDlgItemMessage (hDlg, IDC_RESPONSES,
                        WM_CLEAR, 0, 0);
            SetFocus (GetDlgItem (hDlg, IDC_NAMEINPUT));
            return TRUE;
            }
        case IDC_HELP:
            {
            MessageBox (NULL, "Enter the name you wish to query in the "
                      "Name to Query field, and press return.  "
                      "For help about whois, query on the name "
                      "\"help\".",
                    "WinWhoIs", MB_ICONINFORMATION | MB_OK);
            SetFocus (GetDlgItem (hDlg, IDC_NAMEINPUT));
            return TRUE;
            }
        case IDC_CLEAR:
                ClearText (hDlg, IDC_RESPONSES);
                SetFocus (GetDlgItem (hDlg, IDC_NAMEINPUT));
                return TRUE;
        case IDC_NAMEINPUT:
            if (HIWORD (wParam) == EN_CHANGE) {
            if (SendDlgItemMessage (hDlg, IDC_NAMEINPUT,
                        EM_LINELENGTH, 0, 0L))
                EnableWindow (GetDlgItem (hDlg, IDC_MAKEQUERY),
                      TRUE);
            else
                EnableWindow (GetDlgItem (hDlg, IDC_MAKEQUERY),
                      FALSE);
            return TRUE;
            }
            else
            return FALSE;

        case IDC_MAKEQUERY:                                                   
                SendDlgItemMessage (hDlg, IDC_NAMEINPUT, (UINT) WM_GETTEXT,
                        (WPARAM) 255,
                        (LPARAM) ((LPSTR) szHost));
                SendDlgItemMessage (hDlg, IDC_NAMEINPUT, (UINT) EM_SETSEL,
                        0, MAKELPARAM (0,-1));
                if (*szHost)
                {
                    char szStatus[144];
                    strcpy (szStatus, "Querying server '");
                    strcat (szStatus, szQueryhost);
                    strcat (szStatus, "'.");
                    strcat (szHost, "\r\n");
                    SendDlgItemMessage (hDlg, IDC_STATUS, WM_SETTEXT,
                            0, (LPARAM) (LPCSTR)
                            szStatus);
		    DoWhoIsQuery(hDlg,(LPSTR)szHost,(LPSTR)szQueryhost);
                    return TRUE;
                }
                else {
                MessageBox (NULL, "No name to query specified!",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                return TRUE;
                }

        case IDC_GETLIST:
            {
                    char szStatus[144];
                    strcpy (szStatus, "Querying server '");
                    strcat (szStatus, szServHost);
                    strcat (szStatus, "'.");
                    strcat (szHost, "\r\n");
                    SendDlgItemMessage (hDlg, IDC_STATUS, WM_SETTEXT,
                            0, (LPARAM) (LPCSTR)
                            szStatus);
                    DoWhoIsQuery (hDlg, (LPSTR)"whois-servers\r\n", 
                                        (LPSTR)szServHost);
                    return TRUE;
            }
        
        case IDC_EXIT:
                while (hHeadReq != NULL)
                {
                    HWND hWindow;
                    hWindow = HeadReq->hWin;
                    closesocket (HeadReq->s);
                    CleanRequest (hWindow);
                    DestroyWindow (hWindow);
                }
                EndDialog (hDlg, 0);
                return TRUE;
        }
        return FALSE;

    }
    return FALSE;
}



void CopyText (HWND hDlg, WORD wIDControl)
{

    HANDLE hWholeString;
    HANDLE hCutString;
    LPSTR lpszWholeString;
    LPSTR lpszCutString;
    DWORD ccControl;
    WORD wStartChar;
    WORD wEndChar;
    DWORD dwStartAndEnd;

    dwStartAndEnd = SendDlgItemMessage (hDlg, wIDControl, EM_GETSEL, 0, 0L);
    wStartChar = LOWORD (dwStartAndEnd);
    wEndChar = HIWORD (dwStartAndEnd);

    if (wStartChar == wEndChar)
    {
    SendDlgItemMessage (hDlg, wIDControl, EM_SETSEL, 0,
                MAKELPARAM (0, -1));
    dwStartAndEnd = SendDlgItemMessage (hDlg, wIDControl,
                        EM_GETSEL, 0, 0L);
    wStartChar = LOWORD (dwStartAndEnd);
    wEndChar = HIWORD (dwStartAndEnd);
    if (wStartChar == wEndChar)
        return;
    }

    hWholeString = GlobalAlloc (GHND, ccControl =
                 SendDlgItemMessage (hDlg, wIDControl,
                 WM_GETTEXTLENGTH, 0,0) + 256);
    lpszWholeString = GlobalLock (hWholeString);

    SendDlgItemMessage (hDlg, wIDControl, WM_GETTEXT, (WPARAM) ccControl,
               (LPARAM) lpszWholeString);


    hCutString = GlobalAlloc (GHND, wEndChar - wStartChar + 256);
    lpszCutString = GlobalLock (hCutString);

    memcpy (lpszCutString, lpszWholeString + wStartChar * sizeof (char),
        (wEndChar - wStartChar) * sizeof (char));

    GlobalUnlock (hCutString);

    OpenClipboard (hDlg);
    EmptyClipboard ();
    SetClipboardData (CF_TEXT, hCutString);
    CloseClipboard ();
    GlobalFree (hCutString);


    GlobalUnlock (hWholeString);
    GlobalFree (hWholeString);

}

void ClearText (HWND hDlg, WORD wIDControl)
{
    DWORD dwStartAndEnd;
    WORD wStartChar;
    WORD wEndChar;

    dwStartAndEnd = SendDlgItemMessage (hDlg, wIDControl, EM_GETSEL, 0, 0L);
    wStartChar = LOWORD (dwStartAndEnd);
    wEndChar = HIWORD (dwStartAndEnd);

    if (wStartChar == wEndChar)
    SendDlgItemMessage (hDlg, wIDControl, EM_SETSEL, 0,
                MAKELPARAM (0, -1));

    SendDlgItemMessage (hDlg, wIDControl, EM_REPLACESEL, 0,
            (LPARAM) (LPCSTR) "");

}


LONG FAR PASCAL QueryWndProc (HWND hWind, UINT message, WPARAM wParam, LPARAM lParam)
{
    int s, i, cc, iOutPos;
    struct sockaddr_in;
    DWORD addr;
    HANDLE hszLine, hszOutput;
	LPSTR lpszLine;
	LPSTR lpszOutput;
    REQUEST FAR *thisreq;
        
    switch (message) {
    
        case START_QUERY:
            {
                thisreq = FindRequest (hWind);
                thisreq->hbuffer = GlobalAlloc (GHND, MAXGETHOSTSTRUCT);
                thisreq->lpbuffer = (struct hostent FAR *)GlobalLock (thisreq->hbuffer);
                WSAAsyncGetHostByName (hWind, IDC_GOTADDR, 
                    thisreq->lpQuery, (LPSTR)thisreq->lpbuffer, MAXGETHOSTSTRUCT);
                return TRUE;
            }
        case IDC_GOTADDR:
            {
                unsigned long ii;
                ii = 1;
                thisreq = FindRequest (hWind);

                if (WSAGETASYNCERROR (lParam) != 0) {
                MessageBox (NULL, "Could not resolve host",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                GRelease (&thisreq->hbuffer);
                return FALSE;
                }
                memcpy (&addr, thisreq->lpbuffer->h_addr_list[0],
                            thisreq->lpbuffer->h_length);
                thisreq->s = socket (PF_INET, SOCK_STREAM, 0);
                if (thisreq->s < 0) {
                    MessageBox (NULL, "Could not create socket for communication",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                    GRelease (&thisreq->hbuffer);
                    PostMessage (hWind, IDC_RESETDISPLAY, 0, 0);
                return FALSE;
                }
                ioctlsocket (thisreq->s, FIONBIO, (unsigned long FAR *)&ii);
                thisreq->sock_in.sin_family = PF_INET;
                thisreq->sock_in.sin_port = 0;
                thisreq->sock_in.sin_addr.s_addr = INADDR_ANY;
                if (bind (thisreq->s, (struct sockaddr FAR*) &(thisreq->sock_in),
                     sizeof (thisreq->sock_in)) < 0) {
                    MessageBox (NULL, "Could not bind socket.",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                    closesocket (thisreq->s);
                    GRelease (&thisreq->hbuffer);
                    PostMessage (hWind, IDC_RESETDISPLAY, 0, 0);
                return FALSE;
                }
                GRelease (&thisreq->hbuffer);
                thisreq->sphandle = GlobalAlloc (GHND, MAXGETHOSTSTRUCT);
                thisreq->sp = (struct servent FAR *)GlobalLock (thisreq->sphandle);
                memcpy ((char FAR *)&(thisreq->sock_in.sin_addr), (char FAR *)&addr, 4);
                WSAAsyncGetServByName (hWind, IDC_GOTSERVER, "whois", "tcp", 
                    (LPSTR)thisreq->sp, MAXGETHOSTSTRUCT);
                return TRUE;
            }
        case IDC_GOTSERVER:
            {
                thisreq = FindRequest (hWind);
                if (WSAGETASYNCERROR (lParam) != 0) {
                    MessageBox (NULL, "Found no service: whois / tcp",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                    closesocket (thisreq->s);
                    GRelease (&thisreq->sphandle);
                    PostMessage (hWind, IDC_RESETDISPLAY, 0, 0);
                    return FALSE;
                }
                if (!thisreq->sp) {
                    MessageBox (NULL, "Can't lock service: whois / tcp",
                        "WinWhoIs", MB_OK | MB_ICONHAND);
                    closesocket (thisreq->s);
                    GRelease (&thisreq->sphandle);
                    PostMessage (hWind, IDC_RESETDISPLAY, 0, 0);
                    return FALSE;
                }
                thisreq->sock_in.sin_port = thisreq->sp -> s_port;

                if (connect (thisreq->s, (struct sockaddr FAR *) &(thisreq->sock_in),
                     sizeof (thisreq->sock_in)) != 0) {
                    int lerror;
                    lerror = WSAGetLastError ();
                    if (lerror == WSAEWOULDBLOCK)
                    {
                        WSAAsyncSelect (thisreq->s, hWind, IDC_GOTCONNECT, FD_CONNECT);
                        GRelease (&thisreq->sphandle);
                        return FALSE;
                    }
                    else
                    {
                        wsprintf (lpszLine,"Could not connect; error #%d", lerror);
                        MessageBox (NULL, lpszLine,
                            "WinWhoIs", MB_OK | MB_ICONHAND);
                        closesocket (thisreq->s);
                        GRelease (&thisreq->sphandle);
                        PostMessage (hWind, IDC_RESETDISPLAY, 0, 0);
                        return FALSE;
                    }
                }
            
                GRelease (&thisreq->sphandle);
                /*  Fall Through  */
            }
        case IDC_GOTCONNECT:
            {
                thisreq = FindRequest (hWind);
                if (send (thisreq->s, (LPSTR)thisreq->lpHost, 
                        lstrlen ((LPSTR)thisreq->lpHost), 0) == SOCKET_ERROR)    {
                    int lerror;
                    lerror = WSAGetLastError ();
                    if (lerror == WSAEWOULDBLOCK)
                    {
                        WSAAsyncSelect (thisreq->s, hWind, IDC_GOTCONNECT, FD_WRITE);
                        return FALSE;
                    }
                    else
                    {
                        MessageBox (NULL, "Could not send request",
                            "WinWhoIs", MB_OK | MB_ICONHAND);
                        closesocket (thisreq->s);
                        PostMessage (hWind, IDC_RESETDISPLAY, 0, 0);
                        return FALSE;
                    }
                }
                WSAAsyncSelect (thisreq->s, hWind, IDC_GOTRESPONSE, FD_READ | FD_CLOSE);
            return TRUE;
            }                       
        case IDC_GOTRESPONSE:
            {
                hszLine = GlobalAlloc (GHND, 256);
                lpszLine = GlobalLock (hszLine);
                hszOutput = GlobalAlloc (GHND, 512);
                lpszOutput = GlobalLock (hszOutput);
                s = (int) wParam;

                if ((cc = recv (s, lpszLine, 256, 0)) > 0) {
                    for (i = 0, iOutPos = 0; i < cc; ++i)
                        if (lpszLine [i] == '\n') {
                        lpszOutput [iOutPos++] = '\r';
                        lpszOutput [iOutPos++] = '\n';
                        }
                        else
                        lpszOutput [iOutPos++] = lpszLine [i];
                    
                    lpszOutput [iOutPos] = '\0';
                    SendDlgItemMessage (hDialog, IDC_RESPONSES, EM_REPLACESEL,
                        0, (LPARAM) ((LPCSTR) lpszOutput));
                    GlobalUnlock (hszLine);
                    GlobalFree (hszLine);
                    GlobalUnlock (hszOutput);
                    GlobalFree (hszOutput);

                    return FALSE;  /* If there's more, WSASelect() will get it... */
                }
                else if (cc != 0)
                {
                    int ii;
                    if (ii = WSAGetLastError () == WSAEWOULDBLOCK)
                        return FALSE;
                    MessageBox (NULL, "Receiving error occurred.",
                                "WinWhois", MB_OK | MB_ICONHAND);
                }
        /*  Now we're done;  clean up  */

                WSAAsyncSelect (s, hWind, 0, 0);
                if (closesocket (s))
                    MessageBox (NULL, "Socket did not close!", "WinWhois",
                            MB_OK | MB_ICONHAND);
                GlobalUnlock (hszLine);
                GlobalFree (hszLine);
                GlobalUnlock (hszOutput);
                GlobalFree (hszOutput);
                            SendDlgItemMessage (hDialog, IDC_STATUS, WM_SETTEXT,
                            0, (LPARAM) (LPCSTR)
                            "Waiting for input...");
                    SetFocus (GetDlgItem (hDialog, IDC_NAMEINPUT));
                /* Fall Through */
            }
            case IDC_RESETDISPLAY:
            {
                CleanRequest (hWind);
                DestroyWindow (hWind);
                return TRUE;
            }

       default:
            return (DefWindowProc (hWind, message, wParam, lParam));
      } /*switch*/
    return FALSE;
}

REQUEST FAR *FindRequest (HWND hWind)
{
    REQUEST FAR *CurrReq;
    int flag;
    
    flag = TRUE;
    CurrReq = HeadReq;
    while ((CurrReq != NULL) && (flag))
    {
        if (CurrReq->hWin == hWind)
            flag = FALSE;
        else
        {
            CurrReq = CurrReq->NextReq;
        }
    }
    return CurrReq;
}

void GRelease (HANDLE FAR *h)
{
    if (*h)
    {
        GlobalUnlock (*h);
        GlobalFree (*h);
        *h=NULL;
    }
    return;
}

void CleanRequest (HWND hWind)
{
    REQUEST FAR *thisreq;
    REQUEST FAR *tempreq;
    HANDLE temph;
    
    thisreq = FindRequest (hWind);
    GRelease (&thisreq->hHost);
    GRelease (&thisreq->hQuery);
    GRelease (&thisreq->hbuffer);
    GRelease (&thisreq->sphandle);
    if (thisreq == HeadReq)
    {
        tempreq = thisreq->NextReq;
        temph = thisreq->hNextReq;
        GRelease (&hHeadReq);
        hHeadReq = temph;
        HeadReq = tempreq;
        return;
    }
    tempreq = HeadReq;
    while (tempreq->NextReq != thisreq)
        tempreq = tempreq->NextReq;
    temph = tempreq->hNextReq;
    tempreq->hNextReq = thisreq->hNextReq;
    tempreq->NextReq = thisreq->NextReq;
    GRelease (&temph);
    return;
}

