/* bsh.h
*/
 
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <fcntl.h>

#define VERSION (".001")
#define LLEN            (80)
#define PROMPT          ("smash> ")
#define HISTORYLIMIT    (100)
#define MAXTOKEN        (80)
#define FALSE		(0)
#define EOS             ('\0')
#define C_SPC		(' ')
#define C_TAB		('\t')
#define C_EOL		('\n')
#define C_QUOT		('\"')
#define C_QQUOT		('\'')
#define C_BKGRD		('&')
#define C_REDIR1	('>')
#define C_REDIR2	('>>')
#define C_PIPE		('|')
#define C_WILDALL ('*')
#define C_WILDCHR ('?')
#define MAXCMDS    (100)
#define MAXJOB	(10)
#define ORDER(a)	hisrec.hisring[(a)].order
#define COMMAND(a)	hisrec.hisring[(a)].cmdln

/* flags to different symbols */
#define BKGRD 1
#define REDIRECT1 2
#define REDIRECT2	3	/* append */
#define PIPE 4 

extern char **environ;
extern int errorno;
int getline();
int gettoken();
void ToHisTbl();
void SkipBlank();

typedef enum{false, true} boolean;
/* command table stuff */
typedef struct 
{
	char *name;
	int (*func)();
	char *usage;
} CMDTABLE;

/* shell commands */
int	Interpret(),
		BangBang(int, char **),
		Bang(int, char **),
		ChangeDir(int, char**),		
		ExitShell(int, char** ),	
		PrtHis(int, char**),
		SetEnv(int, char**),
    PrtEnv(int, char**),
		ExecuteCmd(int, char **,int),
		Foreground(int, char **),
		Initial(),
		Help(int, char **),
 		BackgroundHandler();

void doStop(),
		PutJobInBackground(int);

/* ------------------ History Table -- a "Ring" ---------- */
typedef struct {
  int  order;
  char cmdln[LLEN];
} RING;

typedef struct {
  RING  hisring[HISTORYLIMIT];
  int   rear;
  int   count;
} HISRECORD ;

HISRECORD hisrec;

#define Succ(i) (((i)+1)%HISTORYLIMIT)
#define Pred(i) (((i)-1+HISTORYLIMIT)%HISTORYLIMIT)

int (*search())();

/* for future use... job control */
typedef struct {
	int job_no;		/* job number */
	int proc_id;	/* pid associated with job # */
}	JOB ;

JOB job[MAXJOB];
