// pbimg.java 23-Jan-1996/SBH
//
// Written to demo the use of overlaid image files to give a transparent
// effect, hint text on MouseEnter and URL jump on mouse down
//
// Revision History
// ================
// 23-Jan-1996/SBH      Created.
//
//
//-------------------------------------------------------------------------

import java.awt.*;
import java.util.StringTokenizer;
import java.net.URL;
import java.net.MalformedURLException;

//========================================================================
class hint
{
  private int     x,y,h,w;  //position,height,width
  private boolean bVisible;
  private String szMyText;  

  public hint (int _x,int _y, String _szMyText)
  {
  x = _x;
  y = _y;
  szMyText = _szMyText;
  }

  public void hide()
  {
    bVisible = false;
  }
  public void show()
  {
    bVisible = true;
  }

  public void draw(Graphics g)
  {
  if (bVisible)
    {
      w = g.getFontMetrics().stringWidth(szMyText+"  ");
      h = g.getFontMetrics().getHeight();

      g.setColor(Color.yellow);
      g.fillRect(x,y,w,h);
      g.setColor(Color.black);
      g.drawRect(x,y,w,h);
      g.drawString(szMyText,x+2,y+h-2);
    }
  }
}
//========================================================================
public class pbimg extends java.applet.Applet implements Runnable {

    Thread timer;

    Image offscreen;
    Image Imgbackground;
    Image ImgMain;

    int iBackWidth;
    Dimension offscreensize;
    Graphics offG;
    Graphics onGC;

    String szBackGroundFile;
    String szImageFile;

    boolean bBackgroundOK = false;
    boolean bImageOK      = false;

    URL uURL;

    hint myHint;

    Color colMyBackground;


    public void init()
    {

        colMyBackground = getColorFromParam("bgcolor",Color.gray);

        myHint = new hint(15,15,getParameter("hint_text"));
        myHint.hide();

        try
        {
	    uURL = new URL(getDocumentBase(), getParameter("url"));
	}
          catch (MalformedURLException e)
          {
	    uURL = null;
	  }

        boolean bDone = false;

        // we always use the same graphics context, get it now..

        onGC = getGraphics();
        szBackGroundFile = getParameter("background");

        if (null != (Imgbackground = getImage(getDocumentBase(),szBackGroundFile)))
        {
           bBackgroundOK = true;
        }

        szImageFile = getParameter("image");

        if (null != (ImgMain = getImage(getDocumentBase(),szImageFile)))
        {
           bImageOK = true;
        }

    } //init()

    public boolean mouseUp(Event evt,int x, int y)
    {
    if (uURL != null)
    {
        // let's jump..
        getAppletContext().showDocument(uURL);
    }
    return(true);
    }


    public boolean mouseMove(Event evt,int x, int y)
    {
    return(true);
    }
    public boolean mouseEnter(Event evt,int x, int y)
    {
    myHint.show();
    redraw(onGC);
    return(true);
    }

    public boolean mouseExit(Event evt,int x, int y)
    {
    myHint.hide();
    redraw(onGC);
    return(true);
    }


    public void paint(Graphics g)
    {
    redraw(onGC);
    }

   
    public void redraw(Graphics g)
    {
        Dimension d = size();
	if ((offscreen == null) || (d.width != offscreensize.width) || (d.height != offscreensize.height))
        {
            // create an offscreen graphics context identical in size
            // to the one we've been given.

	    offscreen = createImage(d.width, d.height);
	    offscreensize = d;
            offG = offscreen.getGraphics();

            // fill background
         offG.setColor(colMyBackground);
         offG.fillRect(0, 0, d.width, d.height);
       }

        // tile image onto background, if one was specified.
        if (bBackgroundOK)
        {
          Dimension mysize = size();
          if ((iBackWidth = Imgbackground.getWidth(this))>0)
          {
            int bx,by,iBackHeight;
            // we tile the background with repeated draws, starting top left

            if((iBackHeight = Imgbackground.getHeight(this))>0)
              for (bx=0;bx < mysize.width;bx += iBackWidth)
                for (by=0;by < mysize.height;by += iBackHeight)
                 offG.drawImage(Imgbackground,bx,by,this);
          }
        }

        if (bImageOK)
        {
           offG.drawImage(ImgMain,0,0,this);
        }

        // All application graphics code must go here, drawing on offG
        // which is already setup with background & image.
        myHint.draw(offG);

        // and end here...

        // copy offscreen to onscreen
        g.drawImage(offscreen, 0, 0, null);
    }

    Color getColorFromParam(String szParam,Color col_default)
//
// Returns a Color based on a Hex triplet specified as a parameter to
// the applet. If the parameter doesn't exist, or doesn't parse
// correctly, we return col_default.
//
// 01-Jan-1996/SBH      Created

  {
    String szColor;
    String szTemp;

    int Red,Blue,Green;
    int offset = 0;


    if((szColor = getParameter(szParam)) == null)
    {
      return (col_default);
    }
    else
    {
      //Hex triplets optionally start with '#'

      if (szColor.startsWith("#"))
      {
        offset = 1;
      }

 //     System.out.println("hex triplet is " + szColor);
      try
      {
        Red   = Integer.parseInt(szColor.substring(0+offset,2+offset),16);
        Green = Integer.parseInt(szColor.substring(2+offset,4+offset),16);
        Blue  = Integer.parseInt(szColor.substring(4+offset,6+offset),16);
      }
      catch (Exception e)
      {
        return (col_default);
      }

//      System.out.println("RGB (dec)"+ Red + "," + Green +"," +Blue );
      return new Color ( Red,Green,Blue);
    }
  }


    public void start() {
        timer = new Thread(this);
        timer.start();
    }
    public void stop() {
        timer.stop();
    }

    public String getAppletInfo()
    {
      return("pbimg v0.0 - Steve Hill 100144.3120@compuserve.com");
    }

    public String[][] getParameterInfo()
    {
     String pinfo[][] =
     {
        {"hint_text",      "string",    "Hint text to display"},
        {"bgcolor", "RGB hex triplet", "Color of background (optional)"},
        {"background","URL","Image to tile on background(optional)"},
        {"image","URL","Image which forms button(optional - hidden link!)"},
        {"url","URL","Where to go when clicked.."}
     };

      return (pinfo);
  }

    public void run()
    
    {
        while (true)
        {
        //This is effectively a waste of time, but seems to be necessary
        //in Netscape for it to display correctly. Ok in appletviewer w/out.
        try {Thread.currentThread().sleep(5000);} catch (InterruptedException e){}
        }
    }
}
