#include <string.h>
#include <conio.h>

#include "get_scan.cpp"         // Convert ASCII to scan code


/*

Function:       int keybuf(char *string)
Author:         Shawn A. Clifford      sysop@robot.nuceng.ufl.edu
Date:           09-DEC-1993
Purpose:        Inserts a string into the keyboard buffer.  This function
		returns the number of characters actually inserted.  You
		can stuff up 15 characters in the buffer if there is nothing
		already in the buffer.

This routine plays with the keyboard buffer.  It uses Borland C/C++'s
peek & poke functions.  You will need to include CONIO.H to use these
functions and STRING.H for the  strlen()  function.
Remove the inline comments ('// ...') for no C++.

The keyboard buffer is a circular buffer of 16 words (32 bytes).  It
occupies memory between 0000:041E and 0000:043E (note that 043C is the
_beginning_ of the last word).  Note also that 0000:041E => 0040:001E.
Despite what Norton says, the buffer will only hold 15 (_NOT_ 16)
key actions.  Although it could if there were a counter somewhere.  The
last word is not used, but provides a buffer between the head and tail.
That is, the tail always points to an available word.

Each word contains a scan code in the high byte and the ASCII character
in the low byte.  Functions keys, etc., have 0x00 in the low byte.

There is a head pointer that resides at 0000:041A, and a tail pointer
that resides at 0000:041C.  See Norton's Programmer's Guide to the IBM PC
for more information.

*/

int keybuf(char *string)
{
unsigned short key_buf_head, key_buf_tail, c, i, key_count;
unsigned short buf_cmd[15];



   /* Get the byte offset from the start of the segment (ie. 0040:0000) */
   key_buf_head = peek(0x0000, 0x041A);
   key_buf_tail = peek(0x0000, 0x041C);



//   printf("Contents of buffer:\n");
//   while (key_buf_head != key_buf_tail) {
//
//      c = (int) peek(0x0040, key_buf_head);
//      printf("%c", ((short)c & 0x00ff) );
//
//      if (key_buf_head == 0x003C)             // Highest word in circle
//       key_buf_head = 0x001E;                 // Bottom of circle
//      else
//       key_buf_head += 2;                     // Go forward one word
//   }


   /* This is the code to insert the string. */

   key_count = (strlen(string));                // Count the keys
   if (key_count > 15) key_count = 15;          // Truncate if necessary


   /* Store the string in an array of words. */
   /* The scan code goes into the high byte, and the ASCII */
   /* character goes into the low byte of the word.        */
   for (i=0; i < key_count; i++) {
      buf_cmd[i] = (get_scan(*string)<<8) + (unsigned char) *string;
      string++;
   }


   /* Make sure it is Ok to stick a character at the tail. */
   /* Like, don't write on my head, man!                   */
   i = 0;
   while ( ((key_buf_head - key_buf_tail) != 2) &&
	  !((key_buf_head == 0x001E) && (key_buf_tail == 0x003C)) ) {


      /* Ok, stick in the command. */
      poke(0x0040, key_buf_tail, buf_cmd[i]);


      /* Move the tail. */
      if (key_buf_tail == 0x003C) {             // Highest word in circle
	 poke(0x0000, 0x041C, (short) 0x001E);
	 key_buf_tail = 0x001E;
	 }
      else {
	 poke(0x0000, 0x041C, (short) key_buf_tail+2);
	 key_buf_tail += 2;
	 }

      /* Check our limits. */
      i++;
      if (i == key_count) break;

   }

   return (i--);

}  /* keybuf() */
