Sub LoadFormPosition (f As Form)
' Gets the form position from our .INI file.
' If a form position is found, repositions us to that
' position, otherwise does nothing

' NOTE! The .INI file section name is in <form>.Tag
'	The .INI file name is in the global const INI_NAME

Dim nTop As Integer
Dim nLeft As Integer

    nTop = GetPrivateProfileInt(f.Tag, "Top", f.Top, INI_NAME)
    nLeft = GetPrivateProfileInt(f.Tag, "Left", f.Left, INI_NAME)

    f.Move nLeft, nTop

End Sub


Sub SaveFormPosition (f As Form)
' Saves the top,left,height & width positions of <f> into our
' .INI file, using <f>.Tag as a section heading

' NOTE	The .INI file name is in the global const INI_NAME

Dim i As Integer

' The top position
    i = WritePrivateProfileString(f.Tag, "Top", LTrim$(Str$(f.Top)), INI_NAME)
    i = WritePrivateProfileString(f.Tag, "Left", LTrim$(Str$(f.Left)), INI_NAME)
    i = WritePrivateProfileString(f.Tag, "Height", LTrim$(Str$(f.Height)), INI_NAME)
    i = WritePrivateProfileString(f.Tag, "Width", LTrim$(Str$(f.Width)), INI_NAME)

End Sub
