//
//    *******************************************************************
//      JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//    *******************************************************************
//

//
//  OS/2 KBD API
//

#ifndef _KBDKEYINFO_DEFINED
typedef struct {
		unsigned char    chChar;
		unsigned char    chScan;
		unsigned char    fbStatus;
		unsigned char    bNlsShift;
		unsigned short   fsState;
		unsigned long    time;
} KBDKEYINFO;
#define _KBDKEYINFO_DEFINED
#endif

#ifndef _STRINGINBUF_DEFINED
typedef struct {
        unsigned short cb;
        unsigned short cchIn;
} STRINGINBUF;
#define _STRINGINBUF_DEFINED
#endif

#ifndef _KBDINFO_DEFINED
typedef struct {
        unsigned short cb;
        unsigned short fsMask;
        unsigned short chTurnAround;
        unsigned short fsInterim;
        unsigned short fsState;
}KBDINFO;
#define _KBDINFO_DEFINED
#endif

#ifndef _KBDTRANSLATE_DEFINED
typedef struct {
        unsigned char      chChar;
        unsigned char      chScan;
        unsigned char      fbStatus;
		unsigned char      bNlsShift;
        unsigned short     fsState;
        unsigned long      time;
        unsigned short     fsDD;
        unsigned short     fsXlate;
        unsigned short     fsShift;
        unsigned short     sZero;
} KBDTRANSLATE;
#define _KBDTRANSLATE_DEFINED
#endif

extern "C" {

    USHORT _APICALL KbdRegister (unsigned char far *, unsigned char far *, unsigned long);

#define KR_KBDCHARIN        0x00000001
#define KR_KBDPEEK          0x00000002
#define KR_KBDFLUSHBUFFER   0x00000004
#define KR_KBDGETSTATUS     0x00000008
#define KR_KBDSETSTATUS     0x00000010
#define KR_KBDSTRINGIN      0x00000020
#define KR_KBDOPEN          0x00000040
#define KR_KBDCLOSE         0x00000080
#define KR_KBDGETFOCUS      0x00000100
#define KR_KBDFREEFOCUS     0x00000200
#define KR_KBDGETCP         0x00000400
#define KR_KBDSETCP         0x00000800
#define KR_KBDXLATE         0x00001000
#define KR_KBDSETCUSTXT     0x00002000

    USHORT _APICALL KbdDeRegister ( void );

    USHORT _APICALL KbdCharIn ( KBDKEYINFO far *, unsigned short, unsigned short );
    USHORT _APICALL KbdPeek ( KBDKEYINFO far *, unsigned short );

#define IO_WAIT     0
#define IO_NOWAIT   1

	USHORT _APICALL KbdStringIn ( char far *, STRINGINBUF far *, unsigned short, unsigned short );

    USHORT _APICALL KbdFlushBuffer ( unsigned short );

    USHORT _APICALL KbdSetStatus ( KBDINFO far *, unsigned short );
	USHORT _APICALL KbdGetStatus ( KBDINFO far *, unsigned short );

	USHORT _APICALL KbdSetCp ( unsigned short, unsigned short, unsigned short);
	USHORT _APICALL KbdGetCp ( unsigned long, unsigned short far *, unsigned short );

	USHORT _APICALL KbdOpen ( unsigned short far * );
	USHORT _APICALL KbdClose ( unsigned short );

	USHORT _APICALL KbdGetFocus ( unsigned short, unsigned short );
	USHORT _APICALL KbdFreeFocus ( unsigned short );

	USHORT _APICALL KbdSynch ( unsigned short );

	USHORT _APICALL KbdXlate ( KBDTRANSLATE far *, unsigned short );
	USHORT _APICALL KbdSetCustXt ( unsigned short far *, unsigned short );

}
