From: hinson@bohr.physics.purdue.edu (Jason W. Hinson)
Newsgroups: rec.arts.startrek.tech
Subject: Relativity and FTL Travel
Summary: A detailed look at the problem
Message-ID: <8974@dirac.physics.purdue.edu>
Date: 18 Dec 92 21:35:54 GMT
Organization: Purdue University Physics Department
Lines: 785


 
Finally, here it is.  It is a length discussion,  794 lines by my count, 
but it is fairly complete for what I intended to do.  Also, if you are 
only interested in a particular part, you can just skip the rest.  
 
What is it about, and who should read it:
	This is a detailed explanation about how relativity and that 
wonderful science fictional invention of faster than light travel do not 
seem to get along with each other.  It begins with a simple introduction 
to the ideas of relativity.  This section includes some important 
information on space-time diagrams, so if you are not familiar with 
them, I suggest you read it.  Then I get into the problems that 
relativity poses for faster than light travel.  If you think that there 
are many science fictional ways that we can get around these problems, 
then you probably do not understand the second problem which I discuss 
in the third section, and I strongly recommend that you read it to 
educate yourself.  Finally, I introduce my idea (the only one I know of) 
that, if nothing else, gets around this second problem in an interesting 
way. 
	The best way to read the article may be to make a hard copy.  I 
refer back a few times to a Diagram in the first section, and to have it 
readily available would be nice.
	I hope you can learn a little something from reading this, or at 
least strengthen your understanding of that which you already know.  
Your comments and criticisms are welcome, especially if they indicate 
improvements that can be made for future posts.
	And now, without further delay, here it is.
 

 
                        Relativity and FTL Travel
 
Outline:
 
I.	An Introduction to Special Relativity
	A.	Reasoning for its existence
	B.	Time dilation effects
	C.	Other effects on observers
	E.	Space-Time Diagrams
	D.	Experimental support for the theory
II.	The First Problem:  The Light Speed Barrier
	A.	Effects as one approaches the speed of light
	B.	Conceptual ideas around this problem
III.	The Second Problem:  FTL Implies The Violation of Causality
	A.	What is meant here by causality, and its importance
	B.	Why FTL travel of any kind implies violation of causality
	C.	A scenario as "proof"
IV.	A Way Around the Second Problem
	A.	Warped space as a special frame of reference
	B.	How this solves the causality problem
	C.	The relativity problem this produces
	D.	One way around that relativity problem
V.	Conclusion.
 
 
 
 
 
 
 
I.	An Introduction to Special Relativity
 
	The main goal of this introduction is to make relativity and its 
consequences feasible to those who have not seen them before.  It should 
also reinforce such ideas for those who are already somewhat familiar 
with them.  This introduction will not completely follow the traditional 
way in which relativity came about.  It will begin with a pre-Einstein 
view of relativity.  It will then give some reasoning for why Einstein's 
view is plausible.  This will lead to a discussion of some of the 
consequences this theory has, odd as they may seem.  For future 
reference, it will also introduce the reader to the basics of space-time 
diagrams.  Finally, I want to mention some experimental evidence that 
supports the theory.
 
	The idea of relativity was around in Newton's day, but it was 
incomplete.  It involved transforming from one frame of reference to 
another frame which is moving with respect to the first.  The 
transformation was not completely correct, but it seemed so in the realm 
of small speeds.  I give here an example of this to make it clear.  
	Consider two observers, you and me, for example.  Lets say I am 
on a train which passes you at 30 miles per hour.  I through a ball in 
the direction the train is moving, and the ball moves at 10 mph in MY 
point of view.  Now consider a mark on the train tracks.  You see the 
ball initially moving along at the same speed I am moving (the speed of 
the train).  Then I through the ball, and before I can reach the mark on 
the track, the ball is able to reach it.  So to you, the ball is moving 
even faster than I (and the train).  Obviously, it seems as if the speed 
of the ball with respect to you is just the speed of the ball with 
respect to me plus the speed of me with respect to you.   So, the speed 
of the ball with respect to you = 10 mph + 30 mph = 40 mph.  This was 
the first, simple idea for transforming velocities from one frame of 
reference to another. In other words, this was part of the first concept 
of relativity.
 
	Now I introduce you to an important postulate that leads to the 
concept of relativity that we have today.  I believe it will seem quite 
reasonable.  I state it as it appears in a physics book by Serway: "the 
laws of physics are the same in every inertial frame of reference."  
What it means is that if you observer any physical laws for a given 
situation in your frame of reference, then an observer in a reference 
frame moving with a constant velocity with respect to you should also 
agree that those physical laws apply to that situation.  
	As an example, consider the conservation of momentum.  Say that 
there are two balls coming straight at one another.  They collide and go 
off in opposite directions.  Conservation of momentum says that if you 
add up the total momentum (mass times velocity) before the collision and 
after the collision, that the two should be identical.  Now, let this 
experiment be preformed on a train where the balls are moving along the 
line of the train's motion.  An outside observer would say that the 
initial and final velocities of the balls are one thing, while an 
observer on the train would say they were something different.  However, 
BOTH observers must agree that the total momentum is the same before and 
after the collision.  We should be able to apply this to any physical 
law.  If not, (i.e.  if physical laws were different for different 
frames of reference) then we could change the laws of physics just by 
traveling in a particular reference frame.
	A very interesting result occurs when you apply this postulate 
to the laws of electrodynamics.  What one finds is that in order for the 
laws of electrodynamics to be the same in all inertial reference frames, 
it must be true that the speed of electromagnetic waves (such as light) 
is the same for all inertial observers.  Simply stating that may not 
make you think that there is anything that interesting about it, but it 
has amazing consequences.  Consider letting a beam of light take the 
place of the ball in the first example given in this introduction.  If 
the train is moving at half the velocity of light, wouldn't you expect 
the light beam (which is traveling at the speed of light with respect to 
the train) to look as if it is traveling one and a half that speed with 
respect to an outside observer?  Well this is not the case.  The old 
ideas of relativity in Newton's day do not apply here.  What accounts 
for this peculiarity is time dilation and length contraction.
	Here I give an example of how time dilation can help explain a 
peculiarity that arises from the above concept.  Again we consider a 
train, but let's give it a speed of 0.6 c (where c = the speed of light 
which is 3E8 m/s).  An occupant of this train shines a beam of light so 
that (to him) the beam goes straight up, hits a mirror at the top of the 
train, and bounces back to the floor of the train where it is detected. 
Now, in my point of view (outside of the train), that beam of light does 
not travel straight up and straight down, but makes an up-side-down "V" 
shape since the train is also moving.  Here is a diagram of what I see:
 
 
                         /|\
                        / | \
                       /  |  \
 light beam going up->/   |   \<-light beam on return trip
                     /    |    \
                    /     |     \
                   /      |      \
                  /       |       \
                 ---------|---------->trains motion (v = 0.6 c)
 
Lets say that the trip up takes 10 seconds in my point of view.  The 
distance the train travels during that time is:
	(0.6 * 3E8 m/s) * 10 s = 18E8 m.  
The distance that the beam travels on the way up (the slanted line to 
the left) must be 
	3E8 m/s * 10s = 30E8 m.  
Since the left side of the above figure is a right triangle, and we know 
the length of two of the sides, we can now solve for the height of the 
train: 
	Height = [(30E8 m)^2 - (18E8 m)^2]^0.5  =  24E8 m  
(It is a tall train, but this IS just a thought experiment).  Now we 
consider the frame of reference of the traveler.  The light MUST travel 
at 3E8 m/s for him also, and the height of the train doesn't change 
because only lengths in the direction of motion are contracted.  
Therefore, in his frame the light will reach the top of the train in 	24E8 m / 3E8 (m/s) = 8 seconds, 
and there you have it.  To me the event takes 10 seconds, while 
according to him it must take only 8 seconds.  We each measure time in 
different ways.
	To intensify this oddity, consider the fact that all inertial 
frames are equivalent.  That is, from the traveler's point of view he is 
the one who is sitting still, while I zip past him at 0.6 c.  So he will 
think that it is MY clock that is running slowly.  This lends itself 
over to what seem to be paradoxes which I will not get into here.  If 
you have any questions on such things (such as theJ"twin paradox" --
which can be understood with special relativity, by the way)  feel free 
to ask me about them, and I will do the best I can to answer you.
	As I mentioned above, length contraction is another consequence 
of relativity.  Consider the same two travelers in our previous example, 
and let each of them hold a meter stick horizontally (so that the length 
of the stick is oriented in the direction of motion of the train).  To 
the outside observer, the meter stick of the traveler on the train will 
look as if it is shorter than a meter.  Similarly, the observer on the 
train will think that the meter stick of the outside observer is the one 
that is contracted.  The closer one gets to the speed of light with 
respect to an observer, the shorter the stick will look to that 
observer. The factor which determines the amount of length contraction 
and time dilation is called gamma.
	Gamma is defined as (1 - v^2/c^2)^(-1/2).  For our train (for 
which v = 0.6 c), gamma is 1.25.  Lengths will be contracted and time 
dilated (as seen by the outside observer) by a factor of 1/gamma = 0.8, 
which is what we demonstrated with the difference in measured time (8 
seconds compared to 10 seconds). Gamma is obviously an important number 
in relativity, and it will appear as we discuss other consequences of 
the theory.
	Another consequence of relativity is a relationship between 
mass, energy, and momentum.  By considering conservation of momentum and 
energy as viewed from two frames of reference, one can find that the 
following relationship must be true for an unbound particle:
	E^2  =  p^2 * c^2  +  m^2 * c^4
Where E is energy, m is mass, and p is relativistic momentum which is 
defined as
	p  =  gamma * m * v     (gamma is defined above)
By manipulating the above equations, one can find another way to express 
the total energy as
	E  =  gamma * m * c^2
Even when an object is at rest (gamma = 1) it still has an energy of 
	E  =  m * c^2
Many of you have seen something like this stated in context with the 
theory of relativity.  
	It is important to note that the mass in the above equations has 
a special definition which we will now discuss. As a traveler approaches 
the speed of light with respect to an observer, the observer sees the 
mass of the traveler increase.  (By mass, we mean the property that 
indicates (1) how much force is needed to create a certain acceleration 
and (2) how much gravitational pull you will feel from that object).  
However, the mass in the above equations is defined as the mass measured 
in the rest frame of the object.  That mass is always the same.  The 
mass seen by the observer (which I will call the observed mass) is given 
by gamma * m.  Thus, we could also write the total energy as
	E = (observed mass) * c^2
That observed mass approaches infinity as the object approaches the 
speed of light with respect to the observer.
 
	So far we talked about the major consequences of special 
relativity, but now I want to concentrate more specifically on how 
relativity causes a transformation of space and time.  Relativity causes 
a little more than can be understood by simple length contraction and 
time dilation.  It actually results in two different observers having 
two different space-time coordinate systems.  The coordinates transform 
from one frame to the other through what are known as Lorentz 
Transformation.  Without getting deep into the math, much can be 
understood about such transforms by considering space-time diagrams.
	A space-time diagram consists of a coordinate system with one 
axis to represent space and another to represent time.  Where these two 
principle axes meet is the origin (see Diagram 1 below), and for the 
most part, we consider ourselves to be at that point.  Anything above 
the principle space axis is in our future, while anything below that 
axis is in our past.  Any event can be described as a point in this axis 
system.  For example, consider an event that took place 3 seconds ago 
and was 2 light seconds (the distance light travels in 2 seconds) away 
from you to the left (x = -2 light seconds).  This event is marked in 
Diagram 1 as a "*".  
	Now consider a traveler going away from the origin to the right.  
As time progresses forward, the traveler gets further and further from 
the time axis.  The faster he goes, the more slanted the line he makes 
will be as he is able to get far down the x axis in a short amount of 
time.  One important traveler to consider here is light.  If we define 
the x axis in light seconds and the time axis in seconds, then light 
will speed away from the origin creating a line at a 45 degree angle to 
the two axes. On diagram 2, I have drawn two lines which represent a 
pulse of light going away from the origin in the plus and minus x 
directions.  The two pulses are extended back into the past, as if they 
started from far off, came to the origin, and sped away in the future. 
This figure is known as a light cone.
	A light cone divides a space-time diagram into two major 
sections: the area inside the cone and the area outside the cone.  If it 
is impossible for anything to travel faster than light, then the only 
events in the past that you can know about at this moment are those that 
are inside the light cone.  Also, the only events that you can influence 
in the future are, again, those inside the light cone.
	Let us now consider (again) an arbitrary traveler who is going 
slower than the speed of light.  As a consequence of the Lorentz 
transforms that I have mentioned, the line he makes on the space-time 
diagram becomes his new time line (t').  Because of relativity, his 
space axis will also be transformed.  As can be seen in Diagram 3, his 
time axis has been rotated by some angle clockwise, while his space axis 
(x') has been rotated by the same angle counterclockwise.  The faster 
the speed, the greater this angle, and as you approach the speed of 
light, the two axis come closer and closer to being the same line (a 
line on the light cone which is at 45 degrees).  This gives him a skewed 
set of space-time coordinates that I have tried my best to show on 
Diagram 4 (squint your eyes, and you can see the skewed squares of the 
new coordinate system).  It is important to note that in this 
transformation, the position of the light cone does not change.  If you 
move one unit down the space axis, and one unit up the time axis, that 
point will still lie somewhere on the light cone.  This shows that the 
speed of light has not changed for the moving observer (it still travels 
one light second per second).
	Now let us compare the different ways that each observer views 
space and time.  Look at the event marked "*" on Diagram 3.  For the 
observer in the x',t' system, the event is in his future (above his 
principle x' axis).  For the observer in the x,t system, the event is in 
his past.  So how does this make since?  Recall two things: (1) you can 
only know about and influence events that are inside the light cone, and 
(2) the light cone does not change for the moving observer.  So even if 
an event is in one observers past and in another observers future, it 
will be outside the light cone, and neither observer will be able to 
know about it or influence it.  It is the fact that nothing travels 
faster than light that causes this to be true. 
   
 
 Diagram 1                           Diagram 2
              t                                    t
              |                                    |       light
           future                        \       inside      /
              |                            \      cone     /
              |                              \     |     /
              |                       outside  \   |   /    outside
              |                        cone      \ | /       cone
 -------------+------------- x        -------------+------------- x
              |                                  / | \
              |                                /   |   \
      event * |                              /     |     \
              |                            /     inside    \
             past                        /        cone       \
              |
 
 
 
 Diagram 3                           
              t     t'                   
              |    /                   
              |   /                  
              |  /
              | /        ___---> x'             
              |/___---'''                       
 -------------+------------- x        
  * ___ ---'''|                       
 '''        / |   note: * = event                        
           /  |                              
          /   |                         
         /    |                       
              
 
 
 
 
Diagram 4                  principle t' axis
                          /
   +---------------------/-----------+
   |__---/""  /    /    /    /  __/--|
   |    /    /    /    /__--/""" /   |
   |   /    /___-/-"""/    /    /    |
   |__/---"/"   /    /    /    /__--/|
   | /    /    /    / ___/--""/    / |
   |/    /   _/_---/""  /    /    /  |  ___--->principle x' axis
   |___-/-"""/    /    /    /  __/---"""
   |   /    /    /    /__--/""" /    | 
   |  /    / ___O--""/    /    /    /|
   |_/_---/""  /    /    /    /___-/-|    O = Origin
   |/    /    /    /  __/---"/"   /  |
   |    /    /__--/""" /    /    /   |
   |___/--""/    /    /    /   _/_---|
   |  /    /    /    /___-/-"""/     |
   +---------------------------------+
 
 
	These amazing consequences of relativity do have experimental 
foundations.  One of these involves the creation of muons by cosmic rays 
in the upper atmosphere.  In the rest frame of a muon, its life time is 
only about 2.2E-6 seconds.  Even if the muon could traveling at the 
speed of light, it could still only go about 660 meters during its life 
time.  Because of that, they should not be able to reach the surface of 
the Earth.  However, it has been observed that large numbers of them do 
reach the Earth.  From our point of view, time in the muons frame of 
reference is running slow, since the muons are traveling very fast with 
respect to us.  So the 2.2E-6 seconds are slowed down, and the muon has 
enough time to reach the earth.
	We must also be able to explain the result from the muons frame 
of reference.  So in its point of view, it does only have 2.2E-6 seconds 
to live.  However, the muon would say that it is the Earth which is 
speeding toward the muon.  Therefore, the distance from the top of the 
atmosphere to the Earth's surface is length contracted.  Thus, from its 
point of view, it lives a very small amount of time, but it doesn't have 
that far to go.
	Another verification is found all the time in particle physics.  
The results of having a particle strike a target can only be understood 
if one takes the total energy of the particle to be E = Gamma * m * c^2,  
which was predicted by relativity.
	These are only a few examples that give credibility to the 
theory of relativity.  Its predictions have turned out to be true in 
many cases, and to date, no evidence exits that would tend to undermine 
the theory.
 
	Well, that was a fairly lengthy look at relativity, but how does 
it all apply to faster than light travel?  This is what we will look at 
next.
 
 
 
 
II.	The First Problem:  The Light Speed Barrier
 
	In this section we discuss the first thing (and in some cases 
the only thing) that comes to mind for most people who consider the 
problem of faster than light travel.  I call it the light speed barrier. 
As we will see by considering ideas from the previous section, light 
speed seems to be a giant, unreachable wall standing in our way.  I also 
introduce a couple of fictional ways to get around this barrier; 
however, part of my reason for introducing these solutions is to show 
that they do not solve the problem discussed in the next section.
 
	Consider two observers, A and B.  Let A be here on Earth and be 
considered at rest for now.  B will be speeding past the A at highly 
relativistic speeds.  If B's speed is 80% that of light with respect to 
A, then gamma for him (as defined in the previous section) is 
1.6666666... = 1/0.6
So from A's point of view B's clock is running slow and B's lengths in 
the direction of motion are shorter by a factor of 0.6.  If B were 
traveling at 0.9 c, then this factor becomes about 0.436; and at 0.99 c, 
it is about 0.14.  As the speed gets closer and closer to the speed of 
light, A will see B's clock slow down infinitesimally slow, and A will 
see B's lengths in the direction of motion becoming infinitesimally 
small.
	In addition, If B's speed is 0.8 c with respect to A, then A 
will see B's observed mass as being larger by a factor of gamma (which 
is 1.666...).  At 0.9 c and 0.99 c this factor is about 2.3 and 7.1 
respectively.  As the speed gets closer and closer to me speed of light, 
A will see B's observed mass (and thus his energy) get infinitely large.
	Obviously, from A's point of view, B will not be able to reach
the speed of light without stopping his own time, shrinking to 
nothingness in the direction of motion, and taking on an infinite amount 
of energy.
 
	Now lets look at the situation from B's point of view, so we 
will consider him be at rest.  First, notice that the sun, the other 
planets, the nearby stars, etc. are not moving very relativistically 
with respect to the Earth; so we will consider all of these to be in the 
same frame of reference.  Let B be traveling past the earth and toward 
some near by star.  In his point of view, the earth, the sun, the other 
star, etc. are the ones traveling at highly relativistic velocities with 
respect to him.  So to him the clock on Earth are running slow, the 
energy of all those objects becomes greater, and the distances between 
the objects in the direction of motion become smaller.
	Lets consider the distance between the Earth and the star to 
which B is traveling.  From B's point of view, as the speed gets closer 
and closer to that of light, this distance becomes infinitesimally 
small.  So from his point of view, he can get to the star in practically 
no time.  (This explains how A seems to think that B's clock is 
practically stopped during the whole trip when the velocity is almost 
c.)  If B thinks that at the speed of light that distance shrinks to 
zero and that he is able to get there instantaneously, then from his 
point of view, c is the fastest possible speed.
 
	So from either point of view, it seems that the speed of light 
cannot be reached, much less exceeded.  However, through some inventive 
imagination, it is possible to come up with fictional ways around this 
problem.  Some of these solutions involve getting from point A to point 
B without traveling through the intermittent space.  For example, 
consider a forth dimension that we can use to bend two points in our 
universe closer together (sort of like connecting two points of a "two 
dimensional" piece of paper by bending it through a third dimension and 
touching the two points directly).  Then a ship could travel between two 
points without moving through the space in between, thus bypassing the 
light speed barrier.
	Another idea involves bending the space between the points to 
make the distance between them smaller.  In a way, this is what highly 
relativistic traveling looks like from the point of view of the 
traveler; however, we don't want the associated time transformation.  So 
by fictionally bending the space to cause the space distortion without 
the time distortion, one can imagine getting away from the problem.
 
	Again I remind you that these solutions only take care of the 
"light speed barrier" problem.  They do not solve the problem discussed 
in the next section, as we shall soon see.
 
 
 
III.	The Second Problem:  FTL Implies The Violation of Causality
 
	In this section we explore the violation of causality involved 
with faster than light travel.  First I will explain what we mean here 
by causality and why it is important that we do not simply throw it 
aside without a second thought.  I will then try to explain why 
traveling faster than light by any means (except the one introduced in 
the next section) will produce a violation of causality.  Finally, 
attempting to remove any doubt, we will preform a thought experiment to 
show that FTL travel does imply the violation of causality.
 
	When I speak of causality, I have the following particular idea 
in mind.  Consider an event A which has an effect on another event B.  
Causality would require that event B cannot in turn have an effect on 
event A.  For example, let's say that event A is a murderer making a 
decision to shoot and kill his victim.  Let's then say that event B is 
the victim being shot and killed by the murderer.  Causality says that 
the death of the victim cannot then have any effect on the murderer's 
decision.  If the murderer could see his dead victim, go back in time, 
and then decide not to kill him after all, then causality would be 
violated.  In time travel "theories," such problems are reasoned with 
the use of multiple time lines and the likes; however, since we do not 
want every excursion to a nearby star to create a new time line, we 
would hope that FTL travel could be done without such causality 
violations.  As I shall now show, this is not a simple problem to get 
around.
 
	I refer you back to the diagrams in the first section so that I 
can demonstrate the causality problem involved with FTL travel.  In 
Diagram 3, two observers are passing by one another.  At the moment 
represented by the principle axes shown, the two observers are right 
next to one another an the origin.  The x' and t' axes are said to 
represent the K-prime frame of reference (I will call this Kp for 
short). The x and t axes are then the K frame of reference.  We define 
the K system to be our rest system, while the Kp observer passes by K at 
a relativistic speed.  As you can see, the two observers measure space 
and time in different ways.  For example, consider again the event 
marked "*".  Cover up the x and t axis and look only at the Kp system.  
In this system, the event is above the x' axis.  If the Kp observer at 
the origin could look left and right and see all the way down his space 
axis instantaneously, then he would have to wait a while for the event 
to occur.  Now cover up the Kp system and look only at the K system.  In 
this system, the event is below the x axis.  So to the observer in the K 
system, the event has already occurred.
	Normally, this fact gives us no trouble.  If you draw a light 
cone (as discussed in the first section) through the origin, then the 
event will be outside of the light cone.  As long as no signal can 
travel faster than the speed of light, then it will be impossible for 
either observer to know about or influence the event.  So even though it 
is in one observers past, he cannot know about it, and even though it is 
in the other observers future, he cannot have an effect on it. This is 
how relativity saves its own self from violating causality. 
	Now consider what would happen if a signal could be sent 
arbitrarily fast.  From K's frame of reference, the event has already 
occurred. For example, say the event occurred a year ago and 5 light 
years away.  As long as a signal can be sent at 5 times the speed of 
light, then obviously K can receive a signal from the event.  However, 
from Kp's frame of reference, the event is in the future.  So as long as 
he can send a signal sufficiently faster than light, he can get a signal 
out to the place where the event will occur before it occurs.  So, in 
the point of view of one observer, the event can be know about.  This 
observer can then tell the other observer as they pass by each other.  
Then the second observer can send a signal out that could change that 
event.  This is a violation of causality.  Basically, when K receives a 
signal from the event, Kp sees the signal as coming from the future.  
Also, when Kp sends a signal to the event, K sees it as a signal being 
sent into the past.
	As a short example of this, consider the following.  Instead of 
sending a message out, let's say that Kp sends out a bullet that travels 
faster than the speed of light.  This bullet can go out and kill someone 
light-years away in only a few hours (for example) in Kp's frame of 
reference.  Now, say he fires this bullet just as he passes by K.  Then 
we can call the death of the victim the event (*).  Now, in K's frame of 
reference, the victim is already dead when Kp passes by.  This means 
that the victim could have sent a signal just after he was shot that 
would reach K before Kp passed by.  So K can know that Kp will shoot his 
gun as he passes, and K can stop Kp.  But then the victim is never hit, 
and he never sends a message to K.  So K doesn't know to stop Kp and Kp 
does shoot the bullet.  Obviously, causality is not very happy about 
this logical loop that develops.
 
	If this argument hasn't convinced you, then let me try one more 
thought experiment to convince you of the problem.  Here, to make 
calculations easy, we assume that a signal can be sent infinitely fast.
 
	Person A is on earth, and person B speeds away from earth at a 
velocity v.  To make things easy, lets say that v is such that for an 
observer on Earth, person B's clock runs slow by a factor of 2.  now, 
person A waits one hour after person B has passed earth.  At that time
person A sends a message to person B which says "I just found a bomb 
under my chair that will take 10 minutes to defuse, but goes off in 10 
seconds ... HELP"  He sends it instantaneously from his point of view... 
well, from his point of view, B's clock has only moved half an hour. So 
B receives the message half an hour after passing earth in his frame of 
reference.
	Now we must switch to B's point of view.  From his point of 
view, A has been speeding away from him at a velocity v.  So, to B, it 
is A's clock that has been running slow.  Therefore, when he gets the 
message half an hour after passing earth, then in his frame of 
reference, A's clock has only moved 1/4 an hour.  So, B sends a message 
to A that says: "There's a bomb under your chair." It gets to A 
instantaneously, but this time it is sent from B's frame of reference, 
so instantaneously means that A gets the message only 1/4 of an hour 
after B passed Earth. You see that A as received an answer to his 
message before he even sent it.  Obviously, there is a causality 
problem, no matter how you get the message there.
	OK, what about speeds grater than c but NOT instantaneous?  
Whether or not you can use the above argument to find a causality 
problem will depend on how fast you have B traveling. If you have a 
communication travel faster than c, then you can always find a velocity 
for B (v < c) such that a causality problem will occur.  However, if you 
send the communication at a speed that is less than c, then you cannot 
create a causality problem for any velocity of B (as long as B's 
velocity is also less that c).
 
	So, it seems that if you go around traveling faster than the 
speed of light, causality violations are sure to follow you around.  
This causes some very real problems with logic, and I for one would like 
to find a way around such problems. This next section intends to do just 
that.
 
 
 
 
IV.	A Way Around the Second Problem
 
	Now we can discuss my idea for getting around the causality 
problem produced by FTL travel.  I will move through the development of 
the idea step by step so that it is clear to the reader.  I will then 
explain how the idea I pose completely gets rid of causality violations.  
Finally, I will discuss the one "bad" side effect of my solution which 
involves the fundamentals of relativity, and I will mention how this 
might not be so bad after all.
 
	Join me now on a science fictional journey of the imagination.  
Picture, if you will, a particular area of space about one square light-
year in size.  Filling this area of space is a special field which is 
sitting relatively stationary with respect to the earth, the sun, etc.  
(By stationary, I mean relativistically speaking.  That means it could 
still be moving at a few hundreds of thousands of meters per second with 
respect to the earth.  Even at that speed, someone could travel for a 
few thousand years and their clock would only be off by a day or two 
from earth's clocks.)  So, the field has a frame of reference that is 
basically the same as ours on earth.  In our science fictional future, a 
way is found to manipulate the very makeup (fabric, if you will) of this 
field.  When this "warping" is done, it is found that the field has a 
very special property.  An observer inside the warped area can travel at 
any speed he wishes with respect to the field, and his frame of 
reference will always be the same as that of the field.  In our 
discussion of relativity, we saw that in normal space a traveler's frame 
of reference depends on his speed with respect to the things he is 
observing.  However, for a traveler in this warped space, this is no 
longer the case.
	To help you understand this, lets look at a simple example.  
Consider two ships, A and B, which start out sitting still with respect 
to the special field.  They are in regular space, but in the area of 
space where the field exists.  At some time, Ship A warps the field 
around him to produce a warped space.  He then travels to the edge of 
the warped space at a velocity of 0.999 c with respect to ship B.  That 
means that if they started at one end of the field, and A traveled to 
the other end of the field and dropped back into normal space, then B 
says the trip took 1.001001... years.  (That's 1 light-year divided by 
0.999 light-years per year.)  Now, if A had traveled in normal space, 
then his clock would have been moving slow by a factor of 22.4 with 
respect to B's clock.  To observer A, the trip would have only taken 
16.3 days.  However, by using the special field, observer A kept the 
field's frame of reference during the whole trip.  So he also thinks it 
took 1.001001... years to get there.
	Now, let's change one thing about this field.  Let the field 
exist everywhere in space that we have been able to look.  We are able 
to detect its motion with respect to us, and have found that it still 
doesn't have a very relativistic speed with respect to our galaxy and 
its stars.  With this, warping the field now becomes a means of travel 
within all known space.
 
	The most important reason for considering this as a means of 
travel in a science fiction story is that it does preserve causality, as 
I will now attempt to show.  Again, I will be referring to Diagram 3 in 
the first section.  In order to demonstrate my point, I will be doing 
two things.  First, I will assume that the frame of reference of the 
field (let's call it the S frame)  is the same as that of the x and t 
system (the K system) shown in Diagram 3.  Assuming that, I will show 
that the causality violation discussed in the previous section will not 
occur using the new method of travel.  Second, I will show that we can 
instead assume that the S frame is the same as that of the x' and t' 
system (the K-prime--or Kp for short--system), and again causality will 
be preserved.
	Before I do this, let me remind you of how the causality 
violation occurred. The event (*) in the diagram will again be focussed 
on to explore causality.  This event is in the past of the K system, but 
it is in the future of the Kp system.  Since it is in the past according 
to the K observer, a FTL signal could be sent from the event to the 
origin where K would receive the signal.  As the Kp observer passed by, 
K could tell him, "Hay, here is an event that will occur x number of 
light years away and t years in your future."  Now we can switch over to 
Kp's frame of reference.  He sees a universe in which he now knows that 
at some distant point an event will occur some time in the future.  He 
can then send a FTL signal that would get to that distant point before 
the event happens.  So he can influence the event, a future that he 
knows must exist.  That is a violation of causality. But now we have a 
specific frame of reference in which any FTL travel must be done, and 
this will save causality.
	First, we consider what would happen if the frame of the special 
field was the same as that of the K system.  That means that the K 
observer is sitting relatively still with respect to the field.  So, in 
the frame of reference of the field, the event "*" IS in the past.  That 
means that someone at event "*" can send a message by warping the field, 
and the message will be able to get to origin.  Again, the K observer 
has received a signal from the event.  So, again he can tell the Kp 
observer about the event as the Kp observer passes by.  Again, we switch 
to Kp's frame of reference, and again he is in a universe in which he 
now knows that at some distant point an event will occur some time in 
the future.  But here is where the "again's" stop.  Before it was 
possible for Kp to then send a signal out that would get to that distant 
point before the event occurs.  But NOW, to send a signal faster than 
light, you must do so by warping the field, and the signal will be sent 
in the field's frame of reference.  But we have assumed that the field's 
frame of reference is the same as K's frame, and in that frame, the 
event has already occurred.  So, as soon as the signal enters the warped 
space, it is in a frame of reference in which the event is over with, 
and it cannot get to the location of the event before it happens.  What 
Kp basically sees is that no matter how fast he tries to send the 
signal, he can never get it to go fast enough to reach the event.  In 
K's frame, it is theoretically possible to send a signal 
instantaneously; but in Kp's frame, that same signal would have a non-
infinite speed.  So we see that under this first consideration, 
causality is preserved.
	To further convince you of my point, I will now consider what 
would happen if the frame of the special field was the same as that of 
the Kp system instead of the K system.  Again, consider an observer at 
the event "*" who wishes to send a signal to K before Kp passes by K.  
The event of K and Kp passing one another has the position of the origin 
in our diagram (as I hope you understand).  In order to send this 
signal, the observer at "*" must warp the field and thus enter the 
system of the Kp observer.  But in the frame of reference of Kp, when he 
passes by K, the event "*" is in the future.  Another way of saying this 
is that in the Kp frame of reference, when the event "*" occurs, Kp will 
have already passed K and gone off on his merry way.  So when the signal 
at "*" enters the warped space, it's frame of reference switches to one 
in which K and Kp have already passed by one another.  That means that 
it is impossible for "*" to send a signal that would get to K before Kp 
passes by.  The possibility of creating a causality violation thus ends 
here.  
	Let me summarize the two above scenarios.  In the first 
situation, K could know about the event before Kp passes.  So Kp can 
know about the event after he passes K, but Kp could not send a signal 
that would then influence the event.  In the second situation, Kp can 
send a signal that would influence the event after he passed by K. 
However, K could not know about the event before Kp passed, so Kp cannot 
have previous knowledge of the event before he sends a signal to the 
event.  In either case, causality is safe.  Also notice that only one 
case can be true.  If both cases existed at the same time, then 
causality would be no safer than before.  Therefore, only one special 
field can exist, and using it must be the only way that FTL travel can 
be done.
	Many scenarios like the one above can be conceived using 
different events and observers, and (under normal situations) FTL 
travel/communication can be shown to violate causality.  However, in all 
such cases, the same types of arguments are used that I have used here, 
and the causality problem is still eliminated by using the special 
field.
 
	So, is the the perfect solution where FTL travel exists without 
any side effects that make it logically impossible?  Does this mean that 
FTL travel in Star Trek lives, and all we have to do is accept the idea 
that subspace/warped space involves a special frame of reference?  Well, 
not quite.  
	You see, there is one problem with all of this which involves 
the basic ideas which helped form relativity.  We said that an observer 
using our special mode of transportation will always have the frame of 
reference of the field.  This means that his frame of reference does not 
change with respect to his speed, and that travel within the warped 
field does not obey Einstein's Relativity.  At first glance, this 
doesn't seem too bad, it just sounds like good science fiction.  But 
what happens when you observer the outside world while in warp?  To 
explore this, let's first look back at why it is necessary for the frame 
of reference to change with respect to speed.  We had assumed that the 
laws of physics don't simply change for every different inertial 
observer.  It had been found that if the laws of electrodynamics look 
the same to all inertial observers, then the speed of an electromagnetic 
wave such as light must be the same for all observers.  This in turn 
made it necessary for different observers to have different frames of 
reference.  Now, lets go backwards through this argument.  If different 
observers using our special mode of transportation do not have different 
frames of reference, then the speed of light will not look the same to 
all observers.  This in turn means that if you are observing an 
electromagnetic occurrence from within the warped space, the laws 
governing that occurrence will look different to you that they would to 
an observer in normal space.
	Perhaps this is not that big of a problem.  One could assume 
that what you see from within warped space is not actually occurring in 
real space, but is caused by the interaction between the warped space 
and the real universe.  The computer could then compensate for these 
effects and show you on screen what is really happening.  I do not, 
however pretend that this is a sound explanation.  This is the one part 
of the discussion that I have not delved into very deeply.  Perhaps I 
will look further into this in the future, but it seems like science 
fiction could take care of this problem.
 
 
 
 
V.	Conclusion.
 
	I have presented to you some major concepts of relativity and 
the havoc they play with faster than light travel.  I have show you that 
the violation of causality alone is a very powerful deterrent to faster 
than light travel of almost any kind.  So powerful are its effects, in 
fact, that I have found only one way to get around them.  I hope I have 
convinced you that (1) causality is indeed very hard to get around, and 
(2) my idea for a special field with a particular frame of reference 
does get around it.  For the moment, I for one see this as the only way 
I want to consider the possibility of faster than light travel.  Though
I do not expect you to be so adamant about the idea, I do hope that you  
see it as a definite possibility with some desirable outcomes.  If 
nothing else, I hope that I have at least educated you to some extent on
the problems involved when considering the effects of relativity on
faster than light travel.


 
                                                 Jason Hinson
 
-Jay

