From: Tagi@cup.portal.com (Thyagi Morgoth NagaSiva)
Newsgroups: sci.psychology
Subject: MUDs as a Psychological Model (Theory, Long)
Message-ID: <71840@cup.portal.com>
Date: Wed, 16 Dec 92 15:59:51 PST
Organization: The Portal System (TM)
Lines: 308

9212.16 e.v.

It has come to my attention that some people hold rather
tightly to the notion of a 'real world' or 'real life' (RL),
and that this is often distinguished from places known as MUDs
or things known as 'virtual worlds'.

When I first encountered this (in cyberMUDs) something struck me as 
strange and ill-conceived about it.  How could people be sure what 
was 'real' and what was 'virtual', especially the better educated 
of the lot, when philosophers had argued the point for ages and 
countless mystics had suggested that what we take for 'reality' is a 
mere reflection, a fragment of the real.

I took to challenging people regarding these notions and eventually,
through socratic dialogue with a few MUD philosophers, came to develop
a theory which uses the model of the MUD for modern psychology/mysticism.
Below is the present form of this theory, and I'd appreciate any feedback 
that might be offered.  Review, comments and disputation are
enthusiastically requested.

-------------------------------
The MUD as a Basis for Western Mysticism

Contents:

1. Realms and Worlds
2. Multi-User Dimensions (MUDs)
3. The CyberMUD or Cyber Realm, and the NONcyber Realm
4. Reality, Virtual Reality, and Real Life (RL)
5. The Real World and RL
6. RL and MUDs
7. InterMUD Studies
8. Entrenchment and Abstraction
9. The Science of Artistry

------------------------------------
The MUD as a Basis for Western Mysticism
by Thyagi NagaSiva


1. Realms and Worlds

'Realm', 'world' and 'MUD' (Multi-User Dimension, to be defined below), 
are here synonyms.   They describe a bounded sphere of perception.   
A 'virtual world' is a realm which is apparent to some senses but
not to others (whether or not they appear within all dimensions of 
sensation).


2. Multi-User Dimensions (MUD), 

More specifically then, by MUD we refer to a realm of measurement 
(dimension) which makes possible or allows more than one (multi) 
locus of change (user).  Where 'realm' and 'world' are fairly ambiguous,
MUD is a technical term with specific meaning and synonomous 
application.


3. The CyberMUD or Cyber Realm, and the NONcyber Realm

A cybermMUD or 'cyber realm' is one which is reached via
a computer (by whatever definition). It may be contrasted with
a NONcyber realm in two major ways:

A) The cyber realm seems to depend upon the NONcyber realm for
its existence (but this cannot be proven), and

B) The cyber realm is dependent upon some computer for its
ultimate form (whether or not this computer is NONcyber-based).


4. Reality, Virtual Reality, and Real Life (RL)

The term 'reality' is commonly used as a substitute for 'realm',
yet we reserve it for a specific meaning.  Here the phrase
'virtual reality' is an oxymoron, and this will become apparent
below.

The common assumption is that cyber realms are MUDs and NONcyber 
realms are NOT (i.e. that NONcyber realms are 'reality').
However, given the definitions above we can posit that what most 
people call 'real life' (RL) is actually an experience within a 
NONcyber realm of subjective or objective dimensions. 

We have multiple selves, arising from the combined complex of our 
social roles, that vie for supremacy within the dimension of our 
personal mindspace.  This is the subject dimension, the 'me-MUD'.
It includes feelings, thoughts and the entire range of subjective
experience.

There appears to be a world of shapes and objects around us.  We
maneuver, physically, through the familiar subrealms of 'height',
'width' and 'depth' and manipulate or interact with entities and
objects within them.  This is the object dimension, the 'space-MUD'.
It is the one which people assume to be more 'real' based upon their
perception that it contains cyberMUDs and gives rise to the me-MUD.

Taking one (NONcyber, space-MUD) as pre-eminent based 
solely on the grounds of origin (cyber realms seem to originate 
from NONcyber technologies) is quite commom.  For example,
many people  assume that NONcyber personalities are somehow 
more 'real' than their cyber counterpart, even if these personae
(socially imagined constructs deriving from communication
styles and appearance) are comparable in all respects save origin.

That they distinguish one as 'real' and the other as 'virtual' or
'imaginary' displays the bias toward the default dimension
(quite reasonably), but tells us nothing about what 'real' means
aside from 'preferred' or 'longer-lasting'.


5. The Real World and RL

We shall here take for our definition of the 'real world' that 
realm which is a superset of all MUDs.  That superset upon which 
all other dimensions depend is logically the 'real'.  Plato
claimed that the real world is the world of Forms or Ideas, and 
many other philosophers offer their own speculation as to what
constitutes the 'Source Code of Existence' as we know it.

'The superset of all MUDs' is not an easy concept to understand.
It transcends both the MUD of our subjective experience and
the MUD of 'space' (I leave 'time', which connects and/or
interweaves these two, for future speculation).   It is easy to see 
why any aspect of RL in THIS context must be beyond words to some 
extent, especially when attempting to ascertain information about 
'you' or 'me', or indeed any isolated object/subject.

To say 'I went shopping in RL' would seem not only fallacious, 
but completely dishonest.  No separate 'individual' can ever 
'do' anything in 'RL', not when we take it to be this superset, 
this Unity which includes all dimensions of subject and object.

A note about Unity seems necessary.  When speaking of 'Unity', it
is not meaningful to compare this with 'Diversity'.  The reason for this
is that the unity here implied transcends all lingual expressions.
For the same reason that 'Spirit' cannot be compared with 'Matter'
because in the nondual realm Spirit and Matter are One, so also is
Diversity identical to Unity and vice versa.  The term is only a useful
indicator of the realm or dimension (that superset) to which we refer.

Given this, the real world is a subject/object Unity, toward which 
many religious paths point and about which we shall never
obtain a completely accurate lingual expression (due to the
disunitive nature of language). 

Comments about RL, therefore, are of a MYSTICAL nature, within 
this context, rather than a 'practical' one. They apply, perhaps 
abstractly, to that superset which some Christians call 'Heaven' 
and some Buddhists might call 'Nirvana'.


6. RL and MUDs

RL is mystical experience, since it occurs in the dimension of
Unified nonduality and it would seem to depend upon the QUALITY of
its manifestation rather than on the location of particular objects 
or subjects.  We may thus find RL in any MUD, since all MUDs are 
contained by the real world and may include Unitive experiences.

A MUD is a world of flux, where the real is in some ways beyond change,
enveloping a 'becoming beingness' that is not usually perceived in 
ordinary states of consciousness.  To encounter RL, therefore, is to 
become unified with the divine, the God of Platonic and Hermetic 
Christians, who is both beyond and within the MUD experience, at once 
transcending and subsuming it.

A MUD is the equivalent of  Carse's 'finite game', in which we assume 
for the purposes of the game that certain rules are unbreakable 
(i.e. the subject/object division) and that our goal is to somehow 'win'.
Carse speculates that the goal of the infinite game (the real world)
is to continue playing, and no foolish notions about 'death' or 
'morality' or 'identity' get in the way of an infinite player.  


7. InterMUD Studies

The 'real' would seem to be approachable by examining all experiences 
and coming to some determination as to their source.  Modern 
Science's objective examination of the nature of matter is one aspect 
of this search.  Mystical exploration and experimentation in the world 
of the subject is another.

Searches of these types are limited by the techniques used within the
particular MUD.  We shall not determine a purely physical source
for experience because experience is not entirely objective.  Likewise,
we shall not discover a purely mental source because experience 
is not entirely subjective.

InterMUD studies such as those by Fritjof Capra and Gary Zukav, 
popular  scientific explanations  of the comparisons between objective 
and  subjective explorations, are quite important.  They point out the 
boundaries and connections between MUDs (not only the subject/object 
MUDs but also those of academic and popular cultures).   

They indicate the paradoxes, the eddies and vortices that arise 
as a result of entering one particular finite game and looking at
another.  They show us the similarities between worlds, how one
can be used to understand another, and how the real world surpasses
our ability to explain.


8. Entrenchment and Abstraction

Of course those who entrench themselves within one particular MUD
(such as those who argue vehemently for the 'reality' of the object
MUD, for example) will not understand such interMUD studies, nor will
they acknowledge the meaning and accuracy of terms which apply to
realms outside their entrenchment.  This is to be expected.

When my 'reality' is comprised solely of objects, of surface tension 
and physical principles, I cannot then see the veracity of descriptions
regarding subjective referents.  'Soul', 'spirit', 'emotion' and even
'mind' are to be described in physical terms if they are to have any
meaning for me.  

Those who speak of objects in 'abstract' terminology as if they 
were in any sense 'real' are either mistaken or confusing to me due to 
their 'abstractness'.  'Abstraction' is indeed a relative qualifier which 
describes one's position and one's relationship to the qualified noun.  

If I say that 'mind' is an abstraction, then the MUD of my entrenchment
does not contain direct associations with what is being called 'mind'.  
If I say, on the other hand that 'brain' is an abstraction due to the 
relativity of subjective experience, then I find my position identical
yet I am inhabiting a different MUD (the subject-MUD).  

Neither position can be said to be in the real world as we have defined 
it here.  Both MUDs are subsets of  that superset, identified as such by 
the PRESENCE of abstraction within them.   'Abstraction', or that quality 
which admits of disUnity, is an indication of incompleteness, of a MUD 
which is not the real world. 


9. The Science of Artistry

The challenge, therefore, is to find our way into a 'Concreteness' which
admits of the Concrete not because of arbitrary definition (as we may 
obtain by denying the existence of 'mind' by virtue of its abstraction), 
but because there is no other alternative.  RL is that experience which 
penetrates all known MUDs, that concentration of indescribable 
perfection which is implied but never described by language.

InterMUD studies are therefore the study of ALL MUDs and their origins,
differences and similarities.  While they may begin in cyber realms, of
necessity they shall permeate noncyber worlds as well, linking the video
MUDs of the picture, movie, television and arcade/pc games; the lingual
realms of the letter, telephone, cb, short-wave and internet; the sporting
gameworlds of dice, boards, words, role-playing, and 'MU*'; the realms 
of personal expression such as lecture, conversation, music, concert,
dance, sports, war, romance and sexuality.

Moreover, interMUD studies may be considered interdisciplinary studies
of Art in general.  The realms in which we 'do' things each have their own
specializations and techniques.  Over time they develop into what are
called 'spiritual disciplines' (those which we may use to reach the real).
In very old and rich spiritual traditions we can see this manifested quite
readily.

The japanese 'tea ceremony' is an artform which has been developed into
spiritual practice.  So are Chinese and Arabian calligraphy.  Martial arts
in the East and West have grown along similar lines, and, while the martial
arts of the East have seen greater popularity (being of the body), those of
the West (called 'ceremonial magick') have integrated both Western
and Eastern esoteric concepts as elements of their foundation.

These particulars are less important than what they imply in general:
Art is a process of coming to the real and Science in its most
relevant form is the study of Art and that Source toward which we may
return.  The science of Artistry, in its broadest sense, is what such
interMUD studies comprise.  

The real world that such a science seeks to reveal is beyond its 
capacity to describe in language, yet well  within its power to make 
available by direct experience.  The metaphor of the MUD and its
application to the disciplines of philosophy, psychology, religion
and mysticism are monumental and breath-taking in scope.

Drawing on the concepts of the 'worldview' and 'paradigm', the MUD
both exemplifies (in its cyber forms) and symbolizes (within the
mystical model herein portrayed) ordinary experience and its relation
to the real.  May we each use it to move closer to our source and 
begin to live what can truly be called Real Lives.

-----------------------------------------

Books proving inspirational to this essay included:

Games Theory
_Finite and Infinite Games_, by James P. Carse, Ballantine, 1986

Platonism
_A History of Philosophy: Vol. 1, Part 1, Greece and Rome_,
   by F. Copleston, S. J., Image Books, 1962

Modern Scientific Views of Mysticism
_The Tao of Physics_, by Fritjof Capra, Bantam, 1980

_The Dancing Wu Li Masters_, by Gary Zukav, Bantam, 1980.

-----------------------------------------------------------

9212.16 e.v.
Thyagi Morgoth NagaSiva
Tagi@Cup.Portal.Com
871 Ironwood Dr.
San Jose, CA 95125-2815
