/*
**  b_order : program to test the internal bit-ordering scheme used by the
**            current compiler; either network byte order or non-network byte
**            order
**
**  Filename: b_order.c
**  Updated : 9/20/91
*/

/*=[ Include Files ]========================================================*/

#include <stdio.h>

/*=[ General Definitions ]==================================================*/

#define U32     unsigned long

/*=[ Union: Bits32 ]========================================================*/

typedef union {
    struct {
        unsigned  b31:1;
        unsigned  b30:1;
        unsigned  b29:1;
        unsigned  b28:1;
        unsigned  b27:1;
        unsigned  b26:1;
        unsigned  b25:1;
        unsigned  b24:1;
        unsigned  b23:1;
        unsigned  b22:1;
        unsigned  b21:1;
        unsigned  b20:1;
        unsigned  b19:1;
        unsigned  b18:1;
        unsigned  b17:1;
        unsigned  b16:1;
        unsigned  b15:1;
        unsigned  b14:1;
        unsigned  b13:1;
        unsigned  b12:1;
        unsigned  b11:1;
        unsigned  b10:1;
        unsigned  b9:1;
        unsigned  b8:1;
        unsigned  b7:1;
        unsigned  b6:1;
        unsigned  b5:1;
        unsigned  b4:1;
        unsigned  b3:1;
        unsigned  b2:1;
        unsigned  b1:1;
        unsigned  b0:1;
    } N;
    U32 U;
} BU32;

/*==========================================================================*/

void main()
{
    int  type=0;
    BU32 testword;

    testword.U=0x00000001L;
    if (!testword.N.b0)
        type=1;
    printf("\nThe byte ordering of this compiler is: ");
    if (type)
        printf("NON-Network Byte Order.\n\n");
    else
        printf("Network Byte Order.\n\n");
    exit(0);
}
