/****************************************************************************\
**        Password Preprocesser v2.00 - Password Cracker Guess Mutator      **
** ======================================================================== **
**                Sourcefile: pwp.h -- Last Update: 09/20/91                **
** ======================================================================== **
**           Written By Doctor Dissector, Copyright (C) 1990, 1991          **
** ======================================================================== **
**                   LIMITED EDITION -- DO NOT DISTRIBUTE                   **
\****************************************************************************/

/*=[ License ]==============================================================*/

/*
** Password Preprocesser - Version 2.00
** Copyright (C) 1991 By Doctor Dissector
**
** This program is NOT free software BUT may be used without charge or
** payment in any form IF your copy is a "registered" distributed version.
** You may modify it as much as you please, however, you MAY NOT re-
** distribute it, in any shape or for: ie. modified OR unmodified,
** without the expressed written consent (ie. e-mail) of
** Doctor Dissector.
**
** This program was initially distributed in the hope that it will be
** useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

/*=[ Disclaimer ]===========================================================*/

/*
**  The author of this package, Doctor Dissector, will not assume liability
**  for ANY of the effects of the use or distribution of this package.  If
**  you, at ANY time compile or use this package, you will assume full
**  liability for your own actions; Doctor Dissector can neither enforce the
**  lawful use of this package nor your actions before, during, or after
**  exposure to this package.  Doctor Dissector does NOT endorse your unlawful
**  use of this package to appropriate computer accounts not under your lawful
**  ownership.
**
**  The original intent of this package was to prove that Un*x accounts can be
**  easily, efficiently, and effectively cracked utilizing modified DES
**  encryption routines and proper statistical, mathematical, logical, and
**  programming skills.
*/

/*=[ Copyright ]============================================================*/

char pwp_h_msg[] = "Source: pwp.h, Copyright (C) 1990, 1991 By Doctor Dissector";

/*=[ General Definitions ]==================================================*/

#define MAX_FILE          256       /* Maximum filename/pathname length */
#define MAX_LINE          512       /* Maximum length of /etc/passwd lines */
#define MAX_TAIL          256       /* Maximum argument tail length */
#define MAX_XCHAR          20       /* Maximum amount of xlate characters */
#define MAX_WORD           81       /* Maximum word length */

/*=[ Command Definitions ]==================================================*/

#define ERROR_FLAG         -1       /* Command error */
#define DOUBLE_FLAG        10
#define GECOS_FLAG         20       /* Use GECOS fields */
#define HELP_FLAG          30       /* Help/Display usage */
#define INCLUDE_FLAG       40       /* Include original words */
#define KC_FLAG            50       /* Using KC9 format */
#define LOGINS_FLAG        60       /* Use login fields */
#define LOWERCASE_FLAG     70       /* All lowercase */
#define LOWREVERSE_FLAG    80       /* Lowercase & reverse */
#define MINLENGTH_FLAG     90       /* Minimum lengths */
#define NONALPHA_FLAG     100       /* Non-alphabetic characters */
#define NOVOWELS_FLAG     110       /* No vowels */
#define PREFIXES_FLAG     120       /* Prepend characters */
#define REVERSE_FLAG      130       /* Reverse */
#define TRANSLATE_FLAG    140       /* Translate chars */
#define SUFFIXES_FLAG     150       /* Append characters */
#define UPCHAR_FLAG       160       /* Make a char uppercase */
#define UPLAST_FLAG       170       /* Make last char uppercase */
#define UPPERCASE_FLAG    180       /* All uppercase */
#define UPREVERSE_FLAG    190       /* Uppercase & reverse */

/*=[ Structure: cmd ]=======================================================*/

struct cmd {
    char *cmd_name;
    int  unique,
         cmd_code;
};

/*=[ Variable: struct cmd cmdtab[] ]========================================*/

struct cmd cmdtab[] = {
    { "?",          1,  HELP_FLAG       },
    { "double",     1,  DOUBLE_FLAG     },
    { "gecos",      1,  GECOS_FLAG      },
    { "help",       1,  HELP_FLAG       },
    { "include",    1,  INCLUDE_FLAG    },
    { "kc",         1,  KC_FLAG         },
    { "logins",     3,  LOGINS_FLAG     },
    { "lowercase",  4,  LOWERCASE_FLAG  },
    { "lowreverse", 4,  LOWREVERSE_FLAG },
    { "minlength",  1,  MINLENGTH_FLAG  },
    { "nonalpha",   3,  NONALPHA_FLAG   },
    { "novowels",   3,  NOVOWELS_FLAG   },
    { "prefixes",   1,  PREFIXES_FLAG   },
    { "reverse",    1,  REVERSE_FLAG    },
    { "suffixes",   1,  SUFFIXES_FLAG   },
    { "translate",  1,  TRANSLATE_FLAG  },
    { "upchar",     3,  UPCHAR_FLAG     },
    { "uplast",     3,  UPLAST_FLAG     },
    { "uppercase",  3,  UPPERCASE_FLAG  },
    { "upreverse",  3,  UPREVERSE_FLAG  },
    0
};
