/***************************************************************************
 *  SESSION.H								   *
 *	This file contains following NetBIOS Session Service related	   *
 *	function prototypes:						   *
 *
 *	  SendSess   () :- Sends data on an established session 	   *
 *	  ReceiveSess() :- Receives data for a given session		   *
 *	  HangSess   () :- Terminate  a given session			   *
 *	  Call()	:- Establish a session with a remote name	   *
 *	  Listen()	:- Put yourself in "listening" state to receive    *
 *			   remote calls.				   *
 *									   *
 *  History:	Alok Sinha  October, 1991    Created			   *
 *									   *
 ***********************************************************************/

#ifndef SESSION_INCLUDED
#define SESSION_INCLUDED


unsigned char	SendSess(     unsigned char ucLana,
			      unsigned char ucLsn,
			      char far * pchData,
			      unsigned short usDataLen
			);

unsigned char	ReceiveSess(	unsigned char ucLana,
				unsigned char ucLsn,
				char far * pchData,
				unsigned short *pusDataLen
			   );


unsigned char	HangSess(   unsigned char ucLana,
			    unsigned char ucLsn
			);


unsigned char	Call(	 unsigned char ucLana,
			 char far * pchRemoteName,
			 char far * pchLocalName,
			 unsigned char ucSto,
			 unsigned char ucRto,
			 unsigned char far *ucLsn
		    );



unsigned char	Listen(	 unsigned char ucLana,
			 char far * pchRemoteName,
			 char far * pchLocalName,
			 unsigned char ucSto,
			 unsigned char ucRto,
			 unsigned char far *ucLsn
		     );


#endif // SESSION_INCLUDED
