			      --==: COMRAP'S :==--
		       GUIDE TO REMOTE DATABASE SYSTEMS
				 For New Users
		      ==================================
			 Copyright (c) 1985 by COMRAP
			 Committee for Remote Database
			  System Rights and Practices


			 INTRODUCTION:
			 ~~~~~~~~~~~~~
  COMRAP welcomes all new users of remote database sys- tems.  As a participant
in this rapidly expanding means of high-tech communications, you are at the
forefront of the general public's movement from voice-based and "hard copy"
com- munications to digital telecommunications.

  Remote database systems (RDBSs) are non-commercial public or semi-public
computer systems, operating over standard telephone lines, which provide remote
information access and interchange.  Originally known as "BBSs", they include:

  1.  Message-oriented systems, including remote bulletin board systems (RBBSs
or BBSs - also known as public access message systems or PAMS.)

  2.  Public domain software exchanges (PDSEs - often known as remote CP/M
systems or RCPMs.)

  3.  Special interest groups (SIGs), including those on commercial systems
like The Source and CompuServe as well as those operated as stand-alone RDBSs.

  4.  Mixed systems providing a variety of message, text, and software exchange
(known by any of the above names, but best described by the generic term RDBS.)

  If you take the time to read and understand the information in this document,
you should be able to sign on to a remote database system, take steps toward
becoming a validated user of that system, read and write messages, perhaps do
some file transfers, and anything else the system may allow.  You will be safe
in the knowledge that you are doing all of this without making any serious
mistakes, such as accidentally accessing the NORAD computer and launching a
flock of ICBMs toward the Soviet Union!  (Incidentally...  recent motion
pictures notwithstanding, there is no way you or anyone else could break into
the Defense Department's missile launching systems by mistake.  They aren't
even tied in to standard telephone lines.)

  As with everything else that is good in the world, there are responsibilities
that go along with your telecommunications activities.	Always remember that
you are using someone else's computer system; YOU ARE A GUEST!  Each system has
its own unique set of rules, so your first priority is to find out what those
rules are and then obey them when you are on that system!  Most RDBSs are run
on personal computers by private individuals who dedicate a great deal of time,
expense and equipment for our common benefit.  You are the guest of those
SysOps (System Operators) -- always remember to act with courtesy and respect.

  NEVER ACT IN A MANNER THAT COULD BE DETRIMENTAL TO THE SYSTEM.  DO NOT
ATTEMPT TO CRACK OR CRASH AN RDBS OR ANY OTHER REMOTE COMPUTER SYSTEM!	In
almost every jurisdiction in this country, the act of accessing a computer
system without authorization is either a misdemeanor (like breaking and
entering) or a felony (computer fraud.) And someone who "legally" accesses a
system and then attempts to disrupt or do damage to that system is equally
guilty of committing a crime.

  Having said that, let us put your mind at ease.  Most systems are set up with
enough security measures that mistakes by new users have absolutely no effect
on the system's integ- rity whatsoever.  If you screw up, don't worry about it.
In the rare case where it appears you may have caused a serious prob- lem (the
computer automatically logged you off, or the display went blank and you
couldn't figure out how to recover it,) just hang up and call right back.  Then
you should send an electronic note to the SysOp letting him/her know that YOU
realize that you "pushed the wrong button." SysOps are aware of the fact that
it takes a while for new users to learn the ropes.  They can tell from their
records of your activity that you weren't attempting to do their system any
harm.  (And if you follow these guidelines -- written by two SysOps with lots
of exper- ience with new users -- you'll certainly minimize those mistakes!)

		- - - - - - - - - - - - - - - - - - - - -

			   LET'S GET STARTED!
			   ~~~~~~~~~~~~~~~~~~
   A.  "I've got a computer and a modem, what now?"

  One of the first problems you'll encounter is "Who can I call???" Getting
that "first" phone number can be fairly easily accomplished by contacting a few
computer retailers, or just asking your friends or business associates (all of
whom have computers and modems, right?!) Then, once you've gotten on a system,
you are likely to find a few messages about other RDBSs -- and many systems
even have included a comprehensive list of RDBS's in your area that is
available for you online.  The Source and CompuServe also contain extensive,
nation-wide listings.  However, both of these are subscription services that
charge an hourly fee when you're logged on.  Your best bet is to try your local
sources.

  Pretty soon, you'll have a fairly large list of your own, and it won't take
long to determine which systems you like best or which offer you the most
desirable features.  Smaller systems go up and down like flags, and some of the
numbers you get may no longer be valid.  If you encounter this situation, THROW
THE NUMBER AWAY!  It may have been re-assigned by the phone company to another
individual who knows nothing about computers, and it is very irritating to pick
up the phone and get a modem tone in your ear!	If someone answers "voice",
it's courteous to pick up your receiver and ask them if there is a RDBS
operating at that number.  If not, apologize for the wrong number and scratch
it from your list.  Then contact the person you got the number from (SysOp of
an RDBS, computer retailer, friend) and inform him (or her) that the number is
NOT an RDBS any more and should not be given out to anyone else.

  Before you make your first call, though, a word of warning:  THE TELEPHONE
SERVICE KNOWN AS "CALL-WAITING" CAN BE VERY HAZARDOUS TO YOUR
(TELECOMMUNICATIONS) HEALTH!  Call- waiting is a very useful service,
especially to families with teenaged children.	But the "beep" that signals
that a caller is waiting acts as a "break" tone and usually causes one or both
modems to disconnect.  Try to avoid using a modem on a line with call-waiting
except during periods of low telephone usage (late evening, for instance.)

  Also, some "clever" users have devised schemes to dis- able call-waiting.
These schemes include attaching voltage- producing devices to the telephone
line and "busying out" one of the lines by dialing Telephone Company test
loops.	These methods are NOT approved and may result in very serious conse-
quences.  (By adding non-FCC approved equipment to the phone line, these users
can be held personally liable for any damage caused to phone company
equipment.) If call-waiting is that much of a problem, the only two recommended
solutions are to have call-waiting removed (which will save you a few cents a
month anyway) or to add another line for the computer (which is a luxury not
everyone can afford, but is really the best way to go in the long run.)

   B.  Connection:  You're on-line!

  All right, so you've made contact with a RDBS.  What now?  Depending on the
type of program the system uses, and the machine it's being run on, signing in
(logging on) is accom- plished in various ways.  For example, if you've
accessed an IBM-PC running the popular "RBBS-PC" program, you would press
<Enter>, two or three times, s l o w l y, until it recognizes your presence.
(RBBS-PC calls the <Enter> key "C/R", for Carriage Return.) This allows the two
computers to match up with each other so that communication can begin.	The
process of entering one or more carriage returns upon getting a CONNECT is very
common, although some systems do not require it.  From that point on you will
be "prompted," or asked what you want to do next.

  1.  Signing on (logging on, logging in, etc.)

  Now you will be asked certain questions that you must answer in order to be
"validated," or allowed to use the system.  It's good practice to enter only
accurate, honest information.  Usually, it goes something like this:  FIRST
NAME then LAST NAME (or sometimes FULL NAME); CITY and STATE you're calling
from; a valid voice phone number where you can be reached; and your PASSWORD.

  a.  First and Last names.

  This information is probably the most important.  This will be how you're
known to the SysOp and other users, and will be the name to which private
messages ("E-mail") are addressed.  Some RDBSs allow the use of phony names,
"handles", aliases, etc.  Check out the rules of the system to see if this is
permitted.  In just about EVERY case, however, you will be required to disclose
your true identity to the System Operator.  We recommend that you sign on with
your own name first.  If you later learn that aliases are allowed, and you wish
to use one, ask the SysOp to alter your record accordingly.  (SysOps of many of
the more sophisticated systems around the country will not validate a person
who logs on with an alias, even if s/he gives the correct name later.  Right or
wrong, they feel that aliases are a sign of immaturity and thus that the pros-
pective user might just cause problems rather than make a positive
contribution.)

  b.  City and State.

  This information is not usually that critical, unless you are calling out of
state, but it must be entered.	A few SysOps mail passwords to newly validated
users, so a complete mailing address may be required.

  c.  Telephone number.

  Some systems require this information one-time only; some use it as part of
your password.	Some System Operators will not allow you full (or even ANY)
access to the RDBS until they have called you "voice" to verify your vital
information.

  d.  Your password.

  Sometimes the SysOp will assign the password that you'll need for further
access, and either leave it on the system for you to find the next time you
call in, or phone you "voice" and give it to you.  Usually, though, you will be
asked to type in the password you wish to use.	Sometimes the system will ask
you to type it again, and this second time you will see symbols instead of
letters (like "......." or "$$$$$$$" or "12345678".  This is a security
feature, so that in the future you can type your password with people looking
over your shoulder.  (All they will see is symbols.) Make your password clever
enough so that no one can figure it out, but not so clever that you forget it!
It's very difficult to prove to a System Operator that you really "lost" your
password, and you're not actually some nefarious person trying to gain un-
authorized access.  WRITE IT DOWN and put it in a safe place where nobody else
is likely to see it.

  == AND THAT BRINGS UP A VERY IMPORTANT POINT.  ==

  In case you feel a little nervous about giving all this private information
to some stranger, let us try to calm your fears.  YOUR PERSONAL DATA IS HELD IN
THE STRICTEST CONFIDENCE!  Of course, there are some bad SysOps, just like
there are bad users.  And very occasionally accidents do occur, sometimes with
unfortunate results.  But this is VERY rare, and any SysOp who is foolish
enough to betray the confidence placed him/her will VERY soon have a system
with no users on it!  It is also a wise practice to use a DIFFERENT password on
each and every system that you access.	That way, if someone discovers your
password it will only affect ONE system...  a situation that is not all that
difficult to deal with.  In addition, some users like to change their passwords
at regular intervals.  The already slim chance for abuse is reduced even
further!

  2.  A new user's first log-on information.

  Most systems include a new-user message.  This is nor- mally seen only the
first time you get on a system.  It may contain a greeting, a summary of
commands, instruc- tions, system news, or the rules that you will be expected
to observe on that particular system.  READ IT THOROUGHLY!  As a general
practice, you should have your "capture buffer" open or your printer turned on
each time you log in to a new system.  This allows you to study the rules and
procedures of that system before you log in again.  (See your communications
software instructions for information on how to capture data to disk or the
printer.)

  Note that this information is always on-line when you log in, so if you've
forgotten anything and don't have the printed copy handy, just type "H" or "?"
at the main command prompt and you will see how to access the new user
information.  (See below.)

  C.  The Main Command prompt and Menus.

  Almost every system in use has a main command prompt, and a main menu from
which you can select what you want to do.  The latter will list the commands
that you may use, and these may provide access to one or more files that are
designed to assist you.  Known as "help files", they are usually accessed by
entering "H", or "?", or ".HELP", etc., depending on the particular RDBS.  WE
CANNOT STRESS THE IMPORTANCE OF THESE HELP FILES ENOUGH.  In fact, you should
always print them out (or write them down) so that you can easily refer to them
until you become comfortable with the system.  Some other common commands are:
"E" (or "P") for Enter (or Post) a message; "R" for read messages; "G" for
Goodbye; "F" for the file transfer area, and so on.  EACH TYPE OF SYSTEM IS
DIFFERENT, SO TAKE THE TIME TO LEARN THE COMMANDS EACH SYSTEM USES.  For
instance, some systems allow you to leave a private message for the System
Operator at any time during your session.  Others ask you if you would like to
do so when you log off.  It won't take long before you develop a "feel" for
each type of system.

  NOTE:  Experienced users make it a practice to log on to a new system,
"capture" all of the bulletins, help files, and so forth, and then log off
without actually USING the system (except to provide whatever information is
required for future access.) Then the expert users STUDY the help files until
they have a fairly good idea of how the system operates.  This pro- cedure is
all the more important with systems dedicated to software exchange, the
procedures of which can be very complex.  If this is a good practice for
experts, it's an even better practice for novices!

  D.  Respect the time the SysOp must devote to the RDBS and try not to add to
it!

  There is nothing more irritating to a System Operator than a brand-new
caller, usually a novice, who immediately switches the terminal to "Expert"
mode and then starts stumbling around the system, totally lost.  ("Expert"
mode, found on most systems, is for the user who has mastered that system and
no longer needs the majority of the menus or other assistance.) After becoming
completely confused, the user will then either "page" the SysOp, which means
try to get the operator to type directly to him/her on-line, or leave personal
notes to the SysOp like, "I can't get this thing to work," or "What's wrong
with the message area?" THE INFORMATION YOU NEED IS IN THE HELP FILES OR THE
SYSTEM'S BULLETINS!  (If it's not, it's not much of a system.) If all else
fails and you can't get an answer to a legitimate question, by all means try to
contact the SysOp...  but think of it as a last resort measure.

  Also, concerning the "Page" or "Operator" command:  this is a feature found
on most RDBS's which signals the SysOp that a user wishes to "chat" (or type
directly back and forth).  It does so by causing the host computer to beep,
thus alerting the operator.  One quick way to get on a SysOp's bad side is to
engage this function time after time after time.  Usually, once is enough!  If
the operator does not respond, s/he is either not around or does not wish to be
disturbed.  In that case, simply leave a Comment (or Feedback, etc.) for the
SysOp.	If your question or comment requires an answer, you'll usually get one.
Some things that will not get a response are questions about system commands or
procedures.  As stated above, everything you need to know should already be
included in help files or bulle- tins.	Bear in mind that each message, comment
or reply takes up precious disk or memory space, and smaller systems have a
very limited amount of room.  Make your comments count.  If you sin- cerely are
confused about something and need help, most SysOps (and users, for that
matter) will bend over backwards to help you out.  After all, we were all
beginners once!

  E.  File transfer.

  This refers to moving "files" from the host computer (the system you're
logged onto) to your computer, and vice-versa.	Many RDBS's have a variety of
games, utilities, text files and even applications programs which are in the
public domain or which the copyright holder has allowed to be freely distri-
buted for non-commercial purposes.  These may be shared freely among users.  Do
not expect to find commercial (store-bought) software available for you to
download, but some of the so-called "freeware" is better than its slick,
expensive counterparts and can be found for almost any brand of computer that
you can think of.  By the same token, do not attempt to upload programs that
you have purchased or suspect might be "pirated" from legitimate sources.  This
type of activity could lead to serious legal problems.	Systems with a download
section normally contain a "directory" of files which are available to you.
(Some systems require you to upload a certain amount of software in proportion
to the amount that you download...  the idea being that you should contribute
as well as benefit.  This is how "freeware" gets distributed and it is
important that it be a two-way street.)

  You will need to use a communications program that offers uploading and
downloading capabilities in order to transfer files back and forth.  Refer to
the instructions packaged with your communications program for the specific
procedures.  In order to transfer files error-free, you will need to use one of
many error-checking systems built into most communications programs.  The most
common system is called XMODEM, or sometimes Christensen Protocol (after Ward
Christensen who developed the protocol in 1978).  There are a number of other
protocols avail- able, but none enjoys the wide-spread use of XMODEM.

  F.  Reading and posting messages.

  The typical RDBS is message-oriented, hence the term "bulletin board system"
or "public access message system." One of the major benefits of RDBSs is that
they provide the user with the ability to exchange information with friends or
others with common interests.  (There are a number of RDBSs around the country
that limit membership to those in some profession or field of interest, such as
silicon engineering, medicine, law, politics, photography, real estate, and so
forth.	In other cases, there may be a sub-section on the RDBS for such SIGs,
or Special Interest Groups, which may require a sepoarate valid- procedure
before you can obtain access.

  When reading messages, we suggest that you use the continuous or "non-stop"
mode if the system offers it.  (After the first message, you will usually be
prompted by something like "CONTINUE?  YES, NO, N/S".  N/S refers to
"non-stop".) On very busy systems, especially at 300 bps, you may barely have
time to capture all the messages to disk or printer before your time has
expired.  Even on those with longer time limits, it is courteous to read
messages "off-line" rather than tying up sys- tem time to do so.  Then, if you
see something that you wish to reply to, you can do so during your next
session.

  If you wish to send a short message of just a few lines, the normal procedure
is simply to type the message while on-line.  However, for long messages or for
messages which may take time to compose, or for those of us who are
hunt-and-peck typists, type your messages off-line and then "upload" them to
the system.  (The slower modems "type" at about 300 words per minute, the
faster at up to 2400 wpm.  The average person of moderate typing ability can
type at 30-45 wpm; with time out to compose one's thoughts, that speed is
reduced to about 15-20 wpm.) Don't tie up 15 minutes of system time typing a
long message that could be uploaded in 15 seconds!

  In any case, avoid "playing games" within messages.  Control characters,
ASCII graphics (drawings of Darth Vader or what- ever), repeated carriage
returns and tabs or spaces before ending the message, and other "excess
baggage" is usually frowned upon by SysOps and users alike.  The reasons are
not aesthetic, but relate to the time it takes to scroll through the message
(at 300 bps) or the fact that bunches of C/Rs cause the text to scroll off the
screen faster than people can read/scan (at 1200 bps or faster.) And it is
particularly disturbing to those using hardcopy terminals or who capture
everything to their printers.

  NOTE:  Some systems (especially PDSEs) are primarily for file transfers and
actively DISCOURAGE message activity except for information and questions about
computer hardware and/or soft- ware.  A few large PDSEs don't even HAVE a
message base:  the only person with whom one can communicate is the SysOp.

  G.  "Pay" systems.

  Although the majority of RDBSs in existence today are "free" to the user, the
trend is to require a small annual donation for system maintenance and
upgrading.  The typical small system may be run on the SysOp's personal
computer during hours when neither the computer nor the voice line is in use.
The additional cost of running the system is usually an occa- sional service
charge for drive alignment.  Usually the SysOp is more than happy to pay this
for the enjoyment of operating his/her own RDBS.

  Larger and more complex systems are another thing entirely!  Often using
sophisticated custom operating systems and bulletin board programs, with hard
disks of 10 to 140 megabytes, and with one or more telephone lines dedicated to
the system, these RDBSs are expensive and very time consuming to operate.
Systems like PDSEs (which are primarily a source of "freeware") require that
the operator spend a certain amount of time and money on long distance phone
calls to OTHER systems to ensure that s/he has the latest and best software
available.

  These sophisticated systems will often charge $10 to $30 per year for user
access.  A few are not worth the price of a phone call, but many are well worth
the money, and offer a viable and much less expensive alternative to commercial
sys- tems such as CompuServe and The Source.  And even at $30 per user, the
income rarely exceeds the cost of maintenance and upgrading.

			IN CONCLUSION:
			~~~~~~~~~~~~~~
  You are now involved with one of the most fascinating and far-reaching
developments in the history of man:  instant, world-wide personal
telecommunications.  You may wish to use it for fun, for learning, for
business, for on-line shopping and banking, for obtaining free software
(freeware) - virtually any form of communication or information exchange you
can imagine.  Being a good, responsible user can be summed up in one sentence:
"Learn how to USE a system to its full potential and never ABUSE a system in
any way." There are laws in existence now (and new ones being passed all the
time) concerning what you may and may not do with your computer and modem.  And
violators ARE being prosecuted.  (Not to worry:  COMRAP is trying to keep a
close watch on these laws.  So far, as long as a user doesn't violate the
rights of others, s/he's safe.  That's the way it should be.)

  When in doubt, feel free to try out the commands available from the system
menus.	You don't have to worry about harming the remote system; all good RDBSs
have security features built in to protect the system as well as YOU.  As you
learn more about how to take advantage of the various features offered by
RDBSs, your enjoyment will continue to increase.

  Use your modem to pass this information on to your computing friends...  and

		    H A V E   F U N  ! ! !
		    ~~~~~~~~~~~~~~~~~~~~~~

 -  -  -  -  -	-  -  -  -  -  -  -  -	-  -  -  -  -  -  -  -

		      GLOSSARY OF TERMS:
		      ~~~~~~~~~~~~~~~~~~

  ACCESS:  To get onto a system or into a particular area of a specific system.

  BBS:	Bulletin Board System.	Usually message-oriented RDBSs.

  BPS:	Bits per second.  This is a measurement of how fast data is travelling
between two modems.  Eight bits is one single character or space.  Typical
speeds for modems using standard tele- phone lines are 300, 1200, and 2400 bps.
This is also refered to as "baud rate", which is techni- cally incorrect, but
in common usage.

  BAUD RATE:  Frequently used to represent the speed at which data is
travelling.  (See BPS.)

  BREAK:  A 200 to 600 millisecond tone usually used when connected to remote
mainframe computers.  If used with most RDBSs, it is likely to cause the remote
to disconnect.	An incoming call on a telephone line with "call-waiting" has
the same effect.

  BULLETIN:  Text information that the System Operator wishes you to be aware
of.  Bulletins may appear directly before or directly after log-on, or may be
accessible at any time from the main command level.  You should always read new
Bulletins.

  CALL-WAITING:  A telephone company service that lets the tele- phone user
know when there is an incoming call when the line is in use.  This will usually
result in a modem being disconnected.

  C/R:	Carriage Return; the <Enter> key.

  CARRIER TONE:  The high pitched "squeal" made by the modem.  Different
pitches enable two modems to "under- stand" each other.

  CHAT:  Type directly back and forth with the System Operator while on-line.
Usually a very slow and inefficient way to communicate.

  COMMAND:  An instruction to the remote system to do some- thing.  Entered in
response to a PROMPT.

  COMMENT:  Usually a personal message to the System Oper- ator.  (See
FEEDBACK.)

  COMRAP:  A not-for-profit organization involved in pro- moting and protecting
the interests of RDBS users and operators.

  DATA LINE:  A telephone line more-or-less permanently con- nected (dedicated)
to a computer via a modem.  May be either a standard telephone line (dial- up)
or a leased "data-grade" line.  Most RDBSs use standard telephone lines.

  DIRECTORY:  A listing on the remote computer of the files available for
downloading, placed there by the SysOp.  On some systems, the directory is
auto- matically updated to include files contributed by users.

  DOWNLOAD:  Transfer a file from a remote system to your computer.  It comes
"down" the line to you.

  E-MAIL:  Electronic Mail.  Personal message from one user to another.  A
private message.

  ENTER:  The <Enter> key or Carriage Return (C/R) key on your computer.

  EXPERT MODE:	Available on most remote systems.  Suppresses most menus and
help files for more advanced users.  (If you aren't, don't!)

  FEEDBACK:  Usually a personal message to the SysOp.  Same as COMMENT.

  FILE:  A computer program or volume of text.

  FILE TRANSFER:  The uploading and downloading of files.

  FREEWARE:  Software that may be freely distributed for non- commercial
purposes.  Usually copyrighted and sometimes accompanied by a request from the
author that the user donate a small amount of money to him/her if the program
turns out to be useful.

  HANDLE:  An alias; phony name.  Some systems allow them.

  HOST:  The (remote) computer that you're calling.  Can be a micro, mini, or
mainframe system.

  ICBM:  Inter-Continental Ballistic Missile.

  LOG OFF:  End your session.  You must log off by using the proper command in
order for your personal user file to be updated properly!  Repeated failure to
properly log off will almost always result in the SysOp "devalidating" you.

  LOG ON:  Gain access to a remote computer system.

  MODEM:  MOdulator-DEModulator.  A device that connects your computer to other
computers across stan- dard telephone lines.  The remote computer must also be
connected to its own modem.

  NORAD:  North American Air Defense Command.  The Air Force.

  PAGE:  Alert the System Operator that you wish to com- municate directly with
him/her by typing.  (See CHAT.)

  PAMS:  Public Access Message System.	(See BBS.)

  PASSWORD:  Your secret code word that identifies you to the remote system.

  PDSE:  Public Domain Software Exchange.  A new term that is more generic than
the old term (RCPM), which leaves the impression that the system offers only
CP/M software.	(See RCPM.) Software may be public domain or freeware.

  PIRACY:  The act of knowingly obtaining, sharing, trading or copying
proprietary software to avoid having to pay for it.

  PROMPT:  A signal from the host computer indicating that it is waiting for
you to tell it what action you desire it to take.  May be a symbol (>, ?, etc.)
or a word, sometimes accompanied by a beep.

  PUBLIC DOMAIN:  Software that is not copyrighted and which you may freely
share with other users.  Often this term is incorrectly used to refer to ANY
sof- tware that is distributed free or for a very small donation.  (See
"Freeware".)

  RBBS:  Remote Bulletin Board System.	Also the name of a number of related
bulletin board programs.

  RCPM:  Remote CP/M system.  Primarily a place for soft- ware exchange; the
caller is actually using the host computer as if s/he were at the local
keyboard.  Even though the host is usually run- ning the CP/M operating system,
you can rou- tinely find software for most other operating systems.

  RDBS:  Remote Data Base System.  Though usually associ- ated with systems
that offer more features than a simple Bulletin Board System (BBS), the term
encompasses all forms of non-commercial public and semi-public remote computer
databases.  (RBBSs, BBSs, PAMSs, PDSEs, RCPMs, even SIGs on commercial systems
like The Source and Compu- Serve.)

  SIG:	Special Interest Group.  Usually a section of an RDBS or a commercial
database that is devoted solely to discussion and information on a spec- ific
topic (most often, a specific type of com- puter or a specific programming
language, but can be anything from antiques to zoology.)

  SYSOP:  System Operator.  S/he's in charge.

  UPLOAD:  Transfer a file from your computer to a remote system.

  USER:  Anyone who logs on to a remote computer system.

  USER GROUPS:	Organizations of computer users centering around a particular
computer type or programming language.	Often the basis of SIGs (see above.)
Many UGs operate their own RDBSs for the benefit of their members; in some
cases they are open to the general public.

  VALIDATION:  The process of granting system access to pro- spective users.

  VOICE LINE:  A standard telephone line used primarily for voice
communications.  Many RDBS users use their voice line for data communications
as well.

	  =========================================

  COMRAP wishes to express its sincerest appreciation to the following two
system operators, who devoted much time and energy to the writing and
publication of this Users' Guide.

  DAVE SCOTT, SysOp:  Zephyr RDBS Communications

  CHRIS MITCHELL, SysOp:  =Silent Side= RDBS

	 ==========================================


  This document is Copyright (c) 1985 by The Committee for Remote Database
System Rights and Practices (COMRAP).  COMRAP grants the reader the right to
copy and distribute complete and un- altered copies of this document by
electronic means only and without charge to the recipient, for non-commercial
purposes.  (You may adjust the margins to fit on systems with different column
widths.) However, in no case may any portion of this document be altered or
distributed in hardcopy form without the written consent of COMRAP.  Commercial
organizations should contact COMRAP if they wish to incorporate this document
in any other publication.  Typeset printed copies in book form are available to
user groups and other non-profit organizations for a nominal fee.  Just contact
us in writing or through the COMRAP RDBS with your requirements.


			    COMRAP
			 P.O. Box 8696
		  Scottsdale, Arizona  85282

		       -----------------

  COMRAP operates the COMRAP Remote Database System 24 hours a day, 7 days a
week at (602) 253-4269.  The system is accessible at 300 or 1200 bps, with
immediate access for all new callers.
