/*
 * tutor2.c - Turbo C version of Jack Crenshaw's compiler lesson 2
 */
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <process.h>
#include <string.h>
#include <stdarg.h>

#define TAB	9
#define IsAlpha(c) isalpha ((c))
#define IsDigit(c) isdigit ((c))
#define UpCase(c)  toupper ((c))
#define IsAddop(c) (c) == '+' || (c) == '-'
#define IsMulop(c) (c) == '*' || (c) == '/'

char Look;	/* lookahead character */

void Expression (void);

/*
 * Read New Character From Input Stream
 */
void GetChar (void) {
    Look = getchar ();
}

/*
 * Report an Error
 */
void Error (char *fmt, ...) {
    va_list (args);

    printf ("\n\007Error: ");
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
    printf ("\n");
}

/*
 * Report Error and Halt
 */
void Abort (char *fmt, ...) {
    va_list args;

    va_start (args, fmt);
    Error (fmt, args);
    va_end (args);
    exit (1);
}

/*
 * Report What Was Expected
 */
void Expected (char *fmt, ...) {
    va_list args;
    char f[81];

    va_start (args, fmt);
    strcpy (f, fmt);
    Abort (strcat (f, " Expected"), args);
    va_end (args);
}

/*
 * Match a Specific Input Character
 */
void Match (char x) {
    if (Look == x)
        GetChar ();
    else
        Expected ("'%c'", x);
}

/*
 * Get an Identifier
 */
char GetName (void) {
    char c;

    if (! IsAlpha (Look))
        Expected ("Name");
    c = UpCase (Look);
    GetChar ();
    return (c);
}

/*
 * Get a Number
 */
char GetNum (void) {
    char c;
    if (! IsDigit (Look))
        Expected ("Integer");
    c = Look;
    GetChar ();
    return (c);
}

/*
 * Output a String with Tab
 */
void Emit (char *fmt, ...) {
    va_list args;

    printf ("%c", TAB);
    va_start (args, fmt);
    vprintf (fmt, args);
    va_end (args);
}

/*
 * Initialize
 */
void Init (void) {
    GetChar ();
}

/*
 * Parse and Translate a Math Factor
 */
void Factor (void) {

    if (Look == '(') {
	Match ('(');
	Expression ();
	Match (')');
    }
    else
        Emit ("MOV AX,%c\n", GetNum ());
}

/*
 * Recognize and Translate a Multiply
 */
void Multiply (void) {
    Match ('*');
    Factor ();
    Emit ("POP DX\n");
    Emit ("MUL AX,DX\n");
}

/*
 * Recognize and Translate a Divide
 */
void Divide (void) {
    Match ('/');
    Factor ();
    Emit ("POP DX\n");
    Emit ("XCHG AX,DX\n");
    Emit ("DIV AX,DX\n");
}

/*
 * Parse and Translate a Math Term
 */
void Term (void) {
    Factor ();
    while (IsMulop (Look)) {
        Emit ("PUSH AX\n");
	switch (Look) {
	    case '*' : Multiply (); break;
	    case '/' : Divide (); break;
	    default  : Expected ("Mulop"); break;
	}
    }
}

/*
 * Recognize and Translate an Add
 */
void Add (void) {
    Match ('+');
    Term ();
    Emit ("POP DX\n");
    Emit ("ADD AX,DX\n");
}

/*
 * Recognize and Translate a Subtract
 */
void Subtract (void) {
    Match ('-');
    Term ();
    Emit ("POP DX\n");
    Emit ("SUB AX,DX\n");
    Emit ("NEG AX\n");
}

/*
 * Parse and Translate an Expression
 */
void Expression (void) {
    if (IsAddop (Look))
	Emit ("XOR AX,AX\n");
    else
	Term ();
    while (IsAddop (Look)) {
        Emit ("PUSH AX\n");
        switch (Look) {
	    case '+' : Add (); break;
	    case '-' : Subtract ();  break;
	    default  : Expected ("Addop"); break;
	}
    }
}

/*
 * Main Program
 */
void main (void) {
    Init ();
    Expression ();
}
