# Nmake macros for building Windows 32-Bit apps

!include <ntwin32.mak>

.SUFFIXES: .obj .c .cpp .y .l


.cpp.obj:
    $(cc) $(cflags) $(cdebug) -D__try=__ztry -Dthis=__zthis -Dnew=__znew $(cvars) $*.cpp

.c.obj:
    $(cc) $(cflags) $(cdebug) -D__try=try -DYYMAXDEPTH=10000 $(cvars) $*.c


REXX_OBJS= \
	builtin.obj \
	cmath.obj \
	cmsfuncs.obj \
	convert.obj \
	dbgfuncs.obj \
	debug.obj \
	doscmd.obj \
	envir.obj \
	error.obj \
	expr.obj \
	extlib.obj \
	files.obj \
	funcs.obj \
	interp.obj \
	interprt.obj \
	lexsrc.obj \
	library.obj \
	macros.obj \
	memory.obj \
	misc.obj \
	options.obj \
	parsing.obj \
	r2perl.obj \
	rexx.obj \
	rexxext.obj \
	shell.obj \
	signals.obj \
	stack.obj \
	strings.obj \
	strmath.obj \
	tracing.obj \
	variable.obj \
	w32funcs.obj \
	w32ole.obj \
	win32.obj \
	wrappers.obj \
	yaccsrc.obj

all: rexx.exe

rexx.exe: $(REXX_OBJS)
    $(link) $(conlflags) $(ldebug) /STACK:0x1F40000 -out:rexx.exe $(REXX_OBJS) $(conlibs) ole32.lib oleaut32.lib uuid.lib user32.lib

lexsrc.c: lexsrc.l symbols.h
        -@del lexsrc.c
        lex -8 lexsrc.l
        @move lex.yy.c lexsrc.c

yaccsrc.c: yaccsrc.y
        -@del yaccsrc.c
        -@del symbols.h
        yacc -d yaccsrc.y
        move y.tab.c yaccsrc.c

symbols.h: yaccsrc.c
        move y.tab.h symbols.h

clean:
	-del *.obj
	-del rexx.pdb
	-del rexx.exe

clobber: clean
        -del yaccsrc.c
        -del lexsrc.c
        -del symbols.h
        -del win32.vcp

install: all
	copy rexx.exe d:\local\bin
	copy rexx.exe ..\..
