/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: types.h,v 1.11 1993/05/10 05:54:59 anders Exp anders $
 */

/*
    This code modified for Win32 port by Ataman Software, Inc. June 29, 1995.
*/


typedef struct varbox *variableptr ;
typedef struct varbox {
   variableptr next, prev, realbox, *index ;   
   struct strengtype *name, *value ;
   int guard ;
   num_descr *num ;
   int flag ;
   short hwired, valid ;
   variableptr stem ;
} variable ;

/* typedef int bool ; */

typedef struct {
   unsigned int lnum:1 ;
   unsigned int rnum:1 ;
   unsigned int lsvar:1 ;
   unsigned int rsvar:1 ;
   unsigned int lcvar:1 ;
   unsigned int rcvar:1 ;
} compflags ;

typedef struct tnode *nodeptr ;
typedef struct tnode {
   unsigned int type ;
   int charnr, lineno ;
/*   char *value ; */
   struct strengtype *name ;
   long now, unow, usec, sec ;
   nodeptr p[5] ;
   union {
      streng *(*func)(void *) ;
      streng *strng ;
      nodeptr node ;
      num_descr *number ;
      compflags flags ;
      variable *varbx ;
   } u ;
   nodeptr next ; 
} treenode ;

typedef struct stackboxtype *stackboxptr ;
typedef struct stackboxtype {
   int whereto, number ;
   void *increment, *tdescr, *stopval ;
   int incrdir ;
   int guard ;
   streng *oldcnt ;
   nodeptr this ;
} stackbox ;

typedef struct pparambox *paramboxptr ;
typedef struct pparambox {
   paramboxptr next ;
   int dealloc ;
   struct strengtype *value ; 
} parambox ;

typedef struct lineboxx *lineboxptr ;
typedef struct lineboxx {
   lineboxptr next, prev ;
   struct strengtype *line ;
   int lineno ;
} linebox ;

typedef variableptr hashtabl[HASHTABLENGTH] ;

typedef struct labelboxx *labelboxptr ;
typedef struct labelboxx {
   labelboxptr next ;
   nodeptr entry ; 
} labelbox ;

typedef struct trap_type  /* index is type of signal */
{
   unsigned on_off:1 ;     /* true if trap is active/on */
/* unsigned trapped:1 ; */ /* true if condition has been raised */ 
   unsigned def_act:1 ;    /* true if default action is to ignore */
   unsigned delayed:1 ;    /* true if trap is in delay mode */
   unsigned ignored:1 ;    /* true if ignored when in delayed mode */
   unsigned invoked:1 ;    /* true if invoked by SIGNAL */
   streng *name ;          /* label to transfer control to */
} trap ;

typedef struct sig_type 
{
   int type ;
   streng *info ;
   streng *descr ;
   int invoke ;     /* is true if invoked with SIGNAL */
   int rc, lineno ;
} sigtype ;


typedef struct option
{
   char *name ;
   int offset ;
   char *contains ;
} option_type ;



typedef struct proclevelbox *proclevel ;
typedef struct proclevelbox {
   int numfuzz, currnumsize, numform ;
   int mathtype ;
   long sec, usec ;
   proclevel prev, next ;
   variableptr *vars ;
   paramboxptr args ;
   struct strengtype *environment, *prev_env ;
   char tracestat, varflag ;
   sigtype *sig ; 
   trap *traps ;
   jmp_buf *buf ;  /* for use by longjmp */
   union {
      struct {
         unsigned int flushstack : 1 ;
         unsigned int lineouttrunc : 1 ;
         unsigned int close_bif : 1 ;
         unsigned int open_bif : 1 ;
	 unsigned int buftype_bif : 1 ;
	 unsigned int desbuf_bif : 1 ;
	 unsigned int dropbuf_bif : 1 ;
	 unsigned int makebuf_bif : 1 ;
         unsigned int cacheext : 1 ;
         unsigned int find_bif : 1 ;
         unsigned int prune_trace : 1 ;
      } options ;
      unsigned char flags[4] ;
   } u ;
} proclevbox ;

typedef struct systeminfobox *sysinfo ;
typedef struct systeminfobox {
   struct strengtype *called_as, *input_file ;
   streng *environment ;
   char tracing ;
   int interactive ;
   lineboxptr firstline, lastline ;
   labelboxptr first, last ;
   jmp_buf *panic ;
   streng *result ;
   proclevbox *currlevel ;
   struct systeminfobox *previous ;
   nodeptr rootnode, *callstack ;
   int cstackcnt, cstackmax ;
   int hooks ;
   int invoked ;
} sysinfobox ;


struct entrypt {
   char *name ;
   streng *(*addr)() ;
} ;


struct library {
   streng *name ;
   void *handle ;
   short number ;
   struct library_func *first ;
   struct entrypt *funcs ;
   struct library *next, *prev ;
} ;

