/* Set these three variables. */
localtempfilename = "C:\TEMP\APPLOG.EVT"
remotehost = "ntas"
nameofremotetempfile = "f:\temp\applog.evt"
UNCnameofremotetempfile = "\\ntas\f$\temp\applog.evt"

say "WARNING: This test file will clear the Application Event Log your"
say "         local host and a remote host of your choice."
say "         You must also have set the variables in the top of this file."
say "Press return to continue, Control-C to abort."
pull hitreturn

'del' localtempfilename '>nul 2>&1'

call testit '', localtempfilename

'del' UNCnameofremotetempfile '>nul 2>&1'

call testit remotehost, nameofremotetempfile 

exit

testit: procedure
parse arg host, eventlogfile


h = w32OpenEventLog(host, "Application")
w32ClearEventLog(h)
if w32GetNumberOfEventLogRecords(h) \== 0 then do
	say "Failed to clear eventlog"
	exit
end
w32CloseEventLog(h)

call writeit host

h = w32OpenEventLog(host, "Application")

call checkit h

w32BackupEventLog(h, eventlogfile)

w32CloseEventLog(h)

h = w32OpenBackupEventLog(host, eventlogfile)

call checkit h

w32CloseEventLog(h)

return

writeit: procedure
parse arg host

w32WriteEventLog(host, "Rexx Testing", 2, 1, 3, 'ffee03', "This is a test", "Test2")
w32WriteEventLog(host, "Rexx Testing", , , , , "This is another test")
w32WriteEventLog(host, "Rexx Testing", , , , 'ffeeaa')
return

checkit: procedure
parse arg h
if w32GetNumberOfEventLogRecords(h) ^== 3 then do
	say "w32GetNumberOfEventLogRecords returns wrong value"
	exit
end
w32FindEventLogEntry(h, 1)
if w32GetEventCategory() ^== 1 then do
	say "wrong value"
	exit
end
if w32GetEventData() ^== 'ffee03' then do
	say "wrong value"
	exit
end
if w32GetEventID() ^== 3 then do
	say "wrong value"
	exit
end
if w32GetEventNumStrings() ^== 2 then do
	say "wrong value"
	exit
end
if w32GetEventString(1) ^== "This is a test" then do
	say "wrong value"
	exit
end
if w32GetEventString(2) ^== "Test2" then do
	say "wrong value"
	exit
end
if w32GetEventType() ^== 2 then do
	say "wrong value"
	exit
end
say "Time Generated:" w32GetEventTimeGenerated()
say "Time Written:  " w32GetEventTimeWritten()
w32FindEventLogEntry(h, 2)
if w32GetEventCategory() ^== 0 then do
	say "wrong value"
	exit
end
if w32GetEventData() ^== '' then do
	say "wrong value"
	exit
end
if w32GetEventID() ^== 0 then do
	say "wrong value"
	exit
end
if w32GetEventNumStrings() ^== 1 then do
	say "wrong value"
	exit
end
if w32GetEventString(1) ^== "This is another test" then do
	say "wrong value"
	exit
end
if w32GetEventType() ^== 1 then do
	say "wrong value"
	exit
end
w32FindEventLogEntry(h, 3)
if w32GetEventCategory() ^== 0 then do
	say "wrong value"
	exit
end
if w32GetEventData() ^== 'ffeeaa' then do
	say "wrong value"
	exit
end
if w32GetEventID() ^== 0 then do
	say "wrong value"
	exit
end
if w32GetEventNumStrings() ^== 0 then do
	say "wrong value"
	exit
end
if w32GetEventType() ^== 1 then do
	say "wrong value"
	exit
end
return
