Attribute VB_Name = "Module1"
Option Explicit


Sub Main()

    '-- This module demonstrates the functionality of
    '-- VertekHTML.
    '-- (c) 1997 Joe Hubert
    '-- Vertek Corporation, Murray Hill, NJ (908) 464-8400
    '-- joe@vertekcorp.com
    '-- http://www.vertekcorp.com
    
    '-- The following module is VB 4.0 code:
    Dim dbTest As Database
    Dim rsTest As Recordset
    Dim sDbName As String
    Dim sqlOpen As String
    
    Dim vtkTbl As Object
   
    Dim iFileHand As Integer
    
    '-- Change to path of sample Access database (long filename):
    sDbName = "c:\msoffice\access\samples\northwind.mdb"
    Set dbTest = Workspaces(0).OpenDatabase(sDbName)
    sqlOpen = "SELECT * FROM Products WHERE ProductId < 21"
    Set rsTest = dbTest.OpenRecordset(sqlOpen, dbOpenSnapshot)
    
    Set vtkTbl = CreateObject("VertekHTML.HTMLTable")
    
    '-- Set table properties:
    With vtkTbl
        Set .ADORecordSet = rsTest
        .NumCols = 3
        .Border = "1"
        .Width = "500"
        .HeadingRow = True
        .TotalRow = True
    End With
    
    '-- Set properties for each column:
    With vtkTbl.Columns.Item(1)
        .DataField = "ProductName"
        .Heading = "Product"
        .Width = "50%"
    End With
    
    With vtkTbl.Columns.Item(2)
        .DataField = "UnitsInStock"
        .Heading = "# in Stock"
        .TotalType = "SUM"
        .TotalPrefix = "Total: "
        .Width = "25%"
        .Align = "RIGHT"
    End With
    
    With vtkTbl.Columns.Item(3)
        .DataField = "ReorderLevel"
        .Heading = "Reorder Level"
        .TotalType = "AVG"
        .TotalPrefix = "Avg.: "
        .TotalFormat = "#.##"
        .Width = "25%"
        .Align = "RIGHT"
    End With


    '-- Make an html file:
    iFileHand = FreeFile
    Open "test.htm" For Output As iFileHand
    Print #iFileHand, "<HTML><H1>List of Products</H1>"
    '-- The GetHTMLTable method outputs the html table
    Print #iFileHand, vtkTbl.GetHTMLTable
    Print #iFileHand, "</HTML>"
    
    Close iFileHand
    
    rsTest.Close
    dbTest.Close
    
    '-- Open the file test.htm with your web browser to examine output.
    
    Set vtkTbl = Nothing

End Sub
