// (c) Jean MICHEL June 1993 -- any modifications must be signaled to the
// author

// class TShapeWindow is for the 'Shapes' window

#include <stdio.h>
#include <stdlib.h>
#include <owl.h>
#include <commdlg.h>
#include <dir.h>
#include <io.h>
#include <string.h>
#include <inputdia.h>
#include <dos.h>
#include <listbox.h>
#include <button.h>
#include <static.h>
#include "cell.h"
#include "shapewnd.h"
#include "life.h"
#include "efns.h"

cellpop selected_shape("o");
static cellpop local_shape("o");
int listbox_index;
const RECT r={20,195,220,395};

TShapeWindow::TShapeWindow(PTWindowsObject AParent) :
   TWindow(AParent, "Select a shape")
{ DisableAutoCreate();
  Attr.Style |= WS_POPUPWINDOW | WS_CAPTION;
  Attr.X = 0;
  Attr.Y = 0;
  Attr.W = 240;
  Attr.H = 480;
  new TButton(this, ID_BUTTON7, "Load new library",   20, 15, 200, 30, FALSE);
  ListBox = new TListBox(this, ID_LISTBOX, 20, 60, 200, 75);
  ListBox->Attr.Style^=LBS_SORT;
  new TButton(this, ID_BUTTON3, "Load from file", 20, 140, 140, 30, FALSE);
  new TButton(this, ID_BUTTON4, "Line",  180, 140, 40, 30, FALSE);
  PreviewMsg=new TStatic(this, -1,         "Preview:",      20, 175, 160, 19, 0);
  new TButton(this, ID_BUTTON5, "Mirror",  20, 410, 65, 30, FALSE);
  new TButton(this, ID_BUTTON6, "Rotate",  105, 410, 65, 30, FALSE);
  new TButton(this, ID_BUTTON1, "Ok",      190, 410, 30, 30, TRUE);
}

void TShapeWindow::SetupList()
{ char *n;
  ListBox->ClearList();
  for(int j=0;n=getshapename(j);j++)ListBox->AddString(n);
  ListBox->SetSelIndex(listbox_index);
}

void TShapeWindow::SetupWindow()
{ TWindow::SetupWindow();
  SetupList();
  InvalidateRect(HWindow,&r,TRUE);
};

void TShapeWindow::HandleListBoxMsg(RTMessage Msg)
{ cellpop temp=cellpop(getshape(listbox_index=ListBox->GetSelIndex()));
  if(temp.error())return;
  local_shape=temp;
  selected_shape=local_shape;
  InvalidateRect(HWindow,&r,TRUE);
  if(Msg.LP.Hi==LBN_DBLCLK)HandleButton1Msg(Msg);
}

void TShapeWindow::HandleButton1Msg(RTMessage)
{ selected_shape=local_shape;}

void TShapeWindow::Paint(HDC DC, PAINTSTRUCT&)
{ int bx=local_shape.firstx().cellx(),by=local_shape.firsty().celly(),
      ex=local_shape.lastx().cellx(),ey=local_shape.lasty().celly();
  int magnification= (r.right+1-r.left)/(ex+1-bx);
  if(magnification> (r.bottom+1-r.top)/(ey+1-by))
     magnification=(r.bottom+1-r.top)/(ey+1-by);
  if(magnification==0)magnification=1;
  if(magnification>25)magnification=25;
  char prevmsg[20];
  sprintf(prevmsg,"Preview:      Mag:%d",magnification);
  PreviewMsg->SetText(prevmsg);
  int xoffset=((r.right+1+r.left)-magnification*(ex+1-bx))/2;
  if(xoffset<r.left)xoffset=r.left;
  int yoffset=((r.bottom+1+r.top)-magnification*(ey+1-by))/2;
  if(yoffset<r.top)yoffset=r.top;
  int border=magnification>3;
  MoveTo(DC,r.left-1,r.top-1);
  LineTo(DC,r.left-1,r.bottom+1);
  LineTo(DC,r.right+1,r.bottom+1);
  LineTo(DC,r.right+1,r.top-1);
  LineTo(DC,r.left-1,r.top-1);
  SelectObject(DC,Pens[SET]);
  SelectObject(DC,Brushes[SET]);
  for(int iw=0;iw<local_shape.pop;iw++)
  { int x=xoffset+magnification*(local_shape.v[iw].cellx()-bx);
    int y=yoffset+magnification*(local_shape.v[iw].celly()-by);
    if(magnification>1)
      Rectangle(DC,x,y,x+magnification-border,y+magnification-border);
    else SetPixel(DC,x,y,Colors[SET]);
  }
  HPEN pen=CreatePen(PS_DOT,1,RGB(100,100,100));
  SelectObject(DC,pen);
  xoffset+=magnification/2-1-bx*magnification;
  yoffset+=magnification/2-1-by*magnification;
  MoveTo(DC,xoffset,r.top-1);  LineTo(DC,xoffset,r.bottom+1);
  MoveTo(DC,r.left-1,yoffset);  LineTo(DC,r.right-1,yoffset);
  DeleteObject(pen);
}

char *win_getfilename(HWND HWindow,char *szTemp,char *title,char *defext)
{ OPENFILENAME ofnTemp;
  static char FileName[MAXPATH];
/*
Some Windows structures require the size of themselves in an effort to
provide backward compatibility with future versions of Windows.  If the
lStructSize member is not set the call to GetOpenFileName() will fail.
*/
  ofnTemp.lStructSize = sizeof( OPENFILENAME );
  ofnTemp.hwndOwner = HWindow;		// An invalid hWnd causes non-modality
  ofnTemp.hInstance = 0;
  ofnTemp.lpstrFilter = (LPSTR)szTemp;	// See previous note concerning string
  ofnTemp.lpstrCustomFilter = NULL;
  ofnTemp.nMaxCustFilter = 0;
  ofnTemp.nFilterIndex = 2;
  ofnTemp.lpstrFile = FileName;	// Stores the result in this variable
  FileName[0]=0;
  ofnTemp.nMaxFile = sizeof( FileName );
  ofnTemp.lpstrFileTitle = NULL;
  ofnTemp.nMaxFileTitle = 0;
  ofnTemp.lpstrInitialDir = NULL;
  ofnTemp.lpstrTitle = title;				// Title for dialog
  ofnTemp.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_PATHMUSTEXIST;
  ofnTemp.nFileOffset = 0;
  ofnTemp.nFileExtension = 0;
  ofnTemp.lpstrDefExt = defext;
  ofnTemp.lCustData = NULL;
  ofnTemp.lpfnHook = NULL;
  ofnTemp.lpTemplateName = NULL;
/*
If the call to GetOpenFileName() fails you can call CommDlgExtendedError()
to retrieve the type of error that occured.
*/
  if(GetOpenFileName( &ofnTemp ) != TRUE)
  { DWORD Errval=CommDlgExtendedError();
    if(Errval!=0)   // 0 value means user selected Cancel
      efns(WARNING_,"GetOpenFileName returned Error %ld",Errval);
    return NULL;
  }
  return FileName;
}

void TShapeWindow::HandleButton3Msg(RTMessage)
{ char *FileName=win_getfilename(HWindow,"All Files (*.*)\0*.*\0Life Files (*.lfe)\0*.lfe\0",
  "Load Shape","lfe");
  if(FileName)
  {  cellpop temp=readfile(FileName);
     if(temp.error())return;
     local_shape=temp;
     selected_shape=local_shape;
     InvalidateRect(HWindow,&r,TRUE);
  }
}

void TShapeWindow::HandleButton4Msg(RTMessage)
{ char InputText[6];static int lg=10;
  sprintf(InputText, "%d", lg);
  if ( GetApplication()->ExecDialog(
  new TInputDialog(this, "Input Size of Line of Cells:","", InputText, sizeof InputText)
  ) == IDOK )lg = atoi(InputText);
  local_shape=cellpop(lg);
  selected_shape=local_shape;
  InvalidateRect(HWindow,&r,TRUE);
}

void TShapeWindow::HandleButton5Msg(RTMessage)
{ local_shape.transform(1);
  selected_shape=local_shape;
  InvalidateRect(HWindow,&r,TRUE);
}

void TShapeWindow::HandleButton6Msg(RTMessage)
{ local_shape.transform(5);
  selected_shape=local_shape;
  InvalidateRect(HWindow,&r,TRUE);
}

void TShapeWindow::HandleButton7Msg(RTMessage)
{ char *FileName=win_getfilename(HWindow,"All Files (*.*)\0*.*\0Life Libraries (*.lib)\0*.lib\0",
  "Load Shape Library","lib");
  if(FileName)readshapelib(FileName);
  SetupList();
}

