/*
 *  Pundit.h
 *      Header File for Pundit
 *          Defines useful constants
 *
 *  Author:         Jeff Bienstadt
 *
 *  Environment:
 *
 *      Run-Time:   Microsoft Windows 3.0
 *
 *      Compilers/Tools:
 *                  Microsoft C 6.0
 *                  Microsoft Windows SDK 3.0
 *
 */

#define MAX_STRING     208      // maximum string resource number
#define MAX_IN          60      // max seconds for window to show (1 minute)
#define MAX_OUT       3600      // max seconds for window to hide (1 hour)

#define ID_TIMER        1       // ID for our timer

//  Menu Choice IDs
#define IDM_SETTINGS    1       // "Settings..."       menu choice ID
#define IDM_ABOUT       2       // "About Pundit..."   menu choice ID
#define IDM_EXIT        3       // "Exit"              menu choice ID

// Dialog Box Control IDs
#define IDC_INSCROLL    100     // IN time scroll bar
#define IDC_OUTSCROLL   101     // OUT time scroll bar
#define IDC_INSECS      102     // IN seconds display box
#define IDC_OUTSECS     103     // OUT seconds display box
#define IDC_SAVE        104     // "Save Settings" button


//  Private Messages
#define WM_jkb_START    (WM_USER+0x100) // Message to start timer
#define WM_jkb_PAUSE    (WM_USER+0x101) // Message to suspend timer
