//REGEN_FILEHEADING
//REGEN_FILEHEADING

     /********************************************************************
      *                                                                  *
      *   Source File: PREFER.cpp                                        *
      *   Description: Dialog implementation for FLIPIT                  *
      *   Date:        Sat Jun 25 15:12:32 1994                          *
      *                                                                  *
      ********************************************************************/

#include <owl.h>
#include <edit.h>
#include <listbox.h>
#include <combobox.h>
#include <scrollba.h>
#include <dialog.h>
#include <bwcc.h>
#include "FlipitID.h"
#include "FlipiCls.h"


//REGEN_VARIABLES
#include <bradio.h>
extern int Player,BoardSize,Player1,Player2,Difficulty;
extern HWND ghWindow;
extern BOOL bDefault;
//REGEN_VARIABLES

extern HINSTANCE hInst;


// Define TPREFERDlg, a TDialog constructor
TPREFERDlg::TPREFERDlg(PTWindowsObject AParent, LPSTR AName)
               :TDialog(AParent, AName)
{

   //REGEN_PREFER_CONSTRUCTOR
   Rb201 = new TBRadioButton(this,201,NULL,NULL);
   Rb202 = new TBRadioButton(this,202,NULL,NULL);
   Rb204 = new TBRadioButton(this,204,NULL,NULL);
   Rb205 = new TBRadioButton(this,205,NULL,NULL);
   Rb207 = new TBRadioButton(this,207,NULL,NULL);
   Rb208 = new TBRadioButton(this,208,NULL,NULL);
   Rb210 = new TBRadioButton(this,210,NULL,NULL);
   Rb211 = new TBRadioButton(this,211,NULL,NULL);
   Rb212 = new TBRadioButton(this,212,NULL,NULL);
   Rb213 = new TBRadioButton(this,213,NULL,NULL);
   Cb214 = new TCheckBox(this,214,NULL,NULL);
   //REGEN_PREFER_CONSTRUCTOR

}

// Define TPREFERDlg destructor
TPREFERDlg::~TPREFERDlg()
{

   //REGEN_PREFER_DESTRUCTOR
   delete(Rb201);
   delete(Rb202);
   delete(Rb204);
   delete(Rb205);
   delete(Rb207);
   delete(Rb208);
   delete(Rb210);
   delete(Rb211);
   delete(Rb212);
   delete(Rb213);
   SetTimer(ghWindow,10,1500,NULL);
   //REGEN_PREFER_DESTRUCTOR

}

void TPREFERDlg::RTPREFER204(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER204_ROUTING
      Rb204->Check();
      Rb205->Uncheck();
      //REGEN_PREFER204_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER205(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER205_ROUTING
      Rb205->Check();
      Rb204->Uncheck();
      //REGEN_PREFER205_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER207(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER207_ROUTING
      Rb207->Check();
      Rb208->Uncheck();
      //REGEN_PREFER207_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER208(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER208_ROUTING
      Rb208->Check();
      Rb207->Uncheck();
      //REGEN_PREFER208_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER213(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER213_ROUTING
       Rb213->Check();
       Rb201->Uncheck();
       Rb202->Uncheck();
      //REGEN_PREFER213_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER201(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER201_ROUTING
       Rb213->Uncheck();
       Rb201->Check();
       Rb202->Uncheck();
      //REGEN_PREFER201_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER202(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER202_ROUTING
       Rb213->Uncheck();
       Rb201->Uncheck();
       Rb202->Check();
      //REGEN_PREFER202_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER210(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER210_ROUTING
      Rb210->Check();
      Rb211->Uncheck();
      Rb212->Uncheck();
      //REGEN_PREFER210_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER211(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER211_ROUTING
      Rb210->Uncheck();
      Rb211->Check();
      Rb212->Uncheck();
      //REGEN_PREFER211_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER212(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER212_ROUTING
      Rb210->Uncheck();
      Rb211->Uncheck();
      Rb212->Check();
      //REGEN_PREFER212_ROUTING
      break;
   }
}

void TPREFERDlg::RTPREFER214(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFER214_ROUTING
      Cb214->Toggle();
      //REGEN_PREFER214_ROUTING
      break;
   }
}

void TPREFERDlg::Ok(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFERIDOK_ROUTING
	if (Rb201->GetCheck() == BF_CHECKED && BoardSize != 8 ||
            Rb202->GetCheck() == BF_CHECKED && BoardSize != 10 ||
	    Rb213->GetCheck() == BF_CHECKED && BoardSize != 6 ||
            Rb210->GetCheck() == BF_CHECKED && Difficulty != EASY ||
	    Rb211->GetCheck() == BF_CHECKED && Difficulty != MEDIUM ||
	    Rb212->GetCheck() == BF_CHECKED && Difficulty != HARD )
	  if (BWCCMessageBox(HWindow,"Changing the board size or difficulty will start a new game. Continue?","Preferences Message",MB_ICONQUESTION | MB_YESNO ) == IDYES)
          {
	    if (Rb213->GetCheck() == BF_CHECKED)
	      BoardSize = 6;
            else if (Rb202->GetCheck() == BF_CHECKED)
              BoardSize = 10;
            else
	      BoardSize = 8;

	    if (Rb210->GetCheck() == BF_CHECKED)
	      Difficulty = EASY;
	    else if (Rb211->GetCheck() == BF_CHECKED)
	      Difficulty = MEDIUM;
	    else if (Rb212->GetCheck() == BF_CHECKED)
	      Difficulty = HARD;
          }
	  else
	    return;

	if (Rb204->GetCheck() == BF_CHECKED)
	  Player1 = 1;
	else if (Rb205->GetCheck() == BF_CHECKED)
	  Player1 = 2;

	if (Rb207->GetCheck() == BF_CHECKED)
          Player2 = 1;
	else if (Rb208->GetCheck() == BF_CHECKED)
	  Player2 = 2;

	if (Cb214->GetCheck() == BF_CHECKED)
	  bDefault = TRUE;
	else
	  bDefault = FALSE;

      //REGEN_PREFERIDOK_ROUTING
         TDialog::Ok(Msg);
   }
}

void TPREFERDlg::Cancel(RTMessage Msg)
{
   switch(Msg.LP.Hi)
   {
      case BN_CLICKED :
      //REGEN_PREFERIDCANCEL_ROUTING
      //REGEN_PREFERIDCANCEL_ROUTING
         TDialog::Cancel(Msg);
   }
}


//REGEN_CODE
void TPREFERDlg::SetupWindow()
{
   TDialog::SetupWindow();
   KillTimer(ghWindow,10);
   switch (BoardSize)
   {
   case 8:
     Rb213->Uncheck();
     Rb201->Check();
     Rb202->Uncheck();
     break;
   case 10:
     Rb213->Uncheck();
     Rb201->Uncheck();
     Rb202->Check();
     break;
   case 6:
     Rb213->Check();
     Rb201->Uncheck();
     Rb202->Uncheck();
     break;
   }
   if (Player1 == 1)
   {
     Rb204->Check();
     Rb205->Uncheck();
   }
   else
   {
     Rb204->Uncheck();
     Rb205->Check();
   }
   if (Player2 == 1)
   {
     Rb207->Check();
     Rb208->Uncheck();
   }
   else
   {
     Rb207->Uncheck();
     Rb208->Check();
   }
   switch (Difficulty)
   {
   case EASY:
     Rb210->Check();
     Rb211->Uncheck();
     Rb212->Uncheck();
     break;
   case MEDIUM:
     Rb210->Uncheck();
     Rb211->Check();
     Rb212->Uncheck();
     break;
   case HARD:
     Rb210->Uncheck();
     Rb211->Uncheck();
     Rb212->Check();
     break;
   }
}
//REGEN_CODE

