/*
 * Copyright 1993 Network Computing Devices, Inc.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name Network Computing Devices, Inc. not be
 * used in advertising or publicity pertaining to distribution of this
 * software without specific, written prior permission.
 * 
 * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
 * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
 * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
 * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
 * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
 * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
 * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 * $NCDId: @(#)audioutil.h,v 1.19 1993/08/13 20:51:44 greg Exp $
 * 
 * <audio/audioutil.h>
 * 
 * This file contains utilities for using the audio library.
 */

#ifndef AUDIOUTIL_H_
#define AUDIOUTIL_H_

/*****************************************************************************
 * 			       PUBLIC VARIABLES			     	     *
 *****************************************************************************/
#ifndef _UTIL_C_
extern int      AuMonitorRate,			/* sampling rate of the
						 * monitor (in Hz) */
                AuMonitorFormat;		/* format of the monitor data */
#endif						/* !_UTIL_C_ */

_AUFUNCPROTOBEGIN


/*****************************************************************************
 *				    STRINGS				     *
 *****************************************************************************/

/*
 * AuMakeString - this routine create a string object
 */
extern AuString *
AuMakeString(
#if NeedFunctionPrototypes
	     int,				/* type */
	     int,				/* len */
	     char *				/* data */
#endif
);

/*
 * AuCopyString - this routine returns a string object copied from another
 */
extern AuString *
AuCopyString(
#if NeedFunctionPrototypes
	     AuString *				/* string */
#endif
);


/*
 * AuFreeString - this routine returns a string created by AuMakeString or
 * AuCopyString
 */
extern void
AuFreeString(
#if NeedFunctionPrototypes
	     AuString *				/* string */
#endif
);


/*****************************************************************************
 *				    BUCKETS				     *
 *****************************************************************************/

extern          AuBucketID
AuCreateBucket(
#if NeedFunctionPrototypes
	       AuServer *,			/* server */
	       AuUint32,			/* format */
	       AuUint32,			/* num_tracks */
	       AuUint32,			/* access */
	       AuUint32,			/* sample_rate */
	       AuUint32,			/* num_samples */
	       AuString *,			/* description */
	       AuStatus *			/* RETURN_status */
#endif
);

extern void
AuDestroyBucket(
#if NeedFunctionPrototypes
		AuServer *,			/* server */
		AuBucketID,			/* bucket */
		AuStatus *			/* RETURN_status */
#endif
);



/*****************************************************************************
 *				 SIMPLE FLOWS				     *
 *****************************************************************************/

extern          AuFlowID
AuGetScratchFlow(
#if NeedFunctionPrototypes
		 AuServer *,			/* server */
		 AuStatus *			/* RETURN_status */
#endif
);

extern void
AuReleaseScratchFlow(
#if NeedFunctionPrototypes
		     AuServer *,		/* server */
		     AuFlowID,			/* flow */
		     AuStatus *			/* RETURN_status */
#endif
);

extern          AuFlowID
AuGetScratchFlowToBucket(
#if NeedFunctionPrototypes
			 AuServer *,		/* server */
			 AuBucketID,		/* bucket */
			 int *,			/* RETURN_import */
			 AuStatus *		/* RETURN_status */
#endif
);

extern          AuFlowID
AuGetScratchFlowFromBucket(
#if NeedFunctionPrototypes
			   AuServer *,		/* server */
			   AuBucketID,		/* bucket */
			   int *,		/* RETURN_export */
			   AuStatus *		/* RETURN_status */
#endif
);


extern          AuFlowID
AuGetScratchFlowPlayImport(
#if NeedFunctionPrototypes
			   AuServer *,		/* server */
			   AuDeviceID,		/* device */
			   AuFixedPoint,	/* volume */
			   int *,		/* RETURN_import */
			   int *,		/* RETURN_volume_multiplier_el
						 * ement */
			   AuStatus *		/* RETURN_status */
#endif
);


extern          AuFlowID
AuGetScratchFlowPlayBucket(
#if NeedFunctionPrototypes
			   AuServer *,		/* server */
			   AuBucketID,		/* bucket */
			   AuDeviceID,		/* destination */
			   AuFixedPoint,	/* volume */
			   int *,		/* RETURN_volume_multiplier_el
						 * ement */
			   AuStatus *		/* RETURN_status */
#endif
);

extern          AuBool
AuIsFlowRunning(
#if NeedFunctionPrototypes
		AuServer *,			/* server */
		AuFlowID			/* flow */
#endif
);

extern void
AuStartFlow(
#if NeedFunctionPrototypes
	   AuServer *,				/* server */
	   AuFlowID,				/* flow */
	   AuStatus *				/* RETURN_status */
#endif
);

extern void
AuStopFlow(
#if NeedFunctionPrototypes
	   AuServer *,				/* server */
	   AuFlowID,				/* flow */
	   AuStatus *				/* RETURN_status */
#endif
);

extern void
AuPauseFlow(
#if NeedFunctionPrototypes
	   AuServer *,				/* server */
	   AuFlowID,				/* flow */
	   AuStatus *				/* RETURN_status */
#endif
);

/*****************************************************************************
 *			       BUCKET UTILITIES				     *
 *****************************************************************************/

/*
 * AuStartPlayingFromBucket - this routine creates a flow connecting the
 * bucket through a multiplier to an output.  The caller can be notified when
 * it has stopped playing and can instruct the library whether or not to
 * release the flow.
 */
extern AuEventHandlerRec *
AuStartPlayingFromBucket(
#if NeedFunctionPrototypes
			 AuServer *,		/* server */
			 AuBucketID,		/* source */
			 AuDeviceID,		/* destination */
			 AuInt32,			/* start */
			 AuInt32,			/* num_samples */
			 AuFixedPoint,		/* volume */
			 AuBool(*) (		/* done_callback */
#if NeedNestedPrototypes
				    AuServer *,	/* server */
				    AuEventHandlerRec *	/* which */
#endif
				    ),
			 AuFlowID *,		/* RETURN_flow */
			 int *			/* RETURN_volume_multiplier_el
						 * ement */
#endif
);


/*
 * AuStartRecordingToBucket - this routine creates a flow connecting the
 * bucket through a multiplier to an output.  The caller can be notified when
 * it has stopped recording and can instruct the library whether or not to
 * release the flow.
 */
extern AuEventHandlerRec *
AuStartRecordingToBucket(
#if NeedFunctionPrototypes
			 AuServer *,		/* server */
			 AuDeviceID,		/* source */
			 AuBucketID,		/* destination */
			 AuInt32,			/* start */
			 AuInt32,			/* num_samples */
			 AuFixedPoint,		/* volume */
			 AuBool(*) (		/* done_callback */
#if NeedNestedPrototypes
				    AuServer *,	/* server */
				    AuEventHandlerRec *	/* which */
#endif
				    ),
			 AuFlowID *,		/* RETURN_flow */
			 int *			/* RETURN_volume_multiplier_el
						 * ement */
#endif
);



/*****************************************************************************
 *			       EVENT DISPATCHING			     *
 *****************************************************************************/

extern void
AuHandleEvents(
#if NeedFunctionPrototypes
	       AuServer *			/* server */
#endif
);

extern          AuBool
AuDispatchEvent(
#if NeedFunctionPrototypes
		AuServer *,			/* server */
		AuEvent *
#endif
);


extern AuEventHandlerRec *
AuRegisterEventHandler(
#if NeedFunctionPrototypes
		       AuServer *,		/* server */
		       AuMask,			/* value_mask */
		       int,			/* type */
		       AuID,			/* id */
		       AuEventHandlerCallback,	/* callback */
		       AuPointer		/* data */
#endif
);

extern void
AuUnregisterEventHandler(
#if NeedFunctionPrototypes
			 AuServer *,		/* server */
			 AuEventHandlerRec *	/* handler */
#endif
);


extern AuEventHandlerRec *
AuLookupEventHandler(
#if NeedFunctionPrototypes
		     AuServer *,		/* server */
		     AuEvent *,			/* event */
		     AuEventHandlerRec *	/* startwith */
#endif
);

_AuConst char  *
AuFormatToString(
#if NeedFunctionPrototypes
		 unsigned int			/* format */
#endif
);

int
AuStringToFormat(
#if NeedFunctionPrototypes
		 _AuConst char *		/* string */
#endif
);

_AuConst char  *
AuFormatToDefine(
#if NeedFunctionPrototypes
		 unsigned int			/* format */
#endif
);

int
AuDefineToFormat(
#if NeedFunctionPrototypes
		 _AuConst char *		/* define */
#endif
);

AuEventHandlerRec *
AuMonitorDevice(
#if NeedFunctionPrototypes
		AuServer *,			/* server */
		int,				/* sample rate */
		AuDeviceID,			/* input device */
		AuDeviceID,			/* output device */
		AuFixedPoint,			/* volume */
		void (*) (			/* done_callback */
#if NeedNestedPrototypes
			  AuServer *,		/* server */
			  AuEventHandlerRec *,	/* which */
			  AuEvent *,		/* event */
			  AuPointer		/* callback data */
#endif
			  ),
		AuPointer,			/* callback data */
		AuFlowID *,			/* RETURN_flow */
		int *,				/* RETURN_volume_mult_element */
		int *,				/* RETURN_monitor_element */
		AuStatus *			/* RETURN_status */
#endif
);

int
AuConvertDataToShort(
#if NeedFunctionPrototypes
		     int,			/* data format */
		     int,			/* num bytes */
		     AuPointer			/* data */
#endif
);

int
AuConvertShortToData(
#if NeedFunctionPrototypes
		     int,			/* data format */
		     int,			/* num bytes */
		     AuPointer			/* data */
#endif
);

_AUFUNCPROTOEND

#endif						/* AUDIOUTIL_H_ */
